/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.uep.Grouping;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class GroupingGivenNoOfGroups
extends Grouping {
    public Value getNoOfGroups() throws M4CompilerError {
        return (Value)this.getSingleParameter("NoOfGroups", this.getCurrentLoopNumber());
    }

    public Value[] getLabels() throws M4CompilerError {
        return (Value[])this.getParameter("Labels", this.getCurrentLoopNumber());
    }

    public String[] generateLabels(int num) throws M4CompilerError {
        Value[] l = this.getLabels();
        String[] labels = new String[num];
        boolean gen = true;
        if (l.length != 0) {
            if (l.length > 0 && l.length != num) {
                this.doPrint(Print.OPERATOR, "Incorrect number of given labels, labels generated automaticaly!");
            } else {
                gen = false;
            }
        }
        for (int i = 0; i < num; ++i) {
            labels[i] = gen ? "_" + (i + 1) : l[i].getValue();
        }
        return labels;
    }

    public String[] generateGroups(Column theTargetAttributeColumn) throws M4CompilerError {
        MyData x;
        long c;
        int i;
        TreeMap<MyData, Integer> T = new TreeMap<MyData, Integer>();
        String[] elements = this.getM4Db().getCountOfElements(theTargetAttributeColumn);
        this.doPrint(Print.OPERATOR, "GroupingGivenNoOfGroups:");
        long sum = 0L;
        for (i = 0; i < elements.length; ++i) {
            StringTokenizer st = new StringTokenizer(elements[i], ",");
            c = Long.parseLong(st.nextToken());
            x = new MyData("'" + st.nextToken() + "'", c, 0L);
            T.put(x, new Integer(0));
            sum += c;
        }
        long NoOfGroups = Long.parseLong(this.getNoOfGroups().getValue());
        i = 0;
        while ((long)T.size() > NoOfGroups) {
            x = (MyData)T.firstKey();
            String s = x.name;
            c = x.cnt;
            T.remove(x);
            x = (MyData)T.firstKey();
            T.remove(x);
            x = new MyData(s + ", " + x.name, c + x.cnt, ++i);
            T.put(x, null);
        }
        String[] myG = new String[T.size()];
        i = 0;
        while (T.size() > 0) {
            x = (MyData)T.firstKey();
            this.doPrint(Print.OPERATOR, "Group " + (i + 1) + " has " + x.cnt + " elements of this: " + x.name);
            myG[i++] = x.name;
            T.remove(x);
        }
        return myG;
    }

    public class MyData
    implements Comparable {
        public String name;
        public long cnt;
        public long iter;

        public MyData(String Name, long Count, long Iter) {
            this.name = Name;
            this.cnt = Count;
            this.iter = Iter;
        }

        public int compareTo(Object Obj) {
            int x = this.cnt == ((MyData)Obj).cnt ? (this.iter == ((MyData)Obj).iter ? this.name.compareTo(((MyData)Obj).name) : (this.iter > ((MyData)Obj).iter ? -1 : 1)) : (this.cnt > ((MyData)Obj).cnt ? 1 : -1);
            return x;
        }

        public boolean equals(Object Obj) {
            return this.cnt == ((MyData)Obj).cnt && this.iter == ((MyData)Obj).iter && this.name.equals(((MyData)Obj).name);
        }
    }
}

