/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.uep.Discretization;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ErrorBasedDiscretizationGivenNoOfIntervals
extends Discretization {
    public Value getNoOfIntervals() throws M4CompilerError {
        return (Value)this.getSingleParameter("NoOfIntervals", this.getCurrentLoopNumber());
    }

    public Value getClosedTo() throws M4CompilerError {
        return (Value)this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
    }

    public Value[] getLabels() throws M4CompilerError {
        return (Value[])this.getParameter("Labels", this.getCurrentLoopNumber());
    }

    public Value[] getSampleSize() throws M4CompilerError {
        return (Value[])this.getParameter("SampleSize", this.getCurrentLoopNumber());
    }

    private long sampleSize() throws M4CompilerError {
        Value[] tmp = this.getSampleSize();
        if (tmp.length == 0) {
            return 10000L;
        }
        return Long.parseLong(tmp[0].getValue());
    }

    public BaseAttribute getTheClassAttribute() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheClassAttribute", this.getCurrentLoopNumber());
    }

    public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError {
        int i;
        Column theClassAttributeColumn;
        ArrayList<myData> cutPoint = new ArrayList<myData>();
        TreeMap<String, Long> clss = new TreeMap<String, Long>();
        this.doPrint(Print.OPERATOR, "ErrorBasedDiscretizationGivenNoOfIntervals:");
        try {
            theClassAttributeColumn = this.getTheClassAttribute().getCurrentColumn();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        String[] classes = this.getM4Db().getDistinctElementsWithoutNull(theClassAttributeColumn);
        for (i = 0; i < classes.length; ++i) {
            clss.put(classes[i], new Long(i + 1));
        }
        String[] elements = this.getM4Db().getCountOfElements(theClassAttributeColumn, theTargetAttributeColumn, this.sampleSize());
        myData val = null;
        for (i = 0; i < elements.length; ++i) {
            StringTokenizer t = new StringTokenizer(elements[i], ",");
            long cnt = Long.parseLong(t.nextToken());
            String s = t.nextToken();
            double v = Double.parseDouble(t.nextToken());
            if (i == 0) {
                val = new myData();
                val.value = v;
                val.maxfreq = 0L;
                val.label = 0L;
                val.LBound = v - 1.0;
                val.UBound = v + 1.0;
                val.count = 0L;
                cutPoint.add(val);
            } else if (v != val.value) {
                double d;
                val.UBound = d = (v + val.value) / 2.0;
                val = new myData();
                val.value = v;
                val.maxfreq = 0L;
                val.label = 0L;
                val.LBound = d;
                val.UBound = v + 1.0;
                val.count = 0L;
                cutPoint.add(val);
            }
            val.count += cnt;
            int id = ((Long)clss.get(s)).intValue() - 1;
            val.freq[id] = cnt;
            if (cnt < val.maxfreq) continue;
            if (cnt == val.maxfreq) {
                val.label += (long)(1 << id);
                continue;
            }
            val.maxfreq = cnt;
            val.label = 1 << id;
        }
        i = 0;
        while (i < cutPoint.size() - 1) {
            myData x1 = (myData)cutPoint.get(i);
            myData x2 = (myData)cutPoint.get(i + 1);
            if (x1.label == x2.label) {
                x1.maxfreq += x2.maxfreq;
                x1.UBound = x2.UBound;
                x1.count += x2.count;
                for (int x = 0; x < classes.length; ++x) {
                    x1.freq[x] = x1.freq[x] + x2.freq[x];
                }
                cutPoint.remove(i + 1);
                continue;
            }
            ++i;
        }
        long noOfInt = Long.parseLong(this.getNoOfIntervals().getValue());
        while ((long)cutPoint.size() > noOfInt) {
            myData x1;
            int minID = 0;
            long min = ((myData)cutPoint.get((int)minID)).count;
            for (i = 1; i < cutPoint.size(); ++i) {
                if (((myData)cutPoint.get((int)i)).count >= min) continue;
                min = ((myData)cutPoint.get((int)i)).count;
                minID = i;
            }
            myData x2 = (myData)cutPoint.get(minID);
            if (minID == 0) {
                myData x3 = (myData)cutPoint.get(minID + 1);
                for (int x = 0; x < classes.length; ++x) {
                    x2.freq[x] = x2.freq[x] + x3.freq[x];
                    if (x2.freq[x] > x2.maxfreq) {
                        x2.label = 1 << x;
                        x2.maxfreq = x2.freq[x];
                        continue;
                    }
                    if (x2.freq[x] != x2.maxfreq) continue;
                    x2.label += (long)(1 << x);
                }
                x2.count += x3.count;
                x2.UBound = x3.UBound;
                cutPoint.remove(minID + 1);
            } else if (minID == cutPoint.size() - 1) {
                x1 = (myData)cutPoint.get(minID - 1);
                for (int x = 0; x < classes.length; ++x) {
                    x1.freq[x] = x1.freq[x] + x2.freq[x];
                    if (x1.freq[x] > x1.maxfreq) {
                        x1.label = 1 << x;
                        x1.maxfreq = x1.freq[x];
                        continue;
                    }
                    if (x1.freq[x] != x1.maxfreq) continue;
                    x1.label += (long)(1 << x);
                }
                x1.count += x2.count;
                x1.UBound = x2.UBound;
                cutPoint.remove(minID);
            } else {
                int x;
                x1 = (myData)cutPoint.get(minID - 1);
                myData x3 = (myData)cutPoint.get(minID + 1);
                if (x1.count + x2.count - (x1.maxfreq + x2.maxfreq) < x2.count + x3.count - (x2.maxfreq + x3.maxfreq)) {
                    for (x = 0; x < classes.length; ++x) {
                        x1.freq[x] = x1.freq[x] + x2.freq[x];
                        if (x1.freq[x] > x1.maxfreq) {
                            x1.label = 1 << x;
                            x1.maxfreq = x1.freq[x];
                            continue;
                        }
                        if (x1.freq[x] != x1.maxfreq) continue;
                        x1.label += (long)(1 << x);
                    }
                    x1.count += x2.count;
                    x1.UBound = x2.UBound;
                    cutPoint.remove(minID);
                } else {
                    for (x = 0; x < classes.length; ++x) {
                        x2.freq[x] = x2.freq[x] + x3.freq[x];
                        if (x2.freq[x] > x2.maxfreq) {
                            x2.label = 1 << x;
                            x2.maxfreq = x2.freq[x];
                            continue;
                        }
                        if (x2.freq[x] != x2.maxfreq) continue;
                        x2.label += (long)(1 << x);
                    }
                    x2.count += x3.count;
                    x2.UBound = x3.UBound;
                    cutPoint.remove(minID + 1);
                }
            }
            if (cutPoint.size() > 2) continue;
            break;
        }
        this.doPrint(Print.OPERATOR, "\nNew intervals:");
        for (i = 0; i < cutPoint.size(); ++i) {
            this.doPrint(Print.OPERATOR, ((myData)cutPoint.get(i)).Text());
        }
        double[] cp = new double[cutPoint.size() - 1];
        for (i = 0; i < cutPoint.size() - 1; ++i) {
            cp[i] = ((myData)cutPoint.get((int)i)).UBound;
        }
        return cp;
    }

    public String[] generateLabels(int num) throws M4CompilerError {
        Value[] l = this.getLabels();
        String[] labels = new String[num];
        boolean gen = true;
        if (l.length != 0) {
            if (l.length > 0 && l.length != num) {
                this.doPrint(Print.OPERATOR, "Incorrect number of given labels, labels generated automaticaly!");
            } else {
                gen = false;
            }
        }
        for (int i = 0; i < num; ++i) {
            labels[i] = gen ? "_" + (i + 1) : l[i].getValue();
        }
        return labels;
    }

    public class myData {
        public double value;
        public double LBound;
        public double UBound;
        public long label;
        public long maxfreq;
        public long[] freq = new long[64];
        public long count;

        public String Text() {
            return "(" + this.LBound + ", " + this.UBound + ") - " + this.count + " elements";
        }
    }
}

