/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.uep.Discretization;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class EquifrequentDiscretizationGivenCardinality
extends Discretization {
    public Value getCardinality() throws M4CompilerError {
        return (Value)this.getSingleParameter("Cardinality", this.getCurrentLoopNumber());
    }

    public Value getCardinalityType() throws M4CompilerError {
        return (Value)this.getSingleParameter("CardinalityType", this.getCurrentLoopNumber());
    }

    public Value getClosedTo() throws M4CompilerError {
        return (Value)this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
    }

    public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError {
        int i;
        ArrayList<Double> cutPoints = new ArrayList<Double>();
        String[] elements = this.getM4Db().getCountOfElements(theTargetAttributeColumn);
        long[] cnt = new long[elements.length + 1];
        double[] val = new double[elements.length + 1];
        long sum = 0L;
        this.doPrint(Print.OPERATOR, "EquifrequentDiscretizationGivenCardinality:");
        for (i = 0; i < elements.length; ++i) {
            StringTokenizer t = new StringTokenizer(elements[i], ",");
            cnt[i] = Long.parseLong(t.nextToken());
            val[i] = Double.parseDouble(t.nextToken());
            sum += cnt[i];
        }
        cnt[elements.length] = 0L;
        val[elements.length] = val[elements.length - 1] + 0.05;
        long IntCardA = this.getCardinalityType().getValue().equalsIgnoreCase("absolute") ? Long.parseLong(this.getCardinality().getValue()) : Math.round((double)sum * Double.parseDouble(this.getCardinality().getValue()));
        i = 0;
        long MaxDiff = 0L;
        while (i < val.length) {
            long count;
            for (count = 0L; count <= IntCardA && i < val.length; count += cnt[i], ++i) {
            }
            if (count - IntCardA > IntCardA - (count - cnt[--i])) {
                if (MaxDiff < IntCardA - (count - cnt[i])) {
                    MaxDiff = IntCardA - (count - cnt[i]);
                }
                if ((count -= cnt[i]) == 0L && MaxDiff < (count = cnt[i++]) - IntCardA) {
                    MaxDiff = count - IntCardA;
                }
            } else {
                if (MaxDiff < count - IntCardA) {
                    MaxDiff = count - IntCardA;
                }
                ++i;
            }
            if (i == val.length) {
                cutPoints.add(new Double(val[i - 1] + (val[i - 1] - val[0]) * 0.001));
            } else {
                cutPoints.add(new Double((val[i - 1] + val[i]) / 2.0));
            }
            this.doPrint(Print.OPERATOR, "Interval no. " + cutPoints.size() + ",  Cardinality " + count);
        }
        double[] cp = new double[cutPoints.size()];
        for (i = 0; i < cutPoints.size(); ++i) {
            cp[i] = (Double)cutPoints.get(i);
        }
        return cp;
    }
}

