/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.uep.Discretization;

public class EquidistantDiscretizationGivenWidth
extends Discretization {
    public Value[] getStartPoint() throws M4CompilerError {
        return (Value[])this.getParameter("StartPoint", this.getCurrentLoopNumber());
    }

    public Value[] getEndPoint() throws M4CompilerError {
        return (Value[])this.getParameter("EndPoint", this.getCurrentLoopNumber());
    }

    public Value getIntervalWidth() throws M4CompilerError {
        return (Value)this.getSingleParameter("IntervalWidth", this.getCurrentLoopNumber());
    }

    public Value getClosedTo() throws M4CompilerError {
        return (Value)this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
    }

    public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError {
        this.doPrint(Print.OPERATOR, "EquidistantDiscretizationGivenWidth:");
        double start = this.getStartPointOrMinum(theTargetAttributeColumn);
        double width = Double.parseDouble(this.getIntervalWidth().getValue());
        double end = this.getEndPointOrMaximum(theTargetAttributeColumn);
        int numOfIntervals = (int)Math.ceil((end - start) / width);
        double[] cutPoints = new double[numOfIntervals];
        for (int i = 0; i < numOfIntervals; ++i) {
            cutPoints[i] = start + (double)i * width;
        }
        return cutPoints;
    }

    public double getStartPointOrMinum(Column theTargetAttributeColumn) throws M4CompilerError {
        Value[] myVal = this.getStartPoint();
        if (myVal.length == 0) {
            try {
                String min = theTargetAttributeColumn.readOrComputeMinimum();
                return Double.parseDouble(min);
            }
            catch (M4Exception e) {
                throw new M4CompilerError(e.getMessage());
            }
        }
        return Double.parseDouble(myVal[0].getValue());
    }

    public double getEndPointOrMaximum(Column theTargetAttributeColumn) throws M4CompilerError {
        Value[] myVal = this.getEndPoint();
        if (myVal.length == 0) {
            try {
                String max = theTargetAttributeColumn.readOrComputeMaximum();
                return Double.parseDouble(max);
            }
            catch (M4Exception e) {
                throw new M4CompilerError(e.getMessage());
            }
        }
        return Double.parseDouble(myVal[0].getValue());
    }
}

