/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.FeatureConstruction;

public abstract class Discretization
extends FeatureConstruction {
    abstract Value getClosedTo() throws M4CompilerError;

    abstract double[] generateCutPoints(Column var1) throws M4CompilerError;

    public String[] generateLabels(int num) throws M4CompilerError {
        String[] labels = new String[num];
        for (int i = 0; i < num; ++i) {
            labels[i] = "_" + (i + 1);
        }
        return labels;
    }

    public String generateSQL(Column theTargetAttributeColumn) throws M4CompilerError {
        boolean closedToRight = false;
        if (this.getClosedTo().getValue().equalsIgnoreCase("right")) {
            closedToRight = true;
        }
        double[] myCP = this.generateCutPoints(theTargetAttributeColumn);
        String[] myL = this.generateLabels(myCP.length + 1);
        String f = "(CASE ";
        for (int i = 0; i < myCP.length; ++i) {
            f = f + "WHEN " + theTargetAttributeColumn.getSQLDefinition() + " <";
            if (closedToRight) {
                f = f + "=";
            }
            f = f + " " + myCP[i] + " THEN ('" + myL[i] + "') ";
            String s = myCP[i] + "<";
            if (closedToRight) {
                s = s + "=";
            }
            s = s + "'" + myL[i] + "'\n";
        }
        f = f + "ELSE ('" + myL[myL.length - 1] + "') END)";
        this.doPrint(Print.OPERATOR, "String returned by discretization: " + f);
        return f;
    }
}

