/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.ModelApplier;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.DatabaseDataRowReader;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SimpleExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.tools.DatabaseHandler;
import edu.udo.cs.yale.tools.Ontology;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class YaleModelApplier
extends ModelApplier {
    private static final int BLOCKSIZE = 100000;
    private Model yaleModel;

    protected String getRelationalDtForNewColumn(BaseAttribute ba) {
        if (this.yaleModel != null && YaleModelApplier.isNumericalYaleAttribute(this.yaleModel.getLabel())) {
            return "NUMBER";
        }
        return "STRING";
    }

    protected String getDatabaseDtForNewColumn(BaseAttribute ba) throws M4CompilerError {
        Attribute label;
        boolean useBusinessDbCoreForDatabaseDt = true;
        if (this.yaleModel != null && (label = this.yaleModel.getLabel()) != null) {
            if (YaleModelApplier.isNumericalYaleAttribute(label)) {
                return this.getM4Db().getDbNameOfM4Datatype("NUMBER", 0, useBusinessDbCoreForDatabaseDt);
            }
            Collection col = label.getValues();
            if (col != null) {
                Iterator it = col.iterator();
                int maxLength = 1;
                while (it.hasNext()) {
                    String s = (String)it.next();
                    if (s == null || s.length() <= maxLength) continue;
                    maxLength = s.length();
                }
                return this.getM4Db().getDbNameOfM4Datatype("STRING", maxLength, useBusinessDbCoreForDatabaseDt);
            }
        }
        return this.getM4Db().getDbNameOfM4Datatype("STRING", 30, useBusinessDbCoreForDatabaseDt);
    }

    protected void predict() throws M4Exception, M4CompilerError {
        try {
            Columnset inputCs = this.getInputConcept().getCurrentColumnSet();
            String sql = "SELECT COUNT(*) FROM " + inputCs.getSQLDefinition();
            Long countL = this.executeBusinessSingleValueSqlReadL(sql);
            long count = countL;
            Long toRowNum = null;
            int i = 0;
            while ((long)i < count) {
                Long fromRowNum = toRowNum;
                toRowNum = new Long(i + 100000);
                String sql2 = this.getDatabaseQueryForRows(fromRowNum, toRowNum);
                this.predictionForBlock(sql2);
                i += 100000;
            }
        }
        catch (SQLException e) {
            throw new M4CompilerError("YaleModelApplier: SQLException!\n" + e.getMessage());
        }
    }

    private void predictionForBlock(String sql) throws SQLException, DbConnectionClosed, M4CompilerError {
        ExampleSet exampleSet;
        ExampleTable yaleTable = this.createDatabaseExampleTable(sql);
        try {
            exampleSet = this.exampleTableToExampleSet(yaleTable);
        }
        catch (OperatorException e) {
            throw new M4CompilerError("YaleModelApplier: Could not turn ExampleTable into ExampleSet!\n" + e.getMessage());
        }
        Vector<String> predictedAttribs = new Vector<String>();
        Vector<Attribute> yalePredictedAttributes = new Vector<Attribute>();
        for (int loop = 0; loop < this.getNumberOfLoops(); ++loop) {
            BaseAttribute curPredBa = this.getPredictedAttribute(loop);
            String outputAttribute = curPredBa.getName();
            predictedAttribs.add(outputAttribute);
            File modelFile = this.getModelFile(loop);
            ExampleSet toBeExtended = (ExampleSet)exampleSet.clone();
            Attribute newAttribute = this.applyModel(modelFile, toBeExtended, outputAttribute, loop);
            yalePredictedAttributes.add(newAttribute);
        }
        List yaleKeyAttributes = this.getKeyAttributesForExampleSet(exampleSet);
        Vector<Attribute> regularAttributes = new Vector<Attribute>(yaleKeyAttributes);
        regularAttributes.addAll(yalePredictedAttributes);
        SimpleExampleSet ses = new SimpleExampleSet(yaleTable, regularAttributes);
        this.writeResultsToDb((ExampleSet)ses, predictedAttribs, yaleKeyAttributes, yalePredictedAttributes);
    }

    private List getKeyAttributesForExampleSet(ExampleSet exampleSet) {
        Vector<Attribute> attributes = new Vector<Attribute>();
        Iterator it = this.getKeyColumnNames().iterator();
        while (it.hasNext()) {
            String attribName = (String)it.next();
            attributes.add(exampleSet.getAttribute(attribName));
        }
        return attributes;
    }

    private ExampleTable createDatabaseExampleTable(String sqlQuery) throws SQLException, DbConnectionClosed, M4CompilerError {
        ResultSet resultSet = this.executeBusinessSqlRead(sqlQuery);
        List attributesL = DatabaseHandler.createAttributes((ResultSet)resultSet);
        final Attribute[] attributes = attributesL.toArray(new Attribute[attributesL.size()]);
        DatabaseDataRowReader ddrr = new DatabaseDataRowReader(attributes, resultSet){

            public DataRow next() {
                DataRow row = super.next();
                if (row != null) {
                    Attribute[] allAttribs = attributes;
                    double[] rowValues = new double[allAttribs.length];
                    for (int i = 0; i < rowValues.length; ++i) {
                        rowValues[i] = row.get(allAttribs[i]);
                    }
                    row = new DoubleArrayDataRow(rowValues);
                }
                return row;
            }
        };
        MemoryExampleTable table = new MemoryExampleTable(attributesL, (DataRowReader)ddrr);
        resultSet.close();
        return table;
    }

    private ExampleSet exampleTableToExampleSet(ExampleTable yaleTable) throws OperatorException {
        Vector<Attribute> regularAttributes = new Vector<Attribute>();
        Iterator it = this.getPredictionColumnNames().iterator();
        while (it.hasNext()) {
            String attribName = (String)it.next();
            Attribute attrib = null;
            try {
                attrib = yaleTable.findAttribute(attribName);
            }
            catch (OperatorException oe) {
                attrib = yaleTable.findAttribute(attribName.toUpperCase());
            }
            if (attrib == null) {
                this.doPrint(Print.COMPILER_OP_CONTROL, "Warning: Attribute '" + attribName + "' not found!");
                continue;
            }
            regularAttributes.add(attrib);
        }
        HashMap<String, Attribute> specialAttributes = new HashMap<String, Attribute>();
        it = this.getKeyColumnNames().iterator();
        while (it.hasNext()) {
            String attribName = (String)it.next();
            Attribute attrib = null;
            try {
                attrib = yaleTable.findAttribute(attribName);
            }
            catch (OperatorException oe) {
                attrib = yaleTable.findAttribute(attribName.toUpperCase());
            }
            if (attrib == null) continue;
            specialAttributes.put(attribName, attrib);
        }
        AttributeSet attributeSet = new AttributeSet(regularAttributes, specialAttributes);
        return yaleTable.createExampleSet(attributeSet);
    }

    protected Attribute applyModel(File modelFile, ExampleSet exampleSet, String targetAttribute, int loop) throws M4CompilerError {
        try {
            this.yaleModel = Model.readModel((File)modelFile);
            this.createPredictedAttributeInDb(loop);
            Attribute predictedLabel = this.yaleModel.createPredictedLabel(exampleSet, targetAttribute);
            this.yaleModel.apply(exampleSet);
            return predictedLabel;
        }
        catch (IOException e) {
            throw new M4CompilerError("YaleModelApplier: Could not load model!\n" + e.getMessage());
        }
        catch (OperatorException e) {
            throw new M4CompilerError("YaleModelApplier: YALE's OperatorException occured during 'applyModel'!\n" + e.getMessage());
        }
    }

    private void writeResultsToDb(ExampleSet exampleSet, List predictedAttribs, List yaleKeyAttribs, List yalePredAttribs) throws M4CompilerError {
        Vector keyNameCol = this.getKeyColumnNames();
        if (predictedAttribs == null || yaleKeyAttribs == null || yalePredAttribs == null || yalePredAttribs.size() != predictedAttribs.size() || yaleKeyAttribs.size() != keyNameCol.size()) {
            throw new M4CompilerError("Operator 'YaleModelApplier': Yale and Database attributes did not match in method 'writeResults'!");
        }
        String targetTable = this.getTargetTableName();
        String sqlPre = "UPDATE " + targetTable + " SET ";
        String sqlCond = " WHERE ";
        ExampleReader er = exampleSet.getExampleReader();
        while (er.hasNext()) {
            Example example = er.next();
            String setPart = this.createSqlAttributeValueString(example, predictedAttribs, yalePredAttribs, ", ");
            if (setPart == null) continue;
            String condPart = this.createSqlAttributeValueString(example, keyNameCol, yaleKeyAttribs, " AND ");
            String sql = sqlPre + setPart + " WHERE " + condPart;
            try {
                this.executeBusinessSqlWrite(sql);
            }
            catch (SQLException e) {
                throw new M4CompilerError("YaleModelApplier: SQLException occured when trying to insert tuple into table,\nSQL statement was: " + sql + "\n" + e.getMessage());
            }
        }
        try {
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("YaleModelApplier: SQL error when committing a block: " + sqle.getMessage());
        }
    }

    private String createSqlAttributeValueString(Example example, List predictedAttribs, List yaleAttributes, String separator) {
        StringBuffer setList = new StringBuffer();
        Iterator yaleIt = yaleAttributes.iterator();
        Iterator mmIt = predictedAttribs.iterator();
        while (yaleIt.hasNext()) {
            Attribute curAttrib = (Attribute)yaleIt.next();
            String valueS = example.getValueAsString(curAttrib);
            if (valueS == null) continue;
            if (!YaleModelApplier.isNumericalYaleAttribute(curAttrib)) {
                valueS = "'" + valueS + "'";
            }
            setList.append((String)mmIt.next() + "=" + valueS + separator);
        }
        if (setList.length() > 0) {
            return setList.substring(0, setList.length() - separator.length());
        }
        return null;
    }

    private static boolean isNumericalYaleAttribute(Attribute attribute) {
        Ontology types = Ontology.ATTRIBUTE_VALUE_TYPE;
        return attribute != null && types.isA(attribute.getValueType(), 2);
    }

    public File getModelFile(int loop) throws M4CompilerError {
        Value value = (Value)this.getSingleParameter("ModelFile", loop);
        if (value == null || value.getValue() == null) {
            throw new M4CompilerError("YaleModelApplier: Mandatory parameter 'ModelFile' missing (loop number: " + loop + ") !");
        }
        String path = value.getValue();
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            return file;
        }
        throw new M4CompilerError("YaleModelApplier: ModelFile not found (loop number: " + loop + ")!\n" + "Specified path was: '" + path + "'");
    }
}

