/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.TimeOperator;
import edu.udo.cs.miningmart.storedProcedures.TimeOperatorException;
import edu.udo.cs.miningmart.storedProcedures.ToWindow;
import java.sql.SQLException;

public class Windowing
extends TimeOperator {
    private static final String TIMEBASEATTRIB = "TimeBaseAttrib";
    private static final String VALUEBASEATTRIB = "ValueBaseAttrib";
    private static final String WINDOWSIZE = "WindowSize";
    private static final String DISTANCE = "Distance";
    private static final String OUTTIMESTARTBA = "OutputTimeStartBA";
    private static final String OUTTIMEENDBA = "OutputTimeEndBA";
    private static final String WINDOWEDVALUESBA = "WindowedValuesBA";
    private static final String procedureName = "dbWindow";
    private static final String columnSetSuffix = "_CS";

    protected String getColumnSetSuffix() {
        return columnSetSuffix;
    }

    public BaseAttribute getTimeBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(TIMEBASEATTRIB);
    }

    public BaseAttribute getValueBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(VALUEBASEATTRIB);
    }

    public Value getWinSize() throws M4CompilerError {
        return (Value)this.getSingleParameter(WINDOWSIZE);
    }

    public Value getDistance() throws M4CompilerError {
        return (Value)this.getSingleParameter(DISTANCE);
    }

    public BaseAttribute getOutStartTimeBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTTIMESTARTBA);
    }

    public BaseAttribute getOutEndTimeBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTTIMEENDBA);
    }

    private BaseAttribute[] getWindowedValuesBA() throws M4CompilerError {
        return (BaseAttribute[])this.getParameter(WINDOWEDVALUESBA);
    }

    public BaseAttribute getWindowedValueBA(int i) throws M4CompilerError {
        BaseAttribute[] windowedValues = this.getWindowedValuesBA();
        if (windowedValues != null && i < windowedValues.length && i >= 0) {
            return windowedValues[i];
        }
        return null;
    }

    public int getNumberOfWindowedValuesBAs() throws M4CompilerError {
        BaseAttribute[] windowedValues = this.getWindowedValuesBA();
        if (windowedValues != null) {
            return windowedValues.length;
        }
        return 0;
    }

    protected void createJavaColumns(Columnset newColumnSet) throws M4CompilerError {
        this.createWindowedColumns(newColumnSet);
        this.linkOutputTimeBAs(newColumnSet);
    }

    private void createWindowedColumns(Columnset newCS) throws M4CompilerError {
        try {
            Column columnForType = this.getValueBA().getColumn(0);
            int winsize = this.getNumberOfWindowedValuesBAs();
            for (int i = 0; i < winsize; ++i) {
                this.createM4Column(this.getWindowedValueBA(i), newCS, columnForType);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void linkOutputTimeBAs(Columnset newCS) throws M4CompilerError {
        try {
            Column columnForType = this.getTimeBA().getColumn(0);
            this.createM4Column(this.getOutStartTimeBA(), newCS, columnForType);
            this.createM4Column(this.getOutEndTimeBA(), newCS, columnForType);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected void runStoredProcedure(String newColumnsetName) throws SQLException, M4CompilerError, TimeOperatorException {
        Step st = this.getStep();
        this.valueIsLong(this.getWinSize(), WINDOWSIZE);
        this.valueIsLong(this.getDistance(), DISTANCE);
        this.baseattribHasColumns(this.getTimeBA(), TIMEBASEATTRIB);
        this.baseattribHasColumns(this.getValueBA(), VALUEBASEATTRIB);
        if (this.getNumberOfWindowedValuesBAs() != this.getWinSize().getLong().intValue()) {
            throw new M4CompilerError("Array of BaseAttributes 'WindowedValuesBA' of step " + st.getId() + " does not match the windowsize (parameter name: '" + WINDOWSIZE + "')!");
        }
        String[] parameters = new String[]{Windowing.getQuotedColSetNameforCon(this.getInputConcept()), Windowing.getQuotedColNameforInpBA(this.getTimeBA()), Windowing.getQuotedColNameforInpBA(this.getValueBA()), DB.quote(newColumnsetName), Windowing.getQuotedColNameforOutBA(this.getOutStartTimeBA()), Windowing.getQuotedColNameforOutBA(this.getOutEndTimeBA()), DB.quote(this.createWindowedColsString()), Windowing.getUnquotedIntFromValue(this.getDistance())};
        if (this.storedProceduresAvailable()) {
            this.executeDbProcedure(procedureName, parameters);
        } else {
            ToWindow.dbWindow(this.getM4Db(), Windowing.unquote(parameters[0]), Windowing.unquote(parameters[1]), Windowing.unquote(parameters[2]), Windowing.unquote(parameters[3]), Windowing.unquote(parameters[4]), Windowing.unquote(parameters[5]), Windowing.unquote(parameters[6]), Integer.parseInt(parameters[7]));
        }
    }

    private String createWindowedColsString() throws M4CompilerError {
        String r = "";
        int winsize = this.getNumberOfWindowedValuesBAs();
        for (int i = 0; i < winsize; ++i) {
            r = r + this.getWindowedValueBA(i).getName() + " ";
        }
        return r;
    }
}

