/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4CompilerWarning;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.UserError;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.operator.MultipleCSOperator;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class Unsegment
extends MultipleCSOperator {
    private static final String UNSEGMENT_ATTRIB_PARAM = "UnsegmentAttribute";
    private static final String TYPE_OF_OUTPUT_CS = "V";
    private static final int VIEW_SIZE_RESTRICTION = 2000;
    private HashMap colsetsByMsbInfo = null;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Column;

    public int numberOfColumnSets() throws M4CompilerError {
        return this.getColsetsKeySet().size();
    }

    private String[] getDistinctMsbInfos() throws M4CompilerError {
        Set keys = this.getColsetsKeySet();
        return keys.toArray(new String[keys.size()]);
    }

    public String getTypeOfNewColumnSet(int index) {
        return TYPE_OF_OUTPUT_CS;
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return !nameOfFeature.equals(this.getUnsegmentAttribute().getName());
    }

    public String generateSQLDefinition(String selectPart, int index) throws M4CompilerError {
        Object[] keyArray = this.getColsetsKeySet().toArray();
        String key = (String)keyArray[index];
        Vector theColSets = this.getColsetVectorByKey(key);
        String sql = this.sqlUnionOfColsets(theColSets, index);
        return sql;
    }

    private String sqlUnionOfColsets(Vector theColsets, int index) throws M4CompilerError {
        if (theColsets == null || theColsets.size() == 0) {
            throw new M4CompilerError("Unsegment: No Columnsets found when trying to generate an SQL-view for union of ColumnSets.");
        }
        Iterator it = theColsets.iterator();
        Vector<String> sqlDefs = new Vector<String>();
        while (it.hasNext()) {
            String refined = this.refineSqlDef((Columnset)it.next());
            sqlDefs.add(refined);
        }
        return this.concatenateOrSubView(sqlDefs, index, 1);
    }

    private String concatenateOrSubView(Vector viewDefs, int index, int nameSuffix) throws M4CompilerError {
        if (viewDefs == null || viewDefs.size() < 1) {
            return null;
        }
        Iterator it = viewDefs.iterator();
        StringBuffer sbuf = new StringBuffer((String)it.next());
        String viewNamePre = this.getNewCSName(index) + "_V_" + index + "_";
        Vector<String> meta = new Vector<String>();
        while (it.hasNext()) {
            String nextView = (String)it.next();
            if (sbuf.length() + nextView.length() < 2000) {
                sbuf.append(" union " + nextView);
                continue;
            }
            String intermediateView = "(" + sbuf.toString() + ")";
            String completeName = viewNamePre + nameSuffix++;
            this.createView(intermediateView, completeName);
            meta.add("(select * from " + completeName + ")");
            sbuf = new StringBuffer(nextView);
        }
        if (meta.isEmpty()) {
            if (viewDefs.size() == 1) {
                return sbuf.toString();
            }
            return "(" + sbuf.toString() + ")";
        }
        String intermediateView = "(" + sbuf.toString() + ")";
        String completeName = viewNamePre + nameSuffix++;
        this.createView(intermediateView, completeName);
        meta.add("(select * from " + completeName + ")");
        return this.concatenateOrSubView(meta, index, nameSuffix);
    }

    private void createView(String viewDef, String viewName) throws M4CompilerError {
        String sql = null;
        try {
            String schema = this.getInputConcept().getCurrentColumnSet().getSchema();
            sql = "create view " + schema + "." + viewName + " as (" + viewDef + ")";
            this.getM4Db().executeBusinessSqlWrite(sql);
            this.getM4Db().addViewToTrash(viewName, schema, this.getStep().getId());
        }
        catch (SQLException e) {
            throw new M4CompilerError("Unsegment: Could not create intermediate view. SQL:\n" + sql + "\n" + e.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private String refineSqlDef(Columnset c) throws M4CompilerError {
        try {
            String srcDef = c.getSchemaPlusName();
            StringBuffer sql = new StringBuffer("(select ");
            Column[] columns = Unsegment.sortColsByName(c.getColumns());
            for (int i = 0; i < columns.length; ++i) {
                String colName;
                String sqlDef = columns[i].getSQLDefinition();
                if (sqlDef.equals(colName = columns[i].getName())) {
                    sql.append(colName + ", ");
                    continue;
                }
                sql.append(sqlDef + " AS " + colName + ", ");
            }
            String unsegAttrName = this.getUnsegmentAttribute().getName();
            String value = c.getMSBranchSelectionValue(unsegAttrName);
            if (value == null || value.length() == 0) {
                throw new M4CompilerError("Unsegment: Could not find information for unsegment-attribute " + unsegAttrName + " in SQL definition of Columnset " + c.getName() + ", id: " + c.getId() + "\nSQL definition is:\n" + c.getSQLDefinition());
            }
            String sqlS = this.unsegmentBaToBeWritten() ? sql.toString() + value + " AS " + unsegAttrName : sql.substring(0, sql.length() - 2);
            return sqlS + " from " + srcDef + ")";
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private static Column[] sortColsByName(Collection cols) throws M4CompilerError {
        if (cols == null) {
            throw new M4CompilerError("Error in Unsegment operator: Found null value instead of input Column[] when trying to sortColsByName!");
        }
        TreeMap<String, Column> tm = new TreeMap<String, Column>();
        Iterator it = cols.iterator();
        while (it.hasNext()) {
            Column c = (Column)it.next();
            if (c == null) {
                throw new M4CompilerError("Error in Unsegment operator: Found null value in Column[] input when trying to sortColsByName!");
            }
            tm.put(c.getName().toUpperCase(), c);
        }
        return tm.values().toArray(new Column[cols.size()]);
    }

    public BaseAttribute getUnsegmentAttribute() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(UNSEGMENT_ATTRIB_PARAM);
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        try {
            String columnExpr = super.generateColumns(csForOutputConcept);
            if (this.unsegmentBaToBeWritten()) {
                BaseAttribute outBA = this.getUnsegmentAttribute();
                Column outputColumn = (Column)((Object)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$Column == null ? (class$edu$udo$cs$miningmart$m4$core$Column = Unsegment.class$("edu.udo.cs.miningmart.m4.core.Column")) : class$edu$udo$cs$miningmart$m4$core$Column));
                outputColumn.setId(0L);
                outputColumn.setName(outBA.getName());
                outputColumn.setColumnset(csForOutputConcept);
                outputColumn.setBaseAttribute(outBA);
                outputColumn.setSQLDefinition(outBA.getName());
                outputColumn.setColumnDataType(13L);
                outputColumn.setColumnDataTypeName("STRING");
                columnExpr = columnExpr + ", " + outBA.getName() + " AS " + outBA.getName();
                this.getStep().addToTrash(outputColumn);
            }
            return columnExpr;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private boolean unsegmentBaToBeWritten() throws M4CompilerError {
        return !this.getUnsegmentAttribute().getName().startsWith("(");
    }

    private Set getColsetsKeySet() throws M4CompilerError {
        this.aggregateColsets();
        return this.colsetsByMsbInfo.keySet();
    }

    private Vector getColsetVectorByKey(String key) throws M4CompilerError {
        this.aggregateColsets();
        return (Vector)this.colsetsByMsbInfo.get(key);
    }

    private void aggregateColsets() throws M4CompilerError {
        if (this.colsetsByMsbInfo != null) {
            return;
        }
        try {
            Collection colsets = this.getInputConcept().getColumnSets();
            if (colsets == null) {
                throw new M4CompilerError("InputConcept " + this.getInputConcept().getId() + " of operator Unsegment has no Columnset(s) !");
            }
            String baName = this.getUnsegmentAttribute().getName();
            HashMap hm = new HashMap();
            Iterator it = colsets.iterator();
            while (it.hasNext()) {
                Columnset cs = (Columnset)it.next();
                String msbDef = cs.getMsbInfoWithoutAttrib(baName);
                if (!hm.containsKey(msbDef)) {
                    hm.put(msbDef, new Vector());
                }
                Vector v = (Vector)hm.get(msbDef);
                v.add(cs);
            }
            this.colsetsByMsbInfo = hm;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public void execute(boolean lazy) throws UserError, M4CompilerWarning, M4CompilerError, M4Exception, SQLException {
        super.execute(lazy);
        try {
            if (!lazy) {
                Concept inputConcept = this.getInputConcept();
                while (inputConcept.hasNextColumnSet()) {
                    inputConcept.getNextColumnSet();
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected void setNewCSMultiStepBranch(Columnset newCS, int index) throws M4CompilerError {
        Object[] keys = this.getColsetsKeySet().toArray();
        newCS.setMultiStepBranch((String)keys[index]);
    }

    public String getNewCSName(int index) {
        String name = "CS_" + this.getStep().getId() + "_" + index;
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

