/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class Union
extends SingleCSOperator {
    private static final String ARTIFICIAL_BAG_ATTRIBUTE = "MMART_BAG_ATTRIB";
    private Collection inputBaseAttributes;
    private static final String DATAMODE_SET = "set";
    private static final String DATAMODE_BAG = "multi-set";
    private static final String DATAMODE_DEFAULT = "set";

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        Columnset mainInputColumnset;
        Concept[] otherConcepts = this.getTheConcepts();
        Concept inputConcept = this.getInputConcept();
        try {
            if (inputConcept == null || (mainInputColumnset = inputConcept.getCurrentColumnSet()) == null) {
                throw new M4CompilerError("Operator 'Union': No valid input concept/columnset found!");
            }
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Operator 'Union': M4Exception when trying to read the input concept's current columnset!\n" + e.getMessage());
        }
        try {
            boolean bagMode;
            if (otherConcepts == null || otherConcepts.length == 0) {
                return mainInputColumnset.getCompleteSQLQuery();
            }
            this.inputBaseAttributes = this.gatherBaseAttributes(inputConcept);
            boolean bl = bagMode = this.getDataMode() == DATAMODE_BAG;
            if (bagMode && this.getM4Dbms() != 1) {
                this.doPrint(Print.MAX, "Warning: With the current implementation the selected data mode 'Multi-Set' for Operator Union is only available for ORACLE databases, yet!");
                bagMode = false;
            }
            int bagViewCount = 0;
            StringBuffer sbuf = new StringBuffer("(SELECT " + this.createSelectPartWrtInputConcept(inputConcept) + (bagMode ? ", (" + bagViewCount++ + " || '_' || ROWNUM) AS " + ARTIFICIAL_BAG_ATTRIBUTE : "") + " FROM " + mainInputColumnset.getSchemaPlusName() + ")");
            for (int i = 0; i < otherConcepts.length; ++i) {
                Concept concept = otherConcepts[i];
                Columnset cs = concept.getCurrentColumnSet();
                if (cs != null && cs.getColumns() != null && cs.getColumns().size() > 0) {
                    sbuf.append(" UNION (SELECT " + this.createSelectPartWrtInputConcept(concept) + (bagMode ? ", (" + bagViewCount++ + " || '_' || ROWNUM) AS " + ARTIFICIAL_BAG_ATTRIBUTE : "") + " FROM " + cs.getSchemaPlusName() + ")");
                    continue;
                }
                this.doPrint(Print.OPERATOR, "Warning: Input Concept '" + concept.getName() + "' skipped because no valid 'current' Columnset exists!");
            }
            return "(" + sbuf.toString() + ")";
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Operator 'Union' received an M4Exception when trying to getCompleteSQLQuery() for a\nConcept's current Columnset!\n" + e.getMessage());
        }
    }

    private Collection gatherBaseAttributes(Concept concept) throws M4Exception, M4CompilerError {
        Vector<Feature> relevantBAs = new Vector<Feature>();
        Collection feaCol = concept.getFeatures();
        Iterator it = feaCol.iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            if (f instanceof BaseAttribute && !((BaseAttribute)f).isDeselected()) {
                relevantBAs.add(f);
                continue;
            }
            if (!(f instanceof MultiColumnFeature)) continue;
            Iterator baIt = ((MultiColumnFeature)f).getBaseAttributes().iterator();
            while (baIt.hasNext()) {
                BaseAttribute next = (BaseAttribute)baIt.next();
                if (next == null || next.isDeselected()) continue;
                relevantBAs.add(next);
            }
        }
        return relevantBAs;
    }

    private String createSelectPartWrtInputConcept(Concept concept) throws M4Exception, M4CompilerError {
        Collection baCol = this.gatherBaseAttributes(concept);
        StringBuffer sbuf = new StringBuffer();
        Iterator inputIt = this.inputBaseAttributes.iterator();
        while (inputIt.hasNext()) {
            String inColName;
            BaseAttribute inBa = (BaseAttribute)inputIt.next();
            BaseAttribute correspondingBa = null;
            Iterator currentIt = baCol.iterator();
            while (currentIt.hasNext() && correspondingBa == null) {
                BaseAttribute next = (BaseAttribute)currentIt.next();
                if (!next.correspondsTo(inBa)) continue;
                correspondingBa = next;
            }
            String attributeSql = correspondingBa == null || correspondingBa.getCurrentColumn() == null ? "NULL" : correspondingBa.getCurrentColumn().getSQLDefinition();
            if (!attributeSql.equals(inColName = inBa.getCurrentColumn().getName())) {
                attributeSql = attributeSql + " AS " + inColName;
            }
            sbuf.append(attributeSql + ", ");
        }
        return sbuf.substring(0, sbuf.length() - 2);
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return true;
    }

    public Concept[] getTheConcepts() throws M4CompilerError {
        return (Concept[])this.getParameter("FurtherConcepts");
    }

    public String getDataMode() throws M4CompilerError {
        Value dataModeV = (Value)this.getSingleParameter("DataMode");
        if (dataModeV == null || dataModeV.getValue() == null) {
            return "set";
        }
        String dataModeS = dataModeV.getValue();
        if (dataModeS.equalsIgnoreCase(DATAMODE_BAG)) {
            return DATAMODE_BAG;
        }
        return "set";
    }
}

