/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.ManualDiscretization;

public class TimeIntervalManualDiscretization
extends ManualDiscretization {
    private boolean usingPostgres = false;

    public Value getTimeFormat() throws M4CompilerError {
        return (Value)this.getSingleParameter("TimeFormat");
    }

    private String getStringToDateConversion(String value, boolean quoteTheValue) throws M4CompilerError {
        String conversionFunction = "to_date";
        if (this.usingPostgres) {
            conversionFunction = "to_timestamp";
        }
        if (quoteTheValue) {
            value = "'" + value + "'";
        }
        return conversionFunction + "(" + value + ", '" + this.getTimeFormat().getValue() + "')";
    }

    public String generateSQL(Column theTargetAttributeColumn) throws M4CompilerError {
        this.usingPostgres = this.getM4Db().getBusinessDbms() == 2;
        String timeFormat = "'" + this.getTimeFormat().getValue() + "'";
        String inputColumn = this.getStringToDateConversion("to_char(" + theTargetAttributeColumn.getSQLDefinition() + ", " + timeFormat + ")", false);
        int numberOfIntervals = this.getIntervalStart().length;
        String sql = "(CASE ";
        for (int i = 0; i < numberOfIntervals; ++i) {
            String oneIntervalQuery = "WHEN (";
            oneIntervalQuery = oneIntervalQuery + inputColumn + this.getGreater(i, true) + this.getStringToDateConversion(this.getIntervalStart()[i].getValue(), true) + ") AND (" + inputColumn + this.getSmaller(i, false) + this.getStringToDateConversion(this.getIntervalEnd()[i].getValue(), true) + ") THEN '" + this.getMapTo()[i].getValue() + "' ";
            sql = sql + oneIntervalQuery;
        }
        sql = sql + "ELSE '" + this.getDefaultValue().getValue() + "' END)";
        return sql;
    }
}

