/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.ColumnStatistics2;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.Segmentation;
import java.util.Collection;
import java.util.Iterator;

public final class SegmentationStratified
extends Segmentation {
    private String[] distribution;

    public String generateConditionForOp(int columnSetIndex) throws M4CompilerError {
        Column theColumn;
        try {
            theColumn = this.getTheAttribute().getCurrentColumn();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        if (this.distribution == null) {
            if (this.getTheAttribute().getConceptualDataType() != 7L && this.getTheAttribute().getConceptualDataType() != 9L) {
                this.distribution = this.getM4Db().getDistinctElements(theColumn);
            } else {
                try {
                    this.doPrint(Print.OPERATOR, "Computing value distribution for TheAttribute for SegmentationStratified...");
                    theColumn.updateStatistics();
                    Collection distribC = theColumn.getDistributionStatistics();
                    Iterator it = distribC.iterator();
                    this.distribution = new String[distribC.size()];
                    int i = 0;
                    while (it.hasNext()) {
                        ColumnStatistics2 cstat = (ColumnStatistics2)it.next();
                        this.distribution[i] = cstat.getDistributionValue();
                        ++i;
                    }
                }
                catch (M4Exception m4e) {
                    throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
                }
            }
        }
        if (this.distribution.length == 0) {
            throw new M4CompilerError("Error in SegmentationStratified: no values found for segmenting column!");
        }
        if (columnSetIndex < 0 || columnSetIndex >= this.distribution.length) {
            throw new M4CompilerError("Error in SegmentationStratified: wrong index for ColumnSet condition!");
        }
        String curr = this.distribution[columnSetIndex];
        if (this.getTheAttribute().getConceptualDataType() != 7L && this.getTheAttribute().getConceptualDataType() != 9L) {
            curr = DB.quote(curr);
        }
        String sqlCondition = theColumn.getSQLDefinition() + " = " + curr;
        return sqlCondition;
    }

    public BaseAttribute getTheAttribute() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheAttribute");
    }

    public int numberOfSegments() throws M4CompilerError {
        Column theColumn;
        Columnset inCS;
        try {
            inCS = this.getInputConcept().getCurrentColumnSet();
            theColumn = this.getTheAttribute().getCurrentColumn();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        if (theColumn == null) {
            throw new M4CompilerError("Operator SegmentationStratified: could not find the Column for parameter TheAttribute ('" + this.getTheAttribute().getName() + "') that belongs to the current ColumnSet '" + inCS.getName() + "'!");
        }
        this.distribution = this.getM4Db().getDistinctElements(theColumn);
        if (this.distribution == null) {
            return 0;
        }
        return this.distribution.length;
    }

    public void setCSSegmentInfo(String inputMultiStepBranch, Columnset cs, int index) throws M4CompilerError {
        String sqlDef = SegmentationStratified.unBracket(cs.getSQLDefinition());
        String value = SegmentationStratified.lastAssignmentValue(sqlDef);
        try {
            cs.addMultiStepBranchInfo(inputMultiStepBranch, this.getTheAttribute().getName(), value);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private static String unBracket(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("(") && s.endsWith(")")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static String lastAssignmentValue(String s) {
        if (s == null) {
            return null;
        }
        int eqIdx = s.lastIndexOf(61);
        s = eqIdx != -1 ? s.substring(eqIdx + 1).trim() : "";
        return s;
    }
}

