/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.RowSelection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public final class RowSelectionByQuery
extends RowSelection {
    public String generateConditionForOp() throws M4CompilerError {
        try {
            String sqlCondition = "";
            for (int i = 0; i < this.getNumberOfLoops(); ++i) {
                Value rightCond = this.getTheRightCondition(i);
                String rightExpr = rightCond.isLong() || !this.getTheConditionOperator(i).equalsIgnoreCase("=") ? rightCond.getValue() : DB.quote(rightCond.getValue());
                sqlCondition = sqlCondition + "(" + this.getTheLeftCondition(i).getCurrentColumn().getSQLDefinition() + " " + this.getTheConditionOperator(i) + " " + rightExpr + ") AND ";
            }
            sqlCondition = sqlCondition.substring(0, sqlCondition.length() - 4);
            return sqlCondition;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public EstimatedStatistics estimateStatistics(Step theStep) throws M4Exception {
        EstimatedStatistics myEstStat = super.estimateStatistics(theStep);
        try {
            for (int i = 0; i < this.getNumberOfLoops(); ++i) {
                String targetName = this.getTheLeftCondition(i).getName();
                String operator = this.getTheConditionOperator(i).trim();
                String right = this.getTheRightCondition(i).getValue().trim();
                Vector valueList = myEstStat.getValueList(targetName);
                if (operator.equals("=")) {
                    if (right.startsWith("'") && (right = right.substring(1)).endsWith("'")) {
                        right = right.substring(0, right.length() - 1);
                    }
                    if (!valueList.contains(right)) continue;
                    int noOfOcc = myEstStat.getNumberOfOccurrences(targetName, right);
                    if (noOfOcc != Integer.MIN_VALUE && noOfOcc > 0) {
                        myEstStat.setNumberOfRows(noOfOcc);
                    }
                    Vector<String> newValueList = new Vector<String>();
                    newValueList.add(right);
                    myEstStat.setValueList(targetName, newValueList);
                    myEstStat.setNumberOfOccurrences(targetName, right, noOfOcc);
                    continue;
                }
                Vector remainingValues = this.findRemainingValues(valueList, operator, right);
                if (remainingValues == null) continue;
                Iterator allValIt = valueList.iterator();
                Integer numberOfRemainingRows = new Integer(0);
                while (allValIt.hasNext()) {
                    String aValue = (String)allValIt.next();
                    int noOfOcc = Integer.MIN_VALUE;
                    if (remainingValues.contains(aValue)) {
                        noOfOcc = myEstStat.getNumberOfOccurrences(targetName, aValue);
                        if (noOfOcc != Integer.MIN_VALUE && noOfOcc > 0) {
                            if (numberOfRemainingRows == null) continue;
                            numberOfRemainingRows = new Integer(numberOfRemainingRows + noOfOcc);
                            continue;
                        }
                        numberOfRemainingRows = null;
                        continue;
                    }
                    myEstStat.removeValue(aValue, targetName);
                }
                if (numberOfRemainingRows == null) continue;
                myEstStat.setNumberOfRows(numberOfRemainingRows);
            }
        }
        catch (M4CompilerError mce) {
            throw new M4Exception("Error when estimating statistics: " + mce.getMessage());
        }
        return myEstStat;
    }

    private Vector findRemainingValues(Vector listOfValues, String operator, String right) {
        if (operator.equalsIgnoreCase("in")) {
            if (right.startsWith("(") && (right = right.substring(1)).endsWith(")")) {
                right = right.substring(0, right.length() - 1);
            }
            right = right.trim();
            StringTokenizer st = new StringTokenizer(right, ",");
            Vector<String> theValues = new Vector<String>();
            while (st.hasMoreTokens()) {
                String oneValue = st.nextToken();
                if (oneValue.startsWith("'") && (oneValue = oneValue.substring(1)).endsWith("'")) {
                    oneValue = oneValue.substring(0, oneValue.length() - 1);
                }
                if (!listOfValues.contains(oneValue = oneValue.trim())) continue;
                theValues.add(oneValue);
            }
            if (theValues.isEmpty()) {
                return null;
            }
            return theValues;
        }
        boolean smaller = operator.startsWith("<");
        boolean bigger = operator.startsWith(">");
        boolean orEqual = operator.endsWith("=");
        if (smaller || bigger) {
            String compareToValue = right;
            if (compareToValue.startsWith("'") && (compareToValue = compareToValue.substring(1)).endsWith("'")) {
                compareToValue = compareToValue.substring(0, compareToValue.length() - 1);
            }
            compareToValue = compareToValue.trim();
            double compareToD = Double.NaN;
            try {
                compareToD = Double.parseDouble(compareToValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
            Vector<String> remainingValues = new Vector<String>();
            Iterator it = listOfValues.iterator();
            while (it.hasNext()) {
                String testValue = (String)it.next();
                double testD = Double.NaN;
                try {
                    testD = Double.parseDouble(testValue);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
                if (!(bigger && testD > compareToD || smaller && testD < compareToD || bigger && orEqual && testD >= compareToD) && (!smaller || !orEqual || !(testD <= compareToD))) continue;
                remainingValues.add(testValue);
            }
            if (remainingValues.isEmpty()) {
                return null;
            }
            return remainingValues;
        }
        return null;
    }

    public BaseAttribute getTheLeftCondition(int loopNr) throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheLeftCondition", loopNr);
    }

    public String getTheConditionOperator(int loopNr) throws M4CompilerError {
        return ((Value)this.getSingleParameter("TheConditionOperator", loopNr)).getValue();
    }

    public Value getTheRightCondition(int loopNr) throws M4CompilerError {
        return (Value)this.getSingleParameter("TheRightCondition", loopNr);
    }
}

