/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ReversePivotize
extends SingleCSOperator {
    public static final String PARAMETER_PIVOT_ATTRS = "ThePivotizedAttributes";
    public static final String PARAMETER_VALUES = "IndexValues";
    public static final String PARAMETER_KEY_ATTR = "TheKeyAttribute";
    public static final String PARAMETER_NAME_PIVOT = "NameForPivotAttribute";
    public static final String PARAMETER_NAMES_INDEX_ATTRS = "NamesForIndexAttributes";
    private String selectSimpleColumns = null;

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        try {
            int i;
            String sqlDef = "(SELECT " + selectPart + " FROM ";
            long stepId = this.getStep().getId();
            BaseAttribute[] oldPivotAttrs = this.getInputPivotAttrs();
            String[] indexValues = this.getIndexVals();
            String[] indexAttrNames = this.getNewIndexAttrs();
            String nameOfPivotAttribute = ((Value[])this.getParameter(PARAMETER_NAME_PIVOT))[0].getValue();
            String selectInner = "";
            for (i = 0; i < oldPivotAttrs.length; ++i) {
                String selectForView = this.selectSimpleColumns + ", " + oldPivotAttrs[i].getName() + " AS " + nameOfPivotAttribute;
                selectInner = this.selectSimpleColumns + ", " + nameOfPivotAttribute;
                StringTokenizer st = new StringTokenizer(indexValues[i], ", ");
                if (st.countTokens() != indexAttrNames.length) {
                    throw new M4CompilerError("Operator ReversePivotize: Each entry in parameter 'IndexValues' must have as many values as there are index attributes!");
                }
                int pos = 0;
                while (st.hasMoreTokens()) {
                    selectForView = selectForView + ", '" + st.nextToken().trim() + "' AS " + indexAttrNames[pos];
                    selectInner = selectInner + ", " + indexAttrNames[pos];
                    ++pos;
                }
                String tempViewDef = "CREATE OR REPLACE VIEW tmp_" + stepId + "_" + i + " AS (SELECT " + selectForView + " FROM (" + this.getInputConcept().getCurrentColumnSet().getCompleteSQLQuery() + "))";
                try {
                    this.getM4Db().executeBusinessSqlWrite(tempViewDef);
                    this.getM4Db().addViewToTrash(tempViewDef, this.getInputConcept().getCurrentColumnSet().getSchema(), stepId);
                    continue;
                }
                catch (SQLException sqle) {
                    throw new M4CompilerError("Operator ReversePivotize: SQL error trying to create a temporary view.\nMessage: " + sqle.getMessage() + "\n" + "View definition was: " + tempViewDef + "\n");
                }
            }
            for (i = 0; i < oldPivotAttrs.length; ++i) {
                sqlDef = sqlDef + "(SELECT " + selectPart + " FROM tmp_" + stepId + "_" + i + ") UNION ";
            }
            sqlDef = sqlDef.substring(0, sqlDef.length() - 7);
            sqlDef = sqlDef + ")";
            return sqlDef;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Pivotize: M4Exception caught when accessing input concept/its columnset: " + m4e.getMessage());
        }
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        String columnExpr = "";
        this.selectSimpleColumns = "";
        BaseAttribute[] theExistingPivotAttrs = this.getInputPivotAttrs();
        try {
            Collection outFeatures = this.getOutputConcept().getFeatures();
            if (outFeatures == null || outFeatures.isEmpty()) {
                throw new M4CompilerError("Operator ReversePivotize: No Features found in the output concept!");
            }
            Iterator it = outFeatures.iterator();
            while (it.hasNext()) {
                Feature outF = (Feature)it.next();
                for (int i = 0; i < theExistingPivotAttrs.length; ++i) {
                    if (!outF.correspondsTo(theExistingPivotAttrs[i])) continue;
                    throw new M4CompilerError("Operator ReversePivotize: found an Input Pivot-BA in the Output Concept!");
                }
                if ((this.isNewIndexAttr(outF) || outF.getName().equalsIgnoreCase(this.getNewPivotAttr())) && !(outF instanceof BaseAttribute)) {
                    throw new M4CompilerError("ReversePivotize ('" + this.getStep().getName() + "'): cannot handle MultiColumnFeatures like '" + outF.getName() + "!");
                }
                int iIn = 0;
                Feature inF = null;
                do {
                    inF = this.getInputConcept().getFeature(iIn);
                } while (++iIn < this.getInputConcept().getFeatures().size() && !outF.correspondsTo(inF));
                if (!outF.correspondsTo(inF) && (this.isNewIndexAttr(outF) || outF.getName().equalsIgnoreCase(this.getNewPivotAttr()))) {
                    String columnDatatype = null;
                    columnDatatype = outF.getName().equalsIgnoreCase(this.getNewPivotAttr()) ? this.getColDataTypeOfPivotAttr() : this.getColDataTypeOfIndexAttr(outF.getName());
                    Column outCol = csForOutputConcept.createColumn(outF.getName(), columnDatatype);
                    this.getStep().addToTrash(outCol);
                    outCol.setBaseAttribute((BaseAttribute)outF);
                    outCol.setSQLDefinition(outF.getName());
                    columnExpr = columnExpr + outF.getName() + ", ";
                    continue;
                }
                if (!outF.correspondsTo(inF)) {
                    throw new M4CompilerError("Operator ReversePivotize ('" + this.getStep().getName() + "'): found Feature '" + outF.getName() + "' in output concept that should not be there!");
                }
                if (this.isDeselectedParameter(inF)) {
                    this.doPrint(Print.PARAM, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because the corresponding input feature was deselected by " + "a FeatureSelection operator.");
                    continue;
                }
                if (!this.getStep().isVisible(inF)) continue;
                Column outCol = ((BaseAttribute)inF).getCurrentColumn().copyColToCS(csForOutputConcept);
                this.getStep().addToTrash(outCol);
                outCol.setBaseAttribute((BaseAttribute)outF);
                outCol.setSQLDefinition(outCol.getName());
                columnExpr = columnExpr + outCol.getName() + ", ";
                this.selectSimpleColumns = this.selectSimpleColumns + outCol.getName() + ", ";
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator ReversePivotize: M4 Exception caught when generating metadata: " + m4e.getMessage());
        }
        if (columnExpr.length() <= 2) {
            throw new M4CompilerError("Operator ReversePivotize: No columns created for output concept!");
        }
        columnExpr = columnExpr.substring(0, columnExpr.length() - 2);
        if (this.selectSimpleColumns.length() > 2) {
            this.selectSimpleColumns = this.selectSimpleColumns.substring(0, this.selectSimpleColumns.length() - 2);
        }
        return columnExpr;
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return false;
    }

    private String[] getNewIndexAttrs() throws M4CompilerError {
        Value[] vs = (Value[])this.getParameter(PARAMETER_NAMES_INDEX_ATTRS);
        if (vs == null || vs.length == 0) {
            throw new M4CompilerError("Operator ReversePivotize: Parameter 'NamesForIndexAttributes' not found!");
        }
        String[] names = new String[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            names[i] = vs[i].getValue();
        }
        return names;
    }

    private String getColDataTypeOfPivotAttr() throws M4CompilerError {
        BaseAttribute[] pivBAs = this.getInputPivotAttrs();
        try {
            Column oneCol = pivBAs[0].getCurrentColumn();
            return oneCol.getColumnDataTypeName();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator ReversePivotize: M4 error accessing a column of an input Pivot attribute: " + m4e.getMessage());
        }
    }

    public static String getConDataTypeOfPivotAttr(BaseAttribute[] pivotAttrs) throws M4Exception {
        if (pivotAttrs != null && pivotAttrs.length > 0) {
            return pivotAttrs[0].getConceptualDataTypeName();
        }
        return null;
    }

    public static String getConDataTypeOfIndexAttr(String nameOfIndexAttr, String[] indexValues, String[] indexAttrNames) throws M4Exception {
        String[] values = ReversePivotize.getValuesOfIndexAttr(nameOfIndexAttr, indexValues, indexAttrNames);
        boolean allNumbers = true;
        for (int i = 0; i < values.length; ++i) {
            try {
                Double.parseDouble(values[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                allNumbers = false;
            }
        }
        if (allNumbers) {
            return "NUMERIC";
        }
        return "NOMINAL";
    }

    private String getColDataTypeOfIndexAttr(String nameOfIndexAttr) throws M4CompilerError {
        try {
            String[] indexVals = this.getIndexVals();
            String[] indexAttrNames = this.getNewIndexAttrs();
            String[] values = ReversePivotize.getValuesOfIndexAttr(nameOfIndexAttr, indexVals, indexAttrNames);
            boolean allNumbers = true;
            for (int i = 0; i < values.length; ++i) {
                try {
                    Double.parseDouble(values[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    allNumbers = false;
                }
            }
            if (allNumbers) {
                return "NUMBER";
            }
            return "STRING";
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    private static String[] getValuesOfIndexAttr(String nameOfIndexAttr, String[] indexVals, String[] indexAttrNames) throws M4Exception {
        int position = 0;
        while (!indexAttrNames[position].equalsIgnoreCase(nameOfIndexAttr)) {
            ++position;
        }
        if (!indexAttrNames[position].equalsIgnoreCase(nameOfIndexAttr)) {
            throw new M4Exception("Operator ReversePivotize: Could not find output concept feature '" + nameOfIndexAttr + "' in list of index attributes!");
        }
        String[] valuesOfGivenIndexAttr = new String[indexVals.length];
        for (int i = 0; i < indexVals.length; ++i) {
            int posOfToken;
            StringTokenizer st = new StringTokenizer(indexVals[i], ",");
            String oneIndexValue = null;
            for (posOfToken = -1; posOfToken < position && st.hasMoreTokens(); ++posOfToken) {
                oneIndexValue = st.nextToken().trim();
            }
            if (posOfToken != position) {
                throw new M4Exception("Operator ReversePivotize: List of index values '" + indexVals[i] + "' does not match the number of index attributes given!");
            }
            valuesOfGivenIndexAttr[i] = oneIndexValue;
        }
        return valuesOfGivenIndexAttr;
    }

    private BaseAttribute[] getInputPivotAttrs() throws M4CompilerError {
        BaseAttribute[] bas = (BaseAttribute[])this.getParameter(PARAMETER_PIVOT_ATTRS);
        if (bas == null || bas.length == 0) {
            throw new M4CompilerError("Operator ReversePivotize: Parameter 'ThePivotizedAttributes' not found!");
        }
        return bas;
    }

    private String getNewPivotAttr() throws M4CompilerError {
        Value[] vs = (Value[])this.getParameter(PARAMETER_NAME_PIVOT);
        if (vs == null || vs.length == 0) {
            throw new M4CompilerError("Operator ReversePivotize: Parameter 'NameForPivotAttribute' not found!");
        }
        return vs[0].getValue();
    }

    private boolean isNewIndexAttr(Feature outputConceptFeature) throws M4CompilerError {
        String[] namesOfNewIndexAttrs = this.getNewIndexAttrs();
        for (int i = 0; i < namesOfNewIndexAttrs.length; ++i) {
            if (!outputConceptFeature.getName().equalsIgnoreCase(namesOfNewIndexAttrs[i])) continue;
            return true;
        }
        return false;
    }

    private String[] getIndexVals() throws M4CompilerError {
        Value[] vals = (Value[])this.getParameter(PARAMETER_VALUES);
        if (vals == null || vals.length == 0) {
            throw new M4CompilerError("Operator ReversePivotize: Parameter 'IndexValues' not found!");
        }
        String[] st = new String[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            st[i] = vals[i].getValue();
        }
        return st;
    }
}

