/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.Segmentation;

public class Repeat
extends Segmentation {
    private static final String MULTISTEPBRANCH_ATTRIBUTE = "(Repeat)";

    public String generateConditionForOp(int columnSetIndex) throws M4CompilerError {
        return null;
    }

    public String generateSQLDefinition(String selectPart, int index) throws M4CompilerError {
        try {
            Columnset cs = this.getInputConcept().getCurrentColumnSet();
            return "(" + cs.getCompleteSQLQuery() + ")";
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'Repeat': Error trying to read the SQL definition of Columnset of Concept '" + this.getInputConcept().getName() + "' in step '" + this.getStep().getName() + "'");
        }
    }

    public int numberOfSegments() throws M4CompilerError {
        Value value = (Value)this.getSingleParameter("HowOften");
        if (value == null || value.getValue() == null) {
            throw new M4CompilerError("Operator 'Repeat': Mandatory parameter 'HowOften' not set!");
        }
        try {
            return Integer.parseInt(value.getValue());
        }
        catch (NumberFormatException e) {
            throw new M4CompilerError("Operator 'Repeat': Parameter 'HowOften' is no integer!");
        }
    }

    public void setCSSegmentInfo(String inputMultiStepBranch, Columnset cs, int index) throws M4CompilerError {
        try {
            cs.addMultiStepBranchInfo(inputMultiStepBranch, MULTISTEPBRANCH_ATTRIBUTE, Integer.toString(index));
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }
}

