/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.ConfigReader;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4CompilerWarning;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.UserError;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

public class PrepareForYale
extends ExecutableOperator {
    private static final String PARAMETER_INPUT_CONCEPT = "TheInputConcept";
    private static final String PARAMETER_PRIMARY_KEY = "ThePrimaryKey";
    private static final String PARAMETER_LABEL = "TheLabel";
    private static final String PARAMETER_EXPERIMENT_FILE = "ExperimentFileName";
    private static final String PARAMETER_QUERY_FILE = "QueryFilePrefix";

    public void createStatement(boolean lazy) throws SQLException, M4CompilerError {
        Collection colsets;
        try {
            colsets = this.getTheInputConcept().getColumnSets();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator PrepareForYale: M4Exception caught when reading the Columnsets for the input concept: " + m4e.getMessage());
        }
        if (colsets == null || colsets.isEmpty()) {
            throw new M4CompilerError("Operator PrepareForYale: No Columnsets found in input concept!");
        }
        if (colsets.size() > 1 && !lazy) {
            this.createQueryFiles(colsets);
        }
        this.createYaleFile(colsets, lazy);
    }

    public void execute(boolean lazy) throws UserError, M4CompilerWarning, M4CompilerError, M4Exception, SQLException {
        super.execute(lazy);
        try {
            if (!lazy) {
                Concept inputConcept = this.getTheInputConcept();
                while (inputConcept.hasNextColumnSet()) {
                    inputConcept.getNextColumnSet();
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in 'execute' method in PrepareForYale: " + m4e.getMessage());
        }
    }

    public void compileStatement() throws SQLException, M4CompilerError {
    }

    public EstimatedStatistics estimateStatistics(Step theStep) throws M4Exception {
        return null;
    }

    private void createQueryFiles(Collection columnsets) throws M4CompilerError {
        String filePrefix = this.getQueryFilePrefix();
        if (filePrefix == null) {
            throw new M4CompilerError("Operator PrepareForYale: found more than one columnset attached to input concept; need Parameter 'QueryFilePrefix'!");
        }
        Iterator it = columnsets.iterator();
        int suffix = 1;
        try {
            while (it.hasNext()) {
                Columnset cs = (Columnset)it.next();
                PrintStream out = new PrintStream(new FileOutputStream(filePrefix + suffix));
                out.println(this.getQuery(cs));
                out.close();
                ++suffix;
            }
        }
        catch (IOException ioe) {
            throw new M4CompilerError("Operator PrepareForYale: query file prefix not valid; IO error: " + ioe.getMessage());
        }
    }

    private String getQuery(Columnset cs) throws M4CompilerError {
        if (cs == null) {
            throw new M4CompilerError("Operator PrepareForYale: columnset for query creation was null!");
        }
        try {
            String theQuery = cs.getCompleteSQLQuery();
            theQuery = theQuery.replaceAll("<", "&lt;");
            theQuery = theQuery.replaceAll(">", "&gt;");
            return theQuery;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator PrepareForYale: could not generate query for columnset '" + cs.getName() + "': " + m4e.getMessage());
        }
    }

    private void createYaleFile(Collection colsets, boolean lazy) throws M4CompilerError {
        String primkey;
        String urlprefix;
        String passw;
        String username;
        String dbname;
        String indent;
        boolean useIteratingOperatorChain = colsets.size() > 1 && !lazy;
        PrintStream out = this.getPrinterToExperimentFile();
        out.println("<!-- This file was created by the MiningMart operator 'PrepareForYale'. -->");
        out.println("<operator name=\"Root\" class=\"Experiment\">");
        if (useIteratingOperatorChain) {
            out.println("  <operator name=\"IterateOverColumnsets\" class=\"IteratingOperatorChain\">");
            indent = "    ";
            this.addParameterToYaleFile(out, indent, "start", "1");
            this.addParameterToYaleFile(out, indent, "end", "" + colsets.size());
        } else {
            indent = "  ";
        }
        out.println(indent + "<operator name=\"ReadDataFromDB\" class=\"DatabaseExampleSource\">");
        indent = indent + "  ";
        try {
            String dbConfigFileName = System.getProperty("DB_CONFIG_PATH");
            ConfigReader cr = new ConfigReader(dbConfigFileName);
            dbname = cr.getBusDbName();
            username = cr.getBusUser();
            passw = cr.getBusPw();
            urlprefix = cr.getBusUrl();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator PrepareForYale: " + m4e.getMessage());
        }
        String driver = null;
        if (this.getM4Db().getBusinessDbms() == 1) {
            driver = "oracle.jdbc.driver.OracleDriver";
        }
        if (this.getM4Db().getBusinessDbms() == 2) {
            driver = "org.postgresql.Driver";
        }
        this.addParameterToYaleFile(out, indent, "driver", driver);
        this.addParameterToYaleFile(out, indent, "urlprefix", urlprefix);
        this.addParameterToYaleFile(out, indent, "databasename", dbname);
        this.addParameterToYaleFile(out, indent, "username", username);
        this.addParameterToYaleFile(out, indent, "password", passw);
        String label = this.getNameOfBaParam(PARAMETER_LABEL);
        if (label != null) {
            this.addParameterToYaleFile(out, indent, "label_attribute", label.toUpperCase());
        }
        if ((primkey = this.getNameOfBaParam(PARAMETER_PRIMARY_KEY)) != null) {
            this.addParameterToYaleFile(out, indent, "id_attribute", primkey.toUpperCase());
        }
        if (useIteratingOperatorChain) {
            this.addParameterToYaleFile(out, indent, "query_file", this.getQueryFilePrefix() + "%a");
        } else {
            try {
                this.addParameterToYaleFile(out, indent, "query", this.getQuery(this.getTheInputConcept().getCurrentColumnSet()));
            }
            catch (M4Exception m4e) {
                throw new M4CompilerError("Operator PrepareForYale: M4 exception caught when accessing current input columnset: " + m4e.getMessage());
            }
        }
        indent = indent.substring(0, indent.length() - 2);
        out.println(indent + "</operator>");
        if (useIteratingOperatorChain) {
            out.println("  </operator>");
        }
        out.println("</operator>");
    }

    private void addParameterToYaleFile(PrintStream out, String indent, String key, String value) {
        if (value == null) {
            value = "UNKNOWN";
        }
        out.println(indent + "<parameter key=\"" + key + "\" value=\"" + value + "\"/>");
    }

    private Concept getTheInputConcept() throws M4CompilerError {
        return (Concept)this.getSingleParameter(PARAMETER_INPUT_CONCEPT);
    }

    private PrintStream getPrinterToExperimentFile() throws M4CompilerError {
        PrintStream out;
        Value v = (Value)this.getSingleParameter(PARAMETER_EXPERIMENT_FILE);
        if (v == null) {
            throw new M4CompilerError("Operator PrepareForYale: Parameter 'ExperimentFileName' not found!");
        }
        String nameOfFile = v.getValue();
        if (nameOfFile == null || nameOfFile.equals("")) {
            throw new M4CompilerError("Operator PrepareForYale: Parameter 'ExperimentFileName' not found!");
        }
        try {
            out = new PrintStream(new FileOutputStream(nameOfFile));
        }
        catch (IOException ioe) {
            throw new M4CompilerError("Operator PrepareForYale: Filename found in Parameter 'ExperimentFileName' is not valid!");
        }
        return out;
    }

    private String getQueryFilePrefix() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter(PARAMETER_QUERY_FILE);
        if (v == null || v.getValue() == null || v.getValue().equals("")) {
            return null;
        }
        return v.getValue();
    }

    private String getNameOfBaParam(String paramName) throws M4CompilerError {
        BaseAttribute ba = (BaseAttribute)this.getSingleParameter(paramName);
        if (ba == null) {
            return null;
        }
        try {
            return ba.getCurrentColumn().getName();
        }
        catch (NullPointerException npe) {
            throw new M4CompilerError("Operator PrepareForYale: found no column attached to BA specified by parameter '" + paramName + "'!");
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator PrepareForYale: M4 error accessing BA specified by parameter '" + paramName + "': " + m4e.getMessage());
        }
    }
}

