/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Pivotize
extends SingleCSOperator {
    public static final String PARAMETER_GROUPBY_ATTR = "TheGroupByAttributes";
    public static final String PARAMETER_INDEX_ATTR = "TheIndexAttributes";
    public static final String PARAMETER_PIVOT_ATTR = "ThePivotAttribute";
    public static final String PARAMETER_VALUES = "IndexValues";
    public static final String PARAMETER_AGGREGATION = "AggregationOperator";
    public static final String PARAMETER_NULLORZERO = "NullOrZero";
    public static final String NO_AGGREGATION_VALUE = "NONE";
    private Collection myAttributeValueCombinations = null;
    private boolean groupByAttribsExist = false;
    private boolean aggregationFunctionExists = false;

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        if (!this.aggregationFunctionExists && this.groupByAttribsExist) {
            throw new M4CompilerError("Operator Pivotize, Step '" + this.getStep().getName() + "': cannot 'group by' without an aggregation function!");
        }
        try {
            String sqlDef = "(SELECT " + selectPart + " FROM " + this.getInputConcept().getCurrentColumnSet().getSchemaPlusName();
            if (this.groupByAttribsExist) {
                sqlDef = sqlDef + " GROUP BY " + this.getGroupByStatement();
            }
            sqlDef = sqlDef + ")";
            return sqlDef;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Pivotize: M4Exception caught when accessing input concept/its columnset: " + m4e.getMessage());
        }
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        String columnExpr = "";
        Feature[] theGroupByFeatures = (Feature[])this.getParameter(PARAMETER_GROUPBY_ATTR);
        Feature[] theIndexAttrs = (Feature[])this.getParameter(PARAMETER_INDEX_ATTR);
        try {
            Collection outFeatures = this.getOutputConcept().getFeatures();
            if (outFeatures == null || outFeatures.isEmpty()) {
                throw new M4CompilerError("Operator Pivotize: No Features found in the output concept!");
            }
            Iterator it = outFeatures.iterator();
            while (it.hasNext()) {
                Feature outF = (Feature)it.next();
                for (int i = 0; i < theIndexAttrs.length; ++i) {
                    if (!outF.correspondsTo(theIndexAttrs[i])) continue;
                    throw new M4CompilerError("Operator Pivotize: found an Index BA in the Output Concept!");
                }
                Feature inF = null;
                if (theGroupByFeatures != null && theGroupByFeatures.length > 0) {
                    inF = this.correspondsToOneOf(outF, theGroupByFeatures);
                }
                if (inF != null) {
                    this.groupByAttribsExist = true;
                    columnExpr = this.createMetadata(inF, outF, csForOutputConcept, columnExpr);
                    continue;
                }
                if (!(outF instanceof BaseAttribute)) {
                    throw new M4CompilerError("Pivotize ('" + this.getStep().getName() + "'): cannot handle MultiColumnFeatures like '" + outF.getName() + "!");
                }
                AttributeValueCombination theCombi = this.getCombination((BaseAttribute)outF);
                if (theCombi == null) {
                    this.doPrint(Print.OPERATOR, "Operator PivotizeWithAggregation: skipped OutputConcept feature '" + outF.getName() + "' because no corresponding GroupBy- or Output Attribute was found.");
                    continue;
                }
                columnExpr = this.createPivotizedColumn(theCombi, (BaseAttribute)outF, csForOutputConcept, columnExpr);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Pivotize: M4 Exception caught when generating metadata: " + m4e.getMessage());
        }
        if (columnExpr.length() <= 2) {
            throw new M4CompilerError("Operator Pivotize: No columns created for output concept!");
        }
        columnExpr = columnExpr.substring(0, columnExpr.length() - 2);
        return columnExpr;
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return false;
    }

    private Feature correspondsToOneOf(Feature f, Feature[] someFeatures) {
        for (int i = 0; i < someFeatures.length; ++i) {
            if (!someFeatures[i].correspondsTo(f)) continue;
            return someFeatures[i];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String createPivotizedColumn(AttributeValueCombination theCombi, BaseAttribute outBA, Columnset csForOutputConcept, String columnExpr) throws M4CompilerError {
        void var7_7;
        Column pivotCol;
        String myNull;
        BaseAttribute pivotBA = (BaseAttribute)this.getSingleParameter(PARAMETER_PIVOT_ATTR);
        Value nullOrZero = (Value)this.getSingleParameter(PARAMETER_NULLORZERO);
        if (nullOrZero == null || nullOrZero.getValue().equalsIgnoreCase("null")) {
            myNull = "NULL";
        } else if (nullOrZero.getValue().equalsIgnoreCase("zero")) {
            myNull = "0";
        } else {
            throw new M4CompilerError("Operator Pivotize: Parameter 'NullOrZero' must be 'Null' or 'Zero'!");
        }
        Value agg = (Value)this.getSingleParameter(PARAMETER_AGGREGATION);
        String aggregationOpString = "";
        if (!agg.getValue().equals(NO_AGGREGATION_VALUE)) {
            aggregationOpString = agg.getValue().toUpperCase();
            this.aggregationFunctionExists = true;
        }
        String when = null;
        try {
            pivotCol = pivotBA.getCurrentColumn();
            if (pivotCol == null) {
                throw new M4CompilerError("Operator Pivotize: Could not find column for pivot BA '" + pivotBA.getName() + "!");
            }
            when = "";
            for (int i = 0; i < theCombi.getNoOfIndexes(); ++i) {
                BaseAttribute indexBA = theCombi.getIndexBA(i);
                Column indexCol = indexBA.getCurrentColumn();
                if (indexCol == null) {
                    throw new M4CompilerError("Operator Pivotize: Could not find column for index BA '" + indexBA.getName() + "'!");
                }
                String indexValue = theCombi.getIndexValue(i);
                boolean indexColNominal = indexCol.getColumnDataTypeName().equalsIgnoreCase("STRING");
                when = when + indexCol.getSQLPlusLocation() + " = " + (indexColNominal ? DB.quote(indexValue) : indexValue) + " AND ";
            }
            if (!when.equals("")) {
                when = when.substring(0, when.length() - 5);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Pivotize: M4 Exception caught when accessing column of index or pivot attribute: " + m4e.getMessage());
        }
        if (when == null || when.equals("")) {
            throw new M4CompilerError("Operator Pivotize (Step '" + this.getStep().getName() + "'): no when conditions created!");
        }
        String colDef = aggregationOpString + "(CASE WHEN " + when + " THEN " + pivotCol.getSQLPlusLocation() + " ELSE " + (String)var7_7 + " END)";
        try {
            Column outputColumn = pivotCol.copyColToCS(csForOutputConcept);
            this.getStep().addToTrash(outputColumn);
            outputColumn.setBaseAttribute(outBA);
            outputColumn.setSQLDefinition(outBA.getName());
            outputColumn.setName(outBA.getName());
            return columnExpr + colDef + " AS " + outBA.getName() + ", ";
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Pivotize: M4 exception caught when creating column for output BaseAttribute '" + outBA.getName() + "': " + m4e.getMessage());
        }
    }

    private String getGroupByStatement() throws M4CompilerError {
        Feature[] theGroupByFeatures = (Feature[])this.getParameter(PARAMETER_GROUPBY_ATTR);
        String theList = "";
        try {
            for (int i = 0; i < theGroupByFeatures.length; ++i) {
                if (theGroupByFeatures[i] instanceof BaseAttribute) {
                    theList = theList + ((BaseAttribute)theGroupByFeatures[i]).getCurrentColumn().getName() + ", ";
                    continue;
                }
                if (!(theGroupByFeatures[i] instanceof MultiColumnFeature)) {
                    throw new M4CompilerError("Operator Pivotize: One of the features listed in 'TheGroupByAttributes' is neither a BaseAttribute nor a MCF!");
                }
                Collection c = ((MultiColumnFeature)theGroupByFeatures[i]).getBaseAttributes();
                if (c == null || c.isEmpty()) {
                    throw new M4CompilerError("Operator Pivotize: No BAs found in MCF '" + theGroupByFeatures[i].getName() + "'!");
                }
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    BaseAttribute ba = (BaseAttribute)it.next();
                    theList = theList + ba.getCurrentColumn().getName() + ", ";
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Pivotize: M4Exception caught when collecting the names of the GroupBy-Attributes: " + m4e.getMessage());
        }
        if (theList.length() > 2) {
            theList = theList.substring(0, theList.length() - 2);
        }
        return theList;
    }

    private BaseAttribute[] getIndexBAs() throws M4CompilerError {
        BaseAttribute[] bas = (BaseAttribute[])this.getParameter(PARAMETER_INDEX_ATTR);
        if (bas == null || bas.length == 0) {
            throw new M4CompilerError("Operator Pivotize: Parameter 'TheIndexAttributes' not found!");
        }
        return bas;
    }

    private String[] getIndexVals() throws M4CompilerError {
        Value[] vals = (Value[])this.getParameter(PARAMETER_VALUES);
        if (vals == null || vals.length == 0) {
            throw new M4CompilerError("Operator Pivotize: Parameter 'IndexValues' not found!");
        }
        String[] st = new String[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            st[i] = vals[i].getValue();
        }
        return st;
    }

    private Collection getAttrValueCombis() throws M4CompilerError {
        if (this.myAttributeValueCombinations != null) {
            return this.myAttributeValueCombinations;
        }
        BaseAttribute[] indexBAs = this.getIndexBAs();
        String[] indexVals = this.getIndexVals();
        try {
            this.myAttributeValueCombinations = Pivotize.getCombinations(indexVals, indexBAs, (BaseAttribute)this.getSingleParameter(PARAMETER_PIVOT_ATTR));
            return this.myAttributeValueCombinations;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Pivotize-Operator in Step '" + this.getStep().getName() + "': error computing combinations of index values: " + m4e.getMessage());
        }
    }

    private AttributeValueCombination getCombination(BaseAttribute outputBa) throws M4CompilerError {
        Iterator it = this.getAttrValueCombis().iterator();
        while (it.hasNext()) {
            AttributeValueCombination avc = (AttributeValueCombination)it.next();
            if (!avc.getOutputBaName().equalsIgnoreCase(outputBa.getName())) continue;
            return avc;
        }
        return null;
    }

    public static Collection getCombinations(String[] indexValues, BaseAttribute[] indexAttrs, BaseAttribute pivotAttr) throws M4Exception {
        if (indexValues == null || indexValues.length == 0 || indexAttrs == null || indexAttrs.length == 0) {
            throw new M4Exception("Pivotize: got empty index information!");
        }
        if (indexValues.length != indexAttrs.length) {
            throw new M4Exception("For pivotisation an equal number of index value parameters and index attributes is needed!");
        }
        Vector ret = new Vector();
        Vector currentCombi = new Vector();
        Pivotize.computeCombinations(0, indexAttrs, pivotAttr, indexValues, currentCombi, ret, new Pivotize());
        return ret;
    }

    private static void computeCombinations(int currentIndex, BaseAttribute[] indexAttrs, BaseAttribute pivotAttr, String[] indexValues, Vector currentCombination, Collection theCombis, Pivotize dummy) throws M4Exception {
        String valuesOfCurrentIndexAttr = indexValues[currentIndex];
        StringTokenizer st = new StringTokenizer(valuesOfCurrentIndexAttr, ", ");
        while (st.hasMoreTokens()) {
            String nextValue = st.nextToken().trim();
            Vector nextCombination = (Vector)currentCombination.clone();
            nextCombination.add(nextValue);
            if (currentIndex < indexValues.length - 1) {
                Pivotize.computeCombinations(currentIndex + 1, indexAttrs, pivotAttr, indexValues, nextCombination, theCombis, dummy);
                continue;
            }
            Object[] current = nextCombination.toArray();
            String[] currentCombi = new String[current.length];
            for (int i = 0; i < current.length; ++i) {
                currentCombi[i] = current[i].toString();
            }
            Pivotize pivotize = dummy;
            pivotize.getClass();
            AttributeValueCombination theCombi = pivotize.new AttributeValueCombination(Pivotize.getNameOfOutputAttribute(currentCombi, pivotAttr.getName()), indexAttrs, currentCombi);
            theCombis.add(theCombi);
        }
    }

    public static String getNameOfOutputAttribute(String[] indexValue, String pivotAttrName) {
        String ret = pivotAttrName + "_";
        for (int i = 0; i < indexValue.length; ++i) {
            ret = ret + indexValue[i] + "_";
        }
        ret = ret.substring(0, ret.length() - 1);
        return ret;
    }

    public class AttributeValueCombination {
        private String output;
        private BaseAttribute[] indexAttrs;
        private String[] indexVals;

        public AttributeValueCombination(String outBaName, BaseAttribute[] indexBAs, String[] indexValues) throws M4Exception {
            if (indexBAs.length != indexValues.length) {
                throw new M4Exception("Operator Pivotize: The number of index attributes and the number of index values in a value combination must be equal!");
            }
            this.output = outBaName;
            this.indexAttrs = indexBAs;
            this.indexVals = indexValues;
        }

        public String getOutputBaName() {
            return this.output;
        }

        public int getNoOfIndexes() {
            return this.indexAttrs.length;
        }

        public BaseAttribute getIndexBA(int index) {
            return this.indexAttrs[index];
        }

        public String getIndexValue(int index) {
            return this.indexVals[index];
        }
    }
}

