/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.CompilerDatabaseService;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public abstract class ModelApplier
extends SingleCSOperator {
    private final Vector keyColumns = new Vector();
    private final Vector predictionColumns = new Vector();
    private final Vector tablesAttributes = new Vector();
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Column;

    public Vector getKeyColumns() {
        return this.keyColumns;
    }

    public Vector getKeyColumnNames() {
        return ModelApplier.columnsToColumnNames(this.getKeyColumns());
    }

    public Vector getPredictionColumns() {
        return this.predictionColumns;
    }

    public Vector getPredictionColumnNames() {
        return ModelApplier.columnsToColumnNames(this.getPredictionColumns());
    }

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    private static Vector columnsToColumnNames(Collection columns) {
        Iterator it = columns.iterator();
        Vector<String> names = new Vector<String>();
        while (it.hasNext()) {
            Column col = (Column)it.next();
            if (col == null) continue;
            names.add(col.getName());
        }
        return names;
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        try {
            this.initKeyColumns();
            this.initPredictionColumns();
            String targetTable = this.getTargetTableName();
            Columnset inputCs = this.getInputConcept().getCurrentColumnSet();
            String csSql = inputCs.getSQLDefinition();
            Iterator it = inputCs.getColumns().iterator();
            while (it.hasNext()) {
                Column col = (Column)it.next();
                String sql = col.getSQLDefinition();
                if (sql == null || sql.equals(col.getName()) || sql.length() == 0) continue;
                csSql = inputCs.getCompleteSQLQuery();
                break;
            }
            Iterator it2 = this.getKeyColumns().iterator();
            StringBuffer whereBuf = new StringBuffer();
            while (it2.hasNext()) {
                Column keyC = (Column)it2.next();
                String colName = keyC.getName();
                whereBuf.append("V1." + colName + " = V2." + colName + ", ");
            }
            String whereList = whereBuf.substring(0, whereBuf.length() - 2);
            this.createPredictionsTable();
            this.predict();
            String selectList = this.getViewsSelectList(inputCs, "V1", "V2");
            return "( SELECT " + selectList + " FROM (" + csSql + ") V1, " + targetTable + " V2 " + "WHERE " + whereList + " )";
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
    }

    private String getViewsSelectList(Columnset inputCs, String inputCsPrefix, String tablePrefix) throws M4Exception {
        StringBuffer attributes = new StringBuffer();
        HashSet<String> keys = new HashSet<String>();
        Iterator it = this.getKeyColumns().iterator();
        while (it.hasNext()) {
            keys.add(((Column)it.next()).getName());
        }
        it = inputCs.getColumns().iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            String name = column.getName();
            if (keys.contains(name)) continue;
            String sql = column.getSQLDefinition();
            if (!sql.equals(name)) {
                sql = sql + " AS " + name;
            }
            attributes.append(inputCsPrefix + "." + sql + ", ");
        }
        it = this.tablesAttributes.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            attributes.append(tablePrefix + "." + name + ", ");
        }
        return attributes.substring(0, attributes.length() - 2);
    }

    private void createPredictionsTable() throws M4Exception, M4CompilerError {
        String tableName = this.getTargetTableName();
        CompilerDatabaseService db = this.getM4Db();
        Columnset inputCs = this.getInputConcept().getCurrentColumnSet();
        String inCsSql = inputCs.getSQLDefinition();
        db.dropBusinessTable(tableName);
        String sql = "CREATE TABLE " + tableName + " AS ( SELECT " + this.getSelectStatementOfKeys() + " FROM " + inCsSql + " )";
        try {
            db.executeBusinessSqlWrite(sql);
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator 'ModelApplier': SQLException when trying to create an intermediate table '" + tableName + "'!\nSQL statement was:\n" + sql + "\nException message:\n" + e.getMessage());
        }
        db.addTableToTrash(tableName, inputCs.getSchema(), this.getStep().getId());
        Iterator it = this.getKeyColumns().iterator();
        StringBuffer pkBuf = new StringBuffer();
        while (it.hasNext()) {
            String attribName = ((Column)it.next()).getName();
            this.tablesAttributes.add(attribName);
            pkBuf.append(attribName + ", ");
        }
        if (this.tablesAttributes.isEmpty()) {
            throw new M4CompilerError("Operator 'ModelApplier': No primary key for table '" + tableName + "'found!");
        }
        String pkString = "(" + pkBuf.substring(0, pkBuf.length() - 2) + ")";
        String pkName = tableName + "_idx";
        String sql2 = "ALTER TABLE " + tableName + " ADD ( CONSTRAINT " + pkName + " PRIMARY KEY " + pkString + " )";
        try {
            db.executeBusinessSqlWrite(sql2);
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator 'ModelApplier': SQLException, probably because the primary key constraint of Concept '" + this.getInputConcept().getName() + "', table/view '" + inputCs.getName() + "' is not valid!\n" + e.getMessage());
        }
        db.addIndexToTrash(tableName, inputCs.getSchema(), this.getStep().getId());
    }

    protected void createPredictedAttributeInDb(int loop) throws M4CompilerError {
        BaseAttribute predBa = this.getPredictedAttribute(loop);
        String predColName = predBa.getName();
        String dataType = this.getDatabaseDtForNewColumn(predBa);
        String tableName = this.getTargetTableName();
        String getMetadataQuery = "select * from " + tableName + " where " + this.getM4Db().getUniqueRowIdentifier(true) + " < 2";
        try {
            ResultSet rs = this.getM4Db().executeBusinessSqlRead(getMetadataQuery);
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                if (!rsmd.getColumnName(i).equalsIgnoreCase(predColName)) continue;
                rs.close();
                return;
            }
            rs.close();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator 'ModelApplier': SQLException when trying to find out if attribute '" + predColName + "' for predicted values in table '" + tableName + "' already exists:\n" + sqle.getMessage());
        }
        String sql = "ALTER TABLE " + tableName + " ADD ( " + predColName + " " + dataType + " )";
        try {
            this.getM4Db().executeBusinessSqlWrite(sql);
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator 'ModelApplier': SQLException when trying to add attribute '" + predColName + "' for predicted values to table '" + tableName + "'!\n" + e.getMessage());
        }
        this.tablesAttributes.add(predColName);
    }

    protected String getSelectStatementOfKeys() {
        Vector keys = this.getKeyColumns();
        return this.getSelectFromColumnCollection(keys);
    }

    protected String getSelectStatementOfPredAttribs() {
        Vector predAttribs = this.getPredictionColumns();
        return this.getSelectFromColumnCollection(predAttribs);
    }

    private String getSelectFromColumnCollection(Collection columns) {
        Iterator it = columns.iterator();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        try {
            while (it.hasNext()) {
                Column column = (Column)it.next();
                String sql = column.getSQLDefinition();
                if (!sql.equals(column.getName())) {
                    sql = sql + " AS " + column.getName();
                }
                buf.append(sql + ", ");
                ++i;
            }
            return buf.substring(0, buf.length() - 2);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    private void initKeyColumns() throws M4CompilerError {
        try {
            Collection BAs = this.getTheKeys();
            Iterator it = BAs.iterator();
            Vector<Column> keyColumns = new Vector<Column>();
            while (it.hasNext()) {
                keyColumns.add(((BaseAttribute)it.next()).getCurrentColumn());
            }
            if (keyColumns.isEmpty()) {
                throw new M4CompilerError("Operator 'ModelApplier': Empty set of keys in initKeyColumns() !");
            }
            this.keyColumns.clear();
            this.keyColumns.addAll(keyColumns);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'ModelApplier': M4Exception caught when accessing columns of the Primary Key features: " + m4e.getMessage());
        }
    }

    private void initPredictionColumns() throws M4Exception, M4CompilerError {
        Feature[] predFeatures = this.getThePredictingAttributes();
        if (predFeatures == null || predFeatures.length == 0) {
            throw new M4CompilerError("Operator 'ModelApplier': Empty set of PredictingAttributes!");
        }
        this.predictionColumns.clear();
        for (int i = 0; i < predFeatures.length; ++i) {
            Collection col = this.findInputColumnForFeature(predFeatures[i]);
            this.predictionColumns.addAll(col);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection findInputColumnForFeature(Feature feature) throws M4Exception, M4CompilerError {
        Vector<Column> result = new Vector<Column>();
        Concept inputCon = this.getInputConcept();
        if (feature instanceof BaseAttribute) {
            BaseAttribute inKeyF = ModelApplier.findCorrespondingBaInConcept((BaseAttribute)feature, inputCon);
            if (inKeyF == null) throw new M4CompilerError("Operator 'ModelApplier': BaseAttribute '" + feature.getName() + "' not found in InputConcept!");
            Column keyC = inKeyF.getCurrentColumn();
            result.add(keyC);
            return result;
        } else {
            Iterator it = ((MultiColumnFeature)feature).getBaseAttributes().iterator();
            while (it.hasNext()) {
                BaseAttribute inKeyF = ModelApplier.findCorrespondingBaInConcept((BaseAttribute)it.next(), inputCon);
                if (inKeyF == null) throw new M4CompilerError("Operator 'ModelApplier': MultiColumnFeature '" + feature.getName() + "' has a BaseAttribute not found in the InputConcept!");
                Column keyC = inKeyF.getCurrentColumn();
                result.add(keyC);
            }
        }
        return result;
    }

    protected static String stringCollectionToCommaSeparatedString(Collection columnNames) {
        Iterator it = columnNames.iterator();
        StringBuffer sBuf = new StringBuffer();
        while (it.hasNext()) {
            sBuf.append((String)it.next() + ", ");
        }
        return sBuf.substring(0, sBuf.length() - 2);
    }

    public static BaseAttribute findCorrespondingBaInConcept(BaseAttribute ba, Concept concept) throws M4Exception {
        Iterator it = concept.getFeatures().iterator();
        BaseAttribute result = null;
        while (it.hasNext() && result == null) {
            Feature f = (Feature)it.next();
            if (f instanceof MultiColumnFeature) {
                result = ((MultiColumnFeature)f).getBaseAttributeByName(ba.getName());
                continue;
            }
            if (!ba.correspondsTo(f)) continue;
            result = (BaseAttribute)f;
        }
        return result;
    }

    protected String getTargetTableName() throws M4CompilerError {
        return "TMP_" + this.getStep().getId() + this.getInputConcept().getCurrentSuffix();
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return true;
    }

    protected Columnset createSingleColumnSet(int index) throws M4CompilerError {
        Columnset cs = super.createSingleColumnSet(index);
        HashSet<String> keys = new HashSet<String>();
        Iterator it = this.getKeyColumns().iterator();
        while (it.hasNext()) {
            keys.add(((Column)it.next()).getName());
        }
        CompilerDatabaseService db = this.getM4Db();
        it = this.tablesAttributes.iterator();
        try {
            while (it.hasNext()) {
                String attribName = (String)it.next();
                if (keys.contains(attribName)) continue;
                Column newCol = (Column)((Object)db.createNewInstance(class$edu$udo$cs$miningmart$m4$core$Column == null ? ModelApplier.class$("edu.udo.cs.miningmart.m4.core.Column") : class$edu$udo$cs$miningmart$m4$core$Column));
                newCol.setName(attribName);
                newCol.setColumnset(cs);
                Iterator feaIt = this.getOutputConcept().getFeatures().iterator();
                BaseAttribute correspondingBa = null;
                while (feaIt.hasNext() && correspondingBa == null) {
                    BaseAttribute ba;
                    Feature f = (Feature)feaIt.next();
                    if (f instanceof BaseAttribute) {
                        ba = (BaseAttribute)f;
                        if (!attribName.equals(ba.getName())) continue;
                        correspondingBa = ba;
                        continue;
                    }
                    ba = ((MultiColumnFeature)f).getBaseAttributeByName(attribName);
                    if (ba == null) continue;
                    correspondingBa = ba;
                }
                if (correspondingBa == null) {
                    throw new M4CompilerError("Operator 'ModelApplier' created attribute '" + attribName + "' without a corresponding BaseAttribute!");
                }
                newCol.setBaseAttribute(correspondingBa);
                newCol.setColumnDataTypeName(this.getRelationalDtForNewColumn(correspondingBa));
            }
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
        return cs;
    }

    protected String getDatabaseQueryForRows(Long fromRowNum, Long toRowNum) throws M4CompilerError {
        return this.buildDatabaseQuery() + this.getTupleRestriction(fromRowNum, toRowNum);
    }

    private String buildDatabaseQuery() throws M4CompilerError {
        Columnset inputCs = null;
        try {
            this.getInputConcept().getCurrentColumnSet();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("ModelApplier: M4 error accessing input concept's columnset: " + m4e.getMessage());
        }
        String keys = this.getSelectStatementOfKeys();
        String pred = this.getSelectStatementOfPredAttribs();
        String selectPart = "SELECT " + keys + ", " + pred;
        String fromPart = " FROM " + inputCs.getSQLDefinition();
        return selectPart + fromPart;
    }

    private String getTupleRestriction(Long fromRowNum, Long toRowNum) {
        if (fromRowNum == null && toRowNum == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(" WHERE ");
        if (fromRowNum != null) {
            buf.append("ROWNUM > " + (fromRowNum - 1L));
        }
        if (toRowNum != null) {
            buf.append((fromRowNum != null ? " AND" : "") + " ROWNUM < " + toRowNum + 1);
        }
        return buf.toString();
    }

    public Concept getInputConcept() throws M4CompilerError {
        return super.getInputConcept();
    }

    public Concept getOutputConcept() throws M4CompilerError {
        return super.getOutputConcept();
    }

    public Feature[] getThePredictingAttributes() throws M4CompilerError {
        return (Feature[])this.getParameter("PredictingAttributes");
    }

    public BaseAttribute getPredictedAttribute(int loop) throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("PredictedAttribute", loop);
    }

    public Collection getTheKeys() throws M4CompilerError {
        try {
            Feature[] theFeatures = (Feature[])this.getParameter("PrimaryKey");
            Vector<Feature> theKeyBAs = new Vector<Feature>();
            for (int i = 0; i < theFeatures.length; ++i) {
                if (theFeatures[i] instanceof BaseAttribute) {
                    theKeyBAs.add(theFeatures[i]);
                    continue;
                }
                if (!(theFeatures[i] instanceof MultiColumnFeature)) continue;
                theKeyBAs.addAll(((MultiColumnFeature)theFeatures[i]).getBaseAttributes());
            }
            theKeyBAs.trimToSize();
            return theKeyBAs;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'ModelApplier': M4 exception caught when reading Parameter 'PrimaryKey': " + m4e.getMessage());
        }
    }

    protected abstract String getRelationalDtForNewColumn(BaseAttribute var1);

    protected abstract String getDatabaseDtForNewColumn(BaseAttribute var1) throws M4CompilerError;

    protected abstract void predict() throws M4Exception, M4CompilerError;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

