/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.sql.SQLException;

public class Materialize
extends SingleCSOperator {
    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        Concept concept = this.getInputConcept();
        try {
            Columnset cs;
            if (concept == null || (cs = concept.getCurrentColumnSet()) == null) {
                throw new M4CompilerError("Operator 'Materialize': Found no input Concept/Columnset!");
            }
            String tableName = this.getNewCSName();
            this.getM4Db().dropBusinessTable(tableName);
            String sql = "CREATE TABLE " + tableName + " AS " + cs.getCompleteSQLQuery();
            this.executeBusinessSqlWrite(sql);
            this.getM4Db().addTableToTrash(tableName, cs.getSchema(), this.getStep().getId());
            return tableName;
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Operator 'Materialize': M4Exception caught during createStatement:\n" + e.getMessage());
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator 'Materialize': SQLException caught during createStatement:\n" + e.getMessage());
        }
    }

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return true;
    }

    public String getNewCSName(int index) throws M4CompilerError {
        String tableName = this.getTableName();
        if (tableName == null) {
            return super.getNewCSName(index);
        }
        return tableName + this.getInputConcept().getCurrentSuffix();
    }

    public String getTableName() throws M4CompilerError {
        String s;
        Value value = (Value)this.getSingleParameter("TableName");
        if (value != null && (s = value.getValue()) != null && s.trim().length() > 0) {
            return s.trim();
        }
        return null;
    }
}

