/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.Discretization;

public abstract class ManualDiscretization
extends Discretization {
    protected static String INTERVAL_EXCLUSION = "E";
    protected static String INTERVAL_INCLUSION = "I";

    public void load(Step st) throws M4CompilerError {
        super.load(st);
        if (this.getIntervalStart().length != this.getIntervalEnd().length || this.getIntervalEnd().length != this.getMapTo().length || this.getMapTo().length != this.getStartIncExc().length || this.getStartIncExc().length != this.getEndIncExc().length) {
            throw new M4CompilerError(this.getName() + ": Parameter lists IntervalStart, " + "IntervalEnd, MapTo, StartIncExc and EndIncExc sizes must be equal!");
        }
    }

    public int getCurrentLoopNumber() {
        return 0;
    }

    public Value getDefaultValue() throws M4CompilerError {
        return (Value)this.getSingleParameter("DefaultValue");
    }

    public Value[] getIntervalStart() throws M4CompilerError {
        return (Value[])this.getParameter("IntervalStart");
    }

    public Value[] getIntervalEnd() throws M4CompilerError {
        return (Value[])this.getParameter("IntervalEnd");
    }

    public Value[] getMapTo() throws M4CompilerError {
        return (Value[])this.getParameter("MapTo");
    }

    public Value[] getStartIncExc() throws M4CompilerError {
        return (Value[])this.getParameter("StartIncExc");
    }

    public Value[] getEndIncExc() throws M4CompilerError {
        return (Value[])this.getParameter("EndIncExc");
    }

    public abstract String generateSQL(Column var1) throws M4CompilerError;

    protected String getDiscTableName() {
        return "M4_DT_" + this.getStep().getId() + "_" + this.getCurrentLoopNumber();
    }

    protected String getSmaller(int intervalNumber, boolean start) throws M4CompilerError {
        String parameterName;
        String incOrExc = start ? this.getStartIncExc()[intervalNumber].getValue() : this.getEndIncExc()[intervalNumber].getValue();
        String string = parameterName = start ? "StartIncExc" : "EndIncExc";
        if (incOrExc.equals(INTERVAL_EXCLUSION)) {
            return " < ";
        }
        if (incOrExc.equals(INTERVAL_INCLUSION)) {
            return " <= ";
        }
        throw new M4CompilerError("ManualDiscretization: Found unknown value for parameter '" + parameterName + "': " + incOrExc + "; expected '" + INTERVAL_EXCLUSION + "' or '" + INTERVAL_INCLUSION + "'!");
    }

    protected String getGreater(int intervalNumber, boolean start) throws M4CompilerError {
        String parameterName;
        String incOrExc = start ? this.getStartIncExc()[intervalNumber].getValue() : this.getEndIncExc()[intervalNumber].getValue();
        String string = parameterName = start ? "StartIncExc" : "EndIncExc";
        if (incOrExc.equals(INTERVAL_EXCLUSION)) {
            return " > ";
        }
        if (incOrExc.equals(INTERVAL_INCLUSION)) {
            return " >= ";
        }
        throw new M4CompilerError("ManualDiscretization: Found unknown value for parameter '" + parameterName + "': '" + incOrExc + "'; expected '" + INTERVAL_EXCLUSION + "' or '" + INTERVAL_INCLUSION + "'!");
    }
}

