/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.Scaling;

public class LinearScaling
extends Scaling {
    public Value getNewRangeMax() throws M4CompilerError {
        return (Value)this.getSingleParameter("NewRangeMax", this.getCurrentLoopNumber());
    }

    public Value getNewRangeMin() throws M4CompilerError {
        return (Value)this.getSingleParameter("NewRangeMin", this.getCurrentLoopNumber());
    }

    public String generateSQL(Column targetAttributeColumn) throws M4CompilerError {
        try {
            String actMin = targetAttributeColumn.readOrComputeMinimum();
            String actMax = targetAttributeColumn.readOrComputeMaximum();
            return "( ((" + targetAttributeColumn.getSQLPlusLocation() + " - " + actMin + ") / " + "(" + actMax + " - " + actMin + ")) * " + "(" + this.getNewRangeMax().getValue() + " - " + this.getNewRangeMin().getValue() + ") + " + this.getNewRangeMin().getValue() + ")";
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
    }
}

