/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.ParameterDeselectedError;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class JoinByKey
extends SingleCSOperator {
    private BaseAttribute[] sortedKeys;
    private Concept[] sortedConcepts;

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        String sqlDef = "(select " + selectPart + " from " + this.createListOfColumnSets() + " where " + this.createCondition() + ")";
        return sqlDef;
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        try {
            String columnExpr = "";
            Feature inF = null;
            int iIn = 0;
            Feature outF = null;
            Feature[][] mapping = this.getInOutMap();
            Iterator it = this.getOutputConcept().getFeatures().iterator();
            Vector<Feature> outputFeaturesNotInMapping = new Vector<Feature>();
            while (it.hasNext()) {
                outF = (Feature)it.next();
                int mapPos = this.checkOccurrence(mapping, outF);
                if (mapPos > -1) {
                    inF = mapping[0][mapPos];
                    columnExpr = this.createMetadata(inF, outF, csForOutputConcept, columnExpr);
                    continue;
                }
                outputFeaturesNotInMapping.add(outF);
            }
            it = outputFeaturesNotInMapping.iterator();
            while (it.hasNext()) {
                outF = (Feature)it.next();
                int conceptNumber = 0;
                do {
                    Concept currentConcept = this.getSortedConcepts()[conceptNumber];
                    iIn = 0;
                    do {
                        inF = currentConcept.getFeature(iIn);
                    } while (++iIn < currentConcept.getNumberOfFeatures() && !outF.correspondsTo(inF));
                } while (++conceptNumber < this.sortedConcepts.length && !outF.correspondsTo(inF));
                if (!outF.correspondsTo(inF)) {
                    this.doPrint(Print.OPERATOR, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because no corresponding input feature was found.");
                    continue;
                }
                if (this.isDeselectedParameter(inF)) {
                    this.doPrint(Print.PARAM, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because the corresponding input feature was deselected by " + "a FeatureSelection operator.");
                    continue;
                }
                columnExpr = this.createMetadata(inF, outF, csForOutputConcept, columnExpr);
            }
            columnExpr = columnExpr.substring(0, columnExpr.length() - 2);
            return columnExpr;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected String createMetadataForOneBA(BaseAttribute inBA, BaseAttribute outBA, Columnset csForOutputConcept, String columnExpr) throws M4CompilerError {
        Column outputColumn;
        Column inputColumn;
        try {
            inputColumn = inBA.getCurrentColumn();
            outputColumn = inputColumn.copyColToCS(csForOutputConcept);
            this.getStep().addToTrash(outputColumn);
            outputColumn.setBaseAttribute(outBA);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("JoinByKey: M4 Interface error occurred when creating metadata for input BaseAttribute '" + inBA.getName() + "' (Id: " + inBA.getId() + ") and output BaseAttribute '" + outBA.getName() + "' (Id: " + outBA.getId() + "): " + m4e.getMessage());
        }
        outputColumn.setSQLDefinition(outBA.getName());
        outputColumn.setName(outBA.getName());
        String nextAttrib = "";
        if (inputColumn.getSQLDefinition().equalsIgnoreCase(inputColumn.getName())) {
            nextAttrib = inputColumn.getColumnset().getSchemaPlusName() + ".";
        }
        nextAttrib = nextAttrib + inputColumn.getSQLDefinition() + " AS " + outBA.getName();
        columnExpr = columnExpr + nextAttrib + ", ";
        return columnExpr;
    }

    protected void setNewCSMultiStepBranch(Columnset newCS, int index) throws M4CompilerError {
        try {
            Concept[] theConcepts = this.getSortedConcepts();
            Object[] msbArray = new String[theConcepts.length + 1];
            int i = 0;
            while (i < theConcepts.length) {
                String msb = theConcepts[i].getCurrentColumnSet().getMultiStepBranch();
                msbArray[i++] = JoinByKey.nullToEmpty(msb);
            }
            msbArray[i] = JoinByKey.nullToEmpty(this.getInputConcept().getCurrentColumnSet().getMultiStepBranch());
            Arrays.sort(msbArray);
            newCS.setMultiStepBranch("");
            for (i = 0; i < msbArray.length; ++i) {
                newCS.addMultiStepBranch((String)msbArray[i]);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public Concept getInputConcept() {
        return this.getSortedConcepts()[0];
    }

    private static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return false;
    }

    protected Concept[] getSortedConcepts() {
        return this.sortedConcepts;
    }

    protected BaseAttribute[] getSortedKeys() {
        return this.sortedKeys;
    }

    protected Feature[][] getInOutMap() throws M4CompilerError {
        Feature[] inputF = (Feature[])this.getParameter("MapInput");
        Feature[] outputF = (Feature[])this.getParameter("MapOutput");
        Feature[][] theMap = new Feature[2][0];
        if (inputF != null) {
            int noOfMappings = inputF.length;
            if (outputF.length != noOfMappings) {
                throw new M4CompilerError("Operator JoinByKey: need same number of MapInput and MapOutput attributes!");
            }
            theMap = new Feature[2][noOfMappings];
            for (int l = 0; l < noOfMappings; ++l) {
                theMap[0][l] = inputF[l];
                theMap[1][l] = outputF[l];
                if (theMap[0][l] != null && theMap[1][l] != null) continue;
                throw new M4CompilerError("Operator JoinByKey: mapping information is incomplete!");
            }
        }
        return theMap;
    }

    private int checkOccurrence(Feature[][] map, Feature f) {
        for (int i = 0; i < map[1].length; ++i) {
            if (map[1][i].getId() != f.getId()) continue;
            return i;
        }
        return -1;
    }

    private String createListOfColumnSets() throws M4CompilerError {
        try {
            String list = "";
            for (int i = 0; i < this.getSortedConcepts().length; ++i) {
                Columnset cs = this.getSortedConcepts()[i].getCurrentColumnSet();
                list = list + cs.getSchemaPlusName() + ", ";
            }
            list = list.substring(0, list.length() - 2);
            return list;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private String createCondition() throws M4CompilerError {
        try {
            Columnset cs = this.getSortedConcepts()[0].getCurrentColumnSet();
            BaseAttribute key = this.getSortedKeys()[0];
            int noOfCons = this.getSortedConcepts().length;
            String cond = cs.getSchemaPlusName() + "." + key.getCurrentColumn().getSQLDefinition();
            cond = cond + " = ";
            for (int i = 1; i < noOfCons - 1; ++i) {
                cs = this.getSortedConcepts()[i].getCurrentColumnSet();
                key = this.getSortedKeys()[i];
                cond = cond + cs.getSchemaPlusName() + "." + key.getCurrentColumn().getSQLDefinition();
                cond = cond + " AND ";
                cond = cond + cs.getSchemaPlusName() + "." + key.getCurrentColumn().getSQLDefinition();
                cond = cond + " = ";
            }
            cs = this.getSortedConcepts()[noOfCons - 1].getCurrentColumnSet();
            key = this.getSortedKeys()[noOfCons - 1];
            cond = cond + cs.getSchemaPlusName() + "." + key.getCurrentColumn().getSQLDefinition();
            return cond;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void relateKeysToConcepts() throws M4CompilerError {
        BaseAttribute[] keys = (BaseAttribute[])this.getParameter("TheKeys");
        this.sortedConcepts = (Concept[])this.getParameter("TheConcepts");
        if (keys == null || keys.length == 0) {
            throw new M4CompilerError("Operator JoinByKey: No keys found!");
        }
        if (this.sortedConcepts == null || this.sortedConcepts.length == 0) {
            throw new M4CompilerError("Operator JoinByKey: No concepts found!");
        }
        if (this.sortedConcepts.length != keys.length) {
            throw new M4CompilerError("Operator JoinByKey: Number of keys must be equal to number of concepts!");
        }
        this.sortedKeys = new BaseAttribute[keys.length];
        for (int i = 0; i < this.sortedConcepts.length; ++i) {
            this.sortedKeys[i] = keys[this.findKeyPosition(this.sortedConcepts[i], keys)];
        }
    }

    private int findKeyPosition(Concept c, BaseAttribute[] bas) throws M4CompilerError {
        Collection theConceptFeatures;
        try {
            theConceptFeatures = c.getFeatures();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        if (theConceptFeatures == null || theConceptFeatures.size() == 0) {
            throw new M4CompilerError("Operator JoinByKey: concept '" + c.getName() + "' has no features!");
        }
        for (int j = 0; j < bas.length; ++j) {
            Iterator it = theConceptFeatures.iterator();
            while (it.hasNext()) {
                if (bas[j].getId() != ((Feature)it.next()).getId()) continue;
                return j;
            }
        }
        throw new M4CompilerError("Operator JoinByKey: concept '" + c.getName() + "' does not contain any of the given keys!");
    }

    public void load(Step st) throws ParameterDeselectedError, M4CompilerError {
        super.load(st);
        this.relateKeysToConcepts();
    }
}

