/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.FeatureConstruction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class GenericFeatureConstruction
extends FeatureConstruction {
    private BaseAttribute[] outputBAs = null;
    private static String NO_COLUMN_ATTACHED = "< *** No Column *** >";

    public String generateSQL(Column targetColumn) throws M4CompilerError {
        String translated = this.getTranslatedSQL_String();
        this.doPrint(Print.OPERATOR, translated);
        return translated;
    }

    private boolean isOutputBA(BaseAttribute ba) throws M4CompilerError {
        int i;
        if (this.outputBAs == null) {
            this.outputBAs = new BaseAttribute[this.getHighestLoopNr()];
            for (i = 0; i < this.getHighestLoopNr(); ++i) {
                this.outputBAs[i] = (BaseAttribute)this.getSingleParameter("TheOutputAttribute", i);
            }
        }
        for (i = 0; i < this.getHighestLoopNr(); ++i) {
            if (this.outputBAs[i].getId() != ba.getId()) continue;
            return true;
        }
        return false;
    }

    private String getTranslatedSQL_String() throws M4CompilerError {
        HashMap allMappings = this.getBaColumnMapping();
        String untranslatedSql = this.getSqlString();
        StringBuffer translated = new StringBuffer();
        int i = 0;
        while (i < untranslatedSql.length()) {
            int stop;
            int start = GenericFeatureConstruction.nextLetter(untranslatedSql, i);
            if (start > i) {
                translated.append(untranslatedSql.substring(i, start));
            }
            if ((stop = GenericFeatureConstruction.nextNotNameChar(untranslatedSql, start)) > start) {
                String token = untranslatedSql.substring(start, stop);
                String column = (String)allMappings.get(token.toUpperCase());
                if (column == NO_COLUMN_ATTACHED) {
                    throw new M4CompilerError("Operator GenericFeatureConstruction: An error occured when trying to apply the following Pseudo-SQL statement:\n" + untranslatedSql + "\nBaseAttribute " + token + " has no valid column!");
                }
                translated.append(column == null ? token : column);
            }
            i = stop;
        }
        return translated.toString();
    }

    private HashMap getBaColumnMapping() throws M4CompilerError {
        HashMap<String, String> allMappings = new HashMap<String, String>();
        Vector allBaseAttribs = this.getAllInputConceptBAs();
        Iterator it = allBaseAttribs.iterator();
        try {
            while (it.hasNext()) {
                BaseAttribute ba = (BaseAttribute)it.next();
                if (this.isOutputBA(ba)) continue;
                String baName = ba.getName();
                if (allMappings.containsKey(baName)) {
                    throw new M4CompilerError("Operator GenericFeatureConstruction: found more than one BaseAttribute '" + baName + "' in TheInputConcept!");
                }
                Column col = ba.getCurrentColumn();
                if (col != null) {
                    String colName = col.getSQLDefinition();
                    allMappings.put(baName.toUpperCase(), colName);
                    continue;
                }
                allMappings.put(baName.toUpperCase(), NO_COLUMN_ATTACHED);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        return allMappings;
    }

    private static int nextLetter(String s, int start) {
        int i;
        int length = s.length();
        int n = i = start >= 0 ? start : 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                return i;
            }
            if (c == '\'' && i + 1 < length && (i = s.indexOf(39, i + 1)) == -1) {
                i = length;
            }
            ++i;
        }
        return length;
    }

    private static int nextNotNameChar(String s, int start) {
        int i;
        int length = s.length();
        int n = i = start >= 0 ? start : 0;
        while (i < length) {
            char c = s.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_')) {
                return i;
            }
            ++i;
        }
        return length;
    }

    private Vector getAllInputConceptBAs() throws M4CompilerError {
        try {
            Vector<Feature> allBaseAttribs = new Vector<Feature>();
            Collection fs = this.getTheInputConcept().getFeatures();
            Iterator it = fs.iterator();
            while (it.hasNext()) {
                Feature f = (Feature)it.next();
                if (f instanceof BaseAttribute) {
                    allBaseAttribs.add(f);
                    continue;
                }
                Collection theBAs = ((MultiColumnFeature)f).getBaseAttributes();
                Iterator it2 = theBAs.iterator();
                while (it2.hasNext()) {
                    allBaseAttribs.add((Feature)it2.next());
                }
            }
            return allBaseAttribs;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public String getSqlString() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("SQL_String", this.getCurrentLoopNumber());
        return v.getValue();
    }
}

