/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.CompilerDatabaseService;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4CompilerWarning;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.ParameterDeselectedError;
import edu.udo.cs.miningmart.exception.UserError;
import edu.udo.cs.miningmart.m4.Assertion;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Condition;
import edu.udo.cs.miningmart.m4.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.ForeignKey;
import edu.udo.cs.miningmart.m4.ForeignKeyLink;
import edu.udo.cs.miningmart.m4.M4Object;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.ParamDict;
import edu.udo.cs.miningmart.m4.Parameter;
import edu.udo.cs.miningmart.m4.ParameterObject;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.ParameterArray;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;

public abstract class ExecutableOperator {
    private Step myStep;
    private Operator myOperator;
    private int numberOfLoops = -1;
    protected String[] generatedSQLDefinitions;
    private ParamDict myParamDictClone;

    public void load(Step step) throws ParameterDeselectedError, M4CompilerError {
        if (step == null || step.getId() == 0L) {
            throw new M4CompilerError("Error in constructor of executable operator:\nParameter step " + (step == null ? "is null" : "has ID 0"));
        }
        this.myStep = step;
        this.myOperator = this.getStep().getTheOperator();
        if (this.myOperator == null) {
            throw new M4CompilerError("ExecutableOperator.getOpParamsIterator():\nStep with ID " + this.getStep().getId() + " has no operator embedded!");
        }
        this.removeDeselectedParameters();
    }

    public ParameterObject[] getParameter(String name, int loopNr) throws M4CompilerError {
        try {
            edu.udo.cs.miningmart.m4.ParameterArray p;
            ParamDict pd = this.getParameterDictionary();
            if (loopNr > 0 || pd.isLooped(name)) {
                ++loopNr;
            }
            if (this.getOperator().getOpParam(name).isCoordinated()) {
                loopNr = 0;
            }
            if ((p = this.getParameterDictionary().get(name, loopNr)) == null) {
                return null;
            }
            return p.getParameterObjectArray();
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Operator '" + this.getName() + "': " + e.getMessage());
        }
    }

    public ParameterObject[] getParameter(String name) throws M4CompilerError {
        return this.getParameter(name, 0);
    }

    public M4Object getSingleParameter(String name) throws M4CompilerError {
        return this.getSingleParameter(name, 0);
    }

    public M4Object getSingleParameter(String name, int loopNr) throws M4CompilerError {
        ParameterObject[] array = this.getParameter(name, loopNr);
        if (array == null || array.length == 0) {
            return null;
        }
        return array[0];
    }

    private edu.udo.cs.miningmart.m4.ParameterArray getParameterFromDict(String name, int loopNr) throws M4Exception {
        return this.getParameterDictionary().get(name, loopNr);
    }

    private ParamDict getParameterDictionary() throws M4Exception {
        try {
            if (this.myParamDictClone == null) {
                ParamDict theStepParamDict = this.getStep().getParameterDictionary(true);
                this.myParamDictClone = new edu.udo.cs.miningmart.m4.core.ParamDict();
                Iterator allOpParamsIt = this.getStep().getTheOperator().getOpParamsIterator();
                while (allOpParamsIt.hasNext()) {
                    OpParam myOpPar = (OpParam)allOpParamsIt.next();
                    for (int loopNr = 0; loopNr < this.getNumberOfLoops(); ++loopNr) {
                        edu.udo.cs.miningmart.m4.ParameterArray pa;
                        if (!myOpPar.isLoopable() && loopNr != 0) continue;
                        int localLoopNr = loopNr;
                        if (myOpPar.isLoopable() && this.getHighestLoopNr() > 0) {
                            ++localLoopNr;
                        }
                        if ((pa = theStepParamDict.get(myOpPar.getName(), localLoopNr)) == null && !myOpPar.isOptional()) {
                            throw new M4Exception("ExecutableOperator.getParameterDictionary(): Could not find mandatory parameter '" + myOpPar.getName() + "' in Step '" + this.getStep().getName() + "'!");
                        }
                        if (pa == null) continue;
                        this.myParamDictClone.put(myOpPar.getName(), localLoopNr, pa);
                    }
                }
            }
            return this.myParamDictClone;
        }
        catch (M4Exception m4e) {
            throw new M4Exception("M4 exception caught when reading parameters of Step '" + this.getStep().getName() + "': " + m4e.getMessage());
        }
    }

    public CompilerDatabaseService getM4Db() throws M4CompilerError {
        DB theDB = this.getStep().getM4Db();
        if (theDB instanceof CompilerDatabaseService) {
            return (CompilerDatabaseService)theDB;
        }
        throw new M4CompilerError("Executable Operator (" + this.getName() + "): expected CompilerDatabaseService instead of DB!");
    }

    public Operator getOperator() {
        return this.myOperator;
    }

    public String getName() {
        return this.getOperator().getName();
    }

    public Step getStep() {
        return this.myStep;
    }

    public boolean isLoopable() {
        return this.getOperator().isLoopable();
    }

    public boolean isManual() {
        return this.getOperator().isManual();
    }

    public boolean isStepable() {
        return this.getOperator().isStepable();
    }

    protected final int getHighestLoopNr() {
        if (this.numberOfLoops == -1) {
            this.numberOfLoops = this.getStep().getLoopCount();
        }
        return this.numberOfLoops;
    }

    public int getNumberOfLoops() {
        int loops = this.getHighestLoopNr();
        return loops > 0 ? loops : 1;
    }

    public Iterator getOpParamsIterator() throws M4CompilerError {
        try {
            Iterator it = this.getOperator().getOpParamsIterator();
            if (it == null) {
                throw new M4CompilerError("Could not get iterator for OpParams of operator with ID " + this.getOperator().getId());
            }
            return it;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void removeDeselectedParameters() throws ParameterDeselectedError, M4CompilerError {
        Iterator it = this.getOpParamsIterator();
        ParameterDeselectedError e = null;
        try {
            while (it.hasNext()) {
                OpParam op = (OpParam)it.next();
                if (!op.isInput()) continue;
                String paramName = op.getName();
                int highestLoop = this.getHighestLoopNr();
                for (int i = 0; i < highestLoop; ++i) {
                    edu.udo.cs.miningmart.m4.ParameterArray oldParam = this.getParameterFromDict(paramName, i);
                    if (oldParam == null) continue;
                    edu.udo.cs.miningmart.m4.ParameterArray newParam = this.removeDeselectedParameters(oldParam);
                    if (oldParam.size() == newParam.size()) continue;
                    e = this.replaceParameterInCache(op, i, newParam, e);
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        if (e != null) {
            throw e;
        }
    }

    private ParameterDeselectedError replaceParameterInCache(OpParam op, int loop, edu.udo.cs.miningmart.m4.ParameterArray par, ParameterDeselectedError e) throws M4CompilerError {
        int length;
        try {
            this.getParameterDictionary().replace(op.getName(), loop, par);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        int n = length = par == null ? 0 : par.size();
        if (length < op.getMinArg()) {
            if (e == null) {
                String msg = "Loading parameters for operator " + this.getName() + ", step id: " + this.getStep().getId() + "\n" + "Due to deselection of features by FeatureSelection the " + "following parameters violate operator constraints:\n" + op.getName();
                e = new ParameterDeselectedError(msg, op);
            } else {
                e = new ParameterDeselectedError(op.getName(), op, e);
            }
        }
        return e;
    }

    private edu.udo.cs.miningmart.m4.ParameterArray removeDeselectedParameters(edu.udo.cs.miningmart.m4.ParameterArray m4o) throws M4CompilerError {
        if (m4o == null || m4o.size() == 0) {
            return m4o;
        }
        try {
            ParameterArray newPA = new ParameterArray(m4o.getParameterType());
            Collection theParameters = m4o.getParameters();
            Iterator it = new Vector(theParameters).iterator();
            while (it.hasNext()) {
                Parameter current = (Parameter)it.next();
                if (!this.isDeselectedParameter(current)) {
                    // empty if block
                }
                newPA.addParameter(current);
            }
            return newPA;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected final boolean isDeselectedParameter(M4Object m4o) throws M4CompilerError {
        if (m4o != null && m4o instanceof Feature) {
            return ((Feature)m4o).isDeselected();
        }
        return false;
    }

    public void doPrint(Level verbosity, String printString) {
        this.getStep().doPrint(verbosity, printString);
    }

    public void doPrint(Exception ex) {
        this.getStep().doPrint(ex);
    }

    public final void print() {
        this.autoPrint();
    }

    public final void autoPrint() {
        try {
            Iterator it = this.getOpParamsIterator();
            while (it.hasNext()) {
                String name = ((OpParam)it.next()).getName();
                M4Object[] par = this.getParameter(name);
                this.doPrint(Print.M4_OBJECT, "Parameter '" + name + "' :");
                if (par != null) {
                    this.printM4Object(par);
                    continue;
                }
                for (int i = 0; i < this.getHighestLoopNr(); ++i) {
                    par = this.getParameter(name, i + 1);
                    this.doPrint(Print.M4_OBJECT, "  loopnr." + i + 1 + ":");
                    this.printM4Object(par);
                }
            }
        }
        catch (M4CompilerError e) {
            this.doPrint(Print.MAX, "autoPrint() for operator " + this.getName() + ", id: " + this.getOperator().getId() + " failed!\n" + e.getMessage());
        }
    }

    private void printM4Object(M4Object[] obj) {
        if (obj != null) {
            for (int i = 0; i < obj.length; ++i) {
                obj[i].print();
            }
        }
    }

    public void execute(boolean lazy) throws SQLException, M4CompilerWarning, M4CompilerError, UserError, M4Exception {
        this.checkConditions();
        String warningMessage = "";
        try {
            this.createStatement(lazy);
        }
        catch (M4CompilerWarning mcw) {
            warningMessage = warningMessage + mcw.getMessage();
        }
        this.showCreateStatement();
        try {
            this.compileStatement();
        }
        catch (M4CompilerWarning mcw) {
            warningMessage = warningMessage + "\n" + mcw.getMessage();
        }
        try {
            this.handleAssertions();
        }
        catch (M4CompilerWarning mcw) {
            warningMessage = warningMessage + "\n" + mcw.getMessage();
        }
        if (!warningMessage.equals("")) {
            throw new M4CompilerWarning(warningMessage);
        }
    }

    protected void handleAssertions() throws M4CompilerError, M4CompilerWarning {
        Collection assertCol = null;
        try {
            assertCol = this.getOperator().getAssertions();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4Exception during condition checking for compilation: " + m4e.getMessage());
        }
        Iterator it = assertCol.iterator();
        while (it.hasNext()) {
            Assertion assertion = (Assertion)it.next();
            assertion.writeAssertion(this);
        }
        this.doRelationshipAssertions();
    }

    protected void checkConditions() throws UserError, M4CompilerError {
        Collection col = null;
        try {
            col = this.getOperator().getConditions();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4Exception during condition checking for compilation: " + m4e.getMessage());
        }
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Condition condition = (Condition)it.next();
            condition.check(this);
        }
    }

    private void doRelationshipAssertions() throws M4CompilerError, M4CompilerWarning {
        try {
            edu.udo.cs.miningmart.m4.core.BaseAttribute[][] allKeys = this.getStep().getKeysOfRelationshipAssertion();
            if (allKeys != null) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute[] manyKeys = allKeys[0];
                BaseAttribute[] oneKeys = allKeys[1];
                if (oneKeys != null && manyKeys != null && oneKeys.length > 0 && manyKeys.length > 0) {
                    BaseAttribute[] toAttribs;
                    Columnset fromCs;
                    Columnset toCs;
                    Concept manyConcept = manyKeys[0].getConcept();
                    Concept oneConcept = oneKeys[0].getConcept();
                    if (manyConcept == null || oneConcept == null) {
                        return;
                    }
                    boolean manyIsFrom = true;
                    Relation rel = manyConcept.getRelationshipToConcept(oneConcept);
                    if (rel == null) {
                        manyIsFrom = false;
                        rel = oneConcept.getRelationshipToConcept(manyConcept);
                    }
                    if (rel == null) {
                        throw new M4CompilerWarning("Warning: operator '" + this.getName() + "' in step '" + this.getStep().getName() + "' expected a 1:n relationship to exist between input and output, but it could not be found.");
                    }
                    if (rel.isManyToManyRelation()) {
                        throw new M4CompilerError("Operator '" + this.getName() + "' in Step '" + this.getStep().getName() + "': a 1:n relationship should exist between input and output, but an n:m relationship was found!");
                    }
                    ForeignKey theLink = rel.getFromKey();
                    if (theLink == null) {
                        throw new M4CompilerError("Operator '" + this.getName() + "' in Step '" + this.getStep().getName() + "': found Relationship '" + rel.getName() + "' without FromKey!");
                    }
                    Columnset columnset = toCs = manyIsFrom ? oneConcept.getCurrentColumnSet() : manyConcept.getCurrentColumnSet();
                    if (toCs == null) {
                        return;
                    }
                    theLink.setPrimaryKeyColumnset(toCs);
                    Columnset columnset2 = fromCs = manyIsFrom ? manyConcept.getCurrentColumnSet() : oneConcept.getCurrentColumnSet();
                    if (fromCs == null) {
                        return;
                    }
                    theLink.setForeignKeyColumnset(fromCs);
                    Collection links = theLink.getAllColumnLinks();
                    int diff = manyKeys.length - links.size();
                    if (diff < 0) {
                        throw new M4CompilerError("Operator '" + this.getName() + "' in Step '" + this.getStep().getName() + "': found more columns to be linked than BAs that are keys!");
                    }
                    for (int i = 0; i < diff; ++i) {
                        theLink.addColumnLink(null, null);
                    }
                    links = theLink.getAllColumnLinks();
                    Iterator linkIt = links.iterator();
                    int i = 0;
                    BaseAttribute[] baseAttributeArray = toAttribs = manyIsFrom ? oneKeys : manyKeys;
                    while (linkIt.hasNext()) {
                        ForeignKeyLink myColumnLink = (ForeignKeyLink)linkIt.next();
                        edu.udo.cs.miningmart.m4.core.BaseAttribute fkBa = manyIsFrom ? manyKeys[i] : oneKeys[i];
                        myColumnLink.setForeignKeyColumn(fkBa.getCurrentColumn());
                        BaseAttribute pkBa = this.getCorrespondingAttrib(toAttribs, fkBa);
                        if (pkBa == null) {
                            pkBa = manyIsFrom ? oneKeys[i] : manyKeys[i];
                        }
                        myColumnLink.setPrimaryKeyColumn(pkBa.getCurrentColumn());
                        ++i;
                    }
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator '" + this.getName() + "' in Step '" + this.getStep().getName() + "': error accessing M4 schema when dealing with relationship assertions: " + m4e.getMessage());
        }
    }

    private BaseAttribute getCorrespondingAttrib(BaseAttribute[] someAttribs, BaseAttribute theAttrib) {
        for (int i = 0; i < someAttribs.length; ++i) {
            if (!theAttrib.getName().equalsIgnoreCase(someAttribs[i].getName())) continue;
            return someAttribs[i];
        }
        return null;
    }

    public abstract void createStatement(boolean var1) throws SQLException, M4CompilerWarning, M4CompilerError;

    public void showCreateStatement() {
        if (this.generatedSQLDefinitions != null) {
            for (int i = 0; i < this.generatedSQLDefinitions.length; ++i) {
                this.doPrint(Print.OPERATOR, this.getName() + " generated: " + this.generatedSQLDefinitions[i]);
            }
        }
    }

    public abstract void compileStatement() throws SQLException, M4CompilerWarning, M4CompilerError;

    public abstract EstimatedStatistics estimateStatistics(Step var1) throws M4Exception;

    protected short getM4Dbms() throws M4CompilerError, DbConnectionClosed {
        return this.getM4Db().getM4Dbms();
    }

    protected short getBusinessDbms() throws M4CompilerError, DbConnectionClosed {
        return this.getM4Db().getBusinessDbms();
    }

    protected boolean storedProceduresAvailable() throws DbConnectionClosed, M4CompilerError {
        return false;
    }

    public M4Object getM4ObjectFromCache(long Id) throws M4CompilerError {
        return this.getM4Db().getM4ObjectFromCache(Id);
    }

    public void putM4ObjectToCache(M4Object m4o) throws M4CompilerError {
        try {
            this.getM4Db().putM4ObjectToCache(m4o);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public void executeM4SqlWrite(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        this.getM4Db().executeM4SqlWrite(query);
    }

    public void executeBusinessSqlWrite(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        this.getM4Db().executeBusinessSqlWrite(query);
    }

    public ResultSet executeM4SqlRead(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeM4SqlRead(query);
    }

    public ResultSet executeBusinessSqlRead(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeBusinessSqlRead(query);
    }

    public Long executeM4SingleValueSqlReadL(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeM4SingleValueSqlReadL(query);
    }

    public Long executeBusinessSingleValueSqlReadL(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeBusinessSingleValueSqlReadL(query);
    }

    public String executeM4SingleValueSqlRead(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeM4SingleValueSqlRead(query);
    }

    public String executeBusinessSingleValueSqlRead(String query) throws SQLException, M4CompilerError, DbConnectionClosed {
        return this.getM4Db().executeBusinessSingleValueSqlRead(query);
    }

    public long getNextM4SequenceValue() throws M4CompilerError {
        try {
            return this.getM4Db().getNextM4SequenceValue();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    protected String getArtificalColumnName(String otherColumns) {
        String artCol = "Z";
        while (otherColumns.indexOf(artCol + ",") > -1) {
            artCol = artCol + "1";
        }
        return artCol;
    }
}

