/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4CompilerWarning;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

public abstract class ConceptOperator
extends ExecutableOperator {
    private Columnset[] myOutputColumnSets;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Columnset;

    public void compileStatement() throws SQLException, M4CompilerWarning, M4CompilerError {
        if (this.myOutputColumnSets != null) {
            for (int i = 0; i < this.myOutputColumnSets.length; ++i) {
                if (this.myOutputColumnSets[i].getType().equalsIgnoreCase("V")) {
                    this.getM4Db().createSQLView(this.myOutputColumnSets[i], this.getStep());
                }
                if (this.myOutputColumnSets[i].getType().equalsIgnoreCase("SN")) {
                    throw new M4CompilerError("ConceptOperator.compileStatement(): found output ColumnSet of type 'Snapshot' (SN). This is not supported yet!");
                }
                if (!this.myOutputColumnSets[i].getType().equalsIgnoreCase("MV")) continue;
                throw new M4CompilerError("ConceptOperator.compileStatement(): found output ColumnSet of type 'Materialized View' (MV). This is not supported yet!");
            }
        }
    }

    public void createStatement(boolean lazy) throws M4CompilerError, M4CompilerWarning {
        int i;
        this.myOutputColumnSets = this.generateColumnSetsForOp(lazy);
        if (this.myOutputColumnSets == null) {
            throw new M4CompilerError("Operator '" + this.getName() + "' did not create a new Columnset!");
        }
        this.generatedSQLDefinitions = new String[this.myOutputColumnSets.length];
        for (i = 0; i < this.myOutputColumnSets.length; ++i) {
            String type = this.myOutputColumnSets[i].getType().toUpperCase();
            if (type.equals("V")) {
                type = "VIEW";
            }
            if (type.equals("T")) {
                type = "TABLE";
            }
            this.generatedSQLDefinitions[i] = type + " " + this.myOutputColumnSets[i].getName() + " AS " + this.myOutputColumnSets[i].getSQLDefinition();
        }
        try {
            for (i = 0; i < this.myOutputColumnSets.length; ++i) {
                this.getOutputConcept().addColumnSet(this.myOutputColumnSets[i]);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public edu.udo.cs.miningmart.m4.EstimatedStatistics estimateStatistics(Step theStep) throws M4Exception {
        Concept outputCon = theStep.getOutputConcept();
        EstimatedStatistics outEstStat = new EstimatedStatistics(outputCon);
        Collection inputCons = theStep.getAllInputConcepts();
        if (inputCons != null && inputCons.size() == 1) {
            outEstStat.setNumberOfRows(((Concept)inputCons.iterator().next()).getEstimatedStatistics().getNumberOfRows());
        }
        Iterator outIt = outputCon.getAllBaseAttributes().iterator();
        while (outIt.hasNext()) {
            BaseAttribute outBa = (BaseAttribute)outIt.next();
            Iterator inConIt = inputCons.iterator();
            while (inConIt.hasNext()) {
                Concept inCon = (Concept)inConIt.next();
                edu.udo.cs.miningmart.m4.EstimatedStatistics inEstStat = inCon.getEstimatedStatistics();
                Iterator inIt = inCon.getAllBaseAttributes().iterator();
                while (inIt.hasNext()) {
                    BaseAttribute inBa = (BaseAttribute)inIt.next();
                    if (!inBa.correspondsTo(outBa)) continue;
                    String iN = inBa.getName();
                    String oN = outBa.getName();
                    outEstStat.setBiggestValue(oN, inEstStat.getBiggestValue(iN));
                    outEstStat.setLowestValue(oN, inEstStat.getLowestValue(iN));
                    outEstStat.setNumberOfMissingValues(oN, inEstStat.getNumberOfMissingValues(iN));
                    outEstStat.copyValueList(oN, inEstStat, iN);
                }
            }
        }
        return outEstStat;
    }

    public abstract Columnset[] generateColumnSetsForOp(boolean var1) throws M4CompilerError;

    public Concept getInputConcept() throws M4CompilerError {
        return (Concept)this.getSingleParameter("TheInputConcept");
    }

    public Concept getOutputConcept() throws M4CompilerError {
        return (Concept)this.getSingleParameter("TheOutputConcept");
    }

    protected Columnset createSingleColumnSet(int index) throws M4CompilerError {
        Columnset newCS;
        String newName = this.getNewCSName(index);
        try {
            newCS = (Columnset)((Object)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$Columnset == null ? (class$edu$udo$cs$miningmart$m4$core$Columnset = ConceptOperator.class$("edu.udo.cs.miningmart.m4.core.Columnset")) : class$edu$udo$cs$miningmart$m4$core$Columnset));
            this.getStep().addToTrash(newCS);
        }
        catch (M4Exception e) {
            throw new M4CompilerError("M4Exception while trying to add newly created Columnset to trash of Step " + this.getStep().getId() + " in method ConceptOperator.createSingleColumnSet(int)!\n" + e.getMessage());
        }
        newCS.setName(newName);
        try {
            newCS.setId(0L);
            Columnset inputColumnSet = this.getInputConcept().getCurrentColumnSet();
            if (inputColumnSet == null) {
                throw new M4CompilerError("The Input Concept ('" + this.getInputConcept().getName() + "') of Step '" + this.getStep().getName() + "' has no Columnsets!");
            }
            newCS.setSchema(inputColumnSet.getSchema());
            String type = this.getTypeOfNewColumnSet(index).toUpperCase();
            if (!type.equals("T") && !type.equals("V")) {
                throw new M4CompilerError("ConceptOperator: found unknown type for new ColumnSet: '" + type + "'!");
            }
            newCS.setType(type);
            newCS.setTheConcept(this.getOutputConcept());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        String columnExpr = this.generateColumns(newCS);
        String sqlDef = this.generateSQLDefinition(columnExpr, index);
        if (sqlDef.length() > 3995) {
            sqlDef = this.createViewAsSqlDef(sqlDef, index);
        }
        newCS.setSQLDefinition(sqlDef);
        this.setNewCSMultiStepBranch(newCS, index);
        return newCS;
    }

    private String createViewAsSqlDef(String sqlDef, int index) throws M4CompilerError {
        String viewName = this.getNewCSName(index) + "_V";
        String viewDef = "CREATE VIEW " + viewName + " AS " + sqlDef;
        try {
            this.doPrint(Print.COMPILER_OP_CONTROL, "View definition String is too long for database, trying to create a view '" + viewName + "' in advance!");
            this.getM4Db().executeBusinessSqlWrite(viewDef);
            String schema = null;
            try {
                Columnset cs = this.getInputConcept().getCurrentColumnSet();
                if (cs != null) {
                    schema = cs.getSchema();
                }
            }
            catch (M4Exception e) {
                // empty catch block
            }
            if (schema != null) {
                this.getM4Db().addViewToTrash(viewName, schema, this.getStep().getId());
                return "(SELECT * FROM " + viewName + " )";
            }
            throw new M4CompilerError(this.getClass().getName() + ": Could not find business schema we are working on!");
        }
        catch (SQLException e) {
            throw new M4CompilerError("SQLException when trying to create database view.\nStatement:\n" + e.getMessage());
        }
    }

    protected void setNewCSMultiStepBranch(Columnset newCS, int index) throws M4CompilerError {
        try {
            Columnset inputColumnSet = this.getInputConcept().getCurrentColumnSet();
            newCS.setMultiStepBranch(inputColumnSet.getMultiStepBranch());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public abstract String getTypeOfNewColumnSet(int var1);

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        String columnExpr = "";
        Feature inF = null;
        int iIn = 0;
        Feature outF = null;
        int iOut = 0;
        try {
            for (iOut = 0; iOut < this.getOutputConcept().getFeatures().size(); ++iOut) {
                outF = this.getOutputConcept().getFeature(iOut);
                if (!this.mustCopyFeature(outF.getName())) continue;
                iIn = 0;
                do {
                    inF = this.getInputConcept().getFeature(iIn);
                } while (++iIn < this.getInputConcept().getFeatures().size() && !outF.correspondsTo(inF));
                if (!outF.correspondsTo(inF)) {
                    this.doPrint(Print.OPERATOR, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because no corresponding input feature was found.");
                    continue;
                }
                if (this.isDeselectedParameter(inF)) {
                    this.doPrint(Print.PARAM, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because the corresponding input feature was deselected by " + "a FeatureSelection operator.");
                    continue;
                }
                if (!this.getStep().isVisible(inF)) continue;
                columnExpr = this.createMetadata(inF, outF, csForOutputConcept, columnExpr);
            }
            if (columnExpr.equals("")) {
                throw new M4CompilerError("ConceptOperator (" + this.getName() + "): No columns for output concept created!");
            }
            columnExpr = columnExpr.substring(0, columnExpr.length() - 2);
            return columnExpr;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected String createMetadata(Feature inF, Feature outF, Columnset csForOutputConcept, String columnExpr) throws M4CompilerError {
        if (outF instanceof BaseAttribute) {
            BaseAttribute inBA = (BaseAttribute)inF;
            BaseAttribute outBA = (BaseAttribute)outF;
            columnExpr = this.createMetadataForOneBA(inBA, outBA, csForOutputConcept, columnExpr);
        } else {
            if (!(outF instanceof MultiColumnFeature)) {
                throw new M4CompilerError("Operator '" + this.getName() + "': Unknown Feature type found in Concept with id: " + this.getOutputConcept().getId() + "; Feature id: " + outF.getId());
            }
            MultiColumnFeature outMCF = (MultiColumnFeature)outF;
            MultiColumnFeature inMCF = (MultiColumnFeature)inF;
            try {
                Collection theBAs = outMCF.getBaseAttributes();
                if (theBAs != null) {
                    Iterator it2 = theBAs.iterator();
                    while (it2.hasNext()) {
                        BaseAttribute outBA = (BaseAttribute)it2.next();
                        BaseAttribute inBA = inMCF.getBaseAttributeByName(outBA.getName());
                        columnExpr = this.createMetadataForOneBA(inBA, outBA, csForOutputConcept, columnExpr);
                    }
                }
            }
            catch (M4Exception m4e) {
                throw new M4CompilerError("Operator '" + this.getName() + "': M4 Exception when copying metadata: " + m4e.getMessage());
            }
            catch (NullPointerException nfe) {
                throw new M4CompilerError("Operator '" + this.getName() + "': Mismatch between MultiColumnFeatures in in- and output concept!");
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                throw new M4CompilerError("Operator '" + this.getName() + "': Mismatch between MultiColumnFeatures in in- and output concept!");
            }
        }
        return columnExpr;
    }

    protected String createMetadataForOneBA(BaseAttribute inBA, BaseAttribute outBA, Columnset csForOutputConcept, String columnExpr) throws M4CompilerError {
        if (inBA == null || outBA == null || csForOutputConcept == null) {
            throw new M4CompilerError("Operator '" + this.getName() + "': found NULL argument when copying metadata for a BaseAttribute!");
        }
        try {
            Column inputColumn = inBA.getCurrentColumn();
            Column outputColumn = inputColumn.copyColToCS(csForOutputConcept);
            this.getStep().addToTrash(outputColumn);
            outputColumn.setBaseAttribute(outBA);
            outBA.addColumn(outputColumn);
            outputColumn.setSQLDefinition(inputColumn.getName());
            columnExpr = columnExpr + this.getStringForSelection(inputColumn) + ", ";
            return columnExpr;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator '" + this.getName() + "': M4 exception caught when copying input BaseAttribute '" + inBA.getName() + "' to output BaseAttribute '" + outBA.getName() + "':\n" + m4e.getMessage());
        }
    }

    protected String getStringForSelection(Column inputColumn) {
        String nextAttrib = inputColumn.getSQLDefinition();
        nextAttrib = !inputColumn.getName().equals(nextAttrib) ? "(" + inputColumn.getSQLDefinition() + ") AS " + inputColumn.getName() : inputColumn.getColumnset().getSchemaPlusName() + "." + nextAttrib;
        return nextAttrib;
    }

    public String getNewCSName(int index) throws M4CompilerError {
        String name = "CS_" + this.getStep().getId() + this.getInputConcept().getCurrentSuffix();
        if (index > -1) {
            name = name + "_" + index;
        }
        return name;
    }

    protected abstract boolean mustCopyFeature(String var1) throws M4CompilerError;

    public abstract String generateSQLDefinition(String var1, int var2) throws M4CompilerError;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

