/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.compiler.utils.DrawSample;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class Apriori
extends SingleCSOperator {
    private static final String APRIORI_FILENAME = "apriori";
    private static final String RESULT_SUFFIX_SETS = ".sets";
    private static final String RESULT_SUFFIX_RULES = ".rules";
    private static final String NEW_COLDT_NAME = "STRING";
    private static final short NEW_COL_DT = 13;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Columnset;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Column;

    private String getSampleFileName() {
        return "apriori-sample_" + this.getStep().getId();
    }

    private String getRulesFileName() {
        return this.getSampleFileName() + RESULT_SUFFIX_RULES;
    }

    private String getSetsFileName() {
        return this.getSampleFileName() + RESULT_SUFFIX_SETS;
    }

    protected Columnset createSingleColumnSet(int index) throws M4CompilerError {
        try {
            String columnSetName = this.getNewCSName();
            this.callApriori(this.getInputConcept().getCurrentColumnSet().getSchema() + "." + columnSetName, this.getAprioriCommand());
            Columnset newCS = this.createJavaColumnset(columnSetName);
            this.createJavaColumns(newCS);
            long step = this.getStep().getId();
            String schema = this.getInputConcept().getCurrentColumnSet().getSchema();
            this.getM4Db().addTableToTrash(columnSetName, schema, step);
            this.setNewCSMultiStepBranch(newCS, index);
            return newCS;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface exception in '" + this.getName() + "': " + m4e.getMessage());
        }
    }

    private Columnset createJavaColumnset(String columnSetName) throws M4CompilerError {
        try {
            Columnset newCS = (Columnset)((Object)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$Columnset == null ? (class$edu$udo$cs$miningmart$m4$core$Columnset = Apriori.class$("edu.udo.cs.miningmart.m4.core.Columnset")) : class$edu$udo$cs$miningmart$m4$core$Columnset));
            newCS.setId(0L);
            newCS.setName(columnSetName);
            Columnset inputColumnSet = this.getInputConcept().getCurrentColumnSet();
            newCS.setSchema(inputColumnSet.getSchema());
            newCS.setType(this.getTypeOfNewColumnSet());
            newCS.setSQLDefinition(columnSetName);
            newCS.setTheConcept(this.getOutputConcept());
            newCS.setMultiStepBranch(inputColumnSet.getMultiStepBranch());
            this.getStep().addToTrash(newCS);
            return newCS;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface exception in '" + this.getName() + "': " + m4e.getMessage());
        }
    }

    private void createJavaColumns(Columnset newCS) throws M4CompilerError {
        this.createM4Column(this.getPremiseBA(), newCS, this.getNewColNamePremise());
        this.createM4Column(this.getConclusionBA(), newCS, this.getNewColNameConclusion());
    }

    protected Column createM4Column(BaseAttribute outputBA, Columnset newCS, String newColumnName) throws M4CompilerError {
        try {
            Column newColumn = (Column)((Object)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$Column == null ? (class$edu$udo$cs$miningmart$m4$core$Column = Apriori.class$("edu.udo.cs.miningmart.m4.core.Column")) : class$edu$udo$cs$miningmart$m4$core$Column));
            newColumn.setId(0L);
            newColumn.setName(newColumnName);
            newColumn.setColumnset(newCS);
            newColumn.setBaseAttribute(outputBA);
            newColumn.setColumnDataType(13L);
            newColumn.setColumnDataTypeName(NEW_COLDT_NAME);
            newColumn.setSQLDefinition(newColumnName);
            this.getStep().addToTrash(newColumn);
            return newColumn;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface exception in '" + this.getName() + "': " + m4e.getMessage());
        }
    }

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        return null;
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return false;
    }

    private String getNewColNamePremise() throws M4CompilerError {
        return this.getPremiseBA().getName();
    }

    private String getNewColNameConclusion() throws M4CompilerError {
        return this.getConclusionBA().getName();
    }

    private String getAprioriPath() throws M4CompilerError {
        String osName;
        String runtime = System.getProperty("ML_HOME");
        if (runtime == null || runtime.length() == 0) {
            throw new M4CompilerError("Operator Apriori: Missing environment variable 'ML_HOME' !\nUnable to find the binary!");
        }
        String prop = System.getProperty("os.name");
        if (prop.substring(0, 3).equalsIgnoreCase("win")) {
            osName = "Windows";
        } else {
            if (!prop.equals("SunOS") && !prop.equals("Linux")) {
                throw new M4CompilerError("Apriori-Wrapper: No implementation found for your operating system.\nCurrently supported: SunOS, Linux and Windows.\nInstall Apriori for your Operating System and change the method getAprioriPath in class 'Apriori.java'.Your operating system is: " + System.getProperty("os.name"));
            }
            osName = prop;
        }
        String sp = File.separator;
        return runtime + "bin" + sp + osName + sp;
    }

    private String getAprioriCommand() throws M4CompilerError {
        return this.getAprioriPath() + APRIORI_FILENAME;
    }

    private String getTempDir() throws M4CompilerError {
        String tmp = System.getProperty("TEMP_DIR");
        if (tmp == null || tmp.length() == 0) {
            tmp = this.getAprioriPath();
        }
        return tmp;
    }

    private void callApriori(String newCsName, String command) throws M4CompilerError {
        String ttable;
        String inItemCol;
        String inTidCol;
        String inCustCol;
        try {
            inCustCol = this.getCustomerIdBa().getCurrentColumn().getName();
            inTidCol = this.getTransIdBa().getCurrentColumn().getName();
            inItemCol = this.getItemBa().getCurrentColumn().getName();
            long stepId = this.getStep().getId();
            ttable = "tmp1_" + stepId;
            Vector<String> columnNames = new Vector<String>();
            columnNames.add(inCustCol.toUpperCase());
            columnNames.add(inTidCol.toUpperCase());
            columnNames.add(inItemCol.toUpperCase());
            new DrawSample(this.getInputConcept().getCurrentColumnSet(), columnNames, ttable, "tmp2_" + stepId, null, this.getSampleSize(), null, this.getM4Db());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface exception in '" + this.getName() + "': " + m4e.getMessage());
        }
        String sampleFileName = this.getTempDir() + this.getSampleFileName();
        String sql_FromWhereCond = " FROM " + ttable + " WHERE (" + inCustCol + " IS NOT NULL) AND (" + inTidCol + " IS NOT NULL) AND (" + inItemCol + " IS NOT NULL)";
        this.writeSampleToFile(sampleFileName, sql_FromWhereCond);
        try {
            this.getM4Db().dropBusinessTable(ttable);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
        this.runBinary(command, this.getTempDir(), this.getSampleFileName());
        this.doPrint(Print.OPERATOR, "Removing duplicates from association rules array.");
        String resultRulesFile = this.getTempDir() + this.getRulesFileName();
        String resultSetsFile = this.getTempDir() + this.getSetsFileName();
        Collection rules = this.parseRules(this.openResultFile(resultRulesFile));
        this.writeResultsToTable(rules, newCsName);
        this.deleteFile(sampleFileName);
        this.deleteFile(resultRulesFile);
        this.deleteFile(resultSetsFile);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSampleToFile(String sampleFileName, String sql_FromWhereCond) throws M4CompilerError {
        String sql_getData = "SELECT * " + sql_FromWhereCond;
        ResultSet rs = null;
        PrintWriter out = null;
        try {
            rs = this.getM4Db().executeBusinessSqlRead(sql_getData);
            FileWriter fw = new FileWriter(sampleFileName);
            out = new PrintWriter(new BufferedWriter(fw));
            while (rs.next()) {
                String custId = rs.getString(1);
                String TidId = rs.getString(2);
                String Item = rs.getString(3);
                out.println(custId + " " + TidId + " " + Item);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new M4CompilerError("Error in Apriori Wrapper when trying to read a sample from DB:\n" + sqle.getMessage());
                catch (IOException e) {
                    throw new M4CompilerError("Error in Apriori Wrapper when trying to write a DB sample to file:\n" + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                out.close();
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
        out.close();
    }

    private void runBinary(String command, String execDir, String dataFileName) throws M4CompilerError {
        String[] cmdArray = new String[]{command, this.getSampleFileName(), Long.toString(this.getMinSupport()), Double.toString(this.getMinConfidence()), "-ascii", "-print"};
        Process process = null;
        this.doPrint(Print.OPERATOR, "Starting external algorithm (Apriori) (command: '" + command + "')...");
        try {
            String line;
            process = Runtime.getRuntime().exec(cmdArray, null, new File(execDir));
            this.doPrint(Print.MIN, "\n--- Apriori binary output: ---");
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = in.readLine()) != null) {
                this.doPrint(Print.MIN, line);
            }
            this.doPrint(Print.MIN, "------------------------------\n");
            BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = err.readLine()) != null) {
                this.doPrint(Print.MIN, line);
            }
            try {
                process.waitFor();
                int exitCode = process.exitValue();
                this.doPrint(Print.OPERATOR, "Call to " + command + " exited with" + (exitCode == 0 ? "out errors." : " error code " + exitCode));
            }
            catch (IllegalThreadStateException e) {
                throw new M4CompilerError("IllegalThreadStateException caught after Apriori has closed stdout.\n" + e.getMessage());
            }
            catch (InterruptedException e) {
                throw new M4CompilerError("InterruptionException caught after Apriori has closed stdout.\n" + e.getMessage());
            }
        }
        catch (IOException ioe) {
            throw new M4CompilerError("Error accessing Apriori binary: " + ioe.getMessage());
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection parseRules(BufferedReader in) throws M4CompilerError {
        TreeSet<String> hs = new TreeSet<String>();
        try {
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    int i;
                    int[][] rule = this.readRuleFromLine(line);
                    int[] pr = rule[0];
                    int[] ant = rule[1];
                    StringBuffer sbuf = new StringBuffer("('");
                    for (i = 0; i < pr.length - 1; ++i) {
                        sbuf.append(pr[i] + " ");
                    }
                    if (pr.length > 0) {
                        sbuf.append(pr[pr.length - 1]);
                    }
                    sbuf.append("', '");
                    for (i = 0; i < ant.length - 1; ++i) {
                        sbuf.append(ant[i] + " ");
                    }
                    if (ant.length > 0) {
                        sbuf.append(ant[ant.length - 1]);
                    }
                    sbuf.append("')");
                    hs.add(sbuf.toString());
                }
            }
            finally {
                in.close();
            }
            return hs;
        }
        catch (IOException e) {
            throw new M4CompilerError("Apriori-Wrapper: Could not read from successfully opened result file after call to binary.\nException message is:\n" + e.getMessage());
        }
    }

    private void writeResultsToTable(Collection rules, String tableName) throws M4CompilerError {
        try {
            this.createTable(tableName);
            String insertPrefix = "INSERT INTO " + tableName + " (" + this.getNewColNamePremise() + ", " + this.getNewColNameConclusion() + ") VALUES ";
            Iterator it = rules.iterator();
            while (it.hasNext()) {
                String sqlCommand = insertPrefix + (String)it.next();
                this.getM4Db().executeBusinessSqlWrite(sqlCommand);
            }
            this.getM4Db().commitBusinessTransactions();
            this.doPrint(Print.OPERATOR, "Results were successfully written to database table '" + tableName + "'.");
        }
        catch (SQLException e) {
            throw new M4CompilerError("An exception occured when trying to write Apriori results to a database table:\n" + e.getMessage());
        }
    }

    private void createTable(String tableName) throws M4CompilerError {
        try {
            this.getM4Db().dropBusinessTable(tableName);
            String cmd = "CREATE TABLE " + tableName + " (" + this.getNewColNamePremise() + " VARCHAR(1000), " + this.getNewColNameConclusion() + " VARCHAR(1000) )";
            this.getM4Db().executeBusinessSqlWrite(cmd);
        }
        catch (SQLException e) {
            throw new M4CompilerError("SQL error when creating table for " + this.getName() + ": " + e.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    private BufferedReader openResultFile(String fileName) throws M4CompilerError {
        try {
            return new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            throw new M4CompilerError("Apriori Wrapper: Could not open result file '" + fileName + "' after execution of binary.\nException message is:\n" + e.getMessage());
        }
    }

    private int[] readSetFromLine(String line) {
        int stop;
        int start;
        if (line == null || (start = line.indexOf(123)) == -1 || (stop = line.indexOf(125, start)) == -1) {
            return null;
        }
        String setString = line.substring(start + 1, stop);
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (true) {
            int j;
            if (i < setString.length() && Character.isWhitespace(setString.charAt(i))) {
                ++i;
                continue;
            }
            for (j = i; j < setString.length() && !Character.isWhitespace(setString.charAt(j)); ++j) {
            }
            if (j > i) {
                v.add(setString.substring(i, j));
                i = j;
            }
            if (i >= setString.length()) break;
        }
        int[] r = new int[v.size()];
        i = 0;
        Iterator it = v.iterator();
        while (it.hasNext()) {
            r[i++] = Integer.parseInt((String)it.next());
        }
        Arrays.sort(r);
        return r;
    }

    private int[][] readRuleFromLine(String line) {
        int index;
        if (line == null || (index = line.indexOf("->")) == -1) {
            return null;
        }
        String left = line.substring(0, index);
        String right = line.substring(index + 2);
        int[][] r = new int[][]{this.readSetFromLine(left), this.readSetFromLine(right)};
        return r;
    }

    private void deleteFile(String fileName) {
        File f = new File(fileName);
        f.delete();
    }

    public BaseAttribute getCustomerIdBa() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("CustID");
    }

    public BaseAttribute getTransIdBa() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TransID");
    }

    public BaseAttribute getItemBa() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("Item");
    }

    public long getMinSupport() throws M4CompilerError {
        Long l;
        Value v = (Value)this.getSingleParameter("MinSupport");
        if (v != null && (l = v.getLong()) != null && l >= 0L) {
            long minSup = l;
            return minSup;
        }
        throw new M4CompilerError("Operator Apriori: Parameter 'MinSupport' must be a positive integer!\nFound: " + (v == null ? "<null>" : v.getValue()));
    }

    public double getMinConfidence() throws M4CompilerError {
        Double d;
        Value v = (Value)this.getSingleParameter("MinConfidence");
        if (v != null && (d = v.getDouble()) != null && 0.0 <= d && d <= 1.0) {
            return d;
        }
        throw new M4CompilerError("Operator Apriori: Parameter 'MinConfidence' must be a double value in [0, 1] !\nFound: " + (v == null ? "<null>" : v.getValue()));
    }

    public long getSampleSize() throws M4CompilerError {
        Long l;
        Value v = (Value)this.getSingleParameter("SampleSize");
        if (v != null && (l = v.getLong()) != null && l > 0L) {
            return l;
        }
        throw new M4CompilerError("Operator Apriori: Parameter 'SampleSize' must be a positive integer!\nFound: " + (v == null ? "<null>" : v.getValue()));
    }

    public BaseAttribute getPremiseBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("PremiseBA");
    }

    public BaseAttribute getConclusionBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("ConclusionBA");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

