/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.utils;

import edu.udo.cs.miningmart.m4.utils.PrintFormatter;
import edu.udo.cs.miningmart.m4.utils.PrintLevel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Print
implements Serializable {
    private static final String MLHOME = "ML_HOME";
    private static final String LOGFILES = "LOG_FILES";
    public static final Level MAX = new PrintLevel("Max", 1100);
    public static final Level FATAL = new PrintLevel("Fatal", 1000);
    public static final Level ERROR = new PrintLevel("Error", 950);
    public static final Level WARNING = new PrintLevel("Warning", 900);
    public static final Level COMPILER_CASE_CONTROL = new PrintLevel("Compiler Case Control", 860);
    public static final Level COMPILER_STEP_CONTROL = new PrintLevel("Compiler Step Control", 840);
    public static final Level COMPILER_OP_CONTROL = new PrintLevel("Compiler Operator Control", 820);
    public static final Level OPERATOR = new PrintLevel("Operator", 800);
    public static final Level CACHE = new PrintLevel("M4 Cache", 790);
    public static final Level PARAM = new PrintLevel("Parameters", 780);
    public static final Level M4_OBJECT = new PrintLevel("M4 Object", 770);
    public static final Level DB_WRITE = new PrintLevel("DB Write", 760);
    public static final Level DB_READ = new PrintLevel("DB Read", 750);
    public static final Level HELP = new PrintLevel("Help", 740);
    public static final Level MIN = new PrintLevel("Min", 730);
    private static final Level[] theLevel = new Level[]{MIN, HELP, DB_READ, DB_WRITE, M4_OBJECT, PARAM, CACHE, OPERATOR, COMPILER_OP_CONTROL, COMPILER_STEP_CONTROL, COMPILER_CASE_CONTROL, WARNING, ERROR, FATAL, MAX};
    public static final Level DEFAULT_VERBOSITY = OPERATOR;
    private static final int LINESIZE = 500;
    private static SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd_HH:mm:ss");
    private String fileName;
    private Level currVerbosity;
    private final boolean onlyOneLevel = false;
    private static Print theDefaultPrintObject = null;
    private Logger logger;

    private Print() {
        this.createLogger();
        String defVerbProperty = System.getProperty("PRINT_VERBOSITY");
        this.currVerbosity = Print.getVerbosityLevelForName(defVerbProperty);
    }

    private Print(Level verbosityLevel) {
        this.createLogger();
        this.currVerbosity = verbosityLevel;
    }

    public void createLogger() {
        File homeDir = Print.getLogPath();
        if (!homeDir.exists()) {
            homeDir.mkdirs();
        }
        this.logger = Logger.getLogger("org.musoft.limo");
        this.logger.setLevel(Level.INFO);
        this.logger.setUseParentHandlers(false);
        PrintFormatter formatter = new PrintFormatter();
        ConsoleHandler console = new ConsoleHandler();
        console.setFormatter(formatter);
        this.logger.addHandler(console);
        try {
            this.fileName = homeDir.getAbsolutePath() + File.separatorChar + "MiningMart.log";
            FileHandler file = new FileHandler(this.fileName, true);
            file.setFormatter(formatter);
            this.logger.addHandler(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File getLogPath() {
        File homeDir = new File(System.getProperty("MM_HOME", ".") + File.separatorChar + "log");
        return homeDir;
    }

    public static File getLogFile() {
        String fileName = Print.getLogPath().getAbsolutePath() + File.separatorChar + "MiningMart.log";
        return new File(fileName);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static Print getGlobalPrintObject() {
        if (theDefaultPrintObject == null) {
            theDefaultPrintObject = new Print();
        }
        return theDefaultPrintObject;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void addHandler(Handler handler) {
        this.logger.addHandler(handler);
    }

    public void removeHandler(Handler handler) {
        this.logger.removeHandler(handler);
    }

    private String formatString(String printString) {
        if (printString == null) {
            printString = "<null>";
        }
        int length = printString.length();
        for (int i = 0; i < length; i += 500) {
            int end = i + 500;
            if (end > length) {
                end = length;
            }
            String oneLine = printString.substring(i, end);
        }
        return printString;
    }

    public void doPrint(Level verbosityLevel, String printString) {
        String print = null;
        if (verbosityLevel.intValue() >= this.currVerbosity.intValue()) {
            print = this.formatString(printString);
        }
        if (print != null) {
            this.logger.log(verbosityLevel, print);
        }
    }

    public void doPrint(Level verbosityLevel, String printString, Throwable throwable) {
        String print = null;
        if (verbosityLevel.intValue() >= this.currVerbosity.intValue()) {
            print = this.formatString(printString);
        }
        if (print != null) {
            this.logger.log(verbosityLevel, print, throwable);
        }
    }

    public void setMinimumVerbosityLevel(Level newLevel) {
        if (newLevel.intValue() <= MIN.intValue()) {
            newLevel = MIN;
        }
        this.currVerbosity = newLevel;
        this.logger.setLevel(newLevel);
        Handler[] handler = this.logger.getHandlers();
        for (int i = 0; i < handler.length; ++i) {
            handler[i].setLevel(newLevel);
        }
        this.doPrint(MAX, "Print-verbosity set to: " + newLevel.getName());
    }

    public Level getMinimumVerbosityLevel() {
        return this.currVerbosity;
    }

    public static String getNameOfVerbosityLevel(Level level) {
        return level.getName();
    }

    public static Collection getAllVerbosityLevelNames(Level minVerbosityLevel) {
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < theLevel.length; ++i) {
            if (theLevel[i].intValue() < minVerbosityLevel.intValue()) continue;
            names.add(0, theLevel[i].getName());
        }
        names.trimToSize();
        return names;
    }

    public static Level getVerbosityLevelForName(String nameOfLevel) {
        for (int i = 0; i < theLevel.length; ++i) {
            if (!theLevel[i].getName().equals(nameOfLevel)) continue;
            return theLevel[i];
        }
        if (nameOfLevel.equals("OFF")) {
            return Level.OFF;
        }
        if (nameOfLevel.equals("ALL")) {
            return Level.ALL;
        }
        if (nameOfLevel.equals("INFO")) {
            return OPERATOR;
        }
        if (nameOfLevel.equals("CONFIG")) {
            return Level.CONFIG;
        }
        if (nameOfLevel.equals("FINE")) {
            return Level.FINE;
        }
        if (nameOfLevel.equals("FINER")) {
            return Level.FINER;
        }
        if (nameOfLevel.equals("FINEST")) {
            return Level.FINEST;
        }
        if (nameOfLevel.equals("SEVERE")) {
            return FATAL;
        }
        if (nameOfLevel.equals("WARNING")) {
            return WARNING;
        }
        return DEFAULT_VERBOSITY;
    }

    public Level[] getTheLevel() {
        return theLevel;
    }

    private static String getTime() {
        return format.format(new Date());
    }
}

