/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class MultipleOutputStream
extends OutputStream {
    private Vector streams = new Vector();

    public MultipleOutputStream() {
        this.streams.trimToSize();
    }

    public MultipleOutputStream(OutputStream stream) {
        this.streams.add(stream);
        this.streams.trimToSize();
    }

    public MultipleOutputStream(Collection outputStreams) {
        Iterator iter = outputStreams.iterator();
        while (iter.hasNext()) {
            Object stream = iter.next();
            if (!(iter instanceof OutputStream)) continue;
            this.streams.add(stream);
        }
        this.streams.trimToSize();
    }

    public void close() throws IOException {
        for (int i = 0; i < this.streams.size(); ++i) {
            OutputStream stream = (OutputStream)this.streams.get(i);
            stream.close();
        }
    }

    public void flush() throws IOException {
        for (int i = 0; i < this.streams.size(); ++i) {
            OutputStream stream = (OutputStream)this.streams.get(i);
            stream.flush();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < this.streams.size(); ++i) {
            OutputStream stream = (OutputStream)this.streams.get(i);
            stream.write(b, off, len);
        }
    }

    public void write(byte[] b) throws IOException {
        for (int i = 0; i < this.streams.size(); ++i) {
            OutputStream stream = (OutputStream)this.streams.get(i);
            stream.write(b);
        }
    }

    public void write(int b) throws IOException {
        for (int i = 0; i < this.streams.size(); ++i) {
            OutputStream stream = (OutputStream)this.streams.get(i);
            stream.write(b);
        }
    }

    public int getNumberOfOutputStreams() {
        return this.streams.size();
    }

    public OutputStream getOutputStream(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.streams.size()) {
            return null;
        }
        return (OutputStream)this.streams.get(index);
    }

    public void addOutputStream(OutputStream stream) {
        this.streams.add(stream);
    }

    public boolean removeOutputStream(OutputStream stream) {
        return this.streams.remove(stream);
    }

    public boolean containsOutputStream(OutputStream stream) {
        return this.streams.contains(stream);
    }
}

