/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.utils;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.M4Data;
import java.sql.ResultSet;
import java.sql.SQLException;

public class M4InfoEntry {
    private final String dbAttribute;
    private final String getter;
    private final String setter;
    private final Class theObjectClass;
    private boolean notNull = false;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$M4Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public M4InfoEntry(String dbAttribute, String getter, String setter, Class objectClass) {
        this.dbAttribute = dbAttribute;
        this.getter = getter;
        this.setter = setter;
        this.theObjectClass = objectClass;
    }

    public M4InfoEntry(String dbAttribute, String getter, String setter, Class objectClass, String constraint) {
        this(dbAttribute, getter, setter, objectClass);
        if (constraint == null) {
            return;
        }
        if ("NN".equals(constraint)) {
            this.notNull = true;
        }
    }

    public String getDbAttribute() {
        return this.dbAttribute;
    }

    public String getGetter() {
        return this.getter;
    }

    public String getSetter() {
        return this.setter;
    }

    public Class getTheObjectClass() {
        return this.theObjectClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void activateSetter(M4Data m4d, ResultSet rs, DB db) throws SQLException, M4Exception {
        Object object;
        Class type;
        String attributeName = this.getDbAttribute();
        if (!(class$edu$udo$cs$miningmart$m4$M4Object == null ? (class$edu$udo$cs$miningmart$m4$M4Object = M4InfoEntry.class$("edu.udo.cs.miningmart.m4.M4Object")) : class$edu$udo$cs$miningmart$m4$M4Object).isAssignableFrom(type = this.getTheObjectClass())) {
            if (type.equals(Long.TYPE)) {
                object = new Long(rs.getLong(attributeName));
            } else if (type.equals(Integer.TYPE)) {
                object = new Integer(rs.getInt(attributeName));
            } else if (type.equals(Short.TYPE)) {
                object = new Short(rs.getShort(attributeName));
            } else if (type.equals(Double.TYPE)) {
                object = new Double(rs.getDouble(attributeName));
            } else if (type.equals(class$java$lang$String == null ? (class$java$lang$String = M4InfoEntry.class$("java.lang.String")) : class$java$lang$String)) {
                object = rs.getString(attributeName);
            } else if (type.equals(Boolean.TYPE)) {
                String s = rs.getString(attributeName).trim().toUpperCase();
                boolean val = s.startsWith("Y") || s.equals("IN") || s.equals("TRUE");
                object = new Boolean(val);
            } else if (type.equals(class$java$lang$Long == null ? (class$java$lang$Long = M4InfoEntry.class$("java.lang.Long")) : class$java$lang$Long)) {
                long num = rs.getLong(attributeName);
                object = rs.wasNull() ? null : new Long(num);
            } else if (type.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = M4InfoEntry.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                int num = rs.getInt(attributeName);
                object = rs.wasNull() ? null : new Integer(num);
            } else {
                if (!type.equals(class$java$lang$Double == null ? (class$java$lang$Double = M4InfoEntry.class$("java.lang.Double")) : class$java$lang$Double)) throw new M4Exception("Found unsupported Class in M4InfoEntry.activateSetter(M4Table, ResultSet, DB): " + m4d.getClass().getName());
                double num = rs.getDouble(attributeName);
                object = rs.wasNull() ? null : new Double(num);
            }
        } else {
            long id = rs.getLong(attributeName);
            object = db.getM4Object(id, type);
        }
        m4d.genericSetter(this.getSetter(), type, object);
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

