/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.compiler.CompilerAccessLogic;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.ParameterError;
import edu.udo.cs.miningmart.exception.ParameterNotFoundException;
import edu.udo.cs.miningmart.exception.UserError;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.Constraint;
import edu.udo.cs.miningmart.m4.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.ParamDict;
import edu.udo.cs.miningmart.m4.ParameterArray;
import edu.udo.cs.miningmart.m4.ParameterObject;
import edu.udo.cs.miningmart.m4.core.Assertion;
import edu.udo.cs.miningmart.m4.core.Case;
import edu.udo.cs.miningmart.m4.core.Concept;
import edu.udo.cs.miningmart.m4.core.GraphicalM4Object;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.M4Object;
import edu.udo.cs.miningmart.m4.core.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.core.OpParam;
import edu.udo.cs.miningmart.m4.core.Parameter;
import edu.udo.cs.miningmart.m4.core.Relation;
import edu.udo.cs.miningmart.m4.core.Value;
import edu.udo.cs.miningmart.m4.utils.HasCrossReferences;
import edu.udo.cs.miningmart.m4.utils.InterM4Communicator;
import edu.udo.cs.miningmart.m4.utils.InterM4StepParameter;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import edu.udo.cs.miningmart.operator.Pivotize;
import edu.udo.cs.miningmart.operator.ReversePivotize;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Step
extends GraphicalM4Object
implements edu.udo.cs.miningmart.m4.Step,
XmlInfo,
HasCrossReferences {
    public static final String M4_TABLE_NAME = "step_t";
    public static final String ATTRIB_STEP_ID = "st_id";
    public static final String ATTRIB_STEP_NAME = "st_name";
    public static final String ATTRIB_CHAIN_ID = "st_chid";
    public static final String ATTRIB_CASE_ID = "st_caid";
    public static final String ATTRIB_OPERATOR_ID = "st_opid";
    public static final String ATTRIB_NUM_OF_LOOPS = "st_loopnr";
    public static final String ATTRIB_STEP_NR = "st_nr";
    public static final String ATTRIB_MULTISTEP_COND = "st_multistepcond";
    public static InterM4Communicator step2par = new InterM4StepParameter();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    public static final String M4_TABLE_NAME_STEPSEQ = "stepsequence_t";
    public static final String ATTRIB_STEPSEQ_DEPENDENCY_ID = "sts_id";
    public static final String ATTRIB_STEPSEQ_FROM_STEP = "sts_stid";
    public static final String ATTRIB_STEPSEQ_TO_STEP = "sts_successorstid";
    public static final String DB_TRASH_TABLENAME = "dbtrash_t";
    public static final String ATTRIB_DBT_OBJTYPE = "ObjType";
    public static final String ATTRIB_DBT_OBJNAME = "ObjName";
    public static final String ATTRIB_DBT_SCHEMA = "SchemaName";
    public static final String ATTRIB_DBT_STEPID = "StepId";
    public static final String DBT_TYPE_FUNCTION = "F";
    public static final String DBT_TYPE_VIEW = "V";
    public static final String DBT_TYPE_TABLE = "T";
    public static final String DBT_TYPE_INDEX = "I";
    private Case myCase;
    private edu.udo.cs.miningmart.m4.core.Chain myChain;
    private long myNr;
    private int loopCount;
    private String multiStepCondition;
    private edu.udo.cs.miningmart.m4.core.Operator myOperator;
    private final HashSet myM4Trash = new HashSet();
    private boolean allM4TrashLoaded = false;
    private final Collection myParameterTuples = new Vector();
    private boolean allParameterTuplesLoaded = false;
    private final Vector dependentSteps = new Vector();
    private boolean allDependentStepsLoaded = false;
    private boolean dependentStepsDirty = false;
    private final Vector myDbTrash = new Vector();
    private boolean dbTrashDirty = false;
    private boolean allDbTrashLoaded = false;
    private static String specialNameMarker = "##";
    public static final String M4_TRASH_TABLE = "m4trash_t";
    public static final String M4_TRASH_ID = "m4id";
    public static final String M4_TRASH_OBJ_TABLE = "m4table";
    public static final String M4_TRASH_STEP_ID = "stepid";
    private boolean isCompiled = false;
    private boolean m4trashDirty = false;
    private String[][] datatypeCompatibilities = new String[][]{{"CATEGORIAL", "NOMINAL"}, {"SCALAR", "NUMERIC"}, {"NUMERIC", "ORDINAL"}, {"SCALAR", "ORDINAL"}, {"ORDINAL", "BINARY"}, {"SCALAR", "BINARY"}, {"CATEGORIAL", "BINARY"}};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Case;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Chain;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Operator;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Parameter;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Step;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Column;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Columnset;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Value;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Feature;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_STEP_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_STEP_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_STEP_NAME, "getName", "setName", class$java$lang$String == null ? (class$java$lang$String = Step.class$("java.lang.String")) : class$java$lang$String, "NN"), new M4InfoEntry(ATTRIB_STEP_NR, "getNumber", "setNumber", Long.TYPE), new M4InfoEntry(ATTRIB_NUM_OF_LOOPS, "getLoopCount", "setLoopCount", Integer.TYPE), new M4InfoEntry(ATTRIB_MULTISTEP_COND, "getMultiStepCondition", "setMultiStepCondition", class$java$lang$String == null ? (class$java$lang$String = Step.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry(ATTRIB_CASE_ID, "getTheCase", "primitiveSetCase", class$edu$udo$cs$miningmart$m4$Case == null ? (class$edu$udo$cs$miningmart$m4$Case = Step.class$("edu.udo.cs.miningmart.m4.Case")) : class$edu$udo$cs$miningmart$m4$Case, "NN"), new M4InfoEntry(ATTRIB_CHAIN_ID, "getTheChain", "primitiveSetChain", class$edu$udo$cs$miningmart$m4$Chain == null ? (class$edu$udo$cs$miningmart$m4$Chain = Step.class$("edu.udo.cs.miningmart.m4.Chain")) : class$edu$udo$cs$miningmart$m4$Chain), new M4InfoEntry(ATTRIB_OPERATOR_ID, "getTheOperator", "setTheOperator", class$edu$udo$cs$miningmart$m4$Operator == null ? (class$edu$udo$cs$miningmart$m4$Operator = Step.class$("edu.udo.cs.miningmart.m4.Operator")) : class$edu$udo$cs$miningmart$m4$Operator, "NN")};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", class$java$lang$String == null ? (class$java$lang$String = Step.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Number", "getNumber", "setNumber", Long.TYPE), new M4InfoEntry("LoopCount", "getLoopCount", "setLoopCount", Integer.TYPE), new M4InfoEntry("MultiStepCondition", "getMultiStepCondition", "setMultiStepCondition", class$java$lang$String == null ? (class$java$lang$String = Step.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Case", "getTheCase", "setTheCase", class$edu$udo$cs$miningmart$m4$Case == null ? (class$edu$udo$cs$miningmart$m4$Case = Step.class$("edu.udo.cs.miningmart.m4.Case")) : class$edu$udo$cs$miningmart$m4$Case), new M4InfoEntry("Chain", "getTheChain", "setTheChain", class$edu$udo$cs$miningmart$m4$Chain == null ? (class$edu$udo$cs$miningmart$m4$Chain = Step.class$("edu.udo.cs.miningmart.m4.Chain")) : class$edu$udo$cs$miningmart$m4$Chain), new M4InfoEntry("Operator", "getTheOperator", "setTheOperator", class$edu$udo$cs$miningmart$m4$Operator == null ? (class$edu$udo$cs$miningmart$m4$Operator = Step.class$("edu.udo.cs.miningmart.m4.Operator")) : class$edu$udo$cs$miningmart$m4$Operator), new M4InfoEntry("Successors", "getSuccessors", "setSuccessors", class$java$util$Collection == null ? (class$java$util$Collection = Step.class$("java.util.Collection")) : class$java$util$Collection), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", class$java$lang$String == null ? (class$java$lang$String = Step.class$("java.lang.String")) : class$java$lang$String)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Step(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        edu.udo.cs.miningmart.m4.core.Operator op = null;
        op = (edu.udo.cs.miningmart.m4.core.Operator)this.getTheOperator();
        String opName = op == null ? "<null>" : op.getName();
        this.doPrint(Print.M4_OBJECT, "Step (Id = " + this.myId + ";" + "      Operator = " + opName + ";" + "      Loop Count = " + this.getLoopCount() + ";" + "      Multi Step = " + this.getMultiStepCondition() + ")");
        super.print();
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        if (typeOfObjects.isAssignableFrom(class$edu$udo$cs$miningmart$m4$core$Parameter == null ? (class$edu$udo$cs$miningmart$m4$core$Parameter = Step.class$("edu.udo.cs.miningmart.m4.core.Parameter")) : class$edu$udo$cs$miningmart$m4$core$Parameter)) {
            return this.getParameterTuples();
        }
        throw new M4Exception("Step.getObjectsInNamespace: unknown type of objects given: " + typeOfObjects.getName());
    }

    public Operator getTheOperator() {
        return this.myOperator;
    }

    public void setTheOperator(Operator theOp) {
        this.setDirty();
        this.myOperator = (edu.udo.cs.miningmart.m4.core.Operator)theOp;
    }

    public Chain getTheChain() {
        return this.myChain;
    }

    public void setTheChain(Chain chain) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Chain.chain2step.checkNameExists(this, chain);
        edu.udo.cs.miningmart.m4.core.Chain.chain2step.updateReferenceTo(this, chain);
    }

    public void primitiveSetChain(Chain chain) {
        this.setDirty();
        this.myChain = (edu.udo.cs.miningmart.m4.core.Chain)chain;
    }

    public long getCaseId() {
        return this.myCase.getId();
    }

    public long getNumber() {
        return this.myNr;
    }

    public void setTheCase(edu.udo.cs.miningmart.m4.Case myCase) throws M4Exception {
        Case.case2step.checkNameExists(this, myCase);
        Case.case2step.updateReferenceTo(this, myCase);
    }

    public void primitiveSetCase(edu.udo.cs.miningmart.m4.Case myCase) {
        this.setDirty();
        this.myCase = (Case)myCase;
    }

    public void setNumber(long nr) {
        this.setDirty();
        this.myNr = nr;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public String getMultiStepCondition() {
        return this.multiStepCondition;
    }

    public void addParameterTuple(edu.udo.cs.miningmart.m4.Parameter par) throws M4Exception {
        step2par.checkNameExists((Parameter)par, this);
        step2par.add(this, (Parameter)par);
    }

    public boolean removeParameterTuple(edu.udo.cs.miningmart.m4.Parameter par) throws M4Exception {
        return step2par.remove(this, (Parameter)par);
    }

    public void removeAllParameterTuples() throws M4Exception {
        step2par.setCollectionTo(this, null);
    }

    public void removeParameter(String parName) throws M4Exception {
        Collection theParamTuples = this.getParameterTuples();
        Vector theCopy = new Vector(theParamTuples);
        Iterator tupleIt = theCopy.iterator();
        while (tupleIt.hasNext()) {
            Parameter par = (Parameter)tupleIt.next();
            if (par == null || !par.getName().startsWith(parName)) continue;
            this.removeParameterTuple(par);
            par.deleteSoon();
        }
    }

    public void setLoopCount(int lc) throws M4Exception {
        if (this.loopCount > lc) {
            Iterator it = this.getTheOperator().getOpParamsIterator();
            while (it.hasNext()) {
                OpParam myOpPar = (OpParam)it.next();
                if (!myOpPar.isLoopable()) continue;
                for (int loop = lc + 1; loop <= this.loopCount; ++loop) {
                    this.setParameter(myOpPar, new Vector(), loop);
                }
            }
        }
        this.loopCount = lc;
    }

    public void setMultiStepCondition(String msc) {
        this.setDirty();
        this.multiStepCondition = msc;
    }

    public edu.udo.cs.miningmart.m4.Case getTheCase() {
        return this.myCase;
    }

    public Collection getParameterTuples() throws M4Exception {
        if (!this.allParameterTuplesLoaded && !this.isNew()) {
            this.allParameterTuplesLoaded = true;
            this.readParameterTuplesFromDB();
        }
        return this.myParameterTuples;
    }

    private Collection getParameterTuples(edu.udo.cs.miningmart.m4.OpParam theOpParam) throws M4Exception {
        Collection all = this.getParameterTuples();
        Vector<Parameter> ret = new Vector<Parameter>();
        Iterator it = all.iterator();
        while (it.hasNext()) {
            Parameter myPar = (Parameter)it.next();
            if (!myPar.getName().startsWith(theOpParam.getName())) continue;
            ret.add(myPar);
        }
        return ret;
    }

    private Collection getParameterTuples(edu.udo.cs.miningmart.m4.OpParam theOpParam, int loopNr) throws M4Exception {
        Collection all = this.getParameterTuples();
        Vector<Parameter> ret = new Vector<Parameter>();
        Iterator it = all.iterator();
        while (it.hasNext()) {
            Parameter myPar = (Parameter)it.next();
            if (!myPar.getName().startsWith(theOpParam.getName()) || myPar.getLoopNr() != loopNr) continue;
            ret.add(myPar);
        }
        return ret;
    }

    public Collection getSuccessors() throws M4Exception {
        if (!this.allDependentStepsLoaded && !this.isNew()) {
            this.allDependentStepsLoaded = true;
            this.readSuccessorsFromDb();
        }
        return this.dependentSteps;
    }

    public void addSuccessor(edu.udo.cs.miningmart.m4.Step step) throws M4Exception {
        if (step != null) {
            this.dependentStepsDirty = true;
            this.setDirty();
            this.primitiveAddSuccessor(step);
        }
    }

    public void primitiveAddSuccessor(edu.udo.cs.miningmart.m4.Step step) throws M4Exception {
        if (step != null) {
            this.getSuccessors().add(step);
        }
    }

    public boolean removeSuccessor(edu.udo.cs.miningmart.m4.Step step) throws M4Exception {
        if (step != null) {
            boolean success = this.getSuccessors().remove(step);
            if (success) {
                this.dependentStepsDirty = true;
                this.setDirty();
            }
            return success;
        }
        return false;
    }

    public boolean removeSuccessor(String name) throws M4Exception {
        if (name != null) {
            Step toRemove = null;
            Iterator it = this.getSuccessors().iterator();
            while (it.hasNext()) {
                Step st = (Step)it.next();
                if (!st.getName().equals(name)) continue;
                toRemove = st;
            }
            boolean success = this.removeSuccessor(toRemove);
            return success;
        }
        return false;
    }

    public boolean dependencyExists(Chain toChain) throws M4Exception {
        Collection allStepsOfToChain = toChain.getAllSteps();
        if (allStepsOfToChain == null) {
            throw new M4Exception("ToChain '" + toChain.getName() + "': got NULL when asking for all steps!");
        }
        Iterator it = allStepsOfToChain.iterator();
        while (it.hasNext()) {
            Step toStep = (Step)it.next();
            if (!this.getTheCase().containsDependency(this, toStep)) continue;
            return true;
        }
        return false;
    }

    public boolean isRelationallyValid() {
        return true;
    }

    public void addPredecessor(edu.udo.cs.miningmart.m4.Step step) throws M4Exception {
        this.getTheCase().addStepDependency(step, this);
    }

    public void deleteSoon() throws M4Exception {
        this.deleteOutputs();
        super.deleteSoon();
    }

    protected void deleteLocal() throws M4Exception {
        super.deleteLocal();
        this.deleteDbTrash();
        this.writeDbTrashToDb();
        this.deleteM4Trash();
        this.writeM4TrashToDb();
        String sql = "DELETE FROM stepsequence_t WHERE sts_stid = " + this.getId();
        this.executeM4SqlWrite(sql);
        sql = "DELETE FROM stepsequence_t WHERE sts_successorstid = " + this.getId();
        this.executeM4SqlWrite(sql);
    }

    private void readParameterTuplesFromDB() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(class$edu$udo$cs$miningmart$m4$core$Parameter == null ? (class$edu$udo$cs$miningmart$m4$core$Parameter = Step.class$("edu.udo.cs.miningmart.m4.core.Parameter")) : class$edu$udo$cs$miningmart$m4$core$Parameter).iterator();
        while (it.hasNext()) {
            this.addParameterTuple((Parameter)it.next());
        }
    }

    public ParamDict readParametersFromDB(boolean paramsMustExist) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParamDict pd = new edu.udo.cs.miningmart.m4.core.ParamDict();
        Iterator it = this.getTheOperator().getOpParamsIterator();
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.ParameterArray obj;
            int i;
            int loops;
            OpParam op = (OpParam)it.next();
            if (op.getMinArg() == 0) {
                try {
                    edu.udo.cs.miningmart.m4.core.ParameterArray withoutLoop = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.loadParam(op, 0);
                    if (withoutLoop.size() > 0 || this.getLoopCount() <= 0) {
                        pd.put(op.getName(), withoutLoop);
                        continue;
                    }
                    loops = this.getLoopCount() + 1;
                    for (i = 1; i < loops; ++i) {
                        obj = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.loadParam(op, i);
                        pd.put(op.getName(), i, obj);
                    }
                    continue;
                }
                catch (ParameterNotFoundException e) {
                    throw new M4Exception("Internal compiler error.'ParameterNotFound' exception was thrown for an optional parameter:\n" + e.getMessage());
                }
            }
            try {
                pd.put(op.getName(), this.loadParam(op, 0));
            }
            catch (ParameterNotFoundException e) {
                if (this.getLoopCount() > 0) {
                    loops = this.getLoopCount() + 1;
                    try {
                        for (i = 1; i < loops; ++i) {
                            obj = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.loadParam(op, i);
                            pd.put(op.getName(), i, obj);
                        }
                        continue;
                    }
                    catch (ParameterNotFoundException pnfe) {
                        if (!paramsMustExist) continue;
                        throw pnfe;
                    }
                }
                if (!paramsMustExist) continue;
                throw e;
            }
        }
        return pd;
    }

    private ParameterArray loadParam(edu.udo.cs.miningmart.m4.OpParam op, int loopNr) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParameterArray ret = null;
        try {
            if (op.getMaxArg() == 1) {
                Parameter obj = (Parameter)this.loadSingleParam(op, loopNr);
                if (obj != null) {
                    ret = new edu.udo.cs.miningmart.m4.core.ParameterArray(obj.getParObjectType());
                    ret.addParameter(obj);
                }
            } else {
                ret = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.loadParamArray(op, loopNr);
            }
        }
        catch (ParameterError e) {
            // empty catch block
        }
        if (ret == null) {
            if (op.getMinArg() > 0) {
                this.throwParameterLoadException(loopNr, op.getName() + " not found.");
            } else {
                ret = new edu.udo.cs.miningmart.m4.core.ParameterArray(op.getType());
            }
        } else {
            if (ret.size() < op.getMinArg()) {
                this.throwParameterLoadException(loopNr, op.getName() + " should be an Array of at least " + op.getMinArg() + " entries, but has only " + ret.size() + " elements!");
            }
            if (op.getMaxArg() >= 0 && ret.size() > op.getMaxArg()) {
                this.throwParameterLoadException(loopNr, op.getName() + " should be an Array of at most " + op.getMinArg() + " entries, but has " + ret.size() + " elements!");
            }
        }
        return ret;
    }

    private void throwParameterLoadException(int loopNr, String restOfMessage) throws M4Exception {
        String message = "Could not load parameters for operator " + this.getTheOperator().getName() + " in step " + this.getId();
        if (loopNr > 0) {
            message = message + ", loop nr." + loopNr;
        }
        message = message + " !\nParameter " + restOfMessage;
        throw new ParameterNotFoundException(message);
    }

    private edu.udo.cs.miningmart.m4.Parameter loadSingleParam(edu.udo.cs.miningmart.m4.OpParam op, int loopNr) throws M4Exception {
        Parameter theSingleParam = null;
        if (this.myParameterTuples != null) {
            Iterator tupleIt = this.myParameterTuples.iterator();
            while (tupleIt.hasNext()) {
                Parameter myParam = (Parameter)tupleIt.next();
                if (!myParam.getName().startsWith(op.getName())) continue;
                if (theSingleParam == null) {
                    theSingleParam = myParam;
                    continue;
                }
                throw new M4Exception("Step.loadSingleParam(): found more than one Parameter '" + op.getName() + "' in Step '" + this.getName());
            }
        }
        if (theSingleParam != null) {
            return theSingleParam;
        }
        String query = this.createLoadParamQuery(op, loopNr);
        Long parId = this.executeM4SingleValueSqlReadL(query);
        if (parId == null) {
            return null;
        }
        DB db = this.getM4Db();
        return (Parameter)db.getM4Object(parId, class$edu$udo$cs$miningmart$m4$core$Parameter == null ? (class$edu$udo$cs$miningmart$m4$core$Parameter = Step.class$("edu.udo.cs.miningmart.m4.core.Parameter")) : class$edu$udo$cs$miningmart$m4$core$Parameter);
    }

    private ParameterArray loadParamArray(edu.udo.cs.miningmart.m4.OpParam op, int loopNr) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParameterArray parameterArray;
        edu.udo.cs.miningmart.m4.core.ParameterArray ret = null;
        if (this.myParameterTuples != null) {
            ret = new edu.udo.cs.miningmart.m4.core.ParameterArray(op.getType());
            Iterator tupleIt = this.myParameterTuples.iterator();
            while (tupleIt.hasNext()) {
                Parameter myParam = (Parameter)tupleIt.next();
                if (!myParam.getName().startsWith(op.getName())) continue;
                ret.addParameter(myParam);
            }
        }
        if (ret != null && ret.size() != 0) {
            return ret;
        }
        ResultSet rs = null;
        try {
            String query = this.createLoadParamQuery(op, loopNr);
            rs = this.executeM4SqlRead(query);
            DB db = this.getM4Db();
            ret = new edu.udo.cs.miningmart.m4.core.ParameterArray(op.getType());
            while (rs.next()) {
                Long parId = new Long(rs.getLong(1));
                Parameter p = (Parameter)db.getM4Object(parId, class$edu$udo$cs$miningmart$m4$core$Parameter == null ? Step.class$("edu.udo.cs.miningmart.m4.core.Parameter") : class$edu$udo$cs$miningmart$m4$core$Parameter);
                ret.addParameter(p);
            }
            parameterArray = ret;
        }
        catch (SQLException sqle) {
            try {
                throw new M4Exception("SQL error when loading ParameterArray for Step " + this.getId() + ": " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
        return parameterArray;
    }

    private String createLoadParamQuery(edu.udo.cs.miningmart.m4.OpParam op, int loopNr) {
        String parName = op.getName();
        String LoopCondition = loopNr == 0 ? "(par_stloopnr IS NULL OR par_stloopnr = 0)" : "par_stloopnr = " + loopNr;
        String query = "SELECT par_id FROM parameter_t WHERE par_stid = " + this.getId() + " AND " + LoopCondition + " AND " + DB.attribPrefix("par_name", parName) + " = " + DB.quote(parName) + " ORDER BY " + "par_nr";
        return query;
    }

    private void readSuccessorsFromDb() throws M4Exception {
        String query = "SELECT sts_successorstid FROM stepsequence_t WHERE sts_stid = " + this.getId();
        ResultSet rs = null;
        try {
            rs = this.executeM4SqlRead(query);
            DB db = this.getM4Db();
            while (rs.next()) {
                long successorId = rs.getLong(1);
                if (rs.wasNull()) continue;
                Step step = (Step)db.getM4Object(successorId, class$edu$udo$cs$miningmart$m4$core$Step == null ? Step.class$("edu.udo.cs.miningmart.m4.core.Step") : class$edu$udo$cs$miningmart$m4$core$Step);
                if (!this.dependentSteps.contains(step)) {
                    this.primitiveAddSuccessor(step);
                    continue;
                }
                throw new M4Exception("Step.readSuccessorsFromDb(): Found double entry for Step " + this.getId() + " and Successor Step " + step.getId() + "!");
            }
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error when reading step sequence for case with Id " + this.getId() + ": " + sqle.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
    }

    public Collection getCrossReferences() throws M4Exception {
        return this.getSuccessors();
    }

    protected boolean hasCoordinates() {
        return true;
    }

    protected void storeLocal() throws M4Exception {
        super.storeLocal();
        if (this.dependentStepsDirty) {
            String sql = "DELETE FROM stepsequence_t WHERE sts_stid = " + this.getId();
            this.executeM4SqlWrite(sql);
            Iterator it = this.getSuccessors().iterator();
            String prefix = "INSERT INTO stepsequence_t ( sts_id, sts_stid, sts_successorstid ) VALUES ( ";
            while (it.hasNext()) {
                Step successor = (Step)it.next();
                String sql2 = prefix + this.getNextM4SequenceValue() + ", " + this.getId() + ", " + successor.getId() + " )";
                this.executeM4SqlWrite(sql2);
            }
        }
        this.writeM4TrashToDb();
        this.writeDbTrashToDb();
    }

    protected void setSuccessors(Collection newSuccessors) throws M4Exception {
        Iterator it = new Vector(this.getSuccessors()).iterator();
        while (it.hasNext()) {
            this.removeSuccessor((Step)it.next());
        }
        if (newSuccessors == null || newSuccessors.isEmpty()) {
            return;
        }
        edu.udo.cs.miningmart.m4.Case theCase = this.getTheCase();
        if (theCase != null) {
            it = newSuccessors.iterator();
            while (it.hasNext()) {
                theCase.addStepDependency(this, (Step)it.next());
            }
        } else {
            this.getSuccessors().addAll(newSuccessors);
        }
    }

    protected void removeAllM4References() throws M4Exception {
        this.deleteM4Trash();
        this.deleteDbTrash();
        this.removeAllSuccessorsDuringDelete();
        this.removeAllParametersDuringDelete();
        this.setTheCase(null);
        this.setTheChain(null);
        this.setTheOperator(null);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getParameterTuples());
        return ret;
    }

    private void removeAllSuccessorsDuringDelete() throws M4Exception {
        Collection suc = this.getSuccessors();
        if (suc != null && suc.size() > 0) {
            suc.clear();
            this.dependentStepsDirty = true;
        }
    }

    private void removeAllParametersDuringDelete() throws M4Exception {
        Collection col = this.getParameterTuples();
        if (col != null && !col.isEmpty()) {
            Iterator it = new Vector(col).iterator();
            while (it.hasNext()) {
                this.removeParameterTuple((Parameter)it.next());
            }
        }
    }

    public Collection getM4Trash() throws M4Exception {
        if (!this.allM4TrashLoaded && !this.isNew()) {
            this.allM4TrashLoaded = true;
            try {
                this.readM4TrashFromDb();
            }
            catch (SQLException e) {
                throw new M4Exception("SQLException caught when trying to read M4Trash information from DB:\n" + e.getMessage());
            }
        }
        return this.myM4Trash;
    }

    public void addToTrash(edu.udo.cs.miningmart.m4.M4Data m4data) throws M4Exception {
        if (m4data != null) {
            this.getM4Trash().add(m4data);
        }
        this.setM4TrashDirty();
    }

    public void deleteM4Trash() throws M4Exception {
        Iterator it = this.getM4Trash().iterator();
        if (this.getName() != null && this.getName().startsWith("PivotizeByMonth")) {
            boolean i = false;
        }
        try {
            while (it.hasNext()) {
                ((M4Data)it.next()).deleteSoon();
                it.remove();
            }
        }
        catch (ClassCastException cce) {
            System.out.println("CCException in Step " + this.getName() + ": " + cce.getMessage());
            throw cce;
        }
        this.isCompiled = false;
        this.setM4TrashDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void readM4TrashFromDb() throws M4Exception, SQLException {
        String sql = "SELECT m4id, m4table FROM m4trash_t WHERE stepid = " + this.getId();
        DB db = this.getM4Db();
        ResultSet rs = null;
        try {
            rs = this.executeM4SqlRead(sql);
            while (rs.next()) {
                Class objClass;
                long objId = rs.getLong(M4_TRASH_ID);
                String table = rs.getString(M4_TRASH_OBJ_TABLE);
                if (table.equalsIgnoreCase("column_t")) {
                    objClass = class$edu$udo$cs$miningmart$m4$core$Column == null ? Step.class$("edu.udo.cs.miningmart.m4.core.Column") : class$edu$udo$cs$miningmart$m4$core$Column;
                } else if (table.equalsIgnoreCase("columnset_t")) {
                    objClass = class$edu$udo$cs$miningmart$m4$core$Columnset == null ? Step.class$("edu.udo.cs.miningmart.m4.core.Columnset") : class$edu$udo$cs$miningmart$m4$core$Columnset;
                } else {
                    if (table.equals(" ")) {
                        this.isCompiled = true;
                        continue;
                    }
                    throw new M4Exception("Step.readM4TrashFromDb(): Found unsupported M4 table " + table + " in attribute " + M4_TRASH_OBJ_TABLE + " of table " + M4_TRASH_TABLE + "!");
                }
                try {
                    void var7_6;
                    M4Data obj = (M4Data)db.getM4Object(objId, (Class)var7_6);
                    if (obj == null) continue;
                    this.getM4Trash().add(obj);
                }
                catch (ParameterNotFoundException e) {
                    super.doPrint(Print.COMPILER_STEP_CONTROL, "Garbage Collection for Step " + this.getId() + "did not find object with ID " + objId + " from table " + table + "!");
                }
            }
        }
        finally {
            DB.closeResultSet(rs);
        }
    }

    private void setDbTrashDirty() {
        if (!this.dbTrashDirty) {
            this.dbTrashDirty = true;
            this.setDirty();
        }
    }

    public void addDatabaseObjectToTrash(String objectName, String schemaName, String objectType) throws M4Exception {
        String[] trashEntry = this.createDbTrashArray(objectName, schemaName, objectType);
        this.getDbTrash().add(trashEntry);
        this.setDbTrashDirty();
    }

    public void deleteDbTrash() throws M4Exception {
        Iterator it = this.getDbTrash().iterator();
        while (it.hasNext()) {
            String[] trashArray = (String[])it.next();
            String objectName = trashArray[0];
            String schemaName = trashArray[1];
            String objectType = trashArray[2];
            String query = null;
            if (objectType.equalsIgnoreCase(DBT_TYPE_TABLE)) {
                query = "DROP TABLE ";
            } else if (objectType.equalsIgnoreCase(DBT_TYPE_VIEW)) {
                query = "DROP VIEW ";
            } else if (objectType.equalsIgnoreCase(DBT_TYPE_FUNCTION)) {
                query = "DROP FUNCTION ";
            } else if (objectType.equalsIgnoreCase(DBT_TYPE_INDEX)) {
                query = "DROP INDEX ";
            } else {
                throw new M4Exception("Step.deleteDbTrash: Unknown object type '" + objectType + "'!");
            }
            if (schemaName != null) {
                query = query + schemaName + ".";
            }
            query = query + objectName;
            try {
                this.executeBusinessSqlWrite(query);
            }
            catch (M4Exception sqle) {
                this.doPrint(Print.MAX, "WARNING: Error when attempting to remove a database object according to DBTrash_T: " + sqle.getMessage());
                try {
                    this.getM4Db().commitBusinessTransactions();
                }
                catch (DbConnectionClosed dbc) {
                    throw new M4Exception("Closed Db connection during trash deletion: " + dbc.getMessage());
                }
                catch (SQLException se) {
                    throw new M4Exception("Error trying to commit transactions during trash deletion: " + se.getMessage());
                }
            }
            it.remove();
            this.setDbTrashDirty();
        }
    }

    private Collection getDbTrash() throws M4Exception {
        if (!this.allDbTrashLoaded && !this.isNew()) {
            this.allDbTrashLoaded = true;
            this.readDbTrashFromDb();
        }
        return this.myDbTrash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDbTrashFromDb() throws M4Exception {
        String sql = "SELECT ObjName, SchemaName, ObjType FROM dbtrash_t WHERE StepId = " + this.getId();
        ResultSet rs = null;
        try {
            rs = this.executeM4SqlRead(sql);
            while (rs.next()) {
                String[] trashEntry = this.createDbTrashArray(rs.getString(ATTRIB_DBT_OBJNAME), rs.getString(ATTRIB_DBT_SCHEMA), rs.getString(ATTRIB_DBT_OBJTYPE));
                this.myDbTrash.add(trashEntry);
            }
        }
        catch (SQLException e) {
            this.doPrint(Print.MAX, "WARNING: Error when attempting to read a database object from dbtrash_t for step " + this.getId() + ":\n" + e.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
    }

    private void writeDbTrashToDb() throws M4Exception {
        if (this.dbTrashDirty) {
            String query = "DELETE FROM dbtrash_t WHERE StepId = " + this.getId();
            this.executeM4SqlWrite(query);
            String attributes = "ObjType, ObjName, SchemaName, StepId";
            Iterator it = this.getDbTrash().iterator();
            while (it.hasNext()) {
                String[] trashArray = (String[])it.next();
                String objectName = trashArray[0];
                String schemaName = trashArray[1];
                String objectType = trashArray[2];
                schemaName = schemaName == null || schemaName.equals("") ? "NULL" : DB.quote(schemaName);
                query = "INSERT INTO dbtrash_t (ObjType, ObjName, SchemaName, StepId) VALUES (" + DB.quote(objectType) + ", " + DB.quote(objectName) + ", " + schemaName + ", " + this.getId() + ")";
                this.executeM4SqlWrite(query);
            }
        }
        this.dbTrashDirty = false;
    }

    private String[] createDbTrashArray(String objectName, String schemaName, String objectType) throws M4Exception {
        if (!(objectType.equals(DBT_TYPE_FUNCTION) || objectType.equals(DBT_TYPE_INDEX) || objectType.equals(DBT_TYPE_TABLE) || objectType.equals(DBT_TYPE_VIEW))) {
            throw new M4Exception("Error adding a database object to trash: Unknown type: " + objectType + "!");
        }
        if (schemaName != null && schemaName.length() == 0) {
            schemaName = null;
        }
        String[] trashEntry = new String[]{objectName, schemaName, objectType};
        return trashEntry;
    }

    public boolean isCompiled() throws M4Exception {
        this.getM4Trash();
        return this.isCompiled;
    }

    public void setCompiled() throws M4Exception {
        this.getM4Trash();
        this.isCompiled = true;
        this.setM4TrashDirty();
    }

    private void setM4TrashDirty() {
        this.m4trashDirty = true;
        this.setDirty();
    }

    private void writeM4TrashToDb() throws M4Exception {
        if (this.m4trashDirty) {
            this.m4trashDirty = false;
            String delSql = "DELETE FROM m4trash_t WHERE stepid = " + this.getId();
            this.executeM4SqlWrite(delSql);
            String sqlPre = "INSERT INTO m4trash_t ( m4id, m4table, stepid ) VALUES ( ";
            String sqlPost = ", " + this.getId() + " )";
            Iterator it = this.getM4Trash().iterator();
            while (it.hasNext()) {
                M4Data m4data = (M4Data)it.next();
                if (m4data.isWaitingForDelete()) continue;
                long objId = m4data.getId();
                String table = m4data.getM4TableName();
                String sql = "INSERT INTO m4trash_t ( m4id, m4table, stepid ) VALUES ( " + objId + ", " + DB.quote(table) + sqlPost;
                this.executeM4SqlWrite(sql);
            }
            if (this.isCompiled()) {
                String sql = "INSERT INTO m4trash_t ( m4id, m4table, stepid ) VALUES ( 0, ' '" + sqlPost;
                this.executeM4SqlWrite(sql);
            }
        }
    }

    public edu.udo.cs.miningmart.m4.Step getPredecessor() throws M4Exception {
        Iterator it = this.getTheCase().getReverseIterator();
        boolean currentStepFound = false;
        while (it.hasNext()) {
            Step step = (Step)it.next();
            if (this.equals(step)) {
                currentStepFound = true;
                continue;
            }
            if (!currentStepFound || !this.getTheCase().containsDependency(step, this)) continue;
            return step;
        }
        return null;
    }

    public Collection getAllPredecessors() throws M4Exception {
        Iterator it = this.getTheCase().getReverseIterator();
        boolean currentStepFound = false;
        Vector<Step> thePredecessors = new Vector<Step>();
        while (it.hasNext()) {
            Step step = (Step)it.next();
            if (this.equals(step)) {
                currentStepFound = true;
                continue;
            }
            if (!currentStepFound || !this.getTheCase().containsDependency(step, this)) continue;
            thePredecessors.add(step);
        }
        return thePredecessors;
    }

    public boolean belongsToChainOrSubChain(Chain theChain) throws M4Exception {
        if (theChain == null) {
            return true;
        }
        if (this.getTheChain().equals(theChain)) {
            return true;
        }
        Iterator chIt = theChain.getDirectSubChains().iterator();
        while (chIt.hasNext()) {
            theChain = (edu.udo.cs.miningmart.m4.core.Chain)chIt.next();
            if (!this.belongsToChainOrSubChain(theChain)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPredecessorOutsideChain() throws M4Exception {
        Iterator predIt = this.getAllPredecessors().iterator();
        edu.udo.cs.miningmart.m4.core.Chain myChain = (edu.udo.cs.miningmart.m4.core.Chain)this.getTheChain();
        while (predIt.hasNext()) {
            Step aStep = (Step)predIt.next();
            if (aStep.belongsToChainOrSubChain(myChain)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSuccessorOutsideChain() throws M4Exception {
        Iterator succIt = this.getSuccessors().iterator();
        edu.udo.cs.miningmart.m4.core.Chain myChain = (edu.udo.cs.miningmart.m4.core.Chain)this.getTheChain();
        while (succIt.hasNext()) {
            Step aStep = (Step)succIt.next();
            if (aStep.belongsToChainOrSubChain(myChain)) continue;
            return true;
        }
        return false;
    }

    public void removePredecessor() throws M4Exception {
        Step fromStep = (Step)this.getPredecessor();
        this.getTheCase().removeStepDependency(fromStep, this);
    }

    public edu.udo.cs.miningmart.m4.Parameter getParameterTuple(String name, int loopNr) throws M4Exception {
        Iterator it;
        Collection col = this.getParameterTuples();
        if (name != null && col != null && (it = col.iterator()) != null) {
            while (it.hasNext()) {
                Parameter par = (Parameter)it.next();
                if (par == null || !par.getParameterName().startsWith(name) || par.getLoopNr() != loopNr) continue;
                return par;
            }
        }
        return null;
    }

    private ParameterArray getParameterArray(edu.udo.cs.miningmart.m4.OpParam theOperatorParameter, int loopNumber) throws M4Exception {
        Collection allParamTuples = this.getParameterTuples();
        Iterator tupleIt = allParamTuples.iterator();
        edu.udo.cs.miningmart.m4.core.ParameterArray thePA = new edu.udo.cs.miningmart.m4.core.ParameterArray(theOperatorParameter.getType());
        while (tupleIt.hasNext()) {
            Parameter myParam = (Parameter)tupleIt.next();
            if (!this.parameterNamesMatch(theOperatorParameter.getName(), myParam) || myParam.getLoopNr() != loopNumber) continue;
            thePA.addParameter(myParam);
        }
        if (thePA.size() == 0) {
            return null;
        }
        return thePA;
    }

    private boolean parameterNamesMatch(String name, Parameter param) {
        String parName = param.getName();
        if (parName.startsWith(name)) {
            String suffix = parName.substring(name.length());
            if (suffix.length() == 0) {
                return true;
            }
            try {
                Integer.parseInt(suffix);
                return true;
            }
            catch (NumberFormatException n) {
                return false;
            }
        }
        return false;
    }

    public edu.udo.cs.miningmart.m4.Parameter createParameterTuple(String name, ParameterObject object, long number, int loopNumber, String ioType) throws M4Exception {
        if (this.getTheOperator().getOpParam(this.getParameterNameWithoutSuffix(name)) == null) {
            throw new M4Exception("Step.createParameter(...): name '" + name + "' is not an allowed parameter of operator '" + this.getTheOperator().getName() + "'!");
        }
        Parameter par = (Parameter)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$Parameter == null ? (class$edu$udo$cs$miningmart$m4$core$Parameter = Step.class$("edu.udo.cs.miningmart.m4.core.Parameter")) : class$edu$udo$cs$miningmart$m4$core$Parameter);
        par.setParameterName(name);
        par.setParamNr(number);
        par.setInputParam(ioType);
        par.setTheStep(this);
        par.setTheParameterObject(object);
        par.setTheOperator(this.getTheOperator());
        par.setLoopNr(loopNumber);
        return par;
    }

    public edu.udo.cs.miningmart.m4.Parameter createValueParameterTuple(String value, String datatype, String name, long number, int loopNumber, String type) throws M4Exception {
        Value newVal = (Value)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$Value == null ? (class$edu$udo$cs$miningmart$m4$core$Value = Step.class$("edu.udo.cs.miningmart.m4.core.Value")) : class$edu$udo$cs$miningmart$m4$core$Value);
        newVal.setName(name);
        newVal.setType(datatype);
        newVal.setValue(value);
        return this.createParameterTuple(name, newVal, number, loopNumber, type);
    }

    public edu.udo.cs.miningmart.m4.Step copy(edu.udo.cs.miningmart.m4.Case newCase, Chain newChain) throws M4Exception {
        Step theCopy = new Step(this.getM4Db());
        try {
            theCopy.setTheCase(newCase);
            theCopy.setTheChain(newChain);
            theCopy.setLoopCount(this.getLoopCount());
            theCopy.setMultiStepCondition(this.getMultiStepCondition());
            String nameOfCopy = newChain.getValidName(this.getName(), class$edu$udo$cs$miningmart$m4$core$Step == null ? (class$edu$udo$cs$miningmart$m4$core$Step = Step.class$("edu.udo.cs.miningmart.m4.core.Step")) : class$edu$udo$cs$miningmart$m4$core$Step);
            theCopy.setName(nameOfCopy);
            theCopy.setNumber(this.getNumber());
            theCopy.setTheOperator(this.getTheOperator());
            theCopy.setNumber(this.getNumber());
        }
        catch (M4Exception m4e) {
            throw new M4Exception("Could not create copy of Step " + this.getId() + ": " + m4e.getMessage());
        }
        return theCopy;
    }

    public Collection getParameter(edu.udo.cs.miningmart.m4.OpParam theOpParam, int loopNr) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParameterObject[] parObjArray = this.getParameter(theOpParam.getName(), loopNr);
        if (parObjArray == null) {
            return null;
        }
        Vector<edu.udo.cs.miningmart.m4.core.ParameterObject> vec = new Vector<edu.udo.cs.miningmart.m4.core.ParameterObject>();
        for (int i = 0; i < parObjArray.length; ++i) {
            vec.add(parObjArray[i]);
        }
        return vec;
    }

    public void setParameter(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theParameterObjects, int loopNr) throws M4Exception {
        if (theParameterObjects == null) {
            throw new M4Exception("Step.setParameter() was called with >null< Collection 'theParameterObjects'!");
        }
        if (theOpParam.isValueParameter()) {
            Vector<Value> newValueObjects = new Vector<Value>();
            Iterator it = theParameterObjects.iterator();
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.ParameterObject parObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)it.next();
                if (!(parObj instanceof Value)) {
                    throw new M4Exception("Step.setParameter() was called with a Value OpParam but non-Value parameter objects!");
                }
                Value v = (Value)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$Value == null ? Step.class$("edu.udo.cs.miningmart.m4.core.Value") : class$edu$udo$cs$miningmart$m4$core$Value);
                v.setDocumentation(parObj.getDocumentation());
                v.setType(((Value)parObj).getTypeName());
                v.setValue(((Value)parObj).getValue());
                v.setName(parObj.getName());
                newValueObjects.add(v);
            }
            theParameterObjects = newValueObjects;
        }
        String parameterName = theOpParam.getName();
        ParameterArray paOld = null;
        paOld = this.getParameterArray(theOpParam, loopNr);
        boolean needsSuffix = theOpParam.isArray() || theOpParam.isLoopable() || loopNr > 0 || paOld != null && paOld.size() > 1 || theParameterObjects.size() > 1;
        String inputOutputString = theOpParam.getInput();
        M4Object oldParameterObject = null;
        edu.udo.cs.miningmart.m4.core.ParameterObject newParameterObject = null;
        if (paOld == null) {
            if (!theParameterObjects.isEmpty()) {
                Iterator it = theParameterObjects.iterator();
                while (it.hasNext()) {
                    edu.udo.cs.miningmart.m4.core.ParameterObject parObj;
                    newParameterObject = parObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)it.next();
                    long freeParNum = this.getFreeParameterNumber();
                    int freeSuffixNum = this.getFreeParameterSuffix(theOpParam);
                    this.createParameterTuple(needsSuffix ? parameterName + freeSuffixNum : parameterName, parObj, freeParNum, loopNr, inputOutputString);
                }
            }
        } else {
            Parameter oldPar;
            int index;
            Object[] copyOfOldParams = paOld.getParameters().toArray();
            Object[] copyOfParObjs = theParameterObjects.toArray();
            for (index = 0; index < copyOfOldParams.length && index < copyOfParObjs.length; ++index) {
                edu.udo.cs.miningmart.m4.core.ParameterObject newParObj;
                oldPar = (Parameter)copyOfOldParams[index];
                oldParameterObject = (edu.udo.cs.miningmart.m4.core.ParameterObject)oldPar.getTheParameterObject();
                if (!theOpParam.isInput()) {
                    this.handleOldOutput((ParameterObject)((Object)oldParameterObject));
                }
                newParameterObject = newParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)copyOfParObjs[index];
                oldPar.setTheParameterObject(newParObj);
            }
            while (index < copyOfOldParams.length) {
                oldPar = (Parameter)copyOfOldParams[index];
                oldParameterObject = (edu.udo.cs.miningmart.m4.core.ParameterObject)oldPar.getTheParameterObject();
                if (!theOpParam.isInput()) {
                    this.handleOldOutput((ParameterObject)((Object)oldParameterObject));
                }
                this.removeParameterTuple(oldPar);
                oldPar.deleteSoon();
                ++index;
            }
            while (index < copyOfParObjs.length) {
                edu.udo.cs.miningmart.m4.core.ParameterObject newParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)copyOfParObjs[index];
                long freeParameterNumber = this.getFreeParameterNumber();
                int freeSuffixNum = this.getFreeParameterSuffix(theOpParam);
                this.createParameterTuple(needsSuffix ? parameterName + freeSuffixNum : parameterName, newParObj, freeParameterNumber, loopNr, inputOutputString);
                ++index;
            }
        }
        if (oldParameterObject != null && theOpParam.isInput() && theOpParam.isConceptParameter() && !oldParameterObject.equals(newParameterObject)) {
            if (!(oldParameterObject instanceof Concept) || newParameterObject != null && !(newParameterObject instanceof Concept)) {
                throw new M4Exception("Step.setParameter(): found something that is not a concept as (old) parameter object of a concept parameter!");
            }
            this.releaseOldInputConcept((Concept)oldParameterObject);
        }
    }

    private void handleOldOutput(ParameterObject oldOutput) throws M4Exception {
        if (oldOutput instanceof edu.udo.cs.miningmart.m4.core.Feature) {
            oldOutput.deleteSoon();
        }
    }

    private int getHighestLoopNr(edu.udo.cs.miningmart.m4.OpParam theOpParam) throws M4Exception {
        Iterator parIt = this.getParameterTuples(theOpParam).iterator();
        int highestLoopNr = 0;
        while (parIt.hasNext()) {
            Parameter myPar = (Parameter)parIt.next();
            if (myPar.getLoopNr() <= highestLoopNr) continue;
            highestLoopNr = myPar.getLoopNr();
        }
        return highestLoopNr;
    }

    private long getFreeParameterNumber() throws M4Exception {
        Collection theTuples = this.getParameterTuples();
        boolean found = false;
        long candidateNumber = 0L;
        while (!found) {
            Iterator it = theTuples.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                Parameter myPar = (Parameter)it.next();
                long number = myPar.getParamNr();
                if (number != candidateNumber) continue;
                ++candidateNumber;
                changed = true;
            }
            if (changed) continue;
            found = true;
        }
        return candidateNumber;
    }

    private int getFreeParameterSuffix(edu.udo.cs.miningmart.m4.OpParam anOpPar) throws M4Exception {
        Collection theTuples = this.getParameterTuples(anOpPar);
        boolean found = false;
        int candidateSuffix = 0;
        while (!found) {
            Iterator it = theTuples.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                Parameter myPar = (Parameter)it.next();
                int suffix = this.getParameterNameSuffix(myPar);
                if (suffix != candidateSuffix) continue;
                ++candidateSuffix;
                changed = true;
            }
            if (changed) continue;
            found = true;
        }
        return candidateSuffix;
    }

    private int getParameterNameSuffix(Parameter aPar) {
        String parName = aPar.getName();
        int pos = parName.length() - 1;
        while (Character.isDigit(parName.charAt(pos))) {
            --pos;
        }
        if (pos == parName.length() - 1) {
            return -1;
        }
        return Integer.parseInt(parName.substring(pos + 1));
    }

    private String getParameterNameWithoutSuffix(String parName) {
        int pos = parName.length() - 1;
        while (Character.isDigit(parName.charAt(pos))) {
            --pos;
        }
        if (pos == -1) {
            return null;
        }
        return parName.substring(0, pos + 1);
    }

    private void deleteOutputs() throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Operator op = (edu.udo.cs.miningmart.m4.core.Operator)this.getTheOperator();
        if (op != null) {
            Iterator outputOpParIt = op.getAllOutputOperatorParameters().iterator();
            int loops = this.getLoopCount();
            if (loops == 0) {
                loops = 1;
            }
            while (outputOpParIt.hasNext()) {
                OpParam outOpPar = (OpParam)outputOpParIt.next();
                for (int loopNr = 0; loopNr < loops; ++loopNr) {
                    Collection parObjs = this.getParameter(outOpPar, loopNr);
                    if (parObjs == null) continue;
                    Iterator parObjsIt = parObjs.iterator();
                    while (parObjsIt.hasNext()) {
                        edu.udo.cs.miningmart.m4.core.ParameterObject myParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)parObjsIt.next();
                        myParObj.deleteSoon();
                    }
                }
            }
        }
    }

    private void releaseOldInputConcept(edu.udo.cs.miningmart.m4.Concept oldInputConcept) throws M4Exception {
        if (oldInputConcept != null) {
            Vector theOldOutputAttribs = new Vector();
            this.getOutputAttribsOfThisAndFollowingSteps(theOldOutputAttribs);
            Iterator attribsIt = theOldOutputAttribs.iterator();
            while (attribsIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.ParameterObject myParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)attribsIt.next();
                if (!(myParObj instanceof edu.udo.cs.miningmart.m4.core.Feature)) {
                    throw new M4Exception("Step.releaseOldInputConcept(): found illegal parameter object!");
                }
                if (!oldInputConcept.hasFeature((edu.udo.cs.miningmart.m4.core.Feature)myParObj)) continue;
                oldInputConcept.removeFeature((edu.udo.cs.miningmart.m4.core.Feature)myParObj);
            }
        }
    }

    private void getOutputAttribsOfThisAndFollowingSteps(Collection attribs) throws M4Exception {
        if (this.getOutputConcept() != null) {
            return;
        }
        Iterator outputOpParIt = this.getTheOperator().getAllOutputOperatorParameters().iterator();
        while (outputOpParIt.hasNext()) {
            OpParam outOpPar = (OpParam)outputOpParIt.next();
            if (!outOpPar.isBaseAttribParameter() && !outOpPar.isFeatureParameter()) continue;
            Collection coll = this.getParameterTuples(outOpPar);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Parameter myPar = (Parameter)it.next();
                attribs.add(myPar.getTheParameterObject());
            }
        }
        Iterator succStepsIt = this.getSuccessors().iterator();
        while (succStepsIt.hasNext()) {
            Step mySucc = (Step)succStepsIt.next();
            mySucc.getOutputAttribsOfThisAndFollowingSteps(attribs);
        }
    }

    public boolean checkInputParameterEntries() throws M4Exception {
        Collection allConstraints;
        String errorMsg = null;
        int numLoops = this.getLoopCount();
        Collection opParams = this.getTheOperator().getOpParams();
        Iterator it = opParams.iterator();
        while (it.hasNext()) {
            OpParam opPar = (OpParam)it.next();
            if (!opPar.isInput()) continue;
            String parName = opPar.getName();
            if (numLoops > 0 && opPar.isLoopable()) {
                for (int i = 1; i <= numLoops; ++i) {
                    edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray = this.getParameter(parName, i);
                    if (pArray == null) {
                        throw new M4Exception("Step '" + this.getName() + "', Parameter '" + parName + "', Loop " + i + ": no parameter object(s) found!");
                    }
                    errorMsg = this.checkSingleLoopOpParam(opPar, pArray);
                    if (errorMsg == null) continue;
                    errorMsg = errorMsg + " (loop: " + i + ") ";
                }
                continue;
            }
            errorMsg = this.checkSingleLoopOpParam(opPar, this.getParameter(parName, 0));
        }
        if (errorMsg == null) {
            allConstraints = this.getTheOperator().getConstraints();
            HashMap<String, Vector<edu.udo.cs.miningmart.m4.core.Constraint>> datatypeConstraints = new HashMap<String, Vector<edu.udo.cs.miningmart.m4.core.Constraint>>();
            if (allConstraints != null && (it = allConstraints.iterator()) != null) {
                while (it.hasNext() && errorMsg == null) {
                    edu.udo.cs.miningmart.m4.core.Constraint constraint = (edu.udo.cs.miningmart.m4.core.Constraint)it.next();
                    if (constraint.getType().equals("TYPE")) {
                        Vector<edu.udo.cs.miningmart.m4.core.Constraint> listOfConstraints = (Vector<edu.udo.cs.miningmart.m4.core.Constraint>)datatypeConstraints.get(constraint.getObj1());
                        if (listOfConstraints == null) {
                            listOfConstraints = new Vector<edu.udo.cs.miningmart.m4.core.Constraint>();
                            datatypeConstraints.put(constraint.getObj1(), listOfConstraints);
                        }
                        listOfConstraints.add(constraint);
                        continue;
                    }
                    errorMsg = this.checkInputTypeConstraint(constraint);
                }
            }
            if (errorMsg == null) {
                Iterator typeConstrIt = datatypeConstraints.entrySet().iterator();
                while (typeConstrIt.hasNext()) {
                    OpParam obj1OpPar;
                    int loopNum;
                    Map.Entry myEntry = typeConstrIt.next();
                    Vector listOfConstraints = (Vector)myEntry.getValue();
                    if (listOfConstraints.size() == 1) {
                        errorMsg = this.checkInputTypeConstraint((edu.udo.cs.miningmart.m4.core.Constraint)listOfConstraints.get(0));
                        if (errorMsg == null) continue;
                        break;
                    }
                    String obj1 = (String)myEntry.getKey();
                    edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray = this.getParameter(obj1, loopNum = (obj1OpPar = (OpParam)this.getTheOperator().getOpParam(obj1)).isLoopable() && this.getLoopCount() > 0 ? 1 : 0);
                    if (pArray == null || pArray.length == 0 || pArray[0] == null) {
                        if (obj1OpPar.isOptional()) break;
                        throw new UserError("Constraint TYPE violated. No object(s) for mandatory parameter '" + obj1 + "' found!");
                    }
                    boolean oneConstraintFulfilledByEachObject = true;
                    for (int i = 0; i < pArray.length; ++i) {
                        Iterator constrIt = listOfConstraints.iterator();
                        boolean oneConstraintFulfilledByCurrentObject = false;
                        while (constrIt.hasNext()) {
                            edu.udo.cs.miningmart.m4.core.Constraint myConstr = (edu.udo.cs.miningmart.m4.core.Constraint)constrIt.next();
                            String localErrorMsg = this.checkDatatypeConstraint(pArray[i], myConstr.getObj2());
                            if (localErrorMsg == null) {
                                oneConstraintFulfilledByCurrentObject = true;
                                continue;
                            }
                            errorMsg = localErrorMsg;
                        }
                        if (oneConstraintFulfilledByCurrentObject) continue;
                        oneConstraintFulfilledByEachObject = false;
                    }
                    if (!oneConstraintFulfilledByEachObject) continue;
                    errorMsg = null;
                }
            }
        }
        if (errorMsg != null && this.getTheOperator().getName().equals("MultiRelationalFeatureConstruction")) {
            allConstraints = this.getTheOperator().getConstraints();
            Vector<edu.udo.cs.miningmart.m4.core.ParameterObject> inputConcepts = new Vector<edu.udo.cs.miningmart.m4.core.ParameterObject>();
            Vector<edu.udo.cs.miningmart.m4.core.ParameterObject> attribsInInputConcept = new Vector<edu.udo.cs.miningmart.m4.core.ParameterObject>();
            if (allConstraints != null && (it = allConstraints.iterator()) != null) {
                while (it.hasNext()) {
                    int i;
                    edu.udo.cs.miningmart.m4.core.Constraint constraint = (edu.udo.cs.miningmart.m4.core.Constraint)it.next();
                    if (!constraint.getType().equals("IN")) continue;
                    edu.udo.cs.miningmart.m4.core.ParameterObject[] concepts = this.getParameter(constraint.getObj2(), 0);
                    edu.udo.cs.miningmart.m4.core.ParameterObject[] attribs = this.getParameter(constraint.getObj1(), 0);
                    if (concepts == null) continue;
                    for (i = 0; i < attribs.length; ++i) {
                        attribsInInputConcept.add(attribs[i]);
                    }
                    for (i = 0; i < concepts.length; ++i) {
                        inputConcepts.add(concepts[i]);
                    }
                }
            }
            Iterator attrIt = attribsInInputConcept.iterator();
            errorMsg = null;
            while (attrIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute myBA = (edu.udo.cs.miningmart.m4.core.BaseAttribute)attrIt.next();
                Iterator concIt = inputConcepts.iterator();
                boolean found = false;
                while (concIt.hasNext()) {
                    Concept myCon = (Concept)concIt.next();
                    if (myCon.getBaseAttribute(myBA.getName()) == null) continue;
                    found = true;
                }
                if (found) continue;
                errorMsg = "Step '" + this.getName() + "': BaseAttribute '" + myBA.getName() + "' does not belong to any of the input concepts!";
            }
        }
        if (errorMsg == null) {
            return true;
        }
        throw new UserError(errorMsg + " in step '" + this.getName() + "' (Id " + this.getId() + ")");
    }

    public boolean checkOutputParameterEntries() throws M4Exception, UserError {
        Collection out = this.getTheOperator().getAllOutputOperatorParameters();
        String pref = "Step '" + this.getName() + "'";
        String errorPrefix = "";
        if (out == null || out.isEmpty()) {
            return true;
        }
        Iterator it = out.iterator();
        while (it.hasNext()) {
            OpParam outputOpParam = (OpParam)it.next();
            String errPref = pref + ", output parameter '" + outputOpParam.getName() + "'";
            if (outputOpParam.isOptional()) continue;
            int startloop = 0;
            int endloop = 0;
            if (outputOpParam.isLoopable() && this.getLoopCount() > 0) {
                startloop = 1;
                endloop = this.getLoopCount();
            }
            for (int loop = startloop; loop <= endloop; ++loop) {
                errorPrefix = startloop > 0 ? errPref + ", loop " + loop + ": " : errPref + ": ";
                Collection itsTuples = this.getParameterTuples(outputOpParam, loop);
                if (itsTuples == null || itsTuples.isEmpty()) {
                    throw new UserError(errorPrefix + "no entries found, but parameter is not optional!");
                }
                if (outputOpParam.getMinArg() > itsTuples.size()) {
                    throw new UserError(errorPrefix + "at least " + outputOpParam.getMinArg() + " entries are needed!");
                }
                if (outputOpParam.getMaxArg() > -1 && itsTuples.size() > outputOpParam.getMaxArg()) {
                    throw new UserError(errorPrefix + "at most " + outputOpParam.getMinArg() + " entries are possible!");
                }
                Iterator tupleIt = itsTuples.iterator();
                while (tupleIt.hasNext()) {
                    Parameter myPar = (Parameter)tupleIt.next();
                    if (myPar == null) {
                        throw new UserError(errorPrefix + "found NULL parameter!");
                    }
                    edu.udo.cs.miningmart.m4.core.ParameterObject po = (edu.udo.cs.miningmart.m4.core.ParameterObject)myPar.getTheParameterObject();
                    if (po == null) {
                        throw new UserError(errorPrefix + "found no parameter object!");
                    }
                    if (outputOpParam.isBaseAttribParameter() && !(po instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) {
                        throw new UserError(errorPrefix + "expected a BaseAttribute as parameter object!");
                    }
                    if (outputOpParam.isConceptParameter() && !(po instanceof Concept)) {
                        throw new UserError(errorPrefix + "expected a Concept as parameter object!");
                    }
                    if (!outputOpParam.isFeatureParameter() || po instanceof edu.udo.cs.miningmart.m4.core.Feature) continue;
                    throw new UserError(errorPrefix + "expected a Feature as parameter object!");
                }
            }
        }
        return true;
    }

    private String checkSingleLoopOpParam(OpParam opParam, edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray) {
        if (opParam.getMinArg() > 0 && pArray == null) {
            return "Step '" + this.getName() + "': non-optional parameter '" + opParam.getName() + "' is missing!";
        }
        if (pArray == null) {
            return null;
        }
        if (pArray.length < opParam.getMinArg()) {
            return "Non-optional parameter '" + opParam.getName() + "': Found " + pArray.length + " entries, but expect at least " + opParam.getMinArg();
        }
        if (opParam.getMaxArg() > 0 && pArray.length > opParam.getMaxArg()) {
            return "Parameter '" + opParam.getName() + "': Found " + pArray.length + " entries, but expect at most " + opParam.getMaxArg();
        }
        short parType = opParam.getType();
        for (int i = 0; i < pArray.length; ++i) {
            edu.udo.cs.miningmart.m4.core.ParameterObject pObj = pArray[i];
            if (pObj == null) {
                return "Parameter '" + opParam.getName() + "': Found null entry at index " + i;
            }
            String expected = null;
            if (parType == 1 && !(pObj instanceof Concept)) {
                expected = "Concept";
            } else if (parType == 3 && !(pObj instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) {
                expected = "BaseAttribute";
            } else if (parType == 4 && !(pObj instanceof MultiColumnFeature)) {
                expected = "MultiColumnFeature";
            } else if (parType == 5 && !(pObj instanceof edu.udo.cs.miningmart.m4.core.Feature)) {
                expected = "Feature";
            } else if (parType == 0 && !(pObj instanceof Value)) {
                expected = "Value";
            } else if (parType == 2 && !(pObj instanceof Relation)) {
                expected = "Relation";
            }
            if (expected == null) continue;
            return "Parameter '" + opParam.getName() + "' at index " + i + ": Expected was a " + expected + ", but found an object of incompatible class " + pObj.getClass().getName();
        }
        return null;
    }

    private String checkInputTypeConstraint(edu.udo.cs.miningmart.m4.core.Constraint constraint) throws M4Exception {
        String type = constraint.getType();
        String obj1 = constraint.getObj1();
        String obj2 = constraint.getObj2();
        OpParam oneOpPar = (OpParam)this.getTheOperator().getOpParam(obj1);
        OpParam secondOpPar = null;
        if (!oneOpPar.isInput()) {
            return null;
        }
        if (obj2 != null && (secondOpPar = (OpParam)this.getTheOperator().getOpParam(obj2)) != null && !secondOpPar.isInput()) {
            return null;
        }
        int loopNum = 0;
        int lastLoop = this.getLoopCount() + 1;
        if (oneOpPar.isLoopable() && this.getLoopCount() > 0) {
            loopNum = 1;
        }
        if (!oneOpPar.isLoopable()) {
            lastLoop = 0;
        }
        String errMessg = null;
        do {
            edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray;
            if ((pArray = this.getParameter(obj1, loopNum)) == null || pArray.length == 0 || pArray[0] == null) {
                if (oneOpPar.isOptional()) {
                    return null;
                }
                throw new UserError("Constraint " + type + " violated. No object(s) for mandatory parameter '" + obj1 + "' found!");
            }
            if (type.equals("ONE_OF")) {
                errMessg = this.checkOneOfConstraint(pArray, obj2);
                continue;
            }
            if (type.equals("IN")) {
                if (secondOpPar == null) {
                    throw new M4Exception("Step '" + this.getName() + "': IN Constraint found whose object 2 is not a parameter!");
                }
                int loopNumberForSecondParameter = secondOpPar.isLoopable() ? loopNum : 0;
                edu.udo.cs.miningmart.m4.core.ParameterObject[] obj2ParArray = this.getParameter(obj2, loopNumberForSecondParameter);
                errMessg = this.checkContainedInConstraint(pArray, obj2ParArray, loopNum);
                continue;
            }
            if (type.equals("TYPE")) {
                errMessg = this.checkDatatypeConstraint(pArray, obj2);
                continue;
            }
            if (type.equals("GE")) {
                errMessg = this.checkComparisonConstraint(pArray, obj2, loopNum, true, true);
                continue;
            }
            if (type.equals("GT")) {
                errMessg = this.checkComparisonConstraint(pArray, obj2, loopNum, false, true);
                continue;
            }
            if (type.equals("LE")) {
                errMessg = this.checkComparisonConstraint(pArray, obj2, loopNum, true, false);
                continue;
            }
            if (type.equals("LT")) {
                errMessg = this.checkComparisonConstraint(pArray, obj2, loopNum, false, false);
                continue;
            }
            if (type.equals("SAME_TYPE")) {
                errMessg = this.checkSameDataTypeConstraint(pArray, obj2, loopNum);
                continue;
            }
            if (type.equals("SAME_FEAT")) {
                errMessg = this.checkSameFeatureConstraint(pArray, obj2, loopNum);
                continue;
            }
            if (type.equals("SUM")) {
                errMessg = this.checkSumsToOne(pArray);
                continue;
            }
            if (!type.equals("COORD")) continue;
            errMessg = this.checkArrayCoordination(pArray, obj1, obj2, loopNum);
        } while (++loopNum < lastLoop && errMessg == null);
        return errMessg;
    }

    private String checkOneOfConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, String obj2) {
        if (obj2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(obj2);
        Vector<Object> alternatives = new Vector<Object>();
        while (st.hasMoreElements()) {
            alternatives.add(st.nextElement());
        }
        for (int i = 0; i < pArray.length; ++i) {
            if (pArray[i] instanceof Value) {
                String value = ((Value)pArray[i]).getValue();
                if (alternatives.contains(value)) continue;
                return "'ONE OF'-Constraint violated: value " + value + " not found in list of alternatives (" + alternatives.toString() + ").";
            }
            return "'ONE OF'-Constraint found for parameter of different type than Value.";
        }
        return null;
    }

    private String checkContainedInConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, edu.udo.cs.miningmart.m4.core.ParameterObject[] obj2, int loopNum) throws M4Exception {
        int i;
        for (i = 0; i < obj2.length; ++i) {
            if (obj2[i] instanceof Concept) continue;
            return "Constraint 'IN' expects a Concept as its second parameter. Found an object of class " + obj2[i].getClass().getName() + " instead!";
        }
        if (pArray[0] instanceof edu.udo.cs.miningmart.m4.core.Feature) {
            for (i = 0; i < pArray.length; ++i) {
                if (pArray[i] instanceof edu.udo.cs.miningmart.m4.core.Feature) {
                    if (this.findFeatureInConcepts((edu.udo.cs.miningmart.m4.core.Feature)pArray[i], obj2)) continue;
                    return "'IN'-constraint violated for feature '" + ((edu.udo.cs.miningmart.m4.core.Feature)pArray[i]).getName() + "', it does not belong to the input concept(s) in loop number " + loopNum + "!";
                }
                return "Found unsupported object of class " + pArray[i].getClass().getName() + " in first parameter of 'IN' constraint!";
            }
        } else if (pArray[0] instanceof Concept) {
            Iterator it = ((Concept)pArray[0]).getFeatures().iterator();
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Feature f = (edu.udo.cs.miningmart.m4.core.Feature)it.next();
                if (this.findFeatureInConcepts(f, obj2)) continue;
                return "'IN'-constraint violated for feature '" + f.getName() + "' of concept '" + pArray[0].getName() + "'!";
            }
        } else {
            return "Found unsupported object of class " + pArray[0].getClass().getName() + " in first parameter of 'IN' constraint!";
        }
        return null;
    }

    private boolean findFeatureInConcepts(edu.udo.cs.miningmart.m4.core.Feature f, edu.udo.cs.miningmart.m4.core.ParameterObject[] concepts) throws M4Exception {
        for (int i = 0; i < concepts.length; ++i) {
            Concept myCon = (Concept)concepts[i];
            Iterator theFeaturesIt = myCon.getFeatures().iterator();
            while (theFeaturesIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Feature myF = (edu.udo.cs.miningmart.m4.core.Feature)theFeaturesIt.next();
                if (!myF.equals(f)) continue;
                return true;
            }
        }
        return false;
    }

    private String checkSameFeatureConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, String obj2, int loopNum) throws M4Exception {
        Vector<edu.udo.cs.miningmart.m4.core.ParameterObject> otherConcepts = new Vector<edu.udo.cs.miningmart.m4.core.ParameterObject>();
        for (int i = 0; i < pArray.length; ++i) {
            if (!(pArray[i] instanceof Concept)) {
                return "Constraint 'SAME_FEAT' expects a single or an array of Concept(s) as its first parameter. Found an object of class " + pArray[i].getClass().getName() + " instead!";
            }
            otherConcepts.add(pArray[i]);
        }
        edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray2 = this.getParameter(obj2, loopNum);
        if (pArray2 == null || pArray2.length == 0) {
            return null;
        }
        if (!(pArray2[0] instanceof Concept)) {
            return "Constraint 'SAME_FEAT' expects a Concept as its second parameter. Found an object of class " + pArray[0].getClass().getName() + " instead!";
        }
        Concept inConcept = (Concept)pArray2[0];
        Vector<String> inputFeatureNames = new Vector<String>();
        Iterator feaIt = inConcept.getFeatures().iterator();
        while (feaIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Feature fea = (edu.udo.cs.miningmart.m4.core.Feature)feaIt.next();
            if (!this.isVisible(fea)) continue;
            inputFeatureNames.add(fea.getName());
        }
        Iterator it = otherConcepts.iterator();
        while (it.hasNext()) {
            Concept outConcept = (Concept)it.next();
            Iterator feaIt2 = outConcept.getFeatures().iterator();
            Vector ifn = (Vector)inputFeatureNames.clone();
            while (feaIt2.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Feature fea = (edu.udo.cs.miningmart.m4.core.Feature)feaIt2.next();
                if (this.isVisible(fea) && !ifn.contains(fea.getName())) {
                    return "Constraint 'SAME_FEAT' violated. Concept '" + outConcept.getName() + "' contains additional feature '" + fea.getName() + "'!";
                }
                ifn.remove(fea.getName());
            }
            if (ifn.isEmpty()) continue;
            String additional = (String)ifn.firstElement();
            return "Constraint 'SAME_FEAT' violated. Concept '" + inConcept.getName() + "' contains feature '" + additional + "', which is not part of concept '" + outConcept.getName() + "'!";
        }
        return null;
    }

    private boolean checkDatatypeCompatibility(String datatype1, String datatype2) {
        if (datatype1.equalsIgnoreCase(datatype2)) {
            return true;
        }
        for (int i = 0; i < this.datatypeCompatibilities.length; ++i) {
            if (this.datatypeCompatibilities[i][0].equalsIgnoreCase(datatype1) && this.datatypeCompatibilities[i][1].equalsIgnoreCase(datatype2)) {
                return true;
            }
            if (!this.datatypeCompatibilities[i][1].equalsIgnoreCase(datatype1) || !this.datatypeCompatibilities[i][0].equalsIgnoreCase(datatype2)) continue;
            return true;
        }
        return false;
    }

    private String checkDatatypeConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, String obj2) throws M4Exception {
        for (int i = 0; i < pArray.length; ++i) {
            edu.udo.cs.miningmart.m4.core.ParameterObject current = pArray[i];
            String error = this.checkDatatypeConstraint(current, obj2);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private String checkDatatypeConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject theObject, String obj2) throws M4Exception {
        String datatype = null;
        if (theObject instanceof Value) {
            datatype = ((Value)theObject).getTypeName();
        } else if (theObject instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute) {
            datatype = ((edu.udo.cs.miningmart.m4.core.BaseAttribute)theObject).getConceptualDataTypeName();
        } else {
            return "Found unsupported object of class " + theObject.getClass().getName() + " in first parameter of 'TYPE' constraint!";
        }
        if (!this.checkDatatypeCompatibility(obj2, datatype)) {
            return "'TYPE' constraint violated. BaseAttribute or Value '" + theObject.getName() + "' is of type " + datatype + ", but the type must be " + obj2 + "!";
        }
        return null;
    }

    private String checkComparisonConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, String obj2, int loopNr, boolean orEqual, boolean greater) throws M4Exception {
        String constrType = null;
        constrType = greater ? (orEqual ? "GE" : "GT") : (orEqual ? "LE" : "LT");
        OpParam secondObjOpPar = (OpParam)this.getTheOperator().getOpParam(obj2);
        Double obj2D = null;
        if (secondObjOpPar == null) {
            if (obj2 != null) {
                try {
                    obj2D = new Double(obj2);
                }
                catch (NumberFormatException e) {}
            }
        } else {
            Iterator it = this.getParameter(secondObjOpPar, loopNr).iterator();
            edu.udo.cs.miningmart.m4.core.ParameterObject po = (edu.udo.cs.miningmart.m4.core.ParameterObject)it.next();
            if (!(po instanceof Value)) {
                throw new M4Exception("Step '" + this.getName() + "', Constraint " + constrType + ": Second constraint object is neither a number nor a Value parameter!");
            }
            obj2D = ((Value)po).getDouble();
        }
        if (obj2D == null) {
            return "Second argument of " + constrType + "constraint invalid: " + obj2;
        }
        double obj2d = obj2D;
        for (int i = 0; i < pArray.length; ++i) {
            edu.udo.cs.miningmart.m4.core.ParameterObject current = pArray[i];
            if (!(current instanceof Value)) {
                return "Found unsupported object of class " + current.getClass().getName() + " in first parameter of " + constrType + " constraint!";
            }
            String valueS = ((Value)current).getValue();
            Double value = null;
            if (valueS != null) {
                try {
                    value = new Double(valueS);
                }
                catch (NumberFormatException e) {
                    return "Found unsupported Value object for 'GE' or 'GT' constraint:The constraint implies a numeric value, but the value found is '" + valueS + "'!";
                }
            }
            if (!(greater ? value < obj2d || !orEqual && value <= obj2d : value > obj2d || !orEqual && value >= obj2d)) continue;
            return "Constraint " + constrType + " violated: Found parameter value " + value + "!";
        }
        return null;
    }

    private String checkSumsToOne(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray) {
        double sum = 0.0;
        String constraint = "'SUM'";
        for (int i = 0; i < pArray.length; ++i) {
            edu.udo.cs.miningmart.m4.core.ParameterObject current = pArray[i];
            if (!(current instanceof Value)) {
                return "Found unsupported object of class " + current.getClass().getName() + " in first parameter of " + constraint + " constraint!";
            }
            String valueS = ((Value)current).getValue();
            Double value = null;
            if (valueS != null) {
                try {
                    value = new Double(valueS);
                }
                catch (NumberFormatException e) {
                    return "Found unsupported Value object for " + constraint + " constraint:" + "The constraint implies a numeric value, but the value found is '" + valueS + "'!";
                }
            }
            sum += value.doubleValue();
        }
        if (sum != 1.0) {
            return "Constraint " + constraint + " violated. Sum is " + sum + " rather than 1.0 !";
        }
        return null;
    }

    private String checkArrayCoordination(edu.udo.cs.miningmart.m4.core.ParameterObject[] theArray, String nameOf1stArray, String nameOf2ndArray, int loopNum) {
        edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray2 = this.getParameter(nameOf2ndArray, loopNum);
        if (theArray.length != pArray2.length) {
            return "Constraint 'COORD' (Array coordination) is violated for parameters '" + nameOf1stArray + "' and '" + nameOf2ndArray + "' (number of entries not equal), ";
        }
        return null;
    }

    private String checkSameDataTypeConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, String obj2, int loopNum) {
        edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray2 = this.getParameter(obj2, loopNum);
        if (pArray2 == null || pArray2.length == 0 || pArray2[0] == null) {
            return "Second argument of 'SAME_TYPE' constraint missing!";
        }
        if (!(pArray[0] instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) {
            return "First argument of 'SAME_TYPE' constraint should be a BaseAttribute. Found an object of class " + pArray[0].getClass().getName() + " instead!";
        }
        if (!(pArray2[0] instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) {
            return "Second argument of 'SAME_TYPE' constraint should be a BaseAttribute. Found an object of class " + pArray2[0].getClass().getName() + " instead!";
        }
        edu.udo.cs.miningmart.m4.core.BaseAttribute firstBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)pArray[0];
        edu.udo.cs.miningmart.m4.core.BaseAttribute secondBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)pArray2[0];
        if (firstBa.getConceptualDataType() != secondBa.getConceptualDataType()) {
            return "Constraint 'SAME_TYPE' violated for BaseAttributes '" + firstBa.getName() + "' and '" + secondBa.getName() + "'!";
        }
        return null;
    }

    private edu.udo.cs.miningmart.m4.core.ParameterObject[] getParameter(String name, int loopNr) {
        try {
            ParameterArray p = this.getParameterDictionary(false).get(name, loopNr);
            if (p == null) {
                return null;
            }
            return (edu.udo.cs.miningmart.m4.core.ParameterObject[])p.getParameterObjectArray();
        }
        catch (M4Exception e) {
            this.doPrint(Print.MAX, "Warning: Exception caught when trying to fetch parameters for Step " + this.getId());
            this.doPrint(e);
            return null;
        }
    }

    public Collection getPossibleConceptsForParam(edu.udo.cs.miningmart.m4.OpParam opParam) throws M4Exception {
        Class typeOfParameter;
        if (opParam == null) {
            return null;
        }
        if (!(class$edu$udo$cs$miningmart$m4$core$Feature == null ? (class$edu$udo$cs$miningmart$m4$core$Feature = Step.class$("edu.udo.cs.miningmart.m4.core.Feature")) : class$edu$udo$cs$miningmart$m4$core$Feature).isAssignableFrom(typeOfParameter = Parameter.getClassForParameterType(opParam.getType()))) {
            throw new M4Exception("Step.getPossibleConceptsForParam: Expected a Feature parameter, but found an object of class " + typeOfParameter.getName());
        }
        String opParamName = opParam.getName();
        Iterator it = this.getTheOperator().getConstraints().iterator();
        Vector<String> inputConNames = new Vector<String>();
        String outputConName = null;
        while (it.hasNext()) {
            String obj2;
            edu.udo.cs.miningmart.m4.core.Constraint constraint = (edu.udo.cs.miningmart.m4.core.Constraint)it.next();
            if (!constraint.getType().equals("IN") || !constraint.getObj1().equalsIgnoreCase(opParamName) || (obj2 = constraint.getObj2()) == null || obj2.length() <= 0) continue;
            OpParam obj2OpPar = (OpParam)this.getTheOperator().getOpParam(obj2);
            if (obj2OpPar.isInput() && obj2OpPar.isConceptParameter()) {
                inputConNames.add(obj2);
            }
            if (obj2OpPar.isInput() || !obj2OpPar.isConceptParameter()) continue;
            outputConName = obj2;
        }
        if (outputConName != null && inputConNames.isEmpty()) {
            return null;
        }
        if (outputConName != null && !inputConNames.isEmpty()) {
            return inputConNames;
        }
        if (!inputConNames.isEmpty() && this.getOutputConcept() == null) {
            if (opParam.isInput()) {
                return inputConNames;
            }
            return null;
        }
        if (!inputConNames.isEmpty() && this.getOutputConcept() != null) {
            return inputConNames;
        }
        return null;
    }

    public Collection getPossibleInputConcepts() throws M4Exception {
        Vector<Concept> ret = new Vector<Concept>();
        Iterator it = this.getTheCase().getConcepts().iterator();
        while (it.hasNext()) {
            Concept myCon = (Concept)it.next();
            if (!myCon.getType().equals("DB")) continue;
            ret.add(myCon);
        }
        this.addOutputConceptsOfPredecessors(ret);
        ret.trimToSize();
        return ret;
    }

    private void addOutputConceptsOfPredecessors(Collection outCons) throws M4Exception {
        Iterator it = this.getAllPredecessors().iterator();
        while (it.hasNext()) {
            Step myPredStep = (Step)it.next();
            Concept anOutCon = (Concept)myPredStep.getOutputConcept();
            if (anOutCon != null && !outCons.contains(anOutCon)) {
                outCons.add(anOutCon);
            }
            myPredStep.addOutputConceptsOfPredecessors(outCons);
        }
    }

    public boolean isContainedInInputConcept(edu.udo.cs.miningmart.m4.OpParam outputFeature) throws M4Exception {
        if (outputFeature.isInput()) {
            throw new M4Exception("Step.isContainedInInputConcept: can only be called with an output parameter!");
        }
        boolean isContained = false;
        Collection applicableConstraints = outputFeature.getApplicableConstraints();
        Iterator theConstraintsIt = applicableConstraints.iterator();
        while (theConstraintsIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Constraint aConstr = (edu.udo.cs.miningmart.m4.core.Constraint)theConstraintsIt.next();
            if (!aConstr.getType().equalsIgnoreCase("IN")) continue;
            String containedIn = aConstr.getObj2();
            Parameter conceptPar = (Parameter)this.getParameterTuple(containedIn, 0);
            if (!conceptPar.getParObjectType().equalsIgnoreCase(Parameter.typeStringForTypeConst((short)1))) {
                throw new M4Exception("Step '" + this.getName() + "': found IN constraint for output BA without a Concept in object 2!");
            }
            if (!conceptPar.isInputParam()) continue;
            isContained = true;
        }
        return isContained;
    }

    public ParamDict getParameterDictionary(boolean expectingAllParamsToExist) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParamDict pd = new edu.udo.cs.miningmart.m4.core.ParamDict();
        Iterator it = this.getTheOperator().getOpParamsIterator();
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.ParameterArray obj;
            int loops;
            Parameter aParam;
            Iterator it2;
            edu.udo.cs.miningmart.m4.core.ParameterArray additionalParArr;
            int loopNr;
            OpParam op = (OpParam)it.next();
            String paramMissingMsg = "Parameter '" + op.getName() + "' missing in Step '" + this.getName() + "'!";
            if (op.getMinArg() == 0) {
                try {
                    edu.udo.cs.miningmart.m4.core.ParameterArray withoutLoop = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, 0);
                    if (withoutLoop != null && (withoutLoop.size() > 0 || this.getLoopCount() <= 0)) {
                        pd.put(op.getName(), withoutLoop);
                        continue;
                    }
                    if (op.isCoordinated()) {
                        loopNr = 1;
                        edu.udo.cs.miningmart.m4.core.ParameterArray myPar = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, loopNr);
                        if (myPar == null) continue;
                        additionalParArr = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, ++loopNr);
                        while (additionalParArr != null) {
                            it2 = additionalParArr.getParameters().iterator();
                            while (it2.hasNext()) {
                                aParam = (Parameter)it2.next();
                                myPar.addParameter(aParam);
                            }
                            additionalParArr = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, ++loopNr);
                        }
                        pd.put(op.getName(), 0, myPar);
                        continue;
                    }
                    loops = this.getLoopCount() + 1;
                    for (int i = 1; i < loops; ++i) {
                        obj = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, i);
                        if (obj == null) continue;
                        pd.put(op.getName(), i, obj);
                    }
                    continue;
                }
                catch (ParameterNotFoundException e) {
                    throw new M4Exception("Internal error.'ParameterNotFound' exception was thrown for an optional parameter:\n" + e.getMessage());
                }
            }
            try {
                edu.udo.cs.miningmart.m4.core.ParameterArray obj2 = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, 0);
                if (obj2 == null) {
                    throw new ParameterNotFoundException(paramMissingMsg);
                }
                pd.put(op.getName(), obj2);
            }
            catch (ParameterNotFoundException e) {
                if (op.isCoordinated()) {
                    loopNr = 1;
                    edu.udo.cs.miningmart.m4.core.ParameterArray myPar = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, loopNr);
                    if (myPar == null) {
                        if (!expectingAllParamsToExist) continue;
                        throw new ParameterNotFoundException(paramMissingMsg);
                    }
                    additionalParArr = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, ++loopNr);
                    while (additionalParArr != null) {
                        it2 = additionalParArr.getParameters().iterator();
                        while (it2.hasNext()) {
                            aParam = (Parameter)it2.next();
                            myPar.addParameter(aParam);
                        }
                        additionalParArr = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, ++loopNr);
                    }
                    pd.put(op.getName(), 0, myPar);
                    continue;
                }
                if (this.getLoopCount() > 0) {
                    loops = this.getLoopCount() + 1;
                    try {
                        for (int i = 1; i < loops; ++i) {
                            obj = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, i);
                            if (obj == null) {
                                throw new ParameterNotFoundException(paramMissingMsg);
                            }
                            pd.put(op.getName(), i, obj);
                        }
                        continue;
                    }
                    catch (ParameterNotFoundException pnfe) {
                        if (!expectingAllParamsToExist) continue;
                        throw pnfe;
                    }
                }
                if (!expectingAllParamsToExist) continue;
                throw e;
            }
        }
        return pd;
    }

    public boolean isVisible(Feature theFeature) throws M4Exception {
        edu.udo.cs.miningmart.m4.Parameter featureOutputParam;
        if (theFeature instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute) {
            if (((edu.udo.cs.miningmart.m4.core.BaseAttribute)theFeature).isDBAttrib()) {
                return true;
            }
        } else {
            boolean allBAsAreDB = true;
            MultiColumnFeature mcf = (MultiColumnFeature)theFeature;
            Iterator it = mcf.getBaseAttributes().iterator();
            if (!it.hasNext()) {
                throw new M4Exception("Step.isVisible(Feature): found MCF '" + mcf.getName() + "'without BAs!");
            }
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute ba = (edu.udo.cs.miningmart.m4.core.BaseAttribute)it.next();
                if (ba.isDBAttrib()) continue;
                allBAsAreDB = false;
            }
            if (allBAsAreDB) {
                return true;
            }
        }
        if ((featureOutputParam = theFeature.getParameterWhereThisIsOutputFeature()) == null) {
            return true;
        }
        Collection predSteps = this.getTheCase().getStepsToCompileBefore(this, true);
        if (predSteps == null) {
            throw new M4Exception("Step.isVisible(Feature): got <null> Collection when asking for predecessors!");
        }
        Iterator stepIterator = predSteps.iterator();
        while (stepIterator.hasNext()) {
            Step myPrecedingStep = (Step)stepIterator.next();
            if (!myPrecedingStep.getParameterTuples().contains(featureOutputParam)) continue;
            return true;
        }
        return false;
    }

    public boolean usesLoopsForCoordination() throws M4Exception {
        Iterator it = this.getTheOperator().getOpParamsIterator();
        while (it.hasNext()) {
            OpParam anOpPar = (OpParam)it.next();
            if (!anOpPar.isCoordinated()) continue;
            return true;
        }
        return false;
    }

    public void createOutput(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theNames) throws M4Exception {
        boolean create = true;
        if (theNames == null || theNames.isEmpty()) {
            return;
        }
        this.workOnOutput(theOpParam, theNames, create);
    }

    private void workOnOutput(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theNames, boolean create) throws M4Exception {
        if (theOpParam != null && theOpParam.isInput()) {
            throw new M4Exception("Step.create/updateOutput: got an input operator parameter!");
        }
        if (theOpParam != null && theNames != null && create) {
            int startLoop;
            int endLoop = this.getHighestLoopNr(theOpParam);
            for (int l = startLoop = theOpParam.isCoordinated() || theOpParam.isLoopable() && this.getLoopCount() > 0 ? 1 : 0; l <= endLoop; ++l) {
                Collection c = this.getParameter(theOpParam, l);
                if (c == null) continue;
                Iterator parIt = c.iterator();
                while (parIt.hasNext()) {
                    edu.udo.cs.miningmart.m4.core.ParameterObject myParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)parIt.next();
                    myParObj.deleteSoon();
                }
                this.setParameter(theOpParam, new Vector(), l);
            }
        }
        Collection applicableConstraints = new Vector();
        if (theOpParam != null && (applicableConstraints = theOpParam.getApplicableConstraints()).isEmpty() && !this.getTheOperator().getName().equals("SpecifiedStatistics") && !this.getTheOperator().getName().equals("SegmentationStratified") && !this.getTheOperator().getName().equals("Unsegment") & !this.getTheOperator().getName().equals("ReversePivotize")) {
            throw new M4Exception("Step '" + this.getName() + "': the operator does not specify the output parameters (missing constraints on output parameters)!");
        }
        Collection outputFeatureOpParams = null;
        HashMap oldNames = null;
        if (!create) {
            outputFeatureOpParams = this.getOutputFeatureOpParams();
            oldNames = this.storeNamesOfOpParams(outputFeatureOpParams);
        }
        if (theOpParam == null || theOpParam.isConceptParameter()) {
            if (create && (theNames == null || theNames.size() != 1)) {
                throw new M4Exception("Step '" + this.getName() + "': found 0 or several names for output concept, but need exactly one!");
            }
            String theName = null;
            try {
                theName = create ? (String)theNames.iterator().next() : null;
            }
            catch (ClassCastException cce) {
                Collection c = (Collection)theNames.iterator().next();
                theName = (String)c.iterator().next();
            }
            if (theOpParam == null) {
                Iterator it = this.getTheOperator().getAllOutputOperatorParameters().iterator();
                while (it.hasNext()) {
                    OpParam anOutputOpPar = (OpParam)it.next();
                    if (!anOutputOpPar.isConceptParameter()) continue;
                    applicableConstraints.addAll(anOutputOpPar.getApplicableConstraints());
                }
            }
            this.workOnOutputConcept(applicableConstraints, theName, create);
        }
        if (theOpParam == null || theOpParam.isBaseAttribParameter() || theOpParam.isFeatureParameter()) {
            if (theOpParam == null) {
                Iterator it = this.getTheOperator().getAllOutputOperatorParameters().iterator();
                while (it.hasNext()) {
                    OpParam anOutputOpPar = (OpParam)it.next();
                    if (!anOutputOpPar.isBaseAttribParameter() && !anOutputOpPar.isFeatureParameter()) continue;
                    applicableConstraints.addAll(anOutputOpPar.getApplicableConstraints());
                }
            }
            int startLoopNr = 0;
            int endLoopNr = 0;
            if (this.getLoopCount() > 0) {
                startLoopNr = 1;
                endLoopNr = this.getLoopCount();
            }
            if (theOpParam != null && theOpParam.isCoordinated()) {
                startLoopNr = 1;
                endLoopNr = theNames != null ? theNames.size() : this.getHighestLoopNr(theOpParam);
            }
            for (int loopNr = startLoopNr; loopNr <= endLoopNr; ++loopNr) {
                if (create) {
                    Collection namesForLoop = this.getNamesForThisLoop(theOpParam, theNames, startLoopNr, loopNr);
                    this.workOnOutputBAs(applicableConstraints, theOpParam, namesForLoop, loopNr, create);
                    continue;
                }
                Iterator it = outputFeatureOpParams.iterator();
                while (it.hasNext()) {
                    Collection names;
                    OpParam myOutputFeatureOpPar = (OpParam)it.next();
                    if (theOpParam == null && myOutputFeatureOpPar.isCoordinated()) {
                        names = (Collection)oldNames.get(myOutputFeatureOpPar);
                        int newStartLoopNr = 1;
                        int newEndLoopNr = 1;
                        newEndLoopNr = names != null ? names.size() : this.getHighestLoopNr(myOutputFeatureOpPar);
                        Vector nameArray = new Vector(names);
                        for (int l = newStartLoopNr; l <= newEndLoopNr; ++l) {
                            Vector v = new Vector();
                            v.add(nameArray.get(l - 1));
                            this.workOnOutputBAs(applicableConstraints, myOutputFeatureOpPar, v, l, create);
                        }
                        continue;
                    }
                    names = (Collection)oldNames.get(myOutputFeatureOpPar);
                    this.workOnOutputBAs(applicableConstraints, myOutputFeatureOpPar, names, loopNr, create);
                }
            }
        }
        Iterator succIt = this.getSuccessors().iterator();
        while (succIt.hasNext()) {
            Step succStep = (Step)succIt.next();
            succStep.workOnOutput(null, null, false);
        }
    }

    private Collection getOutputFeatureOpParams() throws M4Exception {
        Iterator it = this.getTheOperator().getAllOutputOperatorParameters().iterator();
        Vector<OpParam> ret = new Vector<OpParam>();
        while (it.hasNext()) {
            OpParam outputOpPar = (OpParam)it.next();
            if (!outputOpPar.isBaseAttribParameter() && !outputOpPar.isFeatureParameter()) continue;
            ret.add(outputOpPar);
        }
        return ret;
    }

    private Collection getNamesForThisLoop(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theNames, int startLoopNr, int loopNr) throws M4Exception {
        if (theOpParam != null && (theOpParam.isLoopable() || theOpParam.isCoordinated())) {
            Iterator it = theNames.iterator();
            int counter = startLoopNr;
            while (it.hasNext()) {
                Collection namesForOneLoop = (Collection)it.next();
                if (counter == loopNr) {
                    return namesForOneLoop;
                }
                ++counter;
            }
            throw new M4Exception("Step.create/updateOutput: method getNamesForThisLoop could not find the names for loop number " + loopNr + "!");
        }
        return theNames;
    }

    private HashMap storeNamesOfOpParams(Collection opParams) throws M4Exception {
        Iterator it = opParams.iterator();
        HashMap theMap = new HashMap();
        while (it.hasNext()) {
            OpParam outputOpPar = (OpParam)it.next();
            Vector<String> theNames = new Vector<String>();
            Collection params = this.getParameterTuples(outputOpPar);
            Iterator tupleIt = params.iterator();
            while (tupleIt.hasNext()) {
                Parameter myPar = (Parameter)tupleIt.next();
                edu.udo.cs.miningmart.m4.core.ParameterObject myParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)myPar.getTheParameterObject();
                if (myParObj == null) {
                    throw new M4Exception("An object that was used as parameter '" + myPar.getName() + "' of Step '" + this.getName() + "' has been deleted! This Step is invalid now. No propagation of changes to following Steps is done.");
                }
                theNames.add(myParObj.getName());
            }
            theMap.put(outputOpPar, theNames);
        }
        return theMap;
    }

    private void workOnOutputConcept(Collection theConstraints, String theName, boolean create) throws M4Exception {
        boolean outputConceptWasCreated = false;
        OpParam theOutputConceptOpParam = (OpParam)this.getTheOperator().getOpParam("TheOutputConcept");
        if (!this.workOnOutputConceptForSpecialOperators(theName, theOutputConceptOpParam, create)) {
            Iterator theConstraintsIt = theConstraints.iterator();
            while (theConstraintsIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Constraint aConstr = (edu.udo.cs.miningmart.m4.core.Constraint)theConstraintsIt.next();
                if (aConstr.getType().equalsIgnoreCase("SAME_FEAT") && aConstr.getObj1().equalsIgnoreCase("TheOutputConcept") && aConstr.getObj2().equalsIgnoreCase("TheInputConcept")) {
                    if (create && !outputConceptWasCreated) {
                        this.createEmptyOutputConceptForThisStep(theName, theOutputConceptOpParam);
                        outputConceptWasCreated = true;
                    }
                    Concept outputConcept = this.checkConceptExists(theOutputConceptOpParam);
                    String nameOfSecondConstraintObject = aConstr.getObj2();
                    OpParam inputConcOpPar = (OpParam)this.getTheOperator().getOpParam(nameOfSecondConstraintObject);
                    Concept inputConcept = this.checkConceptExists(inputConcOpPar);
                    this.setFeaturesIntoConcept(inputConcept.getFeatures(), outputConcept);
                }
                if (aConstr.getType().equalsIgnoreCase("IN") && aConstr.getObj1().equalsIgnoreCase("TheOutputConcept") && aConstr.getObj2().equalsIgnoreCase("TheInputConcept")) {
                    if (create && !outputConceptWasCreated) {
                        this.createEmptyOutputConceptForThisStep(theName, theOutputConceptOpParam);
                        outputConceptWasCreated = true;
                    }
                    this.checkConceptExists(theOutputConceptOpParam);
                }
                if (!aConstr.getType().equalsIgnoreCase("IN") || !aConstr.getObj2().equalsIgnoreCase("TheOutputConcept")) continue;
                Collection theInputOpPars = this.getTheOperator().getAllInputOperatorParameters();
                Iterator it = theInputOpPars.iterator();
                boolean found = false;
                OpParam inputOpPar = null;
                while (!found && it.hasNext()) {
                    inputOpPar = (OpParam)it.next();
                    if (!inputOpPar.getName().equalsIgnoreCase(aConstr.getObj1())) continue;
                    found = true;
                }
                if (create && !outputConceptWasCreated) {
                    this.createEmptyOutputConceptForThisStep(theName, theOutputConceptOpParam);
                    outputConceptWasCreated = true;
                }
                Concept outputConcept = this.checkConceptExists(theOutputConceptOpParam);
                if (!found) continue;
                Collection theInputFeaturesForOutputConcept = this.getParameter(inputOpPar, 0);
                if ((theInputFeaturesForOutputConcept = this.checkExistenceOfInputFeatures(theInputFeaturesForOutputConcept)) == null || theInputFeaturesForOutputConcept.isEmpty()) {
                    throw new M4Exception("Step '" + this.getName() + "': could not determine any BaseAttribute for the output concept!");
                }
                this.setFeaturesIntoConcept(theInputFeaturesForOutputConcept, outputConcept);
            }
        }
        if (create) {
            Iterator assIt = this.getTheOperator().getAssertions().iterator();
            while (assIt.hasNext()) {
                int i;
                Assertion myAss = (Assertion)assIt.next();
                if (myAss.getAssertionType().equals("PROJ")) {
                    String fromConceptParName = myAss.getObj2();
                    String toConceptParName = myAss.getObj1();
                    edu.udo.cs.miningmart.m4.core.ParameterObject[] fromConcepts = this.getParameter(fromConceptParName, 0);
                    edu.udo.cs.miningmart.m4.core.ParameterObject[] toConcepts = this.getParameter(toConceptParName, 0);
                    for (i = 0; i < fromConcepts.length; ++i) {
                        for (int j = 0; j < toConcepts.length; ++j) {
                            String projName = null;
                            ((Concept)fromConcepts[i]).createProjectionToConcept((Concept)toConcepts[j], projName);
                        }
                    }
                }
                if (!myAss.getAssertionType().equals("SUBSET")) continue;
                String subConceptParName = myAss.getObj1();
                String superConceptParName = myAss.getObj2();
                edu.udo.cs.miningmart.m4.core.ParameterObject[] subConcepts = this.getParameter(subConceptParName, 0);
                edu.udo.cs.miningmart.m4.core.ParameterObject[] superConcepts = this.getParameter(superConceptParName, 0);
                for (i = 0; i < subConcepts.length; ++i) {
                    for (int j = 0; j < superConcepts.length; ++j) {
                        ((Concept)subConcepts[i]).addSuperConcept((Concept)superConcepts[j]);
                    }
                }
            }
            edu.udo.cs.miningmart.m4.core.BaseAttribute[][] allKeys = this.getKeysOfRelationshipAssertion();
            if (allKeys != null) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute[] manyKeys = allKeys[0];
                edu.udo.cs.miningmart.m4.core.BaseAttribute[] oneKeys = allKeys[1];
                if (oneKeys != null && manyKeys != null && oneKeys.length > 0 && manyKeys.length > 0) {
                    Concept fromConcept = (Concept)manyKeys[0].getConcept();
                    Concept toConcept = (Concept)oneKeys[0].getConcept();
                    String nameForRel = fromConcept.getName() + "_" + toConcept.getName() + "_REL";
                    Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute> mk = new Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute>();
                    Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute> ok = new Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute>();
                    for (int i = 0; i < oneKeys.length; ++i) {
                        mk.add(manyKeys[i]);
                        ok.add(oneKeys[i]);
                    }
                    this.getTheCase().createOneToManyRelation(nameForRel, mk, ok);
                }
            }
        }
    }

    public edu.udo.cs.miningmart.m4.core.BaseAttribute[][] getKeysOfRelationshipAssertion() throws M4Exception {
        Iterator assIt = this.getTheOperator().getAssertions().iterator();
        Concept manyConcept = null;
        Concept oneConcept = null;
        edu.udo.cs.miningmart.m4.core.BaseAttribute[] manyKeys = null;
        edu.udo.cs.miningmart.m4.core.BaseAttribute[] oneKeys = null;
        while (assIt.hasNext()) {
            String oneKeysParName;
            edu.udo.cs.miningmart.m4.core.ParameterObject[] ones;
            String manyKeysParName;
            edu.udo.cs.miningmart.m4.core.ParameterObject[] manys;
            Assertion myAss = (Assertion)assIt.next();
            boolean manyToOne = false;
            manyToOne = myAss.getAssertionType().equals("REL_N_1");
            if (manyToOne || myAss.getAssertionType().equals("REL_1_N")) {
                String manyConceptParName = manyToOne ? myAss.getObj1() : myAss.getObj2();
                String oneConceptParName = manyToOne ? myAss.getObj2() : myAss.getObj1();
                edu.udo.cs.miningmart.m4.core.ParameterObject[] manyConcepts = this.getParameter(manyConceptParName, 0);
                edu.udo.cs.miningmart.m4.core.ParameterObject[] oneConcepts = this.getParameter(oneConceptParName, 0);
                if (manyConcepts != null && manyConcepts.length > 0) {
                    manyConcept = (Concept)manyConcepts[0];
                }
                if (oneConcepts != null && oneConcepts.length > 0) {
                    oneConcept = (Concept)oneConcepts[0];
                }
            }
            if (myAss.getAssertionType().equals("REL_N_K") && (manys = this.getParameter(manyKeysParName = myAss.getObj1(), 0)) != null && manys.length > 0) {
                manyKeys = new edu.udo.cs.miningmart.m4.core.BaseAttribute[manys.length];
                for (int i = 0; i < manys.length; ++i) {
                    manyKeys[i] = (edu.udo.cs.miningmart.m4.core.BaseAttribute)manys[i];
                }
            }
            if (!myAss.getAssertionType().equals("REL_1_K") || (ones = this.getParameter(oneKeysParName = myAss.getObj1(), 0)) == null || ones.length <= 0) continue;
            oneKeys = new edu.udo.cs.miningmart.m4.core.BaseAttribute[ones.length];
            for (int i = 0; i < ones.length; ++i) {
                oneKeys[i] = (edu.udo.cs.miningmart.m4.core.BaseAttribute)ones[i];
            }
        }
        if (manyConcept != null && oneConcept != null && manyKeys != null && oneKeys != null) {
            if (this.attribsBelongToConcept(manyKeys, oneConcept)) {
                manyKeys = this.getCorrespondingAttribs(manyKeys, manyConcept);
            }
            if (this.attribsBelongToConcept(oneKeys, manyConcept)) {
                oneKeys = this.getCorrespondingAttribs(oneKeys, oneConcept);
            }
            if (manyKeys.length != oneKeys.length) {
                throw new M4Exception("Step '" + this.getName() + "': found nonmatching number of keys for relationship between input and output!");
            }
            edu.udo.cs.miningmart.m4.core.BaseAttribute[][] ret = new edu.udo.cs.miningmart.m4.core.BaseAttribute[][]{manyKeys, oneKeys};
            return ret;
        }
        return null;
    }

    private edu.udo.cs.miningmart.m4.core.BaseAttribute[] getCorrespondingAttribs(edu.udo.cs.miningmart.m4.core.BaseAttribute[] theAttribs, Concept theConcept) throws M4Exception {
        if (this.attribsBelongToConcept(theAttribs, theConcept)) {
            return theAttribs;
        }
        if (theAttribs != null) {
            edu.udo.cs.miningmart.m4.core.BaseAttribute[] correspondents = new edu.udo.cs.miningmart.m4.core.BaseAttribute[theAttribs.length];
            for (int i = 0; i < theAttribs.length; ++i) {
                correspondents[i] = (edu.udo.cs.miningmart.m4.core.BaseAttribute)theConcept.getBaseAttribute(theAttribs[i].getName());
                if (correspondents[i] != null) continue;
                return null;
            }
            return correspondents;
        }
        return null;
    }

    private boolean attribsBelongToConcept(edu.udo.cs.miningmart.m4.core.BaseAttribute[] theAttribs, Concept theConcept) throws M4Exception {
        if (theAttribs != null && theConcept != null) {
            for (int i = 0; i < theAttribs.length; ++i) {
                if (theAttribs[i].getConcept().equals(theConcept)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean workOnOutputConceptForSpecialOperators(String theName, edu.udo.cs.miningmart.m4.OpParam outOpPar, boolean create) throws M4Exception {
        String name = this.getTheOperator().getName();
        if (name.equalsIgnoreCase("JoinByKey") || name.equalsIgnoreCase("UnionByKey")) {
            edu.udo.cs.miningmart.m4.core.ParameterObject[] po;
            if (create) {
                this.createEmptyOutputConceptForThisStep(theName, outOpPar);
            }
            if ((po = this.getParameter(outOpPar.getName(), 0)) == null) {
                throw new M4Exception("Step '" + this.getName() + "': could not find output concept!");
            }
            Concept outputConcept = (Concept)po[0];
            if (!create) {
                outputConcept.removeAllFeatures();
            }
            edu.udo.cs.miningmart.m4.core.ParameterObject[] myInConcepts = this.getParameter("TheConcepts", 0);
            edu.udo.cs.miningmart.m4.core.ParameterObject[] myKeys = this.getParameter("TheKeys", 0);
            edu.udo.cs.miningmart.m4.core.ParameterObject[] myMappedInputs = this.getParameter("MapInput", 0);
            if (myInConcepts == null || myKeys == null) {
                throw new M4Exception("Step '" + this.getName() + "': could not read input parameters for output creation!");
            }
            boolean keyDealtWith = false;
            for (int i = 0; i < myInConcepts.length; ++i) {
                Concept inCon = (Concept)myInConcepts[i];
                Iterator fIt = inCon.getFeatures().iterator();
                while (fIt.hasNext()) {
                    edu.udo.cs.miningmart.m4.core.Feature myF = (edu.udo.cs.miningmart.m4.core.Feature)fIt.next();
                    if (!this.isVisible(myF)) continue;
                    for (int j = 0; j < myKeys.length; ++j) {
                        if (!myF.equals(myKeys[j])) continue;
                        if (!keyDealtWith) {
                            keyDealtWith = true;
                            continue;
                        }
                        myF = null;
                        break;
                    }
                    if (myF == null) continue;
                    Vector<String> nameCollection = new Vector<String>();
                    String nameOfFeatureInOutput = myF.getName();
                    if (myMappedInputs != null) {
                        for (int j = 0; j < myMappedInputs.length; ++j) {
                            edu.udo.cs.miningmart.m4.core.Feature mapped = (edu.udo.cs.miningmart.m4.core.Feature)myMappedInputs[j];
                            if (!myF.equals(mapped)) continue;
                            nameOfFeatureInOutput = nameOfFeatureInOutput + specialNameMarker + (j + 1);
                            break;
                        }
                    }
                    nameCollection.add(nameOfFeatureInOutput);
                    String conDt = "NOMINAL";
                    if (myF instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute) {
                        conDt = ((edu.udo.cs.miningmart.m4.core.BaseAttribute)myF).getConceptualDataTypeName();
                    }
                    String[] types = new String[]{conDt};
                    this.createBAsInConcept(nameCollection, types, outputConcept);
                }
            }
            return true;
        }
        if (name.equalsIgnoreCase("SpecifiedStatistics")) {
            edu.udo.cs.miningmart.m4.core.ParameterObject[] po;
            if (create) {
                this.createEmptyOutputConceptForThisStep(theName, outOpPar);
            }
            if ((po = this.getParameter(outOpPar.getName(), 0)) == null) {
                throw new M4Exception("Step '" + this.getName() + "': could not find output concept!");
            }
            Concept outputConcept = (Concept)po[0];
            if (!create) {
                edu.udo.cs.miningmart.m4.core.Feature myF;
                Iterator featureIt = outputConcept.getFeatures().iterator();
                Vector<edu.udo.cs.miningmart.m4.core.Feature> featuresToDelete = new Vector<edu.udo.cs.miningmart.m4.core.Feature>();
                while (featureIt.hasNext()) {
                    myF = (edu.udo.cs.miningmart.m4.core.Feature)featureIt.next();
                    if (!myF.getParameterReferences().isEmpty()) continue;
                    featuresToDelete.add(myF);
                }
                featureIt = featuresToDelete.iterator();
                while (featureIt.hasNext()) {
                    myF = (edu.udo.cs.miningmart.m4.core.Feature)featureIt.next();
                    outputConcept.removeFeature(myF);
                }
            }
            Concept inputConcept = (Concept)this.getInputConceptsThatAreParameters().iterator().next();
            String[] outputAttrParameterNames = new String[]{"AttributesComputeAvg", "AttributesComputeCount", "GroupBy", "AttributesComputeMax", "AttributesComputeMin", "AttributesComputeSum", "AttributesComputeUnique"};
            for (int n = 0; n < outputAttrParameterNames.length; ++n) {
                Vector<String> names = new Vector<String>();
                edu.udo.cs.miningmart.m4.core.ParameterObject[] attrs = this.getParameter(outputAttrParameterNames[n], 0);
                if (attrs == null) continue;
                String[] types = new String[attrs.length];
                for (int i = 0; i < attrs.length; ++i) {
                    String inputFeatName = attrs[i].getName();
                    edu.udo.cs.miningmart.m4.core.BaseAttribute inputBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)inputConcept.getBaseAttribute(inputFeatName);
                    String outputFeatName = this.getSpecStatOutAttrSuffix(outputAttrParameterNames[n], inputFeatName);
                    names.add(outputFeatName);
                    types[i] = outputAttrParameterNames[n].equals("GroupBy") ? inputBa.getConceptualDataTypeName() : "NUMERIC";
                }
                if (names.size() <= 0) continue;
                this.createBAsInConcept(names, types, outputConcept);
            }
            edu.udo.cs.miningmart.m4.core.ParameterObject[] distrAttrs = this.getParameter("AttributesComputeDistrib", 0);
            if (distrAttrs != null && distrAttrs.length > 0) {
                edu.udo.cs.miningmart.m4.core.ParameterObject[] distrVals = this.getParameter("DistribValues", 0);
                if (distrVals == null || distrVals.length != distrAttrs.length) {
                    throw new M4Exception("Step '" + this.getName() + "': number of values for parameters '" + "AttributesComputeDistrib" + "' and '" + "DistribValues" + "' is not equal!");
                }
                Vector<String> names = new Vector<String>();
                for (int i = 0; i < distrAttrs.length; ++i) {
                    String inputAttrName = distrAttrs[i].getName();
                    String valuesOfInputAttr = ((Value)distrVals[i]).getValue();
                    StringTokenizer st = new StringTokenizer(valuesOfInputAttr, ",");
                    while (st.hasMoreTokens()) {
                        String oneValueOfAttr = st.nextToken().trim();
                        String outputFeatName = inputAttrName + "_" + oneValueOfAttr;
                        names.add(outputFeatName);
                    }
                }
                String[] types = new String[names.size()];
                for (int i = 0; i < types.length; ++i) {
                    types[i] = "NUMERIC";
                }
                this.createBAsInConcept(names, types, outputConcept);
            }
            return true;
        }
        if (name.equalsIgnoreCase("Pivotize")) {
            edu.udo.cs.miningmart.m4.core.BaseAttribute[] groupByBAs;
            edu.udo.cs.miningmart.m4.core.BaseAttribute pivotAttribute;
            BaseAttribute[] indexAttributes;
            String[] indexValues;
            edu.udo.cs.miningmart.m4.core.ParameterObject[] po;
            if (create) {
                this.createEmptyOutputConceptForThisStep(theName, outOpPar);
            }
            if ((po = this.getParameter(outOpPar.getName(), 0)) == null) {
                throw new M4Exception("Step '" + this.getName() + "': could not find output concept!");
            }
            Concept outputConcept = (Concept)po[0];
            if (!create) {
                edu.udo.cs.miningmart.m4.core.Feature myF;
                Iterator featureIt = outputConcept.getFeatures().iterator();
                Vector<edu.udo.cs.miningmart.m4.core.Feature> featuresToDelete = new Vector<edu.udo.cs.miningmart.m4.core.Feature>();
                while (featureIt.hasNext()) {
                    myF = (edu.udo.cs.miningmart.m4.core.Feature)featureIt.next();
                    if (!myF.getParameterReferences().isEmpty()) continue;
                    featuresToDelete.add(myF);
                }
                featureIt = featuresToDelete.iterator();
                while (featureIt.hasNext()) {
                    myF = (edu.udo.cs.miningmart.m4.core.Feature)featureIt.next();
                    outputConcept.removeFeature(myF);
                }
            }
            edu.udo.cs.miningmart.m4.core.ParameterObject[] indexAttrs = this.getParameter("TheIndexAttributes", 0);
            edu.udo.cs.miningmart.m4.core.ParameterObject[] indexVals = this.getParameter("IndexValues", 0);
            edu.udo.cs.miningmart.m4.core.ParameterObject[] pivot = this.getParameter("ThePivotAttribute", 0);
            try {
                Value[] someVals = (Value[])indexVals;
                indexValues = new String[someVals.length];
                for (int i = 0; i < someVals.length; ++i) {
                    indexValues[i] = someVals[i].getValue();
                }
                indexAttributes = (edu.udo.cs.miningmart.m4.core.BaseAttribute[])indexAttrs;
                pivotAttribute = (edu.udo.cs.miningmart.m4.core.BaseAttribute)pivot[0];
            }
            catch (ClassCastException cce) {
                throw new M4Exception("Step '" + this.getName() + "': Could not cast parameter(s) to expected type!");
            }
            Collection theCombis = Pivotize.getCombinations(indexValues, indexAttributes, pivotAttribute);
            if (theCombis == null || theCombis.isEmpty()) {
                throw new M4Exception("Step '" + this.getName() + "': Could not compute combinations of index values!");
            }
            edu.udo.cs.miningmart.m4.core.ParameterObject[] groupBy = this.getParameter("TheGroupByAttributes", 0);
            if (groupBy != null) {
                groupByBAs = new edu.udo.cs.miningmart.m4.core.BaseAttribute[groupBy.length];
                for (int i = 0; i < groupBy.length; ++i) {
                    groupByBAs[i] = (edu.udo.cs.miningmart.m4.core.BaseAttribute)groupBy[i];
                }
            } else {
                groupByBAs = new edu.udo.cs.miningmart.m4.core.BaseAttribute[]{};
            }
            Iterator it = theCombis.iterator();
            String[] types = new String[theCombis.size() + groupByBAs.length];
            int i = 0;
            Vector<String> names = new Vector<String>();
            while (it.hasNext()) {
                Pivotize.AttributeValueCombination avc = (Pivotize.AttributeValueCombination)it.next();
                names.add(avc.getOutputBaName());
                types[i] = "NUMERIC";
                ++i;
            }
            for (int j = i; j < i + groupByBAs.length; ++j) {
                names.add(groupByBAs[j - i].getName());
                types[j] = groupByBAs[j - i].getConceptualDataTypeName();
            }
            if (names.size() > 0) {
                this.createBAsInConcept(names, types, outputConcept);
            }
            return true;
        }
        if (name.equalsIgnoreCase("ReversePivotize")) {
            int i;
            edu.udo.cs.miningmart.m4.core.ParameterObject[] po;
            if (create) {
                this.createEmptyOutputConceptForThisStep(theName, outOpPar);
            }
            if ((po = this.getParameter(outOpPar.getName(), 0)) == null) {
                throw new M4Exception("Step '" + this.getName() + "': could not find output concept!");
            }
            Concept outputConcept = (Concept)po[0];
            if (!create) {
                edu.udo.cs.miningmart.m4.core.Feature myF;
                Iterator featureIt = outputConcept.getFeatures().iterator();
                Vector<edu.udo.cs.miningmart.m4.core.Feature> featuresToDelete = new Vector<edu.udo.cs.miningmart.m4.core.Feature>();
                while (featureIt.hasNext()) {
                    myF = (edu.udo.cs.miningmart.m4.core.Feature)featureIt.next();
                    if (!myF.getParameterReferences().isEmpty()) continue;
                    featuresToDelete.add(myF);
                }
                featureIt = featuresToDelete.iterator();
                while (featureIt.hasNext()) {
                    myF = (edu.udo.cs.miningmart.m4.core.Feature)featureIt.next();
                    outputConcept.removeFeature(myF);
                }
            }
            BaseAttribute[] pivotAttrs = (edu.udo.cs.miningmart.m4.core.BaseAttribute[])this.getParameter("ThePivotizedAttributes", 0);
            Concept inCon = (Concept)this.getAllInputConcepts().iterator().next();
            Iterator inFeatIt = inCon.getAllBaseAttributes().iterator();
            Vector<String> names = new Vector<String>();
            Vector<String> baTypes = new Vector<String>();
            while (inFeatIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute inBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)inFeatIt.next();
                if (this.nameOccursIn(inBa, (edu.udo.cs.miningmart.m4.core.BaseAttribute[])pivotAttrs)) continue;
                names.add(inBa.getName());
                baTypes.add(inBa.getConceptualDataTypeName());
            }
            String nameOfPivot = ((Value[])this.getParameter("NameForPivotAttribute", 0))[0].getValue();
            Value[] indexAttrs = (Value[])this.getParameter("NamesForIndexAttributes", 0);
            Value[] indexVals = (Value[])this.getParameter("IndexValues", 0);
            String[] indexValues = new String[indexVals.length];
            for (int i2 = 0; i2 < indexVals.length; ++i2) {
                indexValues[i2] = indexVals[i2].getValue();
            }
            String[] namesOfIndexAttrs = new String[indexAttrs.length];
            for (i = 0; i < indexAttrs.length; ++i) {
                namesOfIndexAttrs[i] = indexAttrs[i].getValue();
            }
            names.add(nameOfPivot);
            baTypes.add(ReversePivotize.getConDataTypeOfPivotAttr(pivotAttrs));
            for (i = 0; i < namesOfIndexAttrs.length; ++i) {
                names.add(namesOfIndexAttrs[i]);
                baTypes.add(ReversePivotize.getConDataTypeOfIndexAttr(namesOfIndexAttrs[i], indexValues, namesOfIndexAttrs));
            }
            String[] types = new String[baTypes.size()];
            for (int i3 = 0; i3 < types.length; ++i3) {
                types[i3] = (String)baTypes.get(i3);
            }
            if (names.size() > 0) {
                this.createBAsInConcept(names, types, outputConcept);
            }
            return true;
        }
        if (name.startsWith("Segmentation") || name.equals("Unsegment")) {
            edu.udo.cs.miningmart.m4.core.ParameterObject[] po;
            if (create) {
                this.createEmptyOutputConceptForThisStep(theName, outOpPar);
            }
            if ((po = this.getParameter(outOpPar.getName(), 0)) == null) {
                throw new M4Exception("Step '" + this.getName() + "': could not find output concept!");
            }
            Concept outputConcept = (Concept)po[0];
            if (!create) {
                edu.udo.cs.miningmart.m4.core.Feature myF;
                Iterator featureIt = outputConcept.getFeatures().iterator();
                Vector<edu.udo.cs.miningmart.m4.core.Feature> featuresToDelete = new Vector<edu.udo.cs.miningmart.m4.core.Feature>();
                while (featureIt.hasNext()) {
                    myF = (edu.udo.cs.miningmart.m4.core.Feature)featureIt.next();
                    if (!myF.getParameterReferences().isEmpty()) continue;
                    featuresToDelete.add(myF);
                }
                featureIt = featuresToDelete.iterator();
                while (featureIt.hasNext()) {
                    myF = (edu.udo.cs.miningmart.m4.core.Feature)featureIt.next();
                    outputConcept.removeFeature(myF);
                }
            }
            edu.udo.cs.miningmart.m4.core.BaseAttribute targetAttr = null;
            if (name.equals("SegmentationStratified")) {
                po = this.getParameter("TheAttribute", 0);
                if (po == null || po.length == 0) {
                    throw new M4Exception("Step '" + this.getName() + "': could not find parameter 'TheAttribute'!");
                }
                targetAttr = (edu.udo.cs.miningmart.m4.core.BaseAttribute)po[0];
            }
            Concept inputConcept = (Concept)this.getInputConceptsThatAreParameters().iterator().next();
            Iterator inputAttribsIt = inputConcept.getAllBaseAttributes().iterator();
            Vector<String> outputBaNames = new Vector<String>();
            Vector<String> outputBaTypes = new Vector<String>();
            while (inputAttribsIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute inBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)inputAttribsIt.next();
                if (!this.isVisible(inBa) || targetAttr != null && !name.equals("Unsegment") && (targetAttr == null || inBa.getName().equals(targetAttr.getName()))) continue;
                outputBaNames.add(inBa.getName());
                outputBaTypes.add(inBa.getConceptualDataTypeName());
            }
            String[] outBaTypes = new String[outputBaTypes.size()];
            for (int i = 0; i < outBaTypes.length; ++i) {
                outBaTypes[i] = (String)outputBaTypes.get(i);
            }
            if (outputBaNames.size() <= 0) {
                throw new M4Exception("Step '" + this.getName() + "': no attributes were copied to output concept!");
            }
            this.createBAsInConcept(outputBaNames, outBaTypes, outputConcept);
            return true;
        }
        return false;
    }

    private boolean nameOccursIn(edu.udo.cs.miningmart.m4.core.BaseAttribute ba, edu.udo.cs.miningmart.m4.core.BaseAttribute[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!ba.getName().equalsIgnoreCase(list[i].getName())) continue;
            return true;
        }
        return false;
    }

    private String getSpecStatOutAttrSuffix(String parName, String parObjectName) throws M4Exception {
        if (parName.equals("AttributesComputeSum")) {
            return parObjectName + "_SUM";
        }
        if (parName.equals("AttributesComputeCount")) {
            return parObjectName + "_COUNT";
        }
        if (parName.equals("AttributesComputeAvg")) {
            return parObjectName + "_AVG";
        }
        if (parName.equals("AttributesComputeMin")) {
            return parObjectName + "_MIN";
        }
        if (parName.equals("AttributesComputeMax")) {
            return parObjectName + "_MAX";
        }
        if (parName.equals("AttributesComputeUnique")) {
            return parObjectName + "_UNIQUE";
        }
        if (parName.equals("GroupBy")) {
            return parObjectName;
        }
        throw new M4Exception("Step '" + this.getName() + "', creating output: got unknown parameter name '" + parName + "'!");
    }

    private Concept checkConceptExists(OpParam theConceptOpParam) throws M4Exception {
        Concept con = null;
        try {
            Parameter theConcPar = (Parameter)this.getParameterTuple(theConceptOpParam.getName(), 0);
            if (theConcPar == null) {
                throw new M4Exception("Step '" + this.getName() + "': no Parameter for '" + theConceptOpParam.getName() + "' has been created!");
            }
            con = (Concept)theConcPar.getTheParameterObject();
        }
        catch (ClassCastException cce) {
            throw new M4Exception("Step '" + this.getName() + "': found something different from a concept as parameter object of '" + theConceptOpParam.getName() + "'!");
        }
        if (con == null) {
            throw new M4Exception("Step '" + this.getName() + "': failed to reach concept '" + theConceptOpParam.getName() + "'!");
        }
        return con;
    }

    private Collection checkExistenceOfInputFeatures(Collection theInputFeatures) throws M4Exception {
        Vector<edu.udo.cs.miningmart.m4.core.Feature> ret = new Vector<edu.udo.cs.miningmart.m4.core.Feature>();
        if (theInputFeatures != null) {
            Iterator it = theInputFeatures.iterator();
            Collection incons = this.getAllInputConcepts();
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Feature myF = (edu.udo.cs.miningmart.m4.core.Feature)it.next();
                Concept theConcept = (Concept)myF.getConcept();
                if (theConcept == null || !incons.contains(theConcept)) continue;
                ret.add(myF);
            }
        }
        return ret;
    }

    private void setFeaturesIntoConcept(Collection theFeatures, edu.udo.cs.miningmart.m4.Concept theConcept) throws M4Exception {
        Collection theFeats = theConcept.getFeatures();
        edu.udo.cs.miningmart.m4.core.Feature[] toDelete = new edu.udo.cs.miningmart.m4.core.Feature[theFeats.size()];
        Iterator outputFeatureIt = theFeats.iterator();
        int i = 0;
        while (outputFeatureIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Feature outF = (edu.udo.cs.miningmart.m4.core.Feature)outputFeatureIt.next();
            Iterator inputFeatureIt = theFeatures.iterator();
            boolean hasCorrespondentInInputConcept = false;
            boolean isUsedAsOutputParameterByDifferentStep = false;
            while (inputFeatureIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Feature inF = (edu.udo.cs.miningmart.m4.core.Feature)inputFeatureIt.next();
                if (!this.isVisible(inF) || !inF.correspondsTo(outF)) continue;
                hasCorrespondentInInputConcept = true;
            }
            Iterator parametersUsingOutF_It = outF.getParameterReferences().iterator();
            while (parametersUsingOutF_It.hasNext()) {
                Parameter aPar = (Parameter)parametersUsingOutF_It.next();
                if (aPar.getTheStep().equals(this)) continue;
                if (aPar.isInputParam()) {
                    if (hasCorrespondentInInputConcept) continue;
                    this.doPrint(Print.MAX, "WARNING: Feature '" + outF.getName() + "' is used as input parameter in Step '" + aPar.getTheStep().getName() + "', but is deleted! Please check the validity of that Step.");
                    continue;
                }
                isUsedAsOutputParameterByDifferentStep = true;
            }
            toDelete[i] = hasCorrespondentInInputConcept || isUsedAsOutputParameterByDifferentStep ? null : outF;
            ++i;
        }
        for (i = 0; i < toDelete.length; ++i) {
            if (toDelete[i] == null) continue;
            toDelete[i].deleteSoon();
        }
        Iterator inputFeatureIt = theFeatures.iterator();
        while (inputFeatureIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Feature myF = (edu.udo.cs.miningmart.m4.core.Feature)inputFeatureIt.next();
            if (!this.isVisible(myF)) continue;
            if (myF instanceof MultiColumnFeature) {
                Iterator it = ((MultiColumnFeature)myF).getBaseAttributes().iterator();
                while (it.hasNext()) {
                    edu.udo.cs.miningmart.m4.core.BaseAttribute ba = (edu.udo.cs.miningmart.m4.core.BaseAttribute)it.next();
                    this.updateOrCreateBaInConcept(theConcept, ba);
                }
                continue;
            }
            edu.udo.cs.miningmart.m4.core.BaseAttribute ba = (edu.udo.cs.miningmart.m4.core.BaseAttribute)myF;
            this.updateOrCreateBaInConcept(theConcept, ba);
        }
    }

    private void updateOrCreateBaInConcept(edu.udo.cs.miningmart.m4.Concept theConcept, BaseAttribute templateBa) throws M4Exception {
        Iterator baIt = theConcept.getAllBaseAttributes().iterator();
        boolean wasUpdated = false;
        while (baIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.BaseAttribute myBA = (edu.udo.cs.miningmart.m4.core.BaseAttribute)baIt.next();
            if (!myBA.correspondsTo(templateBa)) continue;
            myBA.setConceptualDataTypeName(templateBa.getConceptualDataTypeName());
            wasUpdated = true;
        }
        if (!wasUpdated) {
            theConcept.createBaseAttribute(templateBa.getName(), templateBa.getConceptualDataTypeName(), templateBa.getType());
        }
    }

    private void createEmptyOutputConceptForThisStep(String theName, edu.udo.cs.miningmart.m4.OpParam theOutputConceptOpParam) throws M4Exception {
        Concept existingConcept = null;
        edu.udo.cs.miningmart.m4.Parameter existingParameter = null;
        try {
            existingParameter = (Parameter)this.getParameterTuple(theOutputConceptOpParam.getName(), 0);
            if (existingParameter != null) {
                existingConcept = (Concept)existingParameter.getTheParameterObject();
            }
        }
        catch (ClassCastException cce) {
            throw new M4Exception("Step '" + this.getName() + "': Parameter object for output concept was not a concept!");
        }
        if (existingConcept != null) {
            throw new M4Exception("Step '" + this.getName() + "': createOutput was called with output concept, but it exists already!");
        }
        if (theName.equals("")) {
            throw new UserError("Step '" + this.getName() + "': empty output object name!");
        }
        Concept conceptWithGivenName = (Concept)this.getTheCase().getConcept(theName);
        Concept newOutputConcept = null;
        if (conceptWithGivenName != null) {
            conceptWithGivenName.removeAllFeatures();
            newOutputConcept = conceptWithGivenName;
        } else {
            newOutputConcept = (Concept)this.getTheCase().createConcept(theName, "MINING");
        }
        if (existingParameter == null) {
            existingParameter = this.createParameterTuple(theOutputConceptOpParam.getName(), newOutputConcept, this.getFreeParameterNumber(), 0, "OUT");
        } else {
            existingParameter.setTheParameterObject(newOutputConcept);
        }
    }

    private void workOnOutputBAs(Collection theConstraints, edu.udo.cs.miningmart.m4.OpParam theOutputOpParam, Collection theNames, int loopNr, boolean create) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.BaseAttribute[][] allKeys;
        if (!this.workOnOutputBAsForSpecialOperators(theNames, theOutputOpParam, create, loopNr)) {
            String type = null;
            edu.udo.cs.miningmart.m4.core.Constraint inOutputConceptConstraint = null;
            edu.udo.cs.miningmart.m4.core.Constraint inInputConceptConstraint = null;
            Concept outputConcept = null;
            Concept inputConcept = null;
            Iterator theConstraintsIt = theConstraints.iterator();
            while (theConstraintsIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Constraint aConstr = (edu.udo.cs.miningmart.m4.core.Constraint)theConstraintsIt.next();
                if (aConstr.getType().equalsIgnoreCase("TYPE")) {
                    type = aConstr.getObj2();
                }
                if (aConstr.getType().equalsIgnoreCase("SAME_TYPE")) {
                    type = this.getTypeFromCorrespondingBA(aConstr, loopNr);
                }
                if (!aConstr.getType().equalsIgnoreCase("IN")) continue;
                String whatIsContained = aConstr.getObj1();
                OpParam containedOpPar = (OpParam)this.getTheOperator().getOpParam(whatIsContained);
                if (containedOpPar == null) {
                    throw new M4Exception("Step '" + this.getName() + "': found IN constraint whose object 1 is not a parameter!");
                }
                if (!containedOpPar.isBaseAttribParameter() && !containedOpPar.isFeatureParameter() || containedOpPar.isInput()) continue;
                String containedIn = aConstr.getObj2();
                OpParam containedInOpPar = (OpParam)this.getTheOperator().getOpParam(containedIn);
                if (containedInOpPar == null) {
                    throw new M4Exception("Step '" + this.getName() + "': found IN constraint whose object 2 is not a parameter!");
                }
                Parameter conceptPar = (Parameter)this.getParameterTuple(containedInOpPar.getName(), 0);
                if (conceptPar == null) {
                    throw new M4Exception("Step '" + this.getName() + "': found IN CONCEPT constraint for output BA, but the concept does not exist in this Step!");
                }
                if (!conceptPar.getParObjectType().equalsIgnoreCase(Parameter.typeStringForTypeConst((short)1))) {
                    throw new M4Exception("Step '" + this.getName() + "': found IN constraint for output BA without a Concept in object 2!");
                }
                Concept conceptFromInConstraint = (Concept)conceptPar.getTheParameterObject();
                if (!conceptPar.isInputParam()) {
                    if (conceptFromInConstraint == null) {
                        throw new M4Exception("Step '" + this.getName() + "': method workOnOutput was called with an output BA " + "that belongs to an output concept; " + "please create that concept first!");
                    }
                    inOutputConceptConstraint = aConstr;
                    outputConcept = conceptFromInConstraint;
                    continue;
                }
                inInputConceptConstraint = aConstr;
                inputConcept = conceptFromInConstraint;
            }
            if (inInputConceptConstraint == null && inOutputConceptConstraint == null) {
                throw new M4Exception("Step '" + this.getName() + "': could not find a constraint specifying what to do with output BA '" + theOutputOpParam.getName() + "'!");
            }
            String[] typesOfInputBAs = new String[theNames.size()];
            boolean baAddedToInput = false;
            Collection createdBaseAttribs = null;
            if (inInputConceptConstraint != null) {
                int i = 0;
                boolean baIsPresentInInputConcept = true;
                Collection newNames = theNames;
                Iterator theNamesIt = theNames.iterator();
                while (baIsPresentInInputConcept && theNamesIt.hasNext()) {
                    String oneNewName = (String)theNamesIt.next();
                    if (oneNewName.equals("")) {
                        throw new UserError("Step '" + this.getName() + "': empty output object name!");
                    }
                    edu.udo.cs.miningmart.m4.core.Feature inF = (edu.udo.cs.miningmart.m4.core.Feature)inputConcept.getFeature(oneNewName);
                    if (inF != null && this.isVisible(inF) && inF instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute) {
                        typesOfInputBAs[i] = ((edu.udo.cs.miningmart.m4.core.BaseAttribute)inF).getConceptualDataTypeName();
                    } else {
                        baIsPresentInInputConcept = false;
                    }
                    ++i;
                }
                if (!baIsPresentInInputConcept) {
                    String[] theTypes = new String[newNames.size()];
                    for (int j = 0; j < theTypes.length; ++j) {
                        theTypes[j] = type;
                    }
                    createdBaseAttribs = this.createBAsInConcept(newNames, theTypes, inputConcept);
                    boolean bl = baAddedToInput = !createdBaseAttribs.isEmpty();
                }
            }
            if (inOutputConceptConstraint != null) {
                if (baAddedToInput) {
                    throw new M4Exception("Step '" + this.getName() + "': new BA(s) were added to input, but a constraint of type 'IN TheOutputConcept' was also found!");
                }
                createdBaseAttribs = this.createBAsInConcept(theNames, typesOfInputBAs, outputConcept);
            }
            if (createdBaseAttribs != null && !createdBaseAttribs.isEmpty()) {
                this.setParameter(theOutputOpParam, createdBaseAttribs, loopNr);
            } else if (create) {
                // empty if block
            }
        }
        if ((allKeys = this.getKeysOfRelationshipAssertion()) != null) {
            edu.udo.cs.miningmart.m4.core.BaseAttribute[] manyKeys = allKeys[0];
            edu.udo.cs.miningmart.m4.core.BaseAttribute[] oneKeys = allKeys[1];
            if (oneKeys != null && manyKeys != null && oneKeys.length > 0 && manyKeys.length > 0) {
                Concept fromConcept = (Concept)manyKeys[0].getConcept();
                Concept toConcept = (Concept)oneKeys[0].getConcept();
                String nameForRel = fromConcept.getName() + "_" + toConcept.getName() + "_REL";
                Relation rel = (Relation)fromConcept.getRelationshipToConcept(toConcept);
                if (rel == null) {
                    Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute> mk = new Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute>();
                    Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute> ok = new Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute>();
                    for (int i = 0; i < oneKeys.length; ++i) {
                        mk.add(manyKeys[i]);
                        ok.add(oneKeys[i]);
                    }
                    this.getTheCase().createOneToManyRelation(nameForRel, mk, ok);
                }
            }
        }
    }

    private boolean workOnOutputBAsForSpecialOperators(Collection theNames, edu.udo.cs.miningmart.m4.OpParam outOpPar, boolean create, int loopNr) throws M4Exception {
        String name = this.getTheOperator().getName();
        if (name.equalsIgnoreCase("JoinByKey") || name.equalsIgnoreCase("UnionByKey")) {
            edu.udo.cs.miningmart.m4.core.ParameterObject[] po = this.getParameter("TheOutputConcept", 0);
            if (po == null || po.length == 0) {
                throw new M4Exception("Step '" + this.getName() + "': could not find output concept!");
            }
            Concept outputConcept = (Concept)po[0];
            Iterator fIt = outputConcept.getFeatures().iterator();
            Object[] namesMapOutput = theNames.toArray();
            if (namesMapOutput.length != 1) {
                throw new M4Exception("Creating output for Join/UnionByKey: found more than one name for '" + outOpPar.getName() + "' for loop number " + loopNr + "!");
            }
            String mapOutputName = (String)namesMapOutput[0];
            while (fIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Feature myFeature = (edu.udo.cs.miningmart.m4.core.Feature)fIt.next();
                String myFname = myFeature.getName();
                int positionOfMarker = myFname.indexOf(specialNameMarker);
                if (positionOfMarker <= -1) continue;
                String indexString = myFname.substring(positionOfMarker + specialNameMarker.length());
                int index = -1;
                try {
                    index = Integer.parseInt(indexString);
                }
                catch (NumberFormatException nfe) {
                    throw new M4Exception("Step '" + this.getName() + "': could not find MapInput for MapOutput (" + indexString + ")!");
                }
                if (index != loopNr) continue;
                myFeature.setName(mapOutputName);
                if (!create) continue;
                Vector<edu.udo.cs.miningmart.m4.core.Feature> parObjColl = new Vector<edu.udo.cs.miningmart.m4.core.Feature>();
                parObjColl.add(myFeature);
                this.setParameter(outOpPar, parObjColl, loopNr);
            }
            return true;
        }
        if (name.equals("Unsegment")) {
            edu.udo.cs.miningmart.m4.core.ParameterObject[] po = this.getParameter("TheOutputConcept", 0);
            if (po == null || po.length == 0) {
                throw new M4Exception("Step '" + this.getName() + "': could not find output concept!");
            }
            Concept outputConcept = (Concept)po[0];
            if (theNames == null || theNames.isEmpty()) {
                throw new M4Exception("Step '" + this.getName() + "': no name found to create 'UnsegmentAttribute'!");
            }
            String attribName = (String)theNames.iterator().next();
            edu.udo.cs.miningmart.m4.core.BaseAttribute newBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)outputConcept.createBaseAttribute(attribName, "NOMINAL", "MINING");
            if (create) {
                Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute> parObjColl = new Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute>();
                parObjColl.add(newBa);
                this.setParameter(outOpPar, parObjColl, loopNr);
            }
            return true;
        }
        return false;
    }

    private Collection createBAsInConcept(Collection theNames, String[] types, edu.udo.cs.miningmart.m4.Concept theConcept) throws M4Exception {
        Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute> ret = new Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute>();
        Iterator theNamesIt = theNames.iterator();
        if (types.length != theNames.size()) {
            throw new M4Exception("Step '" + this.getName() + "': could not find suitable datatype(s) for new output BA(s)!");
        }
        int i = 0;
        while (theNamesIt.hasNext()) {
            String oneNewName = (String)theNamesIt.next();
            String datatype = types[i] == null ? "NOMINAL" : types[i];
            edu.udo.cs.miningmart.m4.core.BaseAttribute oldBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)theConcept.getBaseAttribute(oneNewName);
            if (oldBa != null) {
                oldBa.setConceptualDataTypeName(datatype);
            } else {
                if (oneNewName.equals("")) {
                    throw new UserError("Step '" + this.getName() + "': empty output object name!");
                }
                edu.udo.cs.miningmart.m4.core.BaseAttribute ba = (edu.udo.cs.miningmart.m4.core.BaseAttribute)theConcept.createBaseAttribute(oneNewName, datatype, "MINING");
                ret.add(ba);
            }
            ++i;
        }
        return ret;
    }

    private String getTypeFromCorrespondingBA(Constraint aConstr, int loopNr) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParameterObject[] targets;
        OpParam constrainedOpPar;
        String nameOfParamWithSameType = aConstr.getObj2();
        String nameOfConstrainedParam = aConstr.getObj1();
        if (nameOfParamWithSameType == null) {
            throw new M4Exception("Step '" + this.getName() + "': a SAME_TYPE constraint was found without second object!");
        }
        OpParam targetOpPar = (OpParam)this.getTheOperator().getOpParam(nameOfParamWithSameType);
        if (targetOpPar == null) {
            throw new M4Exception("Step '" + this.getName() + "': a same-type constraint was found that does not use a parameter of this step!");
        }
        if (!targetOpPar.isInput()) {
            nameOfParamWithSameType = aConstr.getObj1();
            nameOfConstrainedParam = aConstr.getObj2();
            targetOpPar = (OpParam)this.getTheOperator().getOpParam(nameOfParamWithSameType);
            if (targetOpPar == null || !targetOpPar.isInput()) {
                throw new M4Exception("Step '" + this.getName() + "': a same-type constraint was found that does not use an input parameter of this step!");
            }
        }
        if ((constrainedOpPar = (OpParam)this.getTheOperator().getOpParam(nameOfConstrainedParam)).isCoordinated() && !targetOpPar.isCoordinated()) {
            loopNr = 0;
        }
        if (targetOpPar.isCoordinated() && !constrainedOpPar.isCoordinated()) {
            loopNr = 1;
        }
        if ((targets = this.getParameter(nameOfParamWithSameType, loopNr)) == null || targets.length == 0) {
            this.doPrint(Print.MAX, "WARNING: Step '" + this.getName() + "': no parameter '" + nameOfParamWithSameType + "' found, though this name is used in a constraint!");
            return "NOMINAL";
        }
        edu.udo.cs.miningmart.m4.core.BaseAttribute theTarget = null;
        try {
            theTarget = (edu.udo.cs.miningmart.m4.core.BaseAttribute)targets[0];
        }
        catch (ClassCastException cce) {
            throw new M4Exception("Step '" + this.getName() + "': a same-type constraint was found that does not use the name of a BA parameter!");
        }
        if (theTarget == null) {
            throw new M4Exception("Step '" + this.getName() + "': could not find a parameter called '" + nameOfParamWithSameType + "', though it was specified in a same-type constraint!");
        }
        if (!this.isVisible(theTarget)) {
            throw new M4Exception("Step '" + this.getName() + "': The target attribute '" + theTarget.getName() + "' is not visible here!");
        }
        return theTarget.getConceptualDataTypeName();
    }

    public void renameOutput(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theNames) throws M4Exception {
        int endLoopNr;
        int startLoopNr;
        if (theOpParam.isCoordinated()) {
            theNames = this.flattenCollections(theNames);
        }
        Iterator namesIt = theNames.iterator();
        if (theOpParam.isLoopable() && this.getLoopCount() > 0 || theOpParam.isCoordinated()) {
            startLoopNr = 1;
            endLoopNr = this.getHighestLoopNr(theOpParam);
        } else {
            endLoopNr = 0;
            startLoopNr = 0;
        }
        if (namesIt.hasNext()) {
            for (int loopNr = startLoopNr; loopNr <= endLoopNr; ++loopNr) {
                Parameter thePar = (Parameter)this.getParameterTuple(theOpParam.getName(), loopNr);
                if (thePar == null) {
                    this.createOutput(theOpParam, theNames);
                    return;
                }
                edu.udo.cs.miningmart.m4.core.ParameterObject myParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)thePar.getTheParameterObject();
                myParObj.setName((String)namesIt.next());
                if (!(myParObj instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) continue;
                this.propagateNameChange((edu.udo.cs.miningmart.m4.core.BaseAttribute)myParObj);
            }
        }
    }

    private Collection flattenCollections(Collection coll) throws M4Exception {
        if (coll == null) {
            throw new M4Exception("Step '" + this.getName() + "' (method flattenCollections): got >null< instead of names for output objects!");
        }
        Iterator it1 = coll.iterator();
        Vector ret = new Vector();
        while (it1.hasNext()) {
            Collection innerColl = (Collection)it1.next();
            if (innerColl == null) {
                throw new M4Exception("Step '" + this.getName() + "' (method flattenCollections): got >null< instead of names for output objects (inner collection)!");
            }
            Iterator it2 = innerColl.iterator();
            while (it2.hasNext()) {
                ret.add(it2.next());
            }
        }
        return ret;
    }

    private void propagateNameChange(BaseAttribute changedBA) throws M4Exception {
        Collection laterSteps = this.getSuccessors();
        Iterator stepIt = laterSteps.iterator();
        while (stepIt.hasNext()) {
            Step oneSuccessor = (Step)stepIt.next();
            Concept outputConcept = (Concept)oneSuccessor.getOutputConcept();
            if (outputConcept == null) {
                oneSuccessor.propagateNameChange(changedBA);
                continue;
            }
            Collection outputBAs = outputConcept.getAllBaseAttributes();
            Iterator it = outputBAs.iterator();
            boolean correspondingBaFound = false;
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute myBA = (edu.udo.cs.miningmart.m4.core.BaseAttribute)it.next();
                if (!myBA.equals(changedBA)) continue;
                myBA.setName(changedBA.getName());
                oneSuccessor.propagateNameChange(myBA);
                correspondingBaFound = true;
            }
            if (correspondingBaFound) continue;
            throw new M4Exception("Step '" + oneSuccessor.getName() + "': could not find corresponding output BA for BA '" + changedBA.getName() + "'!");
        }
    }

    public Collection getInputConceptsThatAreParameters() throws M4Exception {
        Collection theInputOpParams = this.getTheOperator().getAllInputOperatorParameters();
        Iterator it = theInputOpParams.iterator();
        Vector theInputConcepts = new Vector();
        while (it.hasNext()) {
            Collection inputObjects;
            OpParam myOpPar = (OpParam)it.next();
            if (!myOpPar.isConceptParameter() || (inputObjects = this.getParameter(myOpPar, 0)) == null) continue;
            theInputConcepts.addAll(inputObjects);
        }
        return theInputConcepts;
    }

    public Collection getAllInputConcepts() throws M4Exception {
        Collection directInputs = this.getInputConceptsThatAreParameters();
        Iterator it = this.getAllInputRelations().iterator();
        while (it.hasNext()) {
            Relation inRel = (Relation)it.next();
            Concept from = (Concept)inRel.getTheFromConcept();
            Concept to = (Concept)inRel.getTheToConcept();
            if (!directInputs.contains(from)) {
                directInputs.add(from);
            }
            if (to == null || directInputs.contains(to)) continue;
            directInputs.add(to);
        }
        return directInputs;
    }

    public Collection getAllInputRelations() throws M4Exception {
        Collection theInputOpParams = this.getTheOperator().getAllInputOperatorParameters();
        Iterator it = theInputOpParams.iterator();
        Vector<ParameterObject> theInputRels = new Vector<ParameterObject>();
        while (it.hasNext()) {
            OpParam myOpPar = (OpParam)it.next();
            if (!myOpPar.isRelationParameter()) continue;
            Collection relPars = this.getParameterTuples(myOpPar);
            Iterator parIt = relPars.iterator();
            while (parIt.hasNext()) {
                Parameter myPar = (Parameter)parIt.next();
                theInputRels.add(myPar.getTheParameterObject());
            }
        }
        return theInputRels;
    }

    public edu.udo.cs.miningmart.m4.Concept getOutputConcept() throws M4Exception {
        Collection theOutputOpParams = this.getTheOperator().getAllOutputOperatorParameters();
        Iterator it = theOutputOpParams.iterator();
        while (it.hasNext()) {
            OpParam myOpPar = (OpParam)it.next();
            if (!myOpPar.isConceptParameter()) continue;
            int loopNr = 0;
            Collection outputConcepts = this.getParameter(myOpPar, loopNr);
            if (outputConcepts == null) {
                return null;
            }
            if (outputConcepts.size() > 1) {
                throw new M4Exception("Step '" + this.getName() + "': found more than one output concept (Parameter '" + myOpPar.getName() + "'!");
            }
            if (outputConcepts.isEmpty()) continue;
            return (Concept)outputConcepts.iterator().next();
        }
        return null;
    }

    public Collection getResultingDataModel() throws M4Exception {
        Vector<Concept> inputDataModelOfCase = new Vector<Concept>(this.getTheCase().getInputDataModel());
        Vector conceptsToBeReplaced = new Vector();
        HashSet visitedSteps = new HashSet();
        Concept replacingConcept = this.getReplacingConcept(this, conceptsToBeReplaced, visitedSteps);
        if (replacingConcept != null) {
            inputDataModelOfCase.removeAll(conceptsToBeReplaced);
            inputDataModelOfCase.add(replacingConcept);
        }
        return inputDataModelOfCase;
    }

    private Concept getReplacingConcept(Step current, Collection conceptsToBeReplaced, Collection visitedSteps) throws M4Exception {
        if (visitedSteps.contains(current)) {
            return null;
        }
        visitedSteps.add(current);
        Concept ret = null;
        Collection preds = current.getAllPredecessors();
        if (preds != null && !preds.isEmpty()) {
            Iterator it = preds.iterator();
            Vector<Concept> outputConceptsOfIncomingSteps = new Vector<Concept>();
            while (it.hasNext()) {
                Step next = (Step)it.next();
                if (visitedSteps.contains(next)) continue;
                ret = this.getReplacingConcept(next, conceptsToBeReplaced, visitedSteps);
                outputConceptsOfIncomingSteps.add(ret);
            }
            Collection inCons = current.getAllInputConcepts();
            if (inCons.size() > preds.size()) {
                Iterator concIt = inCons.iterator();
                while (concIt.hasNext()) {
                    Concept anInputConcept = (Concept)concIt.next();
                    if (outputConceptsOfIncomingSteps.contains(anInputConcept)) continue;
                    conceptsToBeReplaced.add(anInputConcept);
                }
            }
        } else {
            Iterator it = current.getAllInputConcepts().iterator();
            while (it.hasNext()) {
                Concept inCon = (Concept)it.next();
                if (conceptsToBeReplaced.contains(inCon)) continue;
                conceptsToBeReplaced.add(inCon);
            }
        }
        if (current.getOutputConcept() != null) {
            ret = (Concept)current.getOutputConcept();
        }
        return ret;
    }

    public void updateOutput(edu.udo.cs.miningmart.m4.OpParam theOpParam) throws M4Exception {
        boolean create = false;
        this.workOnOutput(theOpParam, null, create);
    }

    public boolean inputChangeCanAffectOutput(edu.udo.cs.miningmart.m4.OpParam theOpParam) throws M4Exception {
        if (!theOpParam.isInput()) {
            return false;
        }
        Iterator it = theOpParam.getApplicableConstraints().iterator();
        boolean constraintConnectingGivenOpParamToAnOutputOpParam_Exists = false;
        while (it.hasNext()) {
            OpParam otherOpPar;
            edu.udo.cs.miningmart.m4.core.Constraint myConstr = (edu.udo.cs.miningmart.m4.core.Constraint)it.next();
            String otherParameter = myConstr.getObj1();
            if (otherParameter.equalsIgnoreCase(theOpParam.getName())) {
                otherParameter = myConstr.getObj2();
            }
            if ((otherOpPar = (OpParam)this.getTheOperator().getOpParam(otherParameter)) == null || otherOpPar.isInput()) continue;
            constraintConnectingGivenOpParamToAnOutputOpParam_Exists = true;
        }
        if (!constraintConnectingGivenOpParamToAnOutputOpParam_Exists) {
            if (this.getTheOperator().getName().equalsIgnoreCase("Pivotize")) {
                if (theOpParam.isBaseAttribParameter()) {
                    return true;
                }
                if (theOpParam.getName().equalsIgnoreCase("IndexValues")) {
                    return true;
                }
            }
            if (this.getTheOperator().getName().equalsIgnoreCase("SpecifiedStatistics") && (theOpParam.isBaseAttribParameter() || theOpParam.getName().equals("DistribValues"))) {
                return true;
            }
        }
        return constraintConnectingGivenOpParamToAnOutputOpParam_Exists;
    }

    public EstimatedStatistics estimateStatisticsForOutputConcept() throws M4Exception {
        if (this.getOutputConcept() == null) {
            return null;
        }
        if (this.getOutputConcept().getType() == "DB") {
            throw new M4Exception("Error in step '" + this.getName() + "': output concept of this step is of type DB!");
        }
        ExecutableOperator theOp = null;
        try {
            theOp = CompilerAccessLogic.getExecutableOperator(this.getTheOperator());
            theOp.load(this);
        }
        catch (M4CompilerError mce) {
            throw new M4Exception("Error estimating statistics for output concept of step '" + this.getName() + "': " + mce.getMessage());
        }
        return theOp.estimateStatistics(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

