/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

public class RelationalDatatypes
implements Serializable,
edu.udo.cs.miningmart.m4.RelationalDatatypes {
    public static final String M4_TABLE_NAME = "col_datatype_t";
    public static final String ATTRIB_DATATYPE_ID = "coldt_id";
    public static final String ATTRIB_DATATYPE_NAME = "coldt_name";
    private HashMap idToName = new HashMap();
    private HashMap nameToId = new HashMap();
    private Collection allNames = new Vector();

    public RelationalDatatypes(DB db) throws M4Exception, DbConnectionClosed {
        String query = "SELECT coldt_id, coldt_name FROM col_datatype_t";
        ResultSet rs = null;
        try {
            rs = db.executeM4SqlRead(query);
            while (rs.next()) {
                Integer id = new Integer(rs.getInt(ATTRIB_DATATYPE_ID));
                if (rs.wasNull()) continue;
                String name = rs.getString(ATTRIB_DATATYPE_NAME);
                this.idToName.put(id, name);
                this.nameToId.put(name, id);
                this.allNames.add(name);
            }
        }
        catch (SQLException e) {
            throw new M4Exception("SQLException when trying to read the relational datatypes:\n" + e.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
    }

    public long getIdForName(String name) {
        Integer id = (Integer)this.nameToId.get(name);
        if (id != null) {
            return id.longValue();
        }
        return 0L;
    }

    public String getNameForId(long id) {
        Integer idI = new Integer((int)id);
        return (String)this.idToName.get(idI);
    }

    public Collection getAllRelationalDatatypeNames() {
        return this.allNames;
    }
}

