/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.ParameterError;
import edu.udo.cs.miningmart.exception.ParameterNotFoundException;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.ParameterObject;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.util.Collection;

public class Parameter
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.Parameter {
    public static final String M4_TABLE_NAME = "parameter_t";
    public static final String ATTRIB_PARAMETER_ID = "par_id";
    public static final String ATTRIB_PARAMETER_NAME = "par_name";
    public static final String ATTRIB_OBJECT_ID = "par_objid";
    public static final String ATTRIB_OBJECT_TYPE = "par_objtype";
    public static final String ATTRIB_PAR_IO_TYPE = "par_type";
    public static final String ATTRIB_PAR_LOOP_NR = "par_stloopnr";
    public static final String ATTRIB_PAR_OPERATOR_ID = "par_opid";
    public static final String ATTRIB_PAR_STEP_ID = "par_stid";
    public static final String ATTRIB_PARAMETER_NR = "par_nr";
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private static final String[] typeMapping = new String[]{DB.C_VAL, DB.C_CONC, DB.C_REL, DB.C_BA, DB.C_MCF, DB.C_FEA, "*invalid*"};
    private static final Class[] classForType = new Class[]{class$edu$udo$cs$miningmart$m4$core$Value == null ? (class$edu$udo$cs$miningmart$m4$core$Value = Parameter.class$("edu.udo.cs.miningmart.m4.core.Value")) : class$edu$udo$cs$miningmart$m4$core$Value, class$edu$udo$cs$miningmart$m4$core$Concept == null ? (class$edu$udo$cs$miningmart$m4$core$Concept = Parameter.class$("edu.udo.cs.miningmart.m4.core.Concept")) : class$edu$udo$cs$miningmart$m4$core$Concept, class$edu$udo$cs$miningmart$m4$core$Relation == null ? (class$edu$udo$cs$miningmart$m4$core$Relation = Parameter.class$("edu.udo.cs.miningmart.m4.core.Relation")) : class$edu$udo$cs$miningmart$m4$core$Relation, class$edu$udo$cs$miningmart$m4$core$BaseAttribute == null ? (class$edu$udo$cs$miningmart$m4$core$BaseAttribute = Parameter.class$("edu.udo.cs.miningmart.m4.core.BaseAttribute")) : class$edu$udo$cs$miningmart$m4$core$BaseAttribute, class$edu$udo$cs$miningmart$m4$core$MultiColumnFeature == null ? (class$edu$udo$cs$miningmart$m4$core$MultiColumnFeature = Parameter.class$("edu.udo.cs.miningmart.m4.core.MultiColumnFeature")) : class$edu$udo$cs$miningmart$m4$core$MultiColumnFeature, class$edu$udo$cs$miningmart$m4$core$Feature == null ? (class$edu$udo$cs$miningmart$m4$core$Feature = Parameter.class$("edu.udo.cs.miningmart.m4.core.Feature")) : class$edu$udo$cs$miningmart$m4$core$Feature, class$edu$udo$cs$miningmart$m4$ParameterObject == null ? (class$edu$udo$cs$miningmart$m4$ParameterObject = Parameter.class$("edu.udo.cs.miningmart.m4.ParameterObject")) : class$edu$udo$cs$miningmart$m4$ParameterObject};
    private edu.udo.cs.miningmart.m4.core.Step myStep;
    private boolean isInputParam;
    private int loopNr;
    private edu.udo.cs.miningmart.m4.ParameterObject parameterObject;
    private long myParameterNr;
    private String parTypeDuringLoad;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Step;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Operator;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$ParameterObject;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Value;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Concept;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Relation;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$BaseAttribute;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$MultiColumnFeature;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Feature;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Parameter;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_PARAMETER_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_PARAMETER_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_PARAMETER_NAME, "getName", "setName", class$java$lang$String == null ? (class$java$lang$String = Parameter.class$("java.lang.String")) : class$java$lang$String, "NN"), new M4InfoEntry(ATTRIB_PAR_IO_TYPE, "getInputParam", "setInputParam", class$java$lang$String == null ? (class$java$lang$String = Parameter.class$("java.lang.String")) : class$java$lang$String, "NN"), new M4InfoEntry(ATTRIB_PAR_LOOP_NR, "getLoopNr", "setLoopNr", Integer.TYPE), new M4InfoEntry(ATTRIB_PARAMETER_NR, "getParamNr", "setParamNr", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_PAR_STEP_ID, "getTheStep", "primitiveSetStep", class$edu$udo$cs$miningmart$m4$Step == null ? (class$edu$udo$cs$miningmart$m4$Step = Parameter.class$("edu.udo.cs.miningmart.m4.Step")) : class$edu$udo$cs$miningmart$m4$Step, "NN"), new M4InfoEntry(ATTRIB_OBJECT_TYPE, "getParObjectType", "privateSetParType", class$java$lang$String == null ? (class$java$lang$String = Parameter.class$("java.lang.String")) : class$java$lang$String, "NN"), new M4InfoEntry(ATTRIB_OBJECT_ID, "getParObjectId", "readParObjFromDb", class$java$lang$Long == null ? (class$java$lang$Long = Parameter.class$("java.lang.Long")) : class$java$lang$Long), new M4InfoEntry(ATTRIB_PAR_OPERATOR_ID, "getTheOperator", "setTheOperator", class$edu$udo$cs$miningmart$m4$Operator == null ? (class$edu$udo$cs$miningmart$m4$Operator = Parameter.class$("edu.udo.cs.miningmart.m4.Operator")) : class$edu$udo$cs$miningmart$m4$Operator, "NN")};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", class$java$lang$String == null ? (class$java$lang$String = Parameter.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("InOut", "getInputParam", "setInputParam", class$java$lang$String == null ? (class$java$lang$String = Parameter.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("LoopNumber", "getLoopNr", "setLoopNr", Integer.TYPE), new M4InfoEntry("ParameterNumber", "getParamNr", "setParamNr", Long.TYPE), new M4InfoEntry("Step", "getTheStep", "setTheStep", class$edu$udo$cs$miningmart$m4$Step == null ? (class$edu$udo$cs$miningmart$m4$Step = Parameter.class$("edu.udo.cs.miningmart.m4.Step")) : class$edu$udo$cs$miningmart$m4$Step), new M4InfoEntry("ParameterObject", "getTheParameterObject", "setTheParameterObject", class$edu$udo$cs$miningmart$m4$ParameterObject == null ? (class$edu$udo$cs$miningmart$m4$ParameterObject = Parameter.class$("edu.udo.cs.miningmart.m4.ParameterObject")) : class$edu$udo$cs$miningmart$m4$ParameterObject), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", class$java$lang$String == null ? (class$java$lang$String = Parameter.class$("java.lang.String")) : class$java$lang$String)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public static short typeConstForTypeString(String parameterType) throws ParameterError {
        int type = -1;
        if (parameterType != null) {
            parameterType = parameterType.trim();
            for (int i = 0; i < typeMapping.length && type == -1; i = (int)((short)(i + 1))) {
                if (!typeMapping[i].equalsIgnoreCase(parameterType)) continue;
                type = i;
            }
        }
        if (type == -1) {
            throw new ParameterError("Parameter.typeConstForTypeString(String):\n Unsupported parameter type found: " + parameterType);
        }
        return (short)type;
    }

    public static String typeStringForTypeConst(short parameterType) throws ParameterError {
        if (parameterType < 0 || parameterType >= typeMapping.length) {
            throw new ParameterError("Parameter.typeStringForTypeConst(short):\n Unsupported parameter type found: " + parameterType);
        }
        return typeMapping[parameterType];
    }

    public static Class getClassForParameterType(short parameterType) throws ParameterError {
        if (parameterType < 0 || parameterType >= classForType.length) {
            throw new ParameterError("Parameter.getClassForParameterType(short):\n Unsupported parameter type found: " + parameterType);
        }
        return classForType[parameterType];
    }

    public static String getTypeStringForParObject(edu.udo.cs.miningmart.m4.ParameterObject parameterObject) throws ParameterError {
        if (parameterObject != null) {
            for (short i = 0; i < classForType.length; i = (short)(i + 1)) {
                if (!classForType[i].isInstance(parameterObject)) continue;
                return Parameter.typeStringForTypeConst(i);
            }
            throw new ParameterError("Unknown type of ParameterObject: " + parameterObject.getClass().getName());
        }
        return null;
    }

    public Parameter(DB db) {
        super(db);
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        return null;
    }

    public void setTheOperator(Operator op) {
    }

    public Operator getTheOperator() throws M4Exception {
        Step step = this.getTheStep();
        if (step != null) {
            return step.getTheOperator();
        }
        return null;
    }

    public void setTheStep(Step step) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Step.step2par.checkNameExists(this, step);
        edu.udo.cs.miningmart.m4.core.Step.step2par.updateReferenceTo(this, step);
    }

    public void primitiveSetStep(Step step) {
        this.setDirty();
        this.myStep = (edu.udo.cs.miningmart.m4.core.Step)step;
    }

    public Step getTheStep() throws M4Exception {
        return this.myStep;
    }

    public boolean isInputParam() {
        return this.isInputParam;
    }

    public String getInputParam() {
        return this.isInputParam ? "IN" : "OUT";
    }

    public void setIsInputParam(boolean is) {
        this.setDirty();
        this.isInputParam = is;
    }

    public void setInputParam(String inputString) {
        this.setIsInputParam(!"OUT".equals(inputString));
    }

    public void setLoopNr(int nr) {
        this.setDirty();
        this.loopNr = nr;
    }

    public int getLoopNr() {
        return this.loopNr;
    }

    public String getParObjectType() throws ParameterError, M4Exception {
        return Parameter.getTypeStringForParObject(this.getTheParameterObject());
    }

    public Long getParObjectId() throws M4Exception {
        edu.udo.cs.miningmart.m4.ParameterObject parObj = this.getTheParameterObject();
        return parObj == null ? null : new Long(parObj.getId());
    }

    public edu.udo.cs.miningmart.m4.ParameterObject getTheParameterObject() throws M4Exception {
        return this.parameterObject;
    }

    public void setTheParameterObject(edu.udo.cs.miningmart.m4.ParameterObject parameterObject) throws M4Exception {
        edu.udo.cs.miningmart.m4.ParameterObject old;
        if (parameterObject == null && (old = this.getTheParameterObject()) != null && old instanceof edu.udo.cs.miningmart.m4.core.Value) {
            old.deleteSoon();
        }
        ParameterObject.parObj2par.updateReferenceTo(this, parameterObject);
    }

    public long getParamNr() {
        return this.myParameterNr;
    }

    public void setParamNr(long paramNr) {
        this.setDirty();
        this.myParameterNr = paramNr;
    }

    public void primitiveSetParameterObject(edu.udo.cs.miningmart.m4.ParameterObject paramObj) {
        this.setDirty();
        this.parameterObject = paramObj;
    }

    protected void privateSetParType(String parType) {
        this.parTypeDuringLoad = parType;
    }

    public void print() {
        try {
            if (this.getName() != null) {
                String objectType = this.getParObjectType();
                this.doPrint(Print.PARAM, "Parameter " + this.getName() + "(Id = " + this.getId() + ";" + " Type = " + (objectType == null ? "<null>" : objectType) + "): ");
            }
            ((ParameterObject)this.getTheParameterObject()).print();
        }
        catch (M4Exception e) {
            this.doPrint(Print.MAX, "Warning: Exception caught when trying to print a ParameterObject in Parameter.print():");
            this.doPrint(e);
        }
    }

    protected void readParObjFromDb(Long idL) throws M4Exception {
        String parType = this.parTypeDuringLoad;
        edu.udo.cs.miningmart.m4.ParameterObject parObject = null;
        if (idL != null && parType != null) {
            try {
                parObject = this.readParameterObjectFromDb(parType, idL);
            }
            catch (ParameterNotFoundException e) {
                String name = this.getName();
                this.doPrint(Print.M4_OBJECT, "Invalid ParameterObject-reference detected while loading parameter (Name: " + (name == null ? "<null>" : name) + ", ID: " + this.getId() + ")");
                this.doPrint(Print.M4_OBJECT, "Exception when trying to load was " + e.getMessage());
            }
        }
        this.primitiveSetParameterObject(parObject);
        this.parTypeDuringLoad = null;
    }

    private edu.udo.cs.miningmart.m4.ParameterObject readParameterObjectFromDb(String parObjType, long parObjId) throws M4Exception {
        short type;
        Class c;
        DB db = this.getM4Db();
        edu.udo.cs.miningmart.m4.ParameterObject parObject = null;
        if (!(class$edu$udo$cs$miningmart$m4$ParameterObject == null ? (class$edu$udo$cs$miningmart$m4$ParameterObject = Parameter.class$("edu.udo.cs.miningmart.m4.ParameterObject")) : class$edu$udo$cs$miningmart$m4$ParameterObject).isAssignableFrom(c = Parameter.getClassForParameterType(type = Parameter.typeConstForTypeString(parObjType)))) {
            throw new M4Exception("Internal Compiler Error in Parameter.readParameterObjectFromDb():\nClass provided (" + c.getName() + ") is no subclass of ParameterObject!");
        }
        parObject = (edu.udo.cs.miningmart.m4.ParameterObject)db.getM4Object(parObjId, c);
        if (parObject == null) {
            Step s = this.getTheStep();
            throw new ParameterNotFoundException("M4 Database: Parameter " + this.getName() + " for Step " + (s == null ? "<null>" : "(Name: " + s.getName() + ", ID: " + s.getId()) + " not found");
        }
        return parObject;
    }

    protected void removeAllM4References() throws M4Exception {
        this.setTheStep(null);
        this.setTheParameterObject(null);
        this.removeDocObject();
    }

    public String getParameterName() {
        return this.getName();
    }

    public void setParameterName(String parameterName) throws M4Exception {
        String validName = parameterName;
        if (this.getTheStep() != null) {
            validName = this.getTheStep().getValidName(parameterName, class$edu$udo$cs$miningmart$m4$core$Parameter == null ? (class$edu$udo$cs$miningmart$m4$core$Parameter = Parameter.class$("edu.udo.cs.miningmart.m4.core.Parameter")) : class$edu$udo$cs$miningmart$m4$core$Parameter);
        }
        this.setName(validName);
    }

    public String getParameterType() {
        return this.isInputParam() ? "IN" : "OUT";
    }

    public void setParameterType(String parameterType) throws M4Exception {
        if (parameterType.equals("IN")) {
            this.setIsInputParam(true);
        } else if (parameterType.equals("OUT")) {
            this.setIsInputParam(false);
        } else {
            throw new M4Exception("Parameter.setParameterType: Expected IN or OUT, but got " + parameterType + "!");
        }
    }

    public void removeParameterObject() throws M4Exception {
        this.setTheParameterObject(null);
    }

    public edu.udo.cs.miningmart.m4.Parameter copy(Step newStep) throws M4Exception {
        Parameter theCopy = new Parameter(this.getM4Db());
        theCopy.setTheStep(newStep);
        theCopy.setParameterName(this.getParameterName());
        theCopy.setParamNr(this.getParamNr());
        theCopy.setTheParameterObject(this.getTheParameterObject());
        theCopy.setParameterType(this.getParameterType());
        theCopy.setDocumentation(this.getDocumentation());
        if (newStep != null) {
            theCopy.setTheOperator(newStep.getTheOperator());
        } else {
            theCopy.setTheOperator(null);
        }
        return theCopy;
    }

    public Value getValue() throws M4Exception {
        edu.udo.cs.miningmart.m4.ParameterObject parObj = this.getTheParameterObject();
        if (parObj == null) {
            return null;
        }
        if (!(parObj instanceof edu.udo.cs.miningmart.m4.core.Value)) {
            super.doPrint(Print.MAX, "Warning: ParameterImpl.getValue() called on non-value class " + parObj.getClass().getName() + "!");
            return null;
        }
        return (Value)parObj;
    }

    public void removeValue() throws M4Exception {
        this.removeParameterObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

