/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.Operator;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class OperatorGroup
implements edu.udo.cs.miningmart.m4.OperatorGroup,
Serializable {
    public static final String M4_TABLE_NAME = "op_group_t";
    public static final String ATTRIB_OPGROUP_ID = "opg_id";
    public static final String ATTRIB_OPGROUP_PARENT = "opg_parent";
    public static final String ATTRIB_OPG_OPID = "opg_opid";
    public static final String ATTRIB_OPGROUP_NAME = "opg_name";
    private HashMap opGroupEntries = new HashMap();
    private HashMap parentToChildLookUp = new HashMap();
    private DB m4db;
    private static final Long TOP_LEVEL_ID = new Long(0L);
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Operator;

    public OperatorGroup(DB db) throws M4Exception, DbConnectionClosed {
        this.m4db = db;
        String query = "SELECT opg_id, opg_parent, opg_opid, opg_name FROM op_group_t";
        ResultSet rs = null;
        try {
            rs = db.executeM4SqlRead(query);
            while (rs.next()) {
                long id = rs.getLong(ATTRIB_OPGROUP_ID);
                if (rs.wasNull()) continue;
                long operator = rs.getLong(ATTRIB_OPG_OPID);
                String name = rs.getString(ATTRIB_OPGROUP_NAME);
                Long parent = new Long(rs.getLong(ATTRIB_OPGROUP_PARENT));
                if (rs.wasNull()) {
                    parent = null;
                }
                OpGroupEntry oge = new OpGroupEntry(id, name, parent, operator);
                Long idL = new Long(id);
                this.opGroupEntries.put(idL, oge);
                Long lookUpId = parent == null ? TOP_LEVEL_ID : parent;
                HashSet<Long> childSet = (HashSet<Long>)this.parentToChildLookUp.get(lookUpId);
                if (childSet == null) {
                    childSet = new HashSet<Long>();
                    this.parentToChildLookUp.put(lookUpId, childSet);
                }
                childSet.add(idL);
            }
        }
        catch (SQLException e) {
            throw new M4Exception("SQLException when trying to read the OperatorGroup table:\n" + e.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
    }

    public Collection getTopLevelOperatorGroups() {
        return (Collection)this.parentToChildLookUp.get(TOP_LEVEL_ID);
    }

    public String getGroupName(Long id) {
        OpGroupEntry oge = (OpGroupEntry)this.opGroupEntries.get(id);
        if (oge != null) {
            return oge.getName();
        }
        return null;
    }

    public edu.udo.cs.miningmart.m4.Operator getOperator(Long id) throws M4Exception {
        OpGroupEntry oge = (OpGroupEntry)this.opGroupEntries.get(id);
        if (oge != null) {
            return oge.getOperator();
        }
        return null;
    }

    public Long getParentGroup(Long id) {
        OpGroupEntry oge = (OpGroupEntry)this.opGroupEntries.get(id);
        if (oge != null && (oge = oge.getParent()) != null) {
            return new Long(oge.getId());
        }
        return null;
    }

    public Collection getChildGroups(Long id) {
        Collection col = (Collection)this.parentToChildLookUp.get(id);
        if (col != null && col.isEmpty()) {
            return null;
        }
        return col;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class OpGroupEntry {
        private final long myId;
        private final Long myParent;
        private final String myName;
        private final long myOperator;

        OpGroupEntry(long id, String name, Long parent, long operator) {
            this.myId = id;
            this.myParent = parent;
            this.myName = name;
            this.myOperator = operator;
        }

        long getId() {
            return this.myId;
        }

        String getName() {
            return this.myName;
        }

        Operator getOperator() throws M4Exception {
            if (this.myOperator == 0L) {
                return null;
            }
            return (Operator)OperatorGroup.this.m4db.getM4Object(this.myOperator, class$edu$udo$cs$miningmart$m4$core$Operator == null ? (class$edu$udo$cs$miningmart$m4$core$Operator = OperatorGroup.class$("edu.udo.cs.miningmart.m4.core.Operator")) : class$edu$udo$cs$miningmart$m4$core$Operator);
        }

        OpGroupEntry getParent() {
            if (this.myParent == null) {
                return null;
            }
            return (OpGroupEntry)OperatorGroup.this.opGroupEntries.get(this.myParent);
        }
    }
}

