/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.ParameterError;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.core.Constraint;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.Operator;
import edu.udo.cs.miningmart.m4.core.Parameter;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class OpParam
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.OpParam {
    public static final String M4_TABLE_NAME = "op_params_t";
    public static final String ATTRIB_OP_PARAM_ID = "param_id";
    public static final String ATTRIB_OP_PARAM_OPID = "op_id";
    public static final String ATTRIB_OP_PARAM_NAME = "name";
    public static final String ATTRIB_MIN_ARG = "minarg";
    public static final String ATTRIB_MAX_ARG = "maxarg";
    public static final String ATTRIB_IO_TYPE = "io";
    public static final String ATTRIB_PAR_TYPE = "type";
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private static final boolean IN = true;
    private static final String IN_STRING = "IN";
    private static final boolean OUT = false;
    private static final String OUT_STRING = "OUT";
    private int minArg;
    private int maxArg;
    private short type;
    private boolean ioType;
    private Operator myOperator;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Operator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Value;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_OP_PARAM_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_OP_PARAM_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_OP_PARAM_OPID, "getTheOperator", "primitiveSetOperator", class$edu$udo$cs$miningmart$m4$Operator == null ? (class$edu$udo$cs$miningmart$m4$Operator = OpParam.class$("edu.udo.cs.miningmart.m4.Operator")) : class$edu$udo$cs$miningmart$m4$Operator, "NN"), new M4InfoEntry(ATTRIB_OP_PARAM_NAME, "getName", "setName", class$java$lang$String == null ? (class$java$lang$String = OpParam.class$("java.lang.String")) : class$java$lang$String, "NN"), new M4InfoEntry(ATTRIB_MIN_ARG, "getMinArg", "setMinArg", Integer.TYPE, "NN"), new M4InfoEntry(ATTRIB_MAX_ARG, "getMaxArg", "setMaxArg", Integer.TYPE), new M4InfoEntry(ATTRIB_IO_TYPE, "getInput", "setInput", class$java$lang$String == null ? (class$java$lang$String = OpParam.class$("java.lang.String")) : class$java$lang$String, "NN"), new M4InfoEntry(ATTRIB_PAR_TYPE, "getTypeS", "setType", class$java$lang$String == null ? (class$java$lang$String = OpParam.class$("java.lang.String")) : class$java$lang$String, "NN")};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Operator", "getTheOperator", "setTheOperator", class$edu$udo$cs$miningmart$m4$Operator == null ? (class$edu$udo$cs$miningmart$m4$Operator = OpParam.class$("edu.udo.cs.miningmart.m4.Operator")) : class$edu$udo$cs$miningmart$m4$Operator), new M4InfoEntry("Name", "getName", "setName", class$java$lang$String == null ? (class$java$lang$String = OpParam.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Atleast", "getMinArg", "setMinArg", Integer.TYPE), new M4InfoEntry("Atmost", "getMaxArg", "setMaxArg", Integer.TYPE), new M4InfoEntry("InOut", "getInput", "setInput", class$java$lang$String == null ? (class$java$lang$String = OpParam.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Type", "getTypeS", "setType", class$java$lang$String == null ? (class$java$lang$String = OpParam.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", class$java$lang$String == null ? (class$java$lang$String = OpParam.class$("java.lang.String")) : class$java$lang$String)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public OpParam(DB m4Db) {
        super(m4Db);
    }

    public void print() {
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        return null;
    }

    public boolean isInput() {
        return this.ioType;
    }

    public String getInput() {
        return this.ioType ? IN_STRING : OUT_STRING;
    }

    public int getMaxArg() {
        return this.maxArg == 0 ? -1 : this.maxArg;
    }

    public int getMinArg() {
        return this.minArg;
    }

    public short getType() {
        return this.type;
    }

    public String getTypeS() throws ParameterError {
        short type = this.getType();
        return Parameter.typeStringForTypeConst(type);
    }

    public void setInput(String ioType) throws M4Exception {
        this.setDirty();
        if (ioType.equalsIgnoreCase(IN_STRING)) {
            this.ioType = true;
        } else if (ioType.equalsIgnoreCase(OUT_STRING)) {
            this.ioType = false;
        } else {
            throw new M4Exception("Parameter " + this.getId() + "in table OP_PARAMS_T is neither '" + IN_STRING + "' nor '" + OUT_STRING + "', but: '" + ioType + "'");
        }
    }

    public void setMaxArg(int maxArg) {
        this.setDirty();
        this.maxArg = maxArg;
    }

    public void setMinArg(int minArg) {
        this.setDirty();
        this.minArg = minArg;
    }

    public void setType(String typeString) throws M4Exception {
        try {
            this.type = Parameter.typeConstForTypeString(typeString);
        }
        catch (ParameterError e) {
            throw new M4Exception("Parameter " + this.getId() + "in table OP_PARAMS_T has unsupported type entry: '" + typeString + "'");
        }
    }

    public edu.udo.cs.miningmart.m4.Operator getTheOperator() {
        return this.myOperator;
    }

    public void setTheOperator(edu.udo.cs.miningmart.m4.Operator operator) throws M4Exception {
        Operator.op2oppar.checkNameExists(this, operator);
        Operator.op2oppar.updateReferenceTo(this, operator);
    }

    public void primitiveSetOperator(edu.udo.cs.miningmart.m4.Operator operator) {
        this.setDirty();
        this.myOperator = (Operator)operator;
    }

    protected void removeAllM4References() throws M4Exception {
        this.setTheOperator(null);
        this.removeDocObject();
    }

    public Collection getApplicableConstraints() throws M4Exception {
        Collection cons = this.getTheOperator().getConstraints();
        if (cons == null) {
            throw new M4Exception("OpParam '" + this.getName() + "' for Operator '" + this.getTheOperator().getName() + "': Got NULL when asking for constraints!");
        }
        Iterator it = cons.iterator();
        Vector<Constraint> ret = new Vector<Constraint>();
        while (it.hasNext()) {
            Constraint c = (Constraint)it.next();
            if (!c.getObj1().equalsIgnoreCase(this.getName()) && (c.getObj2() == null || !c.getObj2().equalsIgnoreCase(this.getName()))) continue;
            ret.add(c);
        }
        return ret;
    }

    private Constraint getMyConstraintOfType(String type) throws M4Exception {
        Collection cons = this.getApplicableConstraints();
        Iterator it = cons.iterator();
        while (it.hasNext()) {
            Constraint c = (Constraint)it.next();
            if (!c.getType().equalsIgnoreCase(type)) continue;
            return c;
        }
        return null;
    }

    public boolean isLoopable() throws M4Exception {
        return this.getMyConstraintOfType("IS_LOOPED") != null;
    }

    public boolean isCoordinated() throws M4Exception {
        return this.getMyConstraintOfType("COORD") != null;
    }

    public boolean isOneOf() throws M4Exception {
        return this.getMyConstraintOfType("ONE_OF") != null;
    }

    public boolean isOptional() throws M4Exception {
        return this.getMinArg() == 0;
    }

    public boolean isArray() throws M4Exception {
        return this.getMaxArg() == -1 || this.getMaxArg() > 1;
    }

    public boolean isConceptParameter() throws M4Exception {
        return this.getType() == 1;
    }

    public boolean isValueParameter() throws M4Exception {
        return this.getType() == 0;
    }

    public Value createValueObject() throws M4Exception {
        if (!this.isValueParameter()) {
            throw new M4Exception("OpParam.createValueObject() for OpParam '" + this.getName() + "': this is no Value parameter!");
        }
        Value myVal = (Value)((Object)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$Value == null ? (class$edu$udo$cs$miningmart$m4$Value = OpParam.class$("edu.udo.cs.miningmart.m4.Value")) : class$edu$udo$cs$miningmart$m4$Value));
        myVal.setName(this.getName());
        myVal.setType(this.getConceptualDatatypeForValue());
        return myVal;
    }

    public String getConceptualDatatypeForValue() throws M4Exception {
        if (!this.isValueParameter()) {
            return null;
        }
        Constraint c = this.getMyConstraintOfType("TYPE");
        if (c != null) {
            String conceptualDatatypeForValue = c.getObj2();
            if (conceptualDatatypeForValue == null) {
                throw new M4Exception("OpParam.createValueObject() for OpParam '" + this.getName() + "': Found Constraint of type " + "TYPE" + " that has no entry for the datatype!");
            }
            return conceptualDatatypeForValue;
        }
        return "NOMINAL";
    }

    public boolean isRelationParameter() throws M4Exception {
        return this.getType() == 2;
    }

    public boolean isFeatureParameter() throws M4Exception {
        return this.getType() == 5;
    }

    public boolean isBaseAttribParameter() throws M4Exception {
        return this.getType() == 3;
    }

    public boolean isMcfParameter() throws M4Exception {
        return this.getType() == 4;
    }

    public Collection getOneOfList() throws M4Exception {
        Constraint theOneOfConstr = this.getMyConstraintOfType("ONE_OF");
        if (theOneOfConstr == null) {
            return new Vector();
        }
        String valuesAsList = theOneOfConstr.getObj2();
        StringTokenizer st = new StringTokenizer(valuesAsList, " ,;\t\n\r\f");
        Vector<String> theList = new Vector<String>();
        while (st.hasMoreTokens()) {
            theList.add(st.nextToken());
        }
        return theList;
    }

    public Integer getMaximumNumberOfArrayFields() throws M4Exception {
        if (this.isArray()) {
            return new Integer(this.getMaxArg());
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

