/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.CompilerDatabaseService;
import edu.udo.cs.miningmart.db.ConfigReader;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.MiningMartException;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.M4InterfaceContext;
import edu.udo.cs.miningmart.m4.OperatorGroup;
import edu.udo.cs.miningmart.m4.core.BaseAttribute;
import edu.udo.cs.miningmart.m4.core.Case;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Columnset;
import edu.udo.cs.miningmart.m4.core.Operator;
import edu.udo.cs.miningmart.m4.core.Relation;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.schemamatching.EditDistanceMatcher;
import edu.udo.cs.miningmart.schemamatching.MatchingResult;
import edu.udo.cs.miningmart.schemamatching.NgramMatcher;
import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;
import edu.udo.cs.miningmart.schemamatching.SoundexMatcher;
import edu.udo.cs.miningmart.schemamatching.StringBasedSchemaMatcher;
import edu.udo.cs.miningmart.schemamatching.StringEqualityMatcher;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;

public class M4InterfaceImpl
extends M4Interface
implements M4InterfaceContext,
Serializable {
    private DB db;
    private static final String TABLE_NAME = "M4_ACCESS_T";
    private static final String ATTR_ID = "OBJECT_ID";
    private static final String ATTR_TYPE = "OBJECT_TYPE";
    private static final String ATTR_CLIENT = "CLIENT_NAME";
    private static final String ATTR_ACCESS = "ACCESS_TYPE";
    private static final String ACCESS_STRING_WRITE = "WRITE";
    private static final String ACCESS_STRING_READ = "READ";
    private OperatorGroup opGroup;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Operator;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Case;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Concept;

    public M4InterfaceImpl() {
        Level printVerb = Print.DB_READ;
        String printVerbS = System.getProperty("PRINT_VERBOSITY");
        if (printVerbS != null) {
            printVerb = Print.getVerbosityLevelForName(printVerbS);
        }
        print = Print.getGlobalPrintObject();
        print.setMinimumVerbosityLevel(printVerb);
        this.getNewDbConnection();
    }

    public void getNewDbConnection() {
        String dbConfigPath;
        if (this.db != null) {
            try {
                this.db.updateDatabase();
            }
            catch (M4Exception e) {
                System.err.println("Warning: Could not update Database!\n" + e.getMessage());
            }
            this.db.clearM4Cache();
            M4InterfaceImpl.setCurrentCompilerAccess(null);
        }
        if ((dbConfigPath = System.getProperty("DB_CONFIG_PATH")) == null || dbConfigPath.length() == 0) {
            this.getPrintObject().doPrint(Print.MAX, "Fatal error: Could not read System property DB_CONFIG_PATH to set up database connections!!");
            this.db = null;
        } else {
            CompilerDatabaseService d = null;
            try {
                ConfigReader cr = new ConfigReader(dbConfigPath);
                d = new CompilerDatabaseService(cr.getM4Url(), cr.getM4DbName(), cr.getM4User(), cr.getM4Pw(), cr.getBusUrl(), cr.getBusDbName(), cr.getBusUser(), cr.getBusPw(), true, this);
            }
            catch (SQLException e) {
                this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
                System.out.println("SQLException:" + e.getMessage());
            }
            catch (M4Exception m4e) {
                this.getPrintObject().doPrint(Print.ERROR, "Could not connect to DB: " + m4e.getMessage(), m4e);
                System.err.println("Could not connect to DB: " + m4e.getMessage());
            }
            this.db = d;
        }
    }

    public boolean getStopRequest() {
        return false;
    }

    public edu.udo.cs.miningmart.m4.Case getCase() {
        return null;
    }

    public DB getM4db() {
        return this.db;
    }

    public Print getPrintObject() {
        return print;
    }

    public edu.udo.cs.miningmart.m4.Case createCase(String name, boolean setAsCurrentCase) throws M4Exception {
        Case m4case = new Case(this.getM4db());
        m4case.setName(name);
        if (setAsCurrentCase) {
            M4Interface.setCurrentCase(m4case);
        }
        return m4case;
    }

    public edu.udo.cs.miningmart.m4.Operator createOperator(String name) throws M4Exception {
        Operator op = new Operator(this.getM4db());
        op.setName(name);
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllCaseNames() {
        String query = "SELECT ca_name FROM case_t";
        Vector<String> result = null;
        ResultSet rs = null;
        try {
            rs = this.getM4db().executeM4SqlRead(query);
            result = new Vector<String>();
            while (rs.next()) {
                String caseName = rs.getString(1);
                if (caseName == null) continue;
                result.add(caseName);
            }
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
        catch (DbConnectionClosed e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
        finally {
            this.closeResultSet(rs);
        }
        return result;
    }

    public Collection getNamesOfBusinessTablesAndViews() throws M4Exception {
        return this.getM4db().getNamesOfBusSchemaDbObjects();
    }

    public boolean isBusinessTable(String name) throws M4Exception {
        try {
            return this.getM4db().isBusinessTable(name);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error trying to find out if '" + name + "' is a table or view in the business schema: " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("Connection to DB suddenly closed when trying to find out if '" + name + "' is a table or view in the business schema: " + dbc.getMessage());
        }
    }

    public boolean isBusinessView(String name) throws M4Exception {
        try {
            return this.getM4db().isBusinessView(name);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error trying to find out if '" + name + "' is a table or view in the business schema: " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("Connection to DB suddenly closed when trying to find out if '" + name + "' is a table or view in the business schema: " + dbc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsCase(String name) {
        String query = "SELECT COUNT(*)  FROM case_t WHERE ca_name='" + name + "'";
        boolean result = false;
        ResultSet rs = null;
        try {
            rs = this.getM4db().executeM4SqlRead(query);
            if (rs.next()) {
                String counter = rs.getString(1);
                if (Integer.parseInt(counter) == 0) {
                    result = false;
                }
                if (Integer.parseInt(counter) == 1) {
                    result = true;
                }
            }
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
        catch (DbConnectionClosed e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
        finally {
            this.closeResultSet(rs);
        }
        return result;
    }

    private void closeResultSet(ResultSet rs) {
        Print print;
        String msg = DB.closeResultSet(rs);
        if (msg != null && (print = this.getPrintObject()) != null) {
            print.doPrint(Print.MAX, msg);
        }
    }

    public edu.udo.cs.miningmart.m4.Operator findOperator(String name) {
        if (name != null) {
            String query = "SELECT op_id FROM operator_t WHERE OP_NAME = '" + name + "'";
            try {
                Long opId = this.getM4db().executeM4SingleValueSqlReadL(query);
                if (opId != null) {
                    DB db = this.getM4db();
                    Class targetClass = class$edu$udo$cs$miningmart$m4$core$Operator == null ? (class$edu$udo$cs$miningmart$m4$core$Operator = M4InterfaceImpl.class$("edu.udo.cs.miningmart.m4.core.Operator")) : class$edu$udo$cs$miningmart$m4$core$Operator;
                    return (edu.udo.cs.miningmart.m4.Operator)db.getM4Object(opId, targetClass);
                }
            }
            catch (MiningMartException e) {
                this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
            }
            catch (SQLException e) {
                this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
            }
        }
        return null;
    }

    public edu.udo.cs.miningmart.m4.Case findCase(String name, boolean setAsCurrent) {
        if (name != null) {
            String query = "SELECT ca_id FROM case_t WHERE ca_name = '" + name + "'";
            try {
                Long caId = this.getM4db().executeM4SingleValueSqlReadL(query);
                if (caId != null) {
                    DB db = this.getM4db();
                    Class targetClass = class$edu$udo$cs$miningmart$m4$core$Case == null ? (class$edu$udo$cs$miningmart$m4$core$Case = M4InterfaceImpl.class$("edu.udo.cs.miningmart.m4.core.Case")) : class$edu$udo$cs$miningmart$m4$core$Case;
                    edu.udo.cs.miningmart.m4.Case m4case = (edu.udo.cs.miningmart.m4.Case)db.getM4Object(caId, targetClass);
                    if (setAsCurrent) {
                        M4Interface.setCurrentCase(m4case);
                    }
                    return m4case;
                }
            }
            catch (MiningMartException e) {
                this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
            }
            catch (SQLException e) {
                this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllOperatorNames() {
        String query = "SELECT OP_NAME FROM operator_t";
        Vector<String> result = null;
        ResultSet rs = null;
        try {
            rs = this.getM4db().executeM4SqlRead(query);
            result = new Vector<String>();
            while (rs.next()) {
                String opName = rs.getString(1);
                if (opName == null) continue;
                result.add(opName);
            }
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
        catch (DbConnectionClosed e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
        finally {
            this.closeResultSet(rs);
        }
        return result;
    }

    public Collection findConnection(Concept theConcept, Collection namesOfDbObjects, String matcher) throws M4Exception {
        if (theConcept == null || namesOfDbObjects == null) {
            throw new M4Exception("M4 Interface, method 'findConnection': got NULL as first or second parameter!");
        }
        if (!theConcept.getType().equals("DB")) {
            throw new M4Exception("Cannot re-connect concept '" + theConcept.getName() + "' to a table or view, it is not of type DB!");
        }
        Concept tempConWithDbFeatures = (Concept)((Object)this.getM4db().createNewInstance(class$edu$udo$cs$miningmart$m4$Concept == null ? (class$edu$udo$cs$miningmart$m4$Concept = M4InterfaceImpl.class$("edu.udo.cs.miningmart.m4.Concept")) : class$edu$udo$cs$miningmart$m4$Concept));
        tempConWithDbFeatures.setName(theConcept.getName());
        Iterator it = theConcept.getAllBaseAttributes().iterator();
        while (it.hasNext()) {
            BaseAttribute ba = (BaseAttribute)it.next();
            if (!ba.getType().equals("DB")) continue;
            ba.copy(tempConWithDbFeatures);
        }
        StringBasedSchemaMatcher myMatcher = null;
        if (matcher.equals("SimpleMatcher")) {
            myMatcher = new StringEqualityMatcher();
        }
        if (matcher.equals("SoundexMatcher")) {
            myMatcher = new SoundexMatcher();
        }
        if (matcher.equals("EditDistanceMatcher")) {
            myMatcher = new EditDistanceMatcher();
        }
        if (matcher.equals("N-Gram-Matcher")) {
            int valueOfN = 3;
            myMatcher = new NgramMatcher(valueOfN);
        }
        if (myMatcher == null) {
            throw new M4Exception("M4InterfaceImpl.findConnection: got unknown type of matcher ('" + matcher + "')!");
        }
        edu.udo.cs.miningmart.m4.Case tempCase = this.readSchemaToMatch(namesOfDbObjects);
        it = tempCase.getConcepts().iterator();
        Columnset bestMatch = null;
        double bestSimilarity = -1.0;
        MatchingResult[][] myMatchingMatrix = null;
        while (it.hasNext()) {
            Concept candidateForMatching = (Concept)it.next();
            try {
                double candidateSimilarity = myMatcher.getSimilarity(tempConWithDbFeatures, candidateForMatching);
                if (!(candidateSimilarity >= bestSimilarity)) continue;
                bestSimilarity = candidateSimilarity;
                bestMatch = (Columnset)candidateForMatching.getCurrentColumnSet();
                myMatchingMatrix = myMatcher.getSimilarityMatrix(tempConWithDbFeatures, candidateForMatching);
            }
            catch (SchemaMatchException sme) {
                throw new M4Exception("SchemaMatchException caught when comparing concept '" + theConcept.getName() + "' with table '" + candidateForMatching.getName() + "': " + sme.getMessage());
            }
        }
        it = tempCase.getAllRelations().iterator();
        boolean bestMatchIsResultOfJoin = false;
        Concept from = null;
        Concept to = null;
        while (it.hasNext()) {
            Relation candidateRelationForJoin = (Relation)it.next();
            Columnset candidateCs = (Columnset)candidateRelationForJoin.getResultOfJoin();
            Concept candidateForMatching = tempCase.createConceptFromColumnset(candidateCs);
            try {
                double candidateSimilarity = myMatcher.getSimilarity(tempConWithDbFeatures, candidateForMatching);
                if (!(candidateSimilarity >= bestSimilarity)) continue;
                bestSimilarity = candidateSimilarity;
                bestMatch = candidateCs;
                bestMatchIsResultOfJoin = true;
                myMatchingMatrix = myMatcher.getSimilarityMatrix(tempConWithDbFeatures, candidateForMatching);
                from = candidateRelationForJoin.getTheFromConcept();
                to = candidateRelationForJoin.getTheToConcept();
            }
            catch (SchemaMatchException sme) {
                throw new M4Exception("SchemaMatchException caught when comparing concept '" + theConcept.getName() + "' with table '" + candidateForMatching.getName() + "': " + sme.getMessage());
            }
        }
        Columnset myFromCs = null;
        Columnset myToCs = null;
        edu.udo.cs.miningmart.m4.Case currentCase = theConcept.getTheCase();
        if (bestMatchIsResultOfJoin) {
            Concept myFromCopy = from.copy(currentCase);
            Concept myToCopy = to.copy(currentCase);
            myFromCs = (Columnset)from.getCurrentColumnSet().copy(myFromCopy);
            myToCs = (Columnset)to.getCurrentColumnSet().copy(myToCopy);
            myFromCopy.deleteSoon();
            myToCopy.deleteSoon();
            this.getM4db().createSQLView(bestMatch);
        }
        tempCase.deleteSoon();
        if (bestMatch == null) {
            throw new M4Exception("M4InterfaceImpl.findConnection: Could not match concept '" + theConcept.getName() + "' to any of the given DB objects, nor to the result of a join among them!");
        }
        theConcept.setColumnSets(new Vector());
        Columnset csForTheConcept = (Columnset)bestMatch.copy(theConcept);
        while (myMatchingMatrix.length > 0 && myMatchingMatrix[0].length > 0) {
            double bestOfAllMatchingSimilarities = -1.0;
            int bestRow = 0;
            int bestColumn = 0;
            int currentNoOfRows = myMatchingMatrix.length;
            int noOfColumns = myMatchingMatrix[0].length;
            for (int n = 0; n < myMatchingMatrix.length; ++n) {
                for (int m = 0; m < myMatchingMatrix[n].length; ++m) {
                    if (!(myMatchingMatrix[n][m].getSimilarity() >= bestOfAllMatchingSimilarities)) continue;
                    bestOfAllMatchingSimilarities = myMatchingMatrix[n][m].getSimilarity();
                    bestRow = n;
                    bestColumn = m;
                }
            }
            MatchingResult result = myMatchingMatrix[bestRow][bestColumn];
            BaseAttribute baToMatch = (BaseAttribute)tempConWithDbFeatures.getBaseAttribute(result.getBaOfFirstSchema().getName());
            Column matchCandidate = (Column)result.getBaOfSecondSchema().getCurrentColumn();
            BaseAttribute baToConnect = (BaseAttribute)theConcept.getBaseAttribute(baToMatch.getName());
            Column colToConnect = (Column)csForTheConcept.getColumn(matchCandidate.getName());
            baToConnect.removeLinkToColumns();
            baToConnect.addColumn(colToConnect);
            MatchingResult[][] newMatrix = new MatchingResult[currentNoOfRows - 1][noOfColumns - 1];
            int rowIndexForNewMatrix = 0;
            for (int n = 0; n < myMatchingMatrix.length; ++n) {
                int colIndexForNewMatrix = 0;
                if (n == bestRow) continue;
                for (int m = 0; m < myMatchingMatrix[n].length; ++m) {
                    if (m == bestColumn) continue;
                    newMatrix[rowIndexForNewMatrix][colIndexForNewMatrix] = myMatchingMatrix[n][m];
                    ++colIndexForNewMatrix;
                }
                ++rowIndexForNewMatrix;
            }
            myMatchingMatrix = newMatrix;
        }
        tempConWithDbFeatures.deleteSoon();
        bestMatch.deleteSoon();
        if (bestMatchIsResultOfJoin) {
            Vector<Columnset> ret = new Vector<Columnset>();
            ret.add(myFromCs);
            ret.add(myToCs);
            return ret;
        }
        return null;
    }

    private edu.udo.cs.miningmart.m4.Case readSchemaToMatch(Collection tableNames) throws M4Exception {
        try {
            if (tableNames != null) {
                boolean setAsCurrentCase = false;
                edu.udo.cs.miningmart.m4.Case newCase = this.createCase("__TemporaryCaseWithSchemaToMatch", setAsCurrentCase);
                Iterator namesIt = tableNames.iterator();
                boolean conceptsCreated = false;
                while (namesIt.hasNext()) {
                    String tableName = (String)namesIt.next();
                    if (tableName.indexOf("$") != -1 || this.conceptExistsInCase(newCase, tableName)) continue;
                    if (!this.checkForManyToManyRelation(tableName, newCase)) {
                        newCase.createConceptAndRelationsFromTables(tableName);
                    }
                    conceptsCreated = true;
                }
                if (conceptsCreated) {
                    return newCase;
                }
                return null;
            }
            return null;
        }
        catch (M4Exception e) {
            throw new M4Exception("M4 error when trying to create a temporary Case representing a part of the business schema: " + e.getMessage());
        }
    }

    private boolean conceptExistsInCase(edu.udo.cs.miningmart.m4.Case theCase, String nameOfConcept) throws M4Exception {
        Iterator namesIt = theCase.getAllConceptNames().iterator();
        while (namesIt.hasNext()) {
            String oneConceptName = (String)namesIt.next();
            if (!oneConceptName.equalsIgnoreCase(nameOfConcept)) continue;
            return true;
        }
        return false;
    }

    private boolean checkForManyToManyRelation(String dbTableName, edu.udo.cs.miningmart.m4.Case theCase) throws M4Exception {
        try {
            if (this.getM4db().isCrossTable(dbTableName)) {
                theCase.createManyToManyRelationsFromCrossTable(dbTableName);
                return true;
            }
            return false;
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error occurred when trying to see if '" + dbTableName + "' is a cross table: " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("Suddenly closed connection to DB when trying to see if '" + dbTableName + "' is a cross table: " + dbc.getMessage());
        }
    }

    private Collection readAccessClients(String caseName) throws SQLException {
        String query = "SELECT CLIENT_NAME FROM M4_ACCESS_T WHERE OBJECT_ID = '" + caseName + "'" + " AND " + ATTR_TYPE + " = 'CASE'" + " AND " + ATTR_ACCESS + " = '" + ACCESS_STRING_READ + "'";
        return this.resultCollection(query);
    }

    private Collection writeAccessClients(String caseName) throws SQLException {
        String query = "SELECT CLIENT_NAME FROM M4_ACCESS_T WHERE OBJECT_ID = '" + caseName + "'" + " AND " + ATTR_TYPE + " = 'CASE'" + " AND " + ATTR_ACCESS + " = '" + ACCESS_STRING_WRITE + "'";
        return this.resultCollection(query);
    }

    private Collection resultCollection(String query) throws SQLException {
        Vector<String> result = new Vector<String>();
        ResultSet rs = null;
        try {
            String name;
            rs = this.getM4db().executeM4SqlRead(query);
            while (rs.next() && (name = rs.getString(1)) != null) {
                result.add(name);
            }
        }
        catch (DbConnectionClosed e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            this.closeResultSet(rs);
        }
        return result;
    }

    private void addM4AccessTuple(String caseName, String client, boolean forWriting) {
        String query = "INSERT INTO M4_ACCESS_T ( OBJECT_ID, OBJECT_TYPE, CLIENT_NAME, ACCESS_TYPE ) VALUES ( '" + caseName + "', 'CASE', '" + client + "', '" + (forWriting ? ACCESS_STRING_WRITE : ACCESS_STRING_READ) + "' )";
        try {
            this.getM4db().executeM4SqlWrite(query);
        }
        catch (DbConnectionClosed e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
    }

    private void removeM4AccessTuple(String caseName, String client) {
        String query = "DELETE FROM M4_ACCESS_T WHERE OBJECT_ID = '" + caseName + "'" + " AND " + ATTR_TYPE + " = 'CASE'" + " AND " + ATTR_CLIENT + " = '" + client + "'";
        try {
            this.getM4db().executeM4SqlWrite(query);
        }
        catch (DbConnectionClosed e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
    }

    public boolean canRemoveM4Access(String caseName) {
        try {
            if (this.isCaseLockedForReading(caseName)) {
                Collection writeClients = this.writeAccessClients(caseName);
                return writeClients.contains(this.getUserName()) && writeClients.size() == 1;
            }
            if (this.isCaseLockedForWriting(caseName)) {
                Collection readClients = this.readAccessClients(caseName);
                return readClients.contains(this.getUserName()) && readClients.size() == 1;
            }
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
        return false;
    }

    public boolean isCaseLockedForReading(String caseName) {
        try {
            Collection c = this.writeAccessClients(caseName);
            return c != null && c.size() > 0;
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
            return true;
        }
    }

    public boolean isCaseLockedForWriting(String caseName) {
        try {
            if (this.isCaseLockedForReading(caseName)) {
                return true;
            }
            Collection c = this.readAccessClients(caseName);
            return c != null && c.size() > 0;
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
            return true;
        }
    }

    public edu.udo.cs.miningmart.m4.Case findCaseForReadOnlyAccess(String name, boolean setAsCurrent) throws M4Interface.CaseLockedException {
        if (!this.isCaseLockedForReading(name)) {
            this.addM4AccessTuple(name, this.getUserName(), false);
            return this.findCase(name, setAsCurrent);
        }
        throw new M4Interface.CaseLockedException();
    }

    public edu.udo.cs.miningmart.m4.Case findCaseForUpdate(String name, boolean setAsCurrent) throws M4Interface.CaseLockedException {
        if (!this.isCaseLockedForWriting(name)) {
            this.addM4AccessTuple(name, this.getUserName(), true);
            return this.findCase(name, setAsCurrent);
        }
        throw new M4Interface.CaseLockedException();
    }

    public void releaseCase(String name) {
        try {
            this.removeM4AccessTuple(name, this.getUserName());
            edu.udo.cs.miningmart.m4.Case m4case = this.findCase(name, false);
            if (m4case == null) {
                m4case = M4InterfaceImpl.getCurrentCase();
            }
            if (m4case != null) {
                ((Case)m4case).store();
            }
            this.getM4db().clearM4Cache();
        }
        catch (M4Exception e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage(), e);
        }
    }

    public void releaseCaseWithoutStoring(String name) {
        this.removeM4AccessTuple(name, this.getUserName());
        try {
            this.getM4db().commitM4Transactions();
        }
        catch (DbConnectionClosed bdc) {
            this.getPrintObject().doPrint(Print.ERROR, bdc.getMessage());
        }
        catch (SQLException e) {
            this.getPrintObject().doPrint(Print.ERROR, e.getMessage());
        }
        this.getM4db().clearM4Cache();
    }

    private String getUserName() {
        return System.getProperty("user.name");
    }

    public OperatorGroup getOperatorGroup() {
        if (this.opGroup != null) {
            return this.opGroup;
        }
        DB db = this.getM4db();
        if (db != null) {
            try {
                this.opGroup = new edu.udo.cs.miningmart.m4.core.OperatorGroup(db);
            }
            catch (Exception e) {
                if (M4InterfaceImpl.getCurrentCase() != null) {
                    ((Case)M4InterfaceImpl.getCurrentCase()).doPrint(e);
                }
                System.err.println("M4InterfaceImpl.getOperatorGroup():\n");
                e.printStackTrace();
            }
        }
        return this.opGroup;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

