/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.ParameterNotFoundException;
import edu.udo.cs.miningmart.exception.XmlException;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.core.BaseAttribute;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Coordinates;
import edu.udo.cs.miningmart.m4.core.Docu;
import edu.udo.cs.miningmart.m4.core.M4Object;
import edu.udo.cs.miningmart.m4.core.Value;
import edu.udo.cs.miningmart.m4.utils.HasCrossReferences;
import edu.udo.cs.miningmart.m4.utils.InterM4DataToDocu;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.M4Table;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public abstract class M4Data
extends M4Object
implements M4Table {
    protected Docu myDocumentation = null;
    private boolean documentationLoaded = false;
    static InterM4DataToDocu m4o2doc = new InterM4DataToDocu();
    private boolean isWaitingForDelete;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Value;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Case;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$M4Data;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$M4Data;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Concept;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$BaseAttribute;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$ParameterObject;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Docu;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Parameter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Double;

    public M4Data(DB m4Db) {
        super(m4Db);
        this.setDirty();
    }

    public void readFromDb() throws M4Exception {
        ResultSet rs;
        block6: {
            Collection m4Infos = this.getM4Info().getInfos();
            String idAttribute = this.getIdAttributeName();
            rs = null;
            try {
                rs = this.executeM4SqlRead(this.createQueryForLoading());
                if (rs.next()) {
                    Iterator it = m4Infos.iterator();
                    while (it.hasNext()) {
                        M4InfoEntry entry = (M4InfoEntry)it.next();
                        if (entry.getDbAttribute().equalsIgnoreCase(idAttribute)) continue;
                        entry.activateSetter(this, rs, this.getM4Db());
                    }
                    break block6;
                }
                throw new ParameterNotFoundException(this.createLoadDescription() + "Object not found !");
            }
            catch (SQLException e) {
                try {
                    throw new M4Exception(this.createLoadDescription() + "SQLException\n" + e.getMessage());
                }
                catch (Throwable throwable) {
                    DB.closeResultSet(rs);
                    throw throwable;
                }
            }
        }
        DB.closeResultSet(rs);
        this.readFromDbLocal();
        this.removeDirtyFlag();
    }

    protected void readFromDbLocal() throws M4Exception {
    }

    public boolean isDirty() {
        HashSet tablesSet = DB.getDirtyObjectsForTable(this.getM4TableName());
        return tablesSet.contains(this);
    }

    public boolean isWaitingForDelete() {
        return this.isWaitingForDelete;
    }

    protected void setDirty() {
        if (!this.isWaitingForDelete()) {
            HashSet tablesSet = DB.getDirtyObjectsForTable(this.getM4TableName());
            tablesSet.add(this);
        }
    }

    private void removeDirtyFlag() {
        HashSet tablesSet = DB.getDirtyObjectsForTable(this.getM4TableName());
        tablesSet.remove(this);
    }

    public void setId(long newId) throws M4Exception {
        this.setDirty();
        super.setId(newId);
    }

    public void setName(String n) {
        this.setDirty();
        super.setName(n);
    }

    protected abstract Collection getObjectsInNamespace(Class var1) throws M4Exception;

    public String getValidName(String name, Class typeOfNamedObject) throws M4Exception {
        if (typeOfNamedObject.isAssignableFrom(class$edu$udo$cs$miningmart$m4$core$Value == null ? (class$edu$udo$cs$miningmart$m4$core$Value = M4Data.class$("edu.udo.cs.miningmart.m4.core.Value")) : class$edu$udo$cs$miningmart$m4$core$Value)) {
            return name;
        }
        Collection<String> theNameCollection = new Vector();
        if (typeOfNamedObject.isAssignableFrom(class$edu$udo$cs$miningmart$m4$core$Case == null ? (class$edu$udo$cs$miningmart$m4$core$Case = M4Data.class$("edu.udo.cs.miningmart.m4.core.Case")) : class$edu$udo$cs$miningmart$m4$core$Case)) {
            theNameCollection = M4Interface.getInstance().getAllCaseNames();
        } else {
            Collection allRelevantObjects = this.getObjectsInNamespace(typeOfNamedObject);
            if (allRelevantObjects == null) {
                throw new M4Exception("Cannot ensure name uniqueness for M4 object with temporary name '" + name + "': probably wrong type of object!");
            }
            Iterator it = allRelevantObjects.iterator();
            while (it.hasNext()) {
                M4Data theObject = (M4Data)it.next();
                theNameCollection.add(theObject.getName());
            }
        }
        String newName = name;
        boolean nameIsUnique = false;
        int suffix = 0;
        block1: while (!nameIsUnique) {
            ++suffix;
            Iterator it = theNameCollection.iterator();
            nameIsUnique = true;
            while (it.hasNext()) {
                String oneName = (String)it.next();
                if (oneName == null || !oneName.equalsIgnoreCase(newName)) continue;
                nameIsUnique = false;
                newName = name + suffix;
                continue block1;
            }
        }
        return newName;
    }

    public void deleteSoon() throws M4Exception {
        this.removeAllM4References();
        if (!this.isWaitingForDelete()) {
            this.setDirty();
            this.isWaitingForDelete = true;
        }
    }

    protected abstract void removeAllM4References() throws M4Exception;

    public Collection getObjectsReferencingMe(Class theClass) throws M4Exception {
        if (theClass == null || !(class$edu$udo$cs$miningmart$m4$M4Data == null ? (class$edu$udo$cs$miningmart$m4$M4Data = M4Data.class$("edu.udo.cs.miningmart.m4.M4Data")) : class$edu$udo$cs$miningmart$m4$M4Data).isAssignableFrom(theClass) && !(class$edu$udo$cs$miningmart$m4$core$M4Data == null ? (class$edu$udo$cs$miningmart$m4$core$M4Data = M4Data.class$("edu.udo.cs.miningmart.m4.core.M4Data")) : class$edu$udo$cs$miningmart$m4$core$M4Data).isAssignableFrom(theClass)) {
            throw new M4Exception("M4Data.getObjectsReferencingMe(Class): Found incompatible class " + (theClass.getName() == null ? "<null>" : theClass.getName()));
        }
        M4Data tmp = (M4Data)this.getM4Db().createNewInstance(theClass);
        Collection ret = tmp.getObjectsReferencing(this);
        tmp.deleteSoon();
        return ret;
    }

    public Collection getObjectsReferencingMe(Class theClass, String foreignKey) throws M4Exception {
        if (theClass == null || !(class$edu$udo$cs$miningmart$m4$M4Data == null ? (class$edu$udo$cs$miningmart$m4$M4Data = M4Data.class$("edu.udo.cs.miningmart.m4.M4Data")) : class$edu$udo$cs$miningmart$m4$M4Data).isAssignableFrom(theClass) && !(class$edu$udo$cs$miningmart$m4$core$M4Data == null ? (class$edu$udo$cs$miningmart$m4$core$M4Data = M4Data.class$("edu.udo.cs.miningmart.m4.core.M4Data")) : class$edu$udo$cs$miningmart$m4$core$M4Data).isAssignableFrom(theClass)) {
            throw new M4Exception("M4Data.getObjectsReferencingMe(Class): Found incompatible class " + (theClass.getName() == null ? "<null>" : theClass.getName()));
        }
        M4Data tmp = (M4Data)this.getM4Db().createNewInstance(theClass);
        Collection ret = tmp.getObjectsReferencing(this, foreignKey);
        tmp.deleteSoon();
        return ret;
    }

    private Collection getObjectsReferencing(M4Data m4d) throws M4Exception {
        String query = this.crossTableQuery(this.getM4TableName(), m4d);
        if (query == null) {
            M4InfoEntry fkEntry = this.findMatchingForeignKey(m4d.getClass());
            return this.getObjectsReferencing(m4d, fkEntry.getDbAttribute());
        }
        return this.readM4ObjectsFromDb(query);
    }

    private Collection getObjectsReferencing(M4Data m4d, String foreignKey) throws M4Exception {
        String query = "SELECT " + this.getIdAttributeName() + " FROM " + this.getM4TableName() + " WHERE " + foreignKey + " = " + m4d.getId();
        return this.readM4ObjectsFromDb(query);
    }

    private Collection readM4ObjectsFromDb(String query) throws M4Exception {
        Vector<M4Data> result = new Vector<M4Data>();
        DB db = this.getM4Db();
        ResultSet rs = null;
        try {
            rs = this.executeM4SqlRead(query);
            while (rs.next()) {
                long id = rs.getLong(1);
                if (rs.wasNull()) continue;
                try {
                    M4Data m = (M4Data)db.getM4Object(id, this.getClass());
                    if (m == null) continue;
                    result.add(m);
                }
                catch (ParameterNotFoundException e) {
                    super.doPrint(e);
                }
            }
        }
        catch (SQLException e) {
            throw new M4Exception(this.getClass().getName() + ".getObjectsReferencing(M4Data):" + " SQLException when trying to read IDs of referencing objects from DB!\n" + e.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
        return result;
    }

    private M4InfoEntry findMatchingForeignKey(Class targetClass) throws M4Exception {
        M4InfoEntry fkEntry = null;
        Iterator it = this.getM4Info().getInfos().iterator();
        while (it.hasNext()) {
            M4InfoEntry entry = (M4InfoEntry)it.next();
            if (!entry.getTheObjectClass().isAssignableFrom(targetClass)) continue;
            if (fkEntry != null) {
                throw new M4Exception(this.getClass().getName() + ".findMatchingForeignKey(M4Data):" + " Found two possible foreign key references to the specified object" + " in the M4Table specification of this class!");
            }
            fkEntry = entry;
        }
        if (fkEntry == null) {
            throw new M4Exception(this.getClass().getName() + ".findMatchingForeignKey(M4Data):" + " No foreign key references to the specified object" + " found in the M4Table specification of this class!");
        }
        return fkEntry;
    }

    private String crossTableQuery(String baseTableName, M4Data referenced) {
        String query = null;
        if (baseTableName.equals("baseattrib_t") && (class$edu$udo$cs$miningmart$m4$core$Concept == null ? (class$edu$udo$cs$miningmart$m4$core$Concept = M4Data.class$("edu.udo.cs.miningmart.m4.core.Concept")) : class$edu$udo$cs$miningmart$m4$core$Concept).isInstance(referenced)) {
            query = "SELECT bc_baid FROM ba_concept_t WHERE bc_conid = " + referenced.getId();
        } else if (baseTableName.equals("column_t") && (class$edu$udo$cs$miningmart$m4$core$BaseAttribute == null ? (class$edu$udo$cs$miningmart$m4$core$BaseAttribute = M4Data.class$("edu.udo.cs.miningmart.m4.core.BaseAttribute")) : class$edu$udo$cs$miningmart$m4$core$BaseAttribute).isInstance(referenced)) {
            query = "SELECT bac_colid FROM ba_column_t WHERE bac_baid = " + referenced.getId();
        } else if (baseTableName.equals("parameter_t") && (class$edu$udo$cs$miningmart$m4$core$ParameterObject == null ? (class$edu$udo$cs$miningmart$m4$core$ParameterObject = M4Data.class$("edu.udo.cs.miningmart.m4.core.ParameterObject")) : class$edu$udo$cs$miningmart$m4$core$ParameterObject).isInstance(referenced)) {
            query = "SELECT par_id FROM parameter_t WHERE par_objid = " + referenced.getId();
        }
        return query;
    }

    public void genericSetter(String nameOfSetter, Class parameterClassOfSetter, Object objectToSet) throws M4Exception {
        Class[] methodParArray = new Class[]{parameterClassOfSetter};
        Object[] parameters = new Object[]{objectToSet};
        try {
            Method method = null;
            Class<?> myClass = this.getClass();
            while (method == null) {
                try {
                    method = myClass.getDeclaredMethod(nameOfSetter, methodParArray);
                }
                catch (NoSuchMethodException e) {
                    if ((myClass = myClass.getSuperclass()) != null) continue;
                    throw new M4Exception(e.getMessage());
                }
            }
            method.invoke((Object)this, parameters);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof M4Exception) {
                throw (M4Exception)targetException;
            }
            throw new M4Exception("Unexpected InvocationTargetException in M4Data.genericSetter:\n" + e.getClass().getName() + " as target Exception with message\n" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new M4Exception("IllegalAccessException in M4Data.genericSetter:\n" + e.getMessage());
        }
    }

    public Object genericGetter(String nameOfGetter) throws M4Exception {
        Class[] methodParArray = new Class[]{};
        try {
            Method method = null;
            Class<?> myClass = this.getClass();
            while (method == null) {
                try {
                    method = myClass.getDeclaredMethod(nameOfGetter, methodParArray);
                }
                catch (NoSuchMethodException e) {
                    if ((myClass = myClass.getSuperclass()) != null) continue;
                    throw new M4Exception(e.getMessage());
                }
            }
            return method.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof M4Exception) {
                throw (M4Exception)targetException;
            }
            throw new M4Exception("Unexpected InvocationTargetException in M4Data.genericGetter:\n" + e.getClass().getName() + " as target Exception with message\n" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new M4Exception("IllegalAccessException in M4Data.genericGetter:\n" + e.getMessage());
        }
    }

    private String createQueryForLoading() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.getM4Info().getInfos().iterator();
        while (it.hasNext()) {
            M4InfoEntry entry = (M4InfoEntry)it.next();
            sb.append(entry.getDbAttribute() + ", ");
        }
        String attributes = sb.substring(0, sb.length() - 2);
        String query = "SELECT " + attributes + " FROM " + this.getM4TableName() + " WHERE " + this.getIdAttributeName() + " = " + this.getId();
        return query;
    }

    private String createLoadDescription() {
        return this.getClass().getName() + ".load(" + this.getId() + "): ";
    }

    public String getDocumentation() throws M4Exception {
        Docu docu;
        if (!this.documentationLoaded && !this.isNew()) {
            this.documentationLoaded = true;
            Iterator it = this.getObjectsReferencingMe(class$edu$udo$cs$miningmart$m4$core$Docu == null ? (class$edu$udo$cs$miningmart$m4$core$Docu = M4Data.class$("edu.udo.cs.miningmart.m4.core.Docu")) : class$edu$udo$cs$miningmart$m4$core$Docu, "doc_objid").iterator();
            if (it.hasNext()) {
                this.setDocObject((Docu)it.next());
            }
        }
        return (docu = this.primitiveGetDocObject()) == null ? null : docu.getText();
    }

    public void setDocumentation(String text) throws M4Exception {
        this.getDocumentation();
        Docu docu = this.primitiveGetDocObject();
        if (docu == null) {
            docu = new Docu(this.getM4Db());
            this.setDocObject(docu);
        }
        docu.setText(text);
    }

    public Docu primitiveGetDocObject() {
        return this.myDocumentation;
    }

    public void primitiveSetDocObject(Docu doc) {
        this.myDocumentation = doc;
    }

    private void setDocObject(Docu doc) throws M4Exception {
        m4o2doc.setReciprocalReferences(this, doc);
    }

    protected void removeDocObject() throws M4Exception {
        m4o2doc.removeReferences(this, this.myDocumentation);
    }

    protected void storeLocal() throws M4Exception {
    }

    protected void deleteLocal() throws M4Exception {
    }

    public static Collection updateObjectsFromTable(String dbTableName) throws M4Exception {
        HashSet<M4Data> ret = new HashSet<M4Data>();
        while (!DB.getDirtyObjectsForTable(dbTableName).isEmpty()) {
            Vector dirtyObjects = new Vector(DB.getDirtyObjectsForTable(dbTableName));
            boolean cyclic = true;
            Iterator it = dirtyObjects.iterator();
            while (it.hasNext()) {
                M4Data current = (M4Data)it.next();
                if (!current.isDirty()) continue;
                Collection crossReferences = null;
                boolean foundDirty = false;
                if (current instanceof HasCrossReferences) {
                    crossReferences = ((HasCrossReferences)((Object)current)).getCrossReferences();
                }
                if (crossReferences != null && !crossReferences.isEmpty()) {
                    Iterator crossIt = crossReferences.iterator();
                    while (crossIt.hasNext() && !foundDirty) {
                        foundDirty = dirtyObjects.contains(crossIt.next());
                    }
                }
                if (foundDirty) continue;
                current.save();
                current.removeDirtyFlag();
                if (current.isWaitingForDelete()) {
                    ret.add(current);
                }
                cyclic = false;
            }
            if (!cyclic) continue;
            throw new M4Exception("M4Data.updataDatabase(): Could not store the objects of table '" + dbTableName + "' because of cyclic cross dependencies!");
        }
        return ret;
    }

    public static void removeSetFromDb(Collection objectsToDelete) throws M4Exception {
        Iterator it = objectsToDelete.iterator();
        while (it.hasNext()) {
            ((M4Data)it.next()).removeFromDb();
        }
    }

    private void save() throws M4Exception {
        boolean success = true;
        if (this.isNew() && this.getId() == 0L) {
            success = this.storeByInsert();
        } else {
            this.storeByUpdate();
        }
        if (success) {
            this.storeLocal();
        }
    }

    public void removeFromDb() throws M4Exception {
        this.deleteLocal();
        if (this.isNew() && this.getId() == 0L) {
            this.getM4Db().removeM4ObjectFromCache(this);
            return;
        }
        String sql = "DELETE FROM " + this.getM4TableName() + " WHERE " + this.getIdAttributeName() + " = " + this.getId();
        this.executeM4SqlWrite(sql);
        this.getM4Db().removeM4ObjectFromCache(this);
    }

    private boolean storeByInsert() throws M4Exception {
        M4InfoEntry entry;
        if (this.isWaitingForDelete()) {
            this.isWaitingForDelete = false;
            return false;
        }
        this.setId(this.getNextM4SequenceValue());
        Collection m4infoCol = this.getM4Info().getInfos();
        String tableName = this.getM4TableName();
        StringBuffer sql = new StringBuffer("INSERT INTO " + tableName + " ( ");
        Iterator it = m4infoCol.iterator();
        while (it.hasNext()) {
            entry = (M4InfoEntry)it.next();
            sql.append(entry.getDbAttribute());
            sql.append(", ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(" ) VALUES ( ");
        it = m4infoCol.iterator();
        while (it.hasNext()) {
            entry = (M4InfoEntry)it.next();
            String value = this.getValueFor(entry);
            if (entry.isNotNull() && (value == null || value.equals("''"))) {
                this.doPrint(Print.M4_OBJECT, "Found <null> value for NOT NULL attribute. I will not insert this tuple:\nClass: " + this.getClass().getName() + ", ID: " + this.getId() + ", Name: " + (this.getName() == null ? "<null>" : this.getName()));
                this.removeAllM4References();
                return false;
            }
            sql.append(value == null ? "NULL" : value);
            sql.append(", ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(" )");
        this.executeM4SqlWrite(sql.toString());
        this.getM4Db().putM4ObjectToCache(this);
        return true;
    }

    private void storeByUpdate() throws M4Exception {
        if (this instanceof Coordinates) {
            ((Coordinates)this).store();
            return;
        }
        String idAttrib = this.getIdAttributeName();
        StringBuffer sql = new StringBuffer("UPDATE " + this.getM4TableName() + " SET ");
        Iterator it = this.getM4Info().getInfos().iterator();
        boolean notEmpty = false;
        while (it.hasNext()) {
            M4InfoEntry entry = (M4InfoEntry)it.next();
            if (idAttrib.equals(entry.getDbAttribute())) continue;
            String value = this.getValueFor(entry);
            if (entry.isNotNull() && (value == null || value.equals("''"))) {
                if (this.isWaitingForDelete()) continue;
                this.doPrint(Print.M4_OBJECT, "Removing tuple to avoid database inconsistencies:\nClass: " + this.getClass().getName() + ", ID: " + this.getId() + ", Name: " + (this.getName() == null ? "<null>" : this.getName()));
                this.removeAllM4References();
                this.isWaitingForDelete = true;
                continue;
            }
            sql.append(entry.getDbAttribute() + " = ");
            sql.append(value == null ? "NULL" : value);
            sql.append(", ");
            notEmpty = true;
        }
        if (notEmpty) {
            int length = sql.length();
            sql.delete(length - 2, length);
            sql.append(" WHERE " + idAttrib + " = " + this.getId());
            this.executeM4SqlWrite(sql.toString());
        }
    }

    public boolean hasDeleteStatus() throws M4Exception {
        Column col;
        BaseAttribute ba;
        String idAttrib = this.getIdAttributeName();
        Iterator it = this.getM4Info().getInfos().iterator();
        while (it.hasNext()) {
            M4InfoEntry entry = (M4InfoEntry)it.next();
            if (idAttrib.equals(entry.getDbAttribute())) continue;
            String value = this.getValueFor(entry);
            if (!entry.isNotNull() || value != null && !value.equals("''")) continue;
            return true;
        }
        if (this instanceof BaseAttribute && (ba = (BaseAttribute)this).getConcept() == null) {
            return true;
        }
        if (this instanceof Column && (col = (Column)this).getTheBaseAttribute() == null) {
            return true;
        }
        if (this instanceof Value && !this.isNew()) {
            Collection params = this.getObjectsReferencingMe(class$edu$udo$cs$miningmart$m4$core$Parameter == null ? (class$edu$udo$cs$miningmart$m4$core$Parameter = M4Data.class$("edu.udo.cs.miningmart.m4.core.Parameter")) : class$edu$udo$cs$miningmart$m4$core$Parameter, "par_objid");
            if ((params == null || params.isEmpty()) && ((params = ((Value)this).getParameterReferences()) == null || params.isEmpty())) {
                return true;
            }
        }
        return false;
    }

    private String getValueFor(M4InfoEntry entry) throws M4Exception {
        Object obj = this.genericGetter(entry.getGetter());
        Class type = entry.getTheObjectClass();
        if (obj == null) {
            return null;
        }
        if ((class$edu$udo$cs$miningmart$m4$M4Data == null ? (class$edu$udo$cs$miningmart$m4$M4Data = M4Data.class$("edu.udo.cs.miningmart.m4.M4Data")) : class$edu$udo$cs$miningmart$m4$M4Data).isAssignableFrom(type)) {
            if ((class$edu$udo$cs$miningmart$m4$M4Data == null ? (class$edu$udo$cs$miningmart$m4$M4Data = M4Data.class$("edu.udo.cs.miningmart.m4.M4Data")) : class$edu$udo$cs$miningmart$m4$M4Data).isInstance(obj)) {
                long objId = ((M4Data)obj).getId();
                return Long.toString(objId);
            }
            throw new M4Exception("The generic getter " + entry.getGetter() + " returned an object of type " + obj.getClass().getName() + " where an object of type " + type.getClass().getName() + " was expected!");
        }
        if (type.equals(class$java$lang$String == null ? (class$java$lang$String = M4Data.class$("java.lang.String")) : class$java$lang$String)) {
            return DB.quote((String)obj);
        }
        if (type.equals(Long.TYPE) || type.equals(class$java$lang$Long == null ? (class$java$lang$Long = M4Data.class$("java.lang.Long")) : class$java$lang$Long)) {
            return ((Long)obj).toString();
        }
        if (type.equals(Integer.TYPE) || type.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = M4Data.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return ((Integer)obj).toString();
        }
        if (type.equals(Short.TYPE) || type.equals(class$java$lang$Short == null ? (class$java$lang$Short = M4Data.class$("java.lang.Short")) : class$java$lang$Short)) {
            return ((Short)obj).toString();
        }
        if (type.equals(Double.TYPE) || type.equals(class$java$lang$Double == null ? (class$java$lang$Double = M4Data.class$("java.lang.Double")) : class$java$lang$Double)) {
            return ((Double)obj).toString();
        }
        throw new M4Exception("Unsupported object type in M4InfoEntry for attribute " + entry.getDbAttribute() + " found: " + type.getClass().getName() + "\nClass is " + this.getClass().getName());
    }

    public String getXmlVersion() {
        return "M4-XML V0.5";
    }

    public String getXmlIdTag() {
        return "XmlId";
    }

    public String getObjectTag() {
        Class<?> objClass = this.getClass();
        if (objClass == null) {
            return null;
        }
        String className = objClass.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public Collection getDependentObjects() throws M4Exception {
        Vector<Docu> dependent = new Vector<Docu>();
        Docu docu = this.primitiveGetDocObject();
        if (docu != null) {
            dependent.add(docu);
        }
        return dependent;
    }

    public Collection exportLocal(Writer out, Collection dependent) throws M4Exception, IOException {
        return null;
    }

    public void importLocal(String tag, String embedded) throws XmlException, M4Exception {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

