/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.Coordinates;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.utils.InterM4GraphicalObjectToCoordinates;
import edu.udo.cs.miningmart.m4.utils.InterM4ObjectToObject;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.awt.Point;
import java.util.Collection;

public abstract class GraphicalM4Object
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.GraphicalM4Object {
    private Coordinates myCoordinates;
    private boolean coordinatesLoaded = false;
    public static InterM4ObjectToObject graph2coord = new InterM4GraphicalObjectToCoordinates();

    public GraphicalM4Object(DB m4Db) {
        super(m4Db);
    }

    protected abstract boolean hasCoordinates();

    public void print() {
        Coordinates cc = null;
        try {
            if (this.hasCoordinates()) {
                cc = this.getCoordinates();
            }
        }
        catch (M4Exception m4e) {
            this.doPrint(m4e);
            return;
        }
        if (cc == null) {
            this.doPrint(Print.M4_OBJECT, "M4 Object '" + this.getName() + "' has no graphical info stored with it.");
        } else {
            Point p = null;
            try {
                p = cc.getLocation();
            }
            catch (M4Exception m4e) {
                this.doPrint(Print.MAX, "Error in print method of GraphicalM4Object: " + m4e.getMessage());
            }
            this.doPrint(Print.M4_OBJECT, "Graphical info for M4 object '" + this.getName() + "': X: " + p.x + ", Y: " + p.y + ".");
        }
    }

    public void primitiveSetCoordinates(Coordinates cc) {
        this.setDirty();
        this.myCoordinates = cc;
    }

    public void setName(String name) {
        super.setName(name);
        try {
            this.setCoordinatesDirty();
        }
        catch (M4Exception m4e) {
            System.err.println("WARNING: GraphicalM4Object.setName(): could not load coordinates of M4 object '" + name + "'!");
        }
    }

    public void setCoordinatesDirty() throws M4Exception {
        Coordinates cc;
        if (this.hasCoordinates() && (cc = this.getCoordinates()) != null) {
            cc.setDirty();
        }
    }

    protected void storeLocal() throws M4Exception {
        Coordinates cc;
        if (this.hasCoordinates() && (cc = this.getCoordinates()) != null && cc.isDirty()) {
            cc.store();
        }
    }

    protected void deleteLocal() throws M4Exception {
        Coordinates cc;
        if (this.hasCoordinates() && (cc = this.getCoordinates()) != null && cc.isDirty()) {
            cc.delete();
        }
    }

    public void deleteSoon() throws M4Exception {
        Coordinates cc;
        if (this.hasCoordinates() && (cc = this.getCoordinates()) != null) {
            cc.delete();
        }
        graph2coord.setReciprocalReferences(this, null);
        super.deleteSoon();
    }

    public void setPoint(Point location) throws M4Exception {
        this.getCoordinates().setLocation(location);
    }

    public Point getPoint() throws M4Exception {
        return this.getCoordinates().getLocation();
    }

    public Coordinates getCoordinates() throws M4Exception {
        if (!this.hasCoordinates()) {
            return null;
        }
        if (!this.coordinatesLoaded) {
            Coordinates cc = new Coordinates(this.getM4Db());
            if (!this.isNew()) {
                cc.primitiveSetMyM4Object(this);
                cc.readFromDb();
            }
            this.coordinatesLoaded = true;
            graph2coord.setReciprocalReferences(this, cc);
        }
        return this.myCoordinates;
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        if (this.hasCoordinates()) {
            ret.add(this.getCoordinates());
        }
        return ret;
    }
}

