/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.OperatorRuntimeConditionViolated;
import edu.udo.cs.miningmart.exception.UserError;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.ParameterObject;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.Operator;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class Condition
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.Condition {
    public static final String M4_TABLE_NAME = "op_cond_t";
    public static final String ATTRIB_COND_ID = "cond_id";
    public static final String ATTRIB_OPERATOR_ID = "cond_opid";
    public static final String ATTRIB_COND_TYPE = "cond_type";
    public static final String ATTRIB_COND_OBJ1 = "cond_obj1";
    public static final String ATTRIB_COND_OBJ2 = "cond_obj2";
    private static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private Operator myOperator;
    private String myType;
    private String myObj1;
    private String myObj2;
    private static final String CONDITION_NOT_NULL = "NOT_NULL";
    private static final String CONDITION_HAS_VALUES = "HAS_VALUES";
    private static final String CONDITION_UNIQUE = "UNIQUE";
    private static final String CONDITION_LOWER_BOUND = "LOWERBOUND";
    private static final String CONDITION_UPPER_BOUND = "UPPERBOUND";
    private static final String CONDITION_AVG = "AVG";
    private static final String CONDITION_STD_DEV = "STD_DEV";
    private static final String CONDITION_HAS_NULLS = "HAS_NULLS";
    private static final String CONDITION_ORDERED = "ORDERED";
    private static final String CONDITION_EQUIDIST = "EQUIDIST";
    private static final String CONDITION_LE = "LE";
    private static final String CONDITION_LT = "LT";
    private static final String CONDITION_GE = "GE";
    private static final String CONDITION_GT = "GT";
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Operator;
    static /* synthetic */ Class class$java$lang$String;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_COND_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_COND_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_OPERATOR_ID, "getTheOperator", "primitiveSetOperator", class$edu$udo$cs$miningmart$m4$Operator == null ? (class$edu$udo$cs$miningmart$m4$Operator = Condition.class$("edu.udo.cs.miningmart.m4.Operator")) : class$edu$udo$cs$miningmart$m4$Operator, "NN"), new M4InfoEntry(ATTRIB_COND_TYPE, "getType", "setType", class$java$lang$String == null ? (class$java$lang$String = Condition.class$("java.lang.String")) : class$java$lang$String, "NN"), new M4InfoEntry(ATTRIB_COND_OBJ1, "getObj1", "setObj1", class$java$lang$String == null ? (class$java$lang$String = Condition.class$("java.lang.String")) : class$java$lang$String, "NN"), new M4InfoEntry(ATTRIB_COND_OBJ2, "getObj2", "setObj2", class$java$lang$String == null ? (class$java$lang$String = Condition.class$("java.lang.String")) : class$java$lang$String)};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Operator", "getTheOperator", "setTheOperator", class$edu$udo$cs$miningmart$m4$Operator == null ? (class$edu$udo$cs$miningmart$m4$Operator = Condition.class$("edu.udo.cs.miningmart.m4.Operator")) : class$edu$udo$cs$miningmart$m4$Operator), new M4InfoEntry("Type", "getType", "setType", class$java$lang$String == null ? (class$java$lang$String = Condition.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Obj1", "getObj1", "setObj1", class$java$lang$String == null ? (class$java$lang$String = Condition.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Obj2", "getObj2", "setObj2", class$java$lang$String == null ? (class$java$lang$String = Condition.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", class$java$lang$String == null ? (class$java$lang$String = Condition.class$("java.lang.String")) : class$java$lang$String)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Condition(DB db) {
        super(db);
    }

    public void print() {
        edu.udo.cs.miningmart.m4.Operator op = this.getTheOperator();
        String opName = op == null ? null : op.getName();
        this.doPrint(Print.M4_OBJECT, "Condition (Id = " + this.getId() + ";" + " Name = " + this.getName() + "; TYPE = " + this.getType() + " OBJ1 = " + this.getObj1() + "; OBJ2 = " + this.getObj2() + " Operator = " + opName + ")");
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        return null;
    }

    public String getObj1() {
        return this.myObj1;
    }

    public String getObj2() {
        return this.myObj2;
    }

    public edu.udo.cs.miningmart.m4.Operator getTheOperator() {
        return this.myOperator;
    }

    public String getType() {
        return this.myType;
    }

    public void setObj1(String myObj1) {
        this.setDirty();
        this.myObj1 = myObj1;
    }

    public void setObj2(String myObj2) {
        this.setDirty();
        this.myObj2 = myObj2;
    }

    public void setTheOperator(edu.udo.cs.miningmart.m4.Operator operator) throws M4Exception {
        Operator.op2cond.updateReferenceTo(this, operator);
    }

    public void primitiveSetOperator(edu.udo.cs.miningmart.m4.Operator operator) {
        this.setDirty();
        this.myOperator = (Operator)operator;
    }

    public void setType(String myType) {
        this.setDirty();
        this.myType = myType;
    }

    protected void removeAllM4References() throws M4Exception {
        this.setTheOperator(null);
        this.removeDocObject();
    }

    public void check(ExecutableOperator op) throws UserError, M4CompilerError {
        String conditionType = this.getType();
        for (int loop = 0; loop < op.getNumberOfLoops(); ++loop) {
            if (conditionType.equals(CONDITION_NOT_NULL)) {
                this.checkNotNull(op, loop);
                continue;
            }
            if (conditionType.equals(CONDITION_UNIQUE)) {
                this.checkUniqueness(op, loop);
                continue;
            }
            if (conditionType.equals(CONDITION_HAS_VALUES)) {
                this.checkHasValues(op, loop);
                continue;
            }
            if (conditionType.equals(CONDITION_LOWER_BOUND)) {
                this.checkLowerBound(op, loop);
                continue;
            }
            if (!conditionType.equals(CONDITION_UPPER_BOUND)) continue;
            this.checkUpperBound(op, loop);
        }
    }

    private void checkNotNull(ExecutableOperator exOp, int loop) throws M4CompilerError {
        try {
            String obj1 = this.getObj1();
            ParameterObject[] parArray = exOp.getParameter(obj1, loop);
            Collection columns = Condition.getColumnsForParameter(parArray);
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                int numMissing = column.readOrComputeNumMissingValues();
                if (numMissing <= 0) continue;
                throw new OperatorRuntimeConditionViolated(this.createExceptionText(exOp));
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    private void checkUniqueness(ExecutableOperator exOp, int loop) throws M4CompilerError {
        try {
            String obj1 = this.getObj1();
            ParameterObject[] parArray = exOp.getParameter(obj1, loop);
            Collection columns = Condition.getColumnsForParameter(parArray);
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                int numUnique = column.readOrComputeUniqueValues();
                String countS = column.getColumnset().readOrComputeCount();
                try {
                    long count = Long.parseLong(countS);
                    if ((long)numUnique == count) continue;
                    throw new OperatorRuntimeConditionViolated(this.createExceptionText(exOp));
                }
                catch (NumberFormatException e) {
                    this.doPrint(Print.WARNING, "Could not compute count for Columnset with ID " + column.getColumnset().getId());
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    private void checkHasValues(ExecutableOperator exOp, int loop) throws M4CompilerError {
        int compareTo;
        String obj2 = this.getObj2();
        if (obj2 == null || obj2.trim().length() == 0) {
            compareTo = 1;
        } else {
            int num = 1;
            try {
                num = Integer.parseInt(obj2);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            compareTo = num;
        }
        try {
            String obj1 = this.getObj1();
            ParameterObject[] parArray = exOp.getParameter(obj1, loop);
            Collection columns = Condition.getColumnsForParameter(parArray);
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                int numMissing = column.readOrComputeNumMissingValues();
                String countS = column.getColumnset().readOrComputeCount();
                try {
                    long count = Long.parseLong(countS);
                    if (count - (long)numMissing >= (long)compareTo) continue;
                    throw new OperatorRuntimeConditionViolated(this.createExceptionText(exOp));
                }
                catch (NumberFormatException e) {
                    this.doPrint(Print.WARNING, "Could not compute count for Columnset with ID " + column.getColumnset().getId());
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    private void checkLowerBound(ExecutableOperator exOp, int loop) throws M4CompilerError {
        String obj2 = this.getObj2();
        double lowerBound = 0.0;
        try {
            lowerBound = Double.parseDouble(obj2);
        }
        catch (NumberFormatException e) {
            return;
        }
        try {
            String obj1 = this.getObj1();
            ParameterObject[] parArray = exOp.getParameter(obj1, loop);
            Collection columns = Condition.getColumnsForParameter(parArray);
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                String min = column.readOrComputeMinimum();
                try {
                    double d = Double.parseDouble(min);
                    if (!(d < lowerBound)) continue;
                    throw new OperatorRuntimeConditionViolated(this.createExceptionText(exOp));
                }
                catch (NumberFormatException e) {
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    private void checkUpperBound(ExecutableOperator exOp, int loop) throws M4CompilerError {
        String obj2 = this.getObj2();
        double upperBound = 0.0;
        try {
            upperBound = Double.parseDouble(obj2);
        }
        catch (NumberFormatException e) {
            return;
        }
        try {
            String obj1 = this.getObj1();
            ParameterObject[] parArray = exOp.getParameter(obj1, loop);
            Collection columns = Condition.getColumnsForParameter(parArray);
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                String max = column.readOrComputeMaximum();
                try {
                    double d = Double.parseDouble(max);
                    if (!(d > upperBound)) continue;
                    throw new OperatorRuntimeConditionViolated(this.createExceptionText(exOp));
                }
                catch (NumberFormatException e) {
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    private void checkAverage(ExecutableOperator exOp, int loop) throws M4CompilerError {
        String obj2 = this.getObj2();
        double average = 0.0;
        try {
            average = Double.parseDouble(obj2);
        }
        catch (NumberFormatException e) {
            return;
        }
        try {
            String obj1 = this.getObj1();
            ParameterObject[] parArray = exOp.getParameter(obj1, loop);
            Collection columns = Condition.getColumnsForParameter(parArray);
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                String avgS = column.readOrComputeAverage();
                try {
                    double avg = Double.parseDouble(avgS);
                    if (avg == average) continue;
                    throw new OperatorRuntimeConditionViolated(this.createExceptionText(exOp));
                }
                catch (NumberFormatException e) {
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    private void checkStdDev(ExecutableOperator exOp, int loop) throws M4CompilerError {
        String obj2 = this.getObj2();
        double stddev = Double.parseDouble(obj2);
        try {
            String obj1 = this.getObj1();
            ParameterObject[] parArray = exOp.getParameter(obj1, loop);
            Collection columns = Condition.getColumnsForParameter(parArray);
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                String sdS = column.readOrComputeStdDev();
                try {
                    double sd = Double.parseDouble(sdS);
                    if (sd == stddev) continue;
                    throw new OperatorRuntimeConditionViolated(this.createExceptionText(exOp));
                }
                catch (NumberFormatException e) {
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    private String createExceptionText(ExecutableOperator exOp) {
        return "Step " + exOp.getStep().getName() + "(ID: " + exOp.getStep().getId() + ") violates the following runtime condition:\n" + "Embedded operator is " + exOp.getOperator().getName() + ",\nType of condition is " + this.getType() + " (" + (this.getObj1() == null ? "NULL" : this.getObj1()) + ", " + (this.getObj2() == null ? "NULL" : this.getObj2()) + ")\n";
    }

    public static Collection getColumnsForParameter(ParameterObject[] parArray) throws M4Exception {
        Vector columns = new Vector();
        if (parArray == null) {
            return columns;
        }
        for (int i = 0; i < parArray.length; ++i) {
            ParameterObject par = parArray[i];
            if (par instanceof Feature) {
                columns.addAll(Condition.getColumnsForFeature((Feature)par));
                continue;
            }
            if (!(par instanceof Concept)) continue;
            columns.addAll(Condition.getColumnsForConcept((Concept)par));
        }
        return columns;
    }

    public static Collection getColumnsForConcept(Concept con) throws M4Exception {
        Vector res = new Vector();
        if (con.getFeatures() != null) {
            Iterator it = con.getFeatures().iterator();
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                res.addAll(Condition.getColumnsForFeature(feature));
            }
        }
        return res;
    }

    public static Collection getColumnsForFeature(Feature feature) throws M4Exception {
        MultiColumnFeature mcf;
        Vector res = new Vector();
        if (feature instanceof BaseAttribute) {
            res.addAll(((BaseAttribute)feature).getColumns());
        } else if (feature instanceof MultiColumnFeature && (mcf = (MultiColumnFeature)feature).getBaseAttributes() != null) {
            Iterator mcfIt = mcf.getBaseAttributes().iterator();
            while (mcfIt.hasNext()) {
                res.addAll(((BaseAttribute)mcfIt.next()).getColumns());
            }
        }
        return res;
    }

    public static Collection getColumnsForBa(BaseAttribute ba) throws M4Exception {
        Vector res = new Vector();
        if (ba != null && ba.getColumns() != null) {
            res.addAll(ba.getColumns());
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

