/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Columnset;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.Iterator;

public class ColumnsetStatistics
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.ColumnsetStatistics {
    public static final String M4_TABLE_NAME = "csstatist_t";
    public static final String ATTRIB_CSSTAT_ID = "csst_id";
    public static final String ATTRIB_CSSTAT_CS = "csst_csid";
    public static final String ATTRIB_CSSTAT_ALL = "csst_all";
    public static final String ATTRIB_CSSTAT_ORD = "csst_ord";
    public static final String ATTRIB_CSSTAT_NOM = "csst_nom";
    public static final String ATTRIB_CSSTAT_TIME = "csst_time";
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private Columnset myColumnset;
    private Integer noOfRows;
    private Integer noOfOrdAttr;
    private Integer noOfNomAttr;
    private Integer noOfTimeAttr;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Columnset;
    static /* synthetic */ Class class$java$lang$Integer;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_CSSTAT_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_CSSTAT_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_CSSTAT_CS, "getTheColumnset", "primitiveSetColumnset", class$edu$udo$cs$miningmart$m4$Columnset == null ? (class$edu$udo$cs$miningmart$m4$Columnset = ColumnsetStatistics.class$("edu.udo.cs.miningmart.m4.Columnset")) : class$edu$udo$cs$miningmart$m4$Columnset, "NN"), new M4InfoEntry(ATTRIB_CSSTAT_ALL, "getNrOfAllTuples", "setNrOfAllTuples", class$java$lang$Integer == null ? (class$java$lang$Integer = ColumnsetStatistics.class$("java.lang.Integer")) : class$java$lang$Integer), new M4InfoEntry(ATTRIB_CSSTAT_ORD, "getNrOfOrdAttribs", "setNrOfOrdAttribs", class$java$lang$Integer == null ? (class$java$lang$Integer = ColumnsetStatistics.class$("java.lang.Integer")) : class$java$lang$Integer), new M4InfoEntry(ATTRIB_CSSTAT_NOM, "getNrOfNomAttribs", "setNrOfNomAttribs", class$java$lang$Integer == null ? (class$java$lang$Integer = ColumnsetStatistics.class$("java.lang.Integer")) : class$java$lang$Integer), new M4InfoEntry(ATTRIB_CSSTAT_TIME, "getNrOfTimeAttribs", "setNrOfTimeAttribs", class$java$lang$Integer == null ? (class$java$lang$Integer = ColumnsetStatistics.class$("java.lang.Integer")) : class$java$lang$Integer)};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Columnset", "getTheColumnset", "setTheColumnset", class$edu$udo$cs$miningmart$m4$Columnset == null ? (class$edu$udo$cs$miningmart$m4$Columnset = ColumnsetStatistics.class$("edu.udo.cs.miningmart.m4.Columnset")) : class$edu$udo$cs$miningmart$m4$Columnset), new M4InfoEntry("NrOfTuples", "getNrOfAllTuples", "setNrOfAllTuples", class$java$lang$Integer == null ? (class$java$lang$Integer = ColumnsetStatistics.class$("java.lang.Integer")) : class$java$lang$Integer), new M4InfoEntry("OrdinalAttr", "getNrOfOrdAttribs", "setNrOfOrdAttribs", class$java$lang$Integer == null ? (class$java$lang$Integer = ColumnsetStatistics.class$("java.lang.Integer")) : class$java$lang$Integer), new M4InfoEntry("NominalAttr", "getNrOfNomAttribs", "setNrOfNomAttribs", class$java$lang$Integer == null ? (class$java$lang$Integer = ColumnsetStatistics.class$("java.lang.Integer")) : class$java$lang$Integer), new M4InfoEntry("TimeAttr", "getNrOfTimeAttribs", "setNrOfTimeAttribs", class$java$lang$Integer == null ? (class$java$lang$Integer = ColumnsetStatistics.class$("java.lang.Integer")) : class$java$lang$Integer)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public ColumnsetStatistics(DB db) {
        super(db);
    }

    public edu.udo.cs.miningmart.m4.Columnset getTheColumnset() {
        return this.myColumnset;
    }

    public void setTheColumnset(edu.udo.cs.miningmart.m4.Columnset columnset) throws M4Exception {
        Columnset.csstat.updateReferenceTo(this, columnset);
    }

    public void primitiveSetColumnset(edu.udo.cs.miningmart.m4.Columnset columnset) {
        this.setDirty();
        this.myColumnset = (Columnset)columnset;
    }

    public void print() {
    }

    public void removeAllM4References() throws M4Exception {
        this.setTheColumnset(null);
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        return null;
    }

    public Integer getNrOfAllTuples() {
        return this.noOfRows;
    }

    public void setNrOfAllTuples(Integer nrOfRows) {
        this.noOfRows = nrOfRows;
    }

    public Integer getNrOfOrdAttribs() {
        return this.noOfOrdAttr;
    }

    public void setNrOfOrdAttribs(Integer nrOfOrdinalAttributes) {
        this.noOfOrdAttr = nrOfOrdinalAttributes;
    }

    public Integer getNrOfNomAttribs() {
        return this.noOfNomAttr;
    }

    public void setNrOfNomAttribs(Integer nrOfNominalAttributes) {
        this.noOfNomAttr = nrOfNominalAttributes;
    }

    public Integer getNrOfTimeAttribs() {
        return this.noOfTimeAttr;
    }

    public void setNrOfTimeAttribs(Integer nrOfTimeAttributes) {
        this.noOfTimeAttr = nrOfTimeAttributes;
    }

    public void update() throws M4Exception {
        edu.udo.cs.miningmart.m4.Columnset myCS = this.getTheColumnset();
        if (myCS == null) {
            return;
        }
        this.updateCount();
        String pre = "SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = ";
        String post = " AND col_csid = " + myCS.getId();
        try {
            if (this.getNrOfOrdAttribs() == null) {
                String csstOrd = this.executeM4SingleValueSqlRead("SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = 12" + post);
                this.setNrOfOrdAttribs(csstOrd == null ? null : new Integer(csstOrd));
            }
            if (this.getNrOfNomAttribs() == null) {
                String csstNom = this.executeM4SingleValueSqlRead("SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = 13" + post);
                this.setNrOfNomAttribs(csstNom == null ? null : new Integer(csstNom));
            }
            if (this.getNrOfTimeAttribs() == null) {
                String csstTime = this.executeM4SingleValueSqlRead("SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = 14" + post);
                this.setNrOfTimeAttribs(csstTime == null ? null : new Integer(csstTime));
            }
        }
        catch (NumberFormatException e) {
            throw new M4Exception("Columnset.updateStatistics for ColumnSet with ID " + myCS.getId() + ":\nStatistic calculation yielded a String not parseable to Integer.");
        }
        Collection cols = myCS.getColumns();
        Iterator it = cols.iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            column.updateStatistics();
        }
    }

    public void updateCount() throws M4Exception {
        edu.udo.cs.miningmart.m4.Columnset myCS = this.getTheColumnset();
        if (myCS == null) {
            return;
        }
        Integer count = this.getNrOfAllTuples();
        if (count == null) {
            String query = "SELECT COUNT(*) FROM " + myCS.getSchemaPlusName();
            String newCount = this.executeBusinessSingleValueSqlRead(query);
            if (newCount == null) {
                throw new M4Exception("Could not compute count for columnset '" + this.getName() + "'!");
            }
            try {
                count = new Integer(newCount);
            }
            catch (NumberFormatException e) {
                throw new M4Exception("Internal error when computing number of tuples. Query did not return an integer:\n" + query);
            }
            this.setNrOfAllTuples(count);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

