/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.BaseAttribute;
import edu.udo.cs.miningmart.m4.core.Chain;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Concept;
import edu.udo.cs.miningmart.m4.core.ConceptualDatatypes;
import edu.udo.cs.miningmart.m4.core.Feature;
import edu.udo.cs.miningmart.m4.core.ForeignKey;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.M4Object;
import edu.udo.cs.miningmart.m4.core.Operator;
import edu.udo.cs.miningmart.m4.core.Projection;
import edu.udo.cs.miningmart.m4.core.Relation;
import edu.udo.cs.miningmart.m4.utils.InterM4CaseChain;
import edu.udo.cs.miningmart.m4.utils.InterM4CaseConcept;
import edu.udo.cs.miningmart.m4.utils.InterM4CaseStep;
import edu.udo.cs.miningmart.m4.utils.InterM4Communicator;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class Case
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.Case {
    public static final String M4_TABLE_NAME = "case_t";
    public static final String ATTRIB_CASE_ID = "ca_id";
    public static final String ATTRIB_CASE_NAME = "ca_name";
    public static final String ATTRIB_CASE_MODE = "ca_mode";
    public static final String TESTMODE = "TEST";
    public static final String FINALMODE = "FINAL";
    static final InterM4Communicator case2con = new InterM4CaseConcept();
    static final InterM4Communicator case2step = new InterM4CaseStep();
    static final InterM4Communicator case2chain = new InterM4CaseChain();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private final Vector myChains = new Vector();
    private final Vector mySteps = new Vector();
    private final Vector myConcepts = new Vector();
    private boolean allConceptsLoaded = false;
    private boolean allStepsLoaded = false;
    private boolean allChainsLoaded = false;
    private String myMode = "TEST";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Concept;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Chain;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Step;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Relation;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$Projection;
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$core$ForeignKey;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_CASE_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_CASE_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_CASE_NAME, "getName", "setName", class$java$lang$String == null ? (class$java$lang$String = Case.class$("java.lang.String")) : class$java$lang$String, "NN"), new M4InfoEntry(ATTRIB_CASE_MODE, "getTheMode", "setTheMode", class$java$lang$String == null ? (class$java$lang$String = Case.class$("java.lang.String")) : class$java$lang$String, "NN")};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", class$java$lang$String == null ? (class$java$lang$String = Case.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", class$java$lang$String == null ? (class$java$lang$String = Case.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Mode", "getTheMode", "setTheMode", class$java$lang$String == null ? (class$java$lang$String = Case.class$("java.lang.String")) : class$java$lang$String)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Case(DB m4Db) {
        super(m4Db);
    }

    public void addStepDependency(Step before, Step after) throws M4Exception {
        if (before == null || after == null) {
            throw new M4Exception("Trying to enter null-values in step dependency graph! Case: " + this.getId());
        }
        Vector steps = this.getTheSteps();
        int beforeIndex = steps.indexOf(before);
        int afterIndex = steps.indexOf(after);
        if (beforeIndex == -1 || afterIndex == -1) {
            throw new M4Exception("Trying to enter dependency for unknown step! Step ID:" + (beforeIndex == -1 ? "<" + before.getId() + ">" : "") + (afterIndex == -1 ? "<" + after.getId() + ">" : "") + ", Case ID: " + this.getId());
        }
        before.addSuccessor(after);
        if (beforeIndex > afterIndex) {
            for (int i = afterIndex; i < beforeIndex; ++i) {
                steps.set(i, steps.get(i + 1));
            }
            steps.set(beforeIndex, after);
        }
    }

    public boolean containsDependency(Step before, Step after) throws M4Exception {
        if (this.getTheSteps().contains(before)) {
            return before.getSuccessors().contains(after);
        }
        return false;
    }

    public boolean removeStepDependency(Step before, Step after) throws M4Exception {
        if (before == null || after == null) {
            throw new M4Exception("Trying to remove null-entries in step dependency graph! Case: " + this.getId());
        }
        return before.removeSuccessor(after);
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        if (typeOfObjects.isAssignableFrom(class$edu$udo$cs$miningmart$m4$core$Concept == null ? (class$edu$udo$cs$miningmart$m4$core$Concept = Case.class$("edu.udo.cs.miningmart.m4.core.Concept")) : class$edu$udo$cs$miningmart$m4$core$Concept)) {
            return this.getConcepts();
        }
        if (typeOfObjects.isAssignableFrom(class$edu$udo$cs$miningmart$m4$core$Chain == null ? (class$edu$udo$cs$miningmart$m4$core$Chain = Case.class$("edu.udo.cs.miningmart.m4.core.Chain")) : class$edu$udo$cs$miningmart$m4$core$Chain)) {
            return this.getAllChains();
        }
        if (typeOfObjects.isAssignableFrom(class$edu$udo$cs$miningmart$m4$core$Step == null ? (class$edu$udo$cs$miningmart$m4$core$Step = Case.class$("edu.udo.cs.miningmart.m4.core.Step")) : class$edu$udo$cs$miningmart$m4$core$Step)) {
            return this.getTheSteps();
        }
        if (typeOfObjects.isAssignableFrom(class$edu$udo$cs$miningmart$m4$core$Relation == null ? (class$edu$udo$cs$miningmart$m4$core$Relation = Case.class$("edu.udo.cs.miningmart.m4.core.Relation")) : class$edu$udo$cs$miningmart$m4$core$Relation)) {
            return this.getAllRelations();
        }
        if (typeOfObjects.isAssignableFrom(class$edu$udo$cs$miningmart$m4$core$Projection == null ? (class$edu$udo$cs$miningmart$m4$core$Projection = Case.class$("edu.udo.cs.miningmart.m4.core.Projection")) : class$edu$udo$cs$miningmart$m4$core$Projection)) {
            return this.getAllProjections();
        }
        if (typeOfObjects.isAssignableFrom(class$edu$udo$cs$miningmart$m4$core$ForeignKey == null ? (class$edu$udo$cs$miningmart$m4$core$ForeignKey = Case.class$("edu.udo.cs.miningmart.m4.core.ForeignKey")) : class$edu$udo$cs$miningmart$m4$core$ForeignKey)) {
            Collection rels = this.getAllRelations();
            Vector<ForeignKey> theFKs = new Vector<ForeignKey>();
            Iterator it = rels.iterator();
            while (it.hasNext()) {
                Relation aRel = (Relation)it.next();
                ForeignKey fk = (ForeignKey)aRel.getFromKey();
                if (fk != null && !theFKs.contains(fk)) {
                    theFKs.add(fk);
                }
                if ((fk = (ForeignKey)aRel.getToKey()) == null || theFKs.contains(fk)) continue;
                theFKs.add(fk);
            }
            theFKs.trimToSize();
            return theFKs;
        }
        throw new M4Exception("Case.getObjectsInNamespace: unknown type of objects given: " + typeOfObjects.getName());
    }

    public Collection getAllRelations() throws M4Exception {
        Collection theConcepts = this.getConcepts();
        Iterator it = theConcepts.iterator();
        Vector<Relation> theRels = new Vector<Relation>();
        while (it.hasNext()) {
            Concept con = (Concept)it.next();
            Collection someRels = con.getTheToRelationships();
            someRels.addAll(con.getTheFromRelationships());
            Iterator it2 = someRels.iterator();
            while (it2.hasNext()) {
                Relation rel = (Relation)it2.next();
                if (theRels.contains(rel)) continue;
                theRels.add(rel);
            }
        }
        theRels.trimToSize();
        return theRels;
    }

    public Collection getAllProjections() throws M4Exception {
        Collection theConcepts = this.getConcepts();
        Iterator it = theConcepts.iterator();
        Vector<Projection> theProjs = new Vector<Projection>();
        while (it.hasNext()) {
            Concept con = (Concept)it.next();
            Collection someProjs = con.getProjectionsAsFromConcept();
            someProjs.addAll(con.getProjectionsAsToConcept());
            Iterator it2 = someProjs.iterator();
            while (it2.hasNext()) {
                Projection proj = (Projection)it2.next();
                if (theProjs.contains(proj)) continue;
                theProjs.add(proj);
            }
        }
        theProjs.trimToSize();
        return theProjs;
    }

    public Map getOperatorToStepMap() throws M4Exception {
        Iterator stepIt = this.getStepIterator();
        HashMap<Operator, Vector<edu.udo.cs.miningmart.m4.core.Step>> myMap = new HashMap<Operator, Vector<edu.udo.cs.miningmart.m4.core.Step>>();
        while (stepIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step myStep = (edu.udo.cs.miningmart.m4.core.Step)stepIt.next();
            Operator myOp = (Operator)myStep.getTheOperator();
            Vector<edu.udo.cs.miningmart.m4.core.Step> stepsWithThisOperator = (Vector<edu.udo.cs.miningmart.m4.core.Step>)myMap.get(myOp);
            if (stepsWithThisOperator == null) {
                stepsWithThisOperator = new Vector<edu.udo.cs.miningmart.m4.core.Step>();
                stepsWithThisOperator.add(myStep);
                myMap.put(myOp, stepsWithThisOperator);
                continue;
            }
            stepsWithThisOperator.add(myStep);
        }
        return myMap;
    }

    public void setTheMode(String newMode) throws M4Exception {
        this.setDirty();
        if (!newMode.equals(TESTMODE) && !newMode.equals(FINALMODE)) {
            throw new M4Exception("Case.setTheMode: constant TEST or FINAL expected; found '" + newMode + "'!");
        }
        this.myMode = newMode;
    }

    public String getTheMode() {
        return this.myMode;
    }

    public void print() {
        this.doPrint(Print.M4_OBJECT, "Step (Id = " + this.getId() + ";" + "      Name = " + this.getName() + ";" + "      Steps: ");
        try {
            Iterator it = this.getStepIterator();
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Step s = (edu.udo.cs.miningmart.m4.core.Step)it.next();
                if (s == null) continue;
                this.doPrint(Print.M4_OBJECT, "Step " + s.getId());
            }
        }
        catch (M4Exception e) {
            this.doPrint(Print.M4_OBJECT, "Warning: Error loading steps in Case.print(): " + e.getMessage());
        }
        this.doPrint(Print.M4_OBJECT, ")");
    }

    public Step getStepIdNo(int i) throws M4Exception {
        Vector steps = this.getTheSteps();
        if (i < 0 || i >= steps.size()) {
            return null;
        }
        return (edu.udo.cs.miningmart.m4.core.Step)steps.get(i);
    }

    public int getNumberOfSteps() throws M4Exception {
        return this.getTheSteps().size();
    }

    public Step getPredecessorIdOf(Step step) throws M4Exception {
        Iterator it = this.getStepIterator();
        edu.udo.cs.miningmart.m4.core.Step predecessor = null;
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step next = (edu.udo.cs.miningmart.m4.core.Step)it.next();
            if (next.equals(step)) {
                return predecessor;
            }
            predecessor = next;
        }
        return null;
    }

    public Step getSuccessorOf(Step step) throws M4Exception {
        Iterator it = this.getStepIterator();
        while (it.hasNext() && !((edu.udo.cs.miningmart.m4.core.Step)it.next()).equals(step)) {
        }
        if (it.hasNext()) {
            return (edu.udo.cs.miningmart.m4.core.Step)it.next();
        }
        return null;
    }

    public int indexOfStep(Step step) throws M4Exception {
        Vector col = this.getTheSteps();
        return col.indexOf(step);
    }

    public Iterator getStepIterator() throws M4Exception {
        return this.getTheSteps().iterator();
    }

    public Iterator getReverseIterator() throws M4Exception {
        LinkedList rev = new LinkedList();
        Iterator it = this.getStepIterator();
        while (it.hasNext()) {
            rev.addFirst(it.next());
        }
        return rev.iterator();
    }

    public Collection getDependentStepsFor(Step step) throws M4Exception {
        if (step == null) {
            throw new M4Exception("Case.getDependentStepsFor(Step): got <null> Step!");
        }
        if (!this.getTheSteps().contains(step)) {
            throw new M4Exception("Case.getDependentStepsFor(Step):\nStep with ID: " + step.getId() + " not part of this Case " + this.getId() + "!");
        }
        HashMap openDict = new HashMap();
        LinkedList<Step> path = new LinkedList<Step>();
        LinkedList<edu.udo.cs.miningmart.m4.core.Step> closed = new LinkedList<edu.udo.cs.miningmart.m4.core.Step>();
        HashSet<edu.udo.cs.miningmart.m4.core.Step> closedDict = new HashSet<edu.udo.cs.miningmart.m4.core.Step>();
        path.addLast(step);
        openDict.put(step, new LinkedList(step.getSuccessors()));
        while (!path.isEmpty()) {
            edu.udo.cs.miningmart.m4.core.Step last = (edu.udo.cs.miningmart.m4.core.Step)path.getLast();
            LinkedList successors = (LinkedList)openDict.get(last);
            edu.udo.cs.miningmart.m4.core.Step next = null;
            while (next == null && !successors.isEmpty()) {
                next = (edu.udo.cs.miningmart.m4.core.Step)successors.removeFirst();
                if (openDict.containsKey(next)) {
                    throw new M4Exception("Case.getDependentStepsFor(long):\nCase " + this.getId() + " has cyclic dependencies between Steps!");
                }
                if (!closedDict.contains(next)) continue;
                next = null;
            }
            if (next == null && successors.isEmpty()) {
                path.remove(last);
                openDict.remove(last);
                closedDict.add(last);
                closed.addFirst(last);
                continue;
            }
            path.addLast(next);
            openDict.put(next, new LinkedList(next.getSuccessors()));
        }
        return closed;
    }

    public Collection getStepsToCompileBefore(Step step, boolean ignoreCompiledStatusOfSteps) throws M4Exception {
        if (step == null) {
            throw new M4Exception("Case.getStepsToCompileBefore(Step): got <null> Step!");
        }
        if (!this.getTheSteps().contains(step)) {
            throw new M4Exception("Case.getStepsToCompileBefore(Step):\nStep with ID: " + step.getId() + " not part of this Case " + this.getId() + "!");
        }
        HashSet open = new HashSet();
        LinkedList closed = new LinkedList();
        this.getPreSteps(step, open, closed, ignoreCompiledStatusOfSteps);
        closed.remove(step);
        return closed;
    }

    private void getPreSteps(Step step, HashSet open, LinkedList closed, boolean ignoreCompiledStatus) throws M4Exception {
        Collection predecessors = step.getAllPredecessors();
        if (predecessors == null) {
            throw new M4Exception("Case.getPreSteps(), Step " + step.getId() + ": got NULL when asking for predecessors!");
        }
        if (!ignoreCompiledStatus && step.isCompiled()) {
            return;
        }
        open.add(step);
        Iterator it = predecessors.iterator();
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step onePredecessor = (edu.udo.cs.miningmart.m4.core.Step)it.next();
            if (open.contains(onePredecessor)) {
                throw new M4Exception("Case.getPreSteps(): Found a cycle involving Step '" + onePredecessor.getName() + "' (" + onePredecessor.getId() + ")!");
            }
            this.getPreSteps(onePredecessor, open, closed, ignoreCompiledStatus);
        }
        open.remove(step);
        if (!closed.contains(step)) {
            closed.addLast(step);
        }
    }

    public Collection getDirectlyDependentSteps(Step step) throws M4Exception {
        if (step != null && this.getTheSteps().contains(step)) {
            return step.getSuccessors();
        }
        return null;
    }

    public Collection getConcepts() throws M4Exception {
        if (!this.allConceptsLoaded && !this.isNew()) {
            this.allConceptsLoaded = true;
            this.readConceptsForCaseFromDb();
        }
        return this.myConcepts;
    }

    public Collection getInputDataModel() throws M4Exception {
        Iterator it = this.getConcepts().iterator();
        Vector<Concept> ret = new Vector<Concept>();
        while (it.hasNext()) {
            Collection consumingSteps;
            Concept myCon = (Concept)it.next();
            edu.udo.cs.miningmart.m4.core.Step creatingStep = (edu.udo.cs.miningmart.m4.core.Step)myCon.getStepWhereThisIsOutputConcept();
            if (creatingStep == null && (consumingSteps = myCon.getStepsWhereThisIsInputConcept()) != null && !consumingSteps.isEmpty() && !ret.contains(myCon)) {
                ret.add(myCon);
            }
            if (!myCon.getType().equals("DB") || ret.contains(myCon)) continue;
            ret.add(myCon);
        }
        it = this.getAllRelations().iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            Collection consumingSteps = rel.getStepsWhereThisIsInputRelation();
            Iterator stepIt = consumingSteps.iterator();
            if (!stepIt.hasNext()) continue;
            Concept from = (Concept)rel.getTheFromConcept();
            Concept to = (Concept)rel.getTheToConcept();
            if (from.getStepWhereThisIsOutputConcept() == null && !ret.contains(from)) {
                ret.add(from);
            }
            if (to == null || to.getStepWhereThisIsOutputConcept() != null || ret.contains(to)) continue;
            ret.add(to);
        }
        return ret;
    }

    public void addConcept(edu.udo.cs.miningmart.m4.Concept con) throws M4Exception {
        case2con.checkNameExists((Concept)con, this);
        case2con.add(this, (Concept)con);
    }

    public boolean removeConcept(edu.udo.cs.miningmart.m4.Concept con) throws M4Exception {
        return case2con.remove(this, (Concept)con);
    }

    public Collection getAllChains() throws M4Exception {
        if (!this.allChainsLoaded && !this.isNew()) {
            this.allChainsLoaded = true;
            this.readChainsForCaseFromDb();
        }
        return this.myChains;
    }

    public Collection getTopLevelChains() throws M4Exception {
        Collection allChains = this.getAllChains();
        Iterator it = allChains.iterator();
        Vector<Chain> theTopLevelChains = new Vector<Chain>();
        while (it.hasNext()) {
            Chain aChain = (Chain)it.next();
            if (aChain.getParentChain() != null) continue;
            theTopLevelChains.add(aChain);
        }
        return theTopLevelChains;
    }

    public edu.udo.cs.miningmart.m4.Chain getChainByName(String name) throws M4Exception {
        if (name == null) {
            return null;
        }
        Collection theChains = this.getAllChains();
        Iterator it = theChains.iterator();
        while (it.hasNext()) {
            Chain c = (Chain)it.next();
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public void addChain(edu.udo.cs.miningmart.m4.Chain chain) throws M4Exception {
        Chain ch = (Chain)chain;
        case2chain.checkNameExists(ch, this);
        case2chain.add(this, ch);
    }

    public boolean removeChain(edu.udo.cs.miningmart.m4.Chain chain) throws M4Exception {
        return case2chain.remove(this, (Chain)chain);
    }

    public void removeChain(String name) throws M4Exception {
        if (name == null) {
            throw new M4Exception("Case.removeChain: got <null> for chain name!");
        }
        Collection theChains = this.getAllChains();
        Iterator it = theChains.iterator();
        try {
            while (it.hasNext()) {
                Chain c = (Chain)it.next();
                if (!c.getName().equals(name)) continue;
                this.removeChain(c);
            }
        }
        catch (M4Exception m4e) {
            throw new M4Exception("Could not remove Chain '" + name + " from Case " + this.getId() + ": " + m4e.getMessage());
        }
    }

    public Step getStepByName(String name) throws M4Exception {
        if (name == null) {
            return null;
        }
        Iterator it = this.getTheSteps().iterator();
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step step = (edu.udo.cs.miningmart.m4.core.Step)it.next();
            if (step == null || !name.equals(step.getName())) continue;
            return step;
        }
        return null;
    }

    public Vector getTheSteps() throws M4Exception {
        if (!this.allStepsLoaded && !this.isNew()) {
            this.allStepsLoaded = true;
            this.readStepsFromDb();
        }
        return this.mySteps;
    }

    public void addStep(Step step) throws M4Exception {
        case2step.checkNameExists((edu.udo.cs.miningmart.m4.core.Step)step, this);
        case2step.add(this, (edu.udo.cs.miningmart.m4.core.Step)step);
    }

    public boolean removeStep(Step step) throws M4Exception {
        return case2step.remove(this, (edu.udo.cs.miningmart.m4.core.Step)step);
    }

    private void readConceptsForCaseFromDb() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(class$edu$udo$cs$miningmart$m4$core$Concept == null ? (class$edu$udo$cs$miningmart$m4$core$Concept = Case.class$("edu.udo.cs.miningmart.m4.core.Concept")) : class$edu$udo$cs$miningmart$m4$core$Concept).iterator();
        while (it.hasNext()) {
            this.addConcept((Concept)it.next());
        }
    }

    private void readChainsForCaseFromDb() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(class$edu$udo$cs$miningmart$m4$core$Chain == null ? (class$edu$udo$cs$miningmart$m4$core$Chain = Case.class$("edu.udo.cs.miningmart.m4.core.Chain")) : class$edu$udo$cs$miningmart$m4$core$Chain).iterator();
        while (it.hasNext()) {
            this.addChain((Chain)it.next());
        }
    }

    private void readStepsFromDb() throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Step artificialStep = (edu.udo.cs.miningmart.m4.core.Step)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$Step == null ? (class$edu$udo$cs$miningmart$m4$core$Step = Case.class$("edu.udo.cs.miningmart.m4.core.Step")) : class$edu$udo$cs$miningmart$m4$core$Step);
        Collection theSteps = this.getObjectsReferencingMe(class$edu$udo$cs$miningmart$m4$core$Step == null ? (class$edu$udo$cs$miningmart$m4$core$Step = Case.class$("edu.udo.cs.miningmart.m4.core.Step")) : class$edu$udo$cs$miningmart$m4$core$Step);
        Iterator it = theSteps.iterator();
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step currentStep = (edu.udo.cs.miningmart.m4.core.Step)it.next();
            this.addStep(currentStep);
            artificialStep.addSuccessor(currentStep);
        }
        Vector stepsOfCase = this.getTheSteps();
        stepsOfCase.add(artificialStep);
        Iterator sequentialIterator = this.getDependentStepsFor(artificialStep).iterator();
        stepsOfCase.clear();
        artificialStep.getSuccessors().clear();
        artificialStep.deleteSoon();
        if (sequentialIterator.next() != artificialStep) {
            throw new M4Exception("Sequentializer error in Case.readStepsFromDb():\nMethod getDependentStepsFor(Step) returns invalid Collection!");
        }
        while (sequentialIterator.hasNext()) {
            stepsOfCase.add(sequentialIterator.next());
        }
    }

    protected void removeAllM4References() throws M4Exception {
        Vector empty = new Vector();
        case2chain.setCollectionTo(this, empty);
        case2con.setCollectionTo(this, empty);
        case2step.setCollectionTo(this, empty);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getAllChains());
        ret.addAll(this.getConcepts());
        ret.addAll(this.getTheSteps());
        return ret;
    }

    public void store() throws M4Exception {
        this.getM4Db().updateDatabase();
    }

    public edu.udo.cs.miningmart.m4.Case copy() throws M4Exception {
        Case theCopy = new Case(this.getM4Db());
        theCopy.setTheMode(this.getTheMode());
        String nameOfCopy = this.getValidName(this.getName(), null);
        theCopy.setName(nameOfCopy);
        return theCopy;
    }

    public Step createStep(String name) throws M4Exception {
        if (name == null) {
            throw new M4Exception("Case.createStep: got <null> for step name!");
        }
        HashSet dirtySteps = DB.getDirtyObjectsForTable("step_t".toLowerCase());
        edu.udo.cs.miningmart.m4.core.Step newStep = (edu.udo.cs.miningmart.m4.core.Step)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$Step == null ? (class$edu$udo$cs$miningmart$m4$core$Step = Case.class$("edu.udo.cs.miningmart.m4.core.Step")) : class$edu$udo$cs$miningmart$m4$core$Step);
        String errormessage = "Could not connect new Step '" + name + "' to Case " + this.getId() + ": ";
        try {
            newStep.setName(name);
            this.addStep(newStep);
        }
        catch (M4Exception m4e) {
            throw new M4Exception(errormessage + m4e.getMessage());
        }
        return newStep;
    }

    public Collection getAllStepNames() throws M4Exception {
        Iterator it = this.getStepIterator();
        Vector<String> stepNames = new Vector<String>();
        if (it != null) {
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Step step = (edu.udo.cs.miningmart.m4.core.Step)it.next();
                if (step == null) continue;
                stepNames.add(step.getName());
            }
        }
        return stepNames;
    }

    public void removeStep(String name) throws M4Exception {
        if (name == null) {
            throw new M4Exception("Case.removeStep: got <null> for step name!");
        }
        edu.udo.cs.miningmart.m4.core.Step step = (edu.udo.cs.miningmart.m4.core.Step)this.getStepByName(name);
        if (step != null) {
            this.removeStep(step);
        }
    }

    public void removeAllSteps() throws M4Exception {
        Iterator it = this.getStepIterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Step step = (edu.udo.cs.miningmart.m4.core.Step)it.next();
            this.removeStep(step);
        }
    }

    public edu.udo.cs.miningmart.m4.Chain createChain(String name) throws M4Exception {
        if (name == null) {
            throw new M4Exception("Case.createChain: got <null> for chain name!");
        }
        Chain newChain = new Chain(this.getM4Db());
        newChain.setName(name);
        this.addChain(newChain);
        return newChain;
    }

    public edu.udo.cs.miningmart.m4.Chain createChain(String name, Collection stepsAndChains) throws M4Exception {
        if (stepsAndChains == null) {
            this.doPrint(Print.M4_OBJECT, "Warning: Case.createChain/2: got <null> instead of a collection of steps and chains!");
        }
        Chain newChain = (Chain)this.createChain(name);
        Iterator it = stepsAndChains.iterator();
        while (it.hasNext()) {
            M4Object anM4Object = (M4Object)it.next();
            if (anM4Object instanceof edu.udo.cs.miningmart.m4.core.Step) {
                newChain.addStep((edu.udo.cs.miningmart.m4.core.Step)anM4Object);
                continue;
            }
            if (anM4Object instanceof Chain) {
                newChain.addSubChain((Chain)anM4Object);
                continue;
            }
            throw new M4Exception("Case.createChain/2: found something in the given collection that is neither Step nor Chain!");
        }
        return newChain;
    }

    public void resolveChain(edu.udo.cs.miningmart.m4.Chain toBeResolved) throws M4Exception {
        if (toBeResolved == null || toBeResolved.getParentChain() != null) {
            throw new M4Exception("Case.resolveChain: can only resolve top-level chains!");
        }
        if (this.getChainByName(toBeResolved.getName()) == null) {
            throw new M4Exception("Case.resolveChain: unknown Chain '" + toBeResolved.getName() + "'!");
        }
        Collection stepsOfResolvedChain = toBeResolved.getTopLevelSteps();
        Collection chainsOfResolvedChain = toBeResolved.getDirectSubChains();
        Iterator stepsIt = stepsOfResolvedChain.iterator();
        if (stepsIt.hasNext()) {
            throw new M4Exception("Case.resolveChain: chain '" + toBeResolved.getName() + "' is top-level chain and has Steps, so it cannot be resolved!");
        }
        Iterator chainIt = chainsOfResolvedChain.iterator();
        while (chainIt.hasNext()) {
            Chain subChain = (Chain)chainIt.next();
            subChain.setParentChain(null);
        }
        toBeResolved.deleteSoon();
    }

    public edu.udo.cs.miningmart.m4.Concept createConcept(String name, String type) throws M4Exception {
        if (name == null || type == null) {
            throw new M4Exception("Case.createConcept: Name or type for new concept were <null>!");
        }
        Concept newConcept = new Concept(this.getM4Db());
        newConcept.setName(name);
        newConcept.setType(type);
        this.addConcept(newConcept);
        return newConcept;
    }

    public edu.udo.cs.miningmart.m4.Concept createConceptFromTable(String tableName) throws M4Exception {
        Concept newConcept = null;
        edu.udo.cs.miningmart.m4.core.Columnset newCs = null;
        newCs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getM4Db().createColumnsetFromTable(tableName);
        newConcept = (Concept)this.createConceptFromColumnset(newCs);
        return newConcept;
    }

    public edu.udo.cs.miningmart.m4.Concept createConceptFromColumnset(Columnset cs) throws M4Exception {
        if (cs == null) {
            return null;
        }
        Concept newConcept = null;
        try {
            newConcept = (Concept)this.createConcept(cs.getName(), "DB");
            newConcept.addColumnSet(cs);
            Iterator it = cs.getColumns().iterator();
            while (it.hasNext()) {
                Column myCol = (Column)it.next();
                String m4RelationalDataType = myCol.getColumnDataTypeName();
                String m4ConceptualDataType = ConceptualDatatypes.guessConceptualTypeGivenRelationalType(m4RelationalDataType);
                BaseAttribute newBa = (BaseAttribute)newConcept.createBaseAttribute(myCol.getName(), m4ConceptualDataType, "DB");
                newBa.addColumn(myCol);
            }
        }
        catch (DbConnectionClosed d) {
            if (newConcept != null) {
                newConcept.deleteSoon();
            }
            throw new M4Exception("Connection to business schema closed when trying to create a Concept for table/view '" + cs.getName() + "': " + d.getMessage());
        }
        catch (M4Exception m4e) {
            if (newConcept != null) {
                newConcept.deleteSoon();
            }
            throw m4e;
        }
        return newConcept;
    }

    public edu.udo.cs.miningmart.m4.Concept createConceptAndRelationsFromTables(String tableName) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Columnset newCs;
        Concept fromConcept = (Concept)this.createConceptFromTable(tableName);
        if (fromConcept != null && (newCs = (edu.udo.cs.miningmart.m4.core.Columnset)fromConcept.getCurrentColumnSet()) != null) {
            Map myMap = this.getM4Db().getMapOfForeignKeyReferences(newCs, this);
            Map columnsForCs = this.transformMapping(myMap);
            Iterator entriesIt = columnsForCs.entrySet().iterator();
            while (entriesIt.hasNext()) {
                Map.Entry myEntry = entriesIt.next();
                edu.udo.cs.miningmart.m4.core.Columnset referencedCs = (edu.udo.cs.miningmart.m4.core.Columnset)myEntry.getKey();
                Collection referringCols = (Collection)myEntry.getValue();
                Concept toConcept = (Concept)referencedCs.getTheConcept();
                if (toConcept == null) {
                    toConcept = (Concept)this.createConceptFromColumnset(referencedCs);
                }
                Collection primaryKeyColsInReferencedCs = this.getM4Db().getPrimaryKeysFromDbSchema(referencedCs);
                Collection fromConceptKeyAttribs = this.findBAs(referringCols, fromConcept);
                Collection toConceptKeyAttribs = this.findBAs(primaryKeyColsInReferencedCs, toConcept);
                String nameForNewRelation = "Rel" + fromConcept.getName() + "To" + toConcept.getName();
                this.createOneToManyRelation(nameForNewRelation, fromConceptKeyAttribs, toConceptKeyAttribs);
            }
        }
        return fromConcept;
    }

    public Collection createManyToManyRelationsFromCrossTable(String crossTableName) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Columnset crossCs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getM4Db().getColumnsetFromCase(crossTableName, this);
        if (crossCs == null) {
            crossCs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getM4Db().createColumnsetFromTable(crossTableName);
        }
        Map myMap = this.getM4Db().getMapOfForeignKeyReferences(crossCs, this);
        Map columnsForCs = this.transformMapping(myMap);
        Vector<Relation> ret = new Vector<Relation>();
        Iterator entriesIt = columnsForCs.entrySet().iterator();
        while (entriesIt.hasNext()) {
            Map.Entry myEntry = entriesIt.next();
            edu.udo.cs.miningmart.m4.core.Columnset referencedCs = (edu.udo.cs.miningmart.m4.core.Columnset)myEntry.getKey();
            Collection referringCols = (Collection)myEntry.getValue();
            Concept fromConcept = (Concept)referencedCs.getTheConcept();
            if (fromConcept == null) {
                fromConcept = (Concept)this.createConceptFromColumnset(referencedCs);
            }
            Collection primaryKeyColsInReferencedCs = this.getM4Db().getPrimaryKeysFromDbSchema(referencedCs);
            Collection fromConceptKeyAttribs = this.findBAs(primaryKeyColsInReferencedCs, fromConcept);
            Iterator secondEntriesIt = columnsForCs.entrySet().iterator();
            while (secondEntriesIt.hasNext()) {
                Map.Entry secondEntry = secondEntriesIt.next();
                edu.udo.cs.miningmart.m4.core.Columnset secondReferencedCs = (edu.udo.cs.miningmart.m4.core.Columnset)secondEntry.getKey();
                if (secondReferencedCs.equals(referencedCs)) continue;
                Collection secondReferringCols = (Collection)myEntry.getValue();
                Concept toConcept = (Concept)secondReferencedCs.getTheConcept();
                if (toConcept == null) {
                    toConcept = (Concept)this.createConceptFromColumnset(secondReferencedCs);
                }
                if (!this.checkNoRelationExists(fromConcept, toConcept)) continue;
                Collection secondPrimaryKeyColsInReferencedCs = this.getM4Db().getPrimaryKeysFromDbSchema(secondReferencedCs);
                Collection toConceptKeyAttribs = this.findBAs(secondPrimaryKeyColsInReferencedCs, toConcept);
                Collection referringColumnsNames = this.getNames(referringCols);
                Collection secondReferringColumnsNames = this.getNames(secondReferringCols);
                String nameForNewRelation = "Rel" + fromConcept.getName() + "To" + toConcept.getName();
                Relation r = (Relation)this.createManyToManyRelation(nameForNewRelation, fromConceptKeyAttribs, toConceptKeyAttribs, crossTableName, referringColumnsNames, secondReferringColumnsNames);
                ret.add(r);
            }
        }
        return ret;
    }

    private boolean checkNoRelationExists(Concept from, Concept to) throws M4Exception {
        Relation myRel;
        Collection candidateRelations = from.getTheFromRelationships();
        Iterator relIt = candidateRelations.iterator();
        while (relIt.hasNext()) {
            myRel = (Relation)relIt.next();
            if (!myRel.getTheToConcept().equals(to)) continue;
            return false;
        }
        candidateRelations = to.getTheFromRelationships();
        relIt = candidateRelations.iterator();
        while (relIt.hasNext()) {
            myRel = (Relation)relIt.next();
            if (!myRel.getTheToConcept().equals(from)) continue;
            return false;
        }
        return true;
    }

    private Map transformMapping(Map givenMap) {
        HashMap<edu.udo.cs.miningmart.m4.core.Columnset, Vector<Column>> columnsForCs = new HashMap<edu.udo.cs.miningmart.m4.core.Columnset, Vector<Column>>();
        if (givenMap != null && !givenMap.isEmpty()) {
            Iterator entriesIt = givenMap.entrySet().iterator();
            while (entriesIt.hasNext()) {
                Map.Entry myEntry = entriesIt.next();
                Column foreignKeyCol = (Column)myEntry.getKey();
                edu.udo.cs.miningmart.m4.core.Columnset referencedCs = (edu.udo.cs.miningmart.m4.core.Columnset)myEntry.getValue();
                if (referencedCs == null) continue;
                Vector<Column> allForeignKeyColsForReferencedCs = (Vector<Column>)columnsForCs.get(referencedCs);
                if (allForeignKeyColsForReferencedCs == null) {
                    allForeignKeyColsForReferencedCs = new Vector<Column>();
                    columnsForCs.put(referencedCs, allForeignKeyColsForReferencedCs);
                }
                allForeignKeyColsForReferencedCs.add(foreignKeyCol);
            }
        }
        return columnsForCs;
    }

    private Collection getNames(Collection objects) {
        Vector<String> names = new Vector<String>();
        if (objects != null) {
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                M4Object anM4Obj = (M4Object)it.next();
                names.add(anM4Obj.getName());
            }
        }
        return names;
    }

    private Collection findBAs(Collection columns, Concept aConcept) throws M4Exception {
        Vector<BaseAttribute> ret = new Vector<BaseAttribute>();
        Iterator baIt = aConcept.getAllBaseAttributes().iterator();
        while (baIt.hasNext()) {
            BaseAttribute myBa = (BaseAttribute)baIt.next();
            Iterator colsIt = columns.iterator();
            while (colsIt.hasNext()) {
                Column myCol = (Column)colsIt.next();
                if (!myCol.getTheBaseAttribute().equals(myBa)) continue;
                ret.add(myBa);
            }
        }
        return ret;
    }

    public edu.udo.cs.miningmart.m4.Relation createOneToManyRelation(String relName, Collection fromConceptKeyAttribs, Collection toConceptKeyAttribs) throws M4Exception {
        if (fromConceptKeyAttribs == null || fromConceptKeyAttribs.isEmpty() || toConceptKeyAttribs == null || toConceptKeyAttribs.isEmpty()) {
            throw new M4Exception("Cannot create a Relation without Key attributes!");
        }
        if (fromConceptKeyAttribs.size() != toConceptKeyAttribs.size()) {
            throw new M4Exception("Case.createOneToManyRelation: number of key attributes in FromConcept and ToConcept must be equal!");
        }
        ForeignKey theForeignKey = (ForeignKey)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$ForeignKey == null ? (class$edu$udo$cs$miningmart$m4$core$ForeignKey = Case.class$("edu.udo.cs.miningmart.m4.core.ForeignKey")) : class$edu$udo$cs$miningmart$m4$core$ForeignKey);
        Iterator fromKeyIt = fromConceptKeyAttribs.iterator();
        Iterator toKeyIt = toConceptKeyAttribs.iterator();
        Concept fromConcept = null;
        Concept toConcept = null;
        while (fromKeyIt.hasNext()) {
            Feature fromFeature = (Feature)fromKeyIt.next();
            Feature toFeature = (Feature)toKeyIt.next();
            if (fromConcept == null) {
                fromConcept = (Concept)fromFeature.getConcept();
                theForeignKey.setForeignKeyColumnset(fromConcept.getCurrentColumnSet());
            } else if (!fromConcept.equals(fromFeature.getConcept())) {
                throw new M4Exception("Case.createOneToManyRelation: all 'from' key attributes must belong to the same Concept!");
            }
            if (toConcept == null) {
                toConcept = (Concept)toFeature.getConcept();
                if (toConcept.equals(fromConcept)) {
                    throw new M4Exception("Case.createOneToManyRelation: 'from' and 'to' key attributes must belong to different Concepts!");
                }
                theForeignKey.setPrimaryKeyColumnset(toConcept.getCurrentColumnSet());
            } else if (!toConcept.equals(toFeature.getConcept())) {
                throw new M4Exception("Case.createOneToManyRelation: all 'to' key attributes must belong to the same Concept!");
            }
            if (fromFeature instanceof BaseAttribute && toFeature instanceof BaseAttribute) {
                Column fromCol = (Column)((BaseAttribute)fromFeature).getCurrentColumn();
                Column toCol = (Column)((BaseAttribute)toFeature).getCurrentColumn();
                theForeignKey.addColumnLink(fromCol, toCol);
                continue;
            }
            throw new M4Exception("Case.createOneToManyRelation: MultiColumnFeatures are not allowed as Key attributes yet!");
        }
        if (fromConcept == null || toConcept == null) {
            throw new M4Exception("Case.createOneToManyRelation: either FromConcept or ToConcept or both are NULL!");
        }
        theForeignKey.setName(relName + "_FK");
        Relation newRelation = (Relation)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$Relation == null ? (class$edu$udo$cs$miningmart$m4$core$Relation = Case.class$("edu.udo.cs.miningmart.m4.core.Relation")) : class$edu$udo$cs$miningmart$m4$core$Relation);
        newRelation.setFromKey(theForeignKey);
        newRelation.setToKey(null);
        newRelation.setCrossLinkColumnSet(null);
        newRelation.setTheFromConcept(fromConcept);
        newRelation.setTheToConcept(toConcept);
        newRelation.setName(relName);
        return newRelation;
    }

    public edu.udo.cs.miningmart.m4.Relation createManyToManyRelation(String relName, Collection fromConceptKeyAttribs, Collection toConceptKeyAttribs, String crossTableName, Collection crossLinkToFromConceptNames, Collection crossLinkToToConceptNames) throws M4Exception {
        if (fromConceptKeyAttribs == null || fromConceptKeyAttribs.isEmpty() || toConceptKeyAttribs == null || toConceptKeyAttribs.isEmpty()) {
            throw new M4Exception("Cannot create a Relation without Key attributes!");
        }
        if (fromConceptKeyAttribs.size() != crossLinkToFromConceptNames.size()) {
            throw new M4Exception("Case.createManyToManyRelation: number of key attribs in FromConcept and cross table must be equal!");
        }
        if (toConceptKeyAttribs.size() != crossLinkToToConceptNames.size()) {
            throw new M4Exception("Case.createManyToManyRelation: number of key attribs in ToConcept and cross table must be equal!");
        }
        ForeignKey linkCrossToFromConcept = (ForeignKey)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$ForeignKey == null ? (class$edu$udo$cs$miningmart$m4$core$ForeignKey = Case.class$("edu.udo.cs.miningmart.m4.core.ForeignKey")) : class$edu$udo$cs$miningmart$m4$core$ForeignKey);
        ForeignKey linkCrossToToConcept = (ForeignKey)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$ForeignKey == null ? (class$edu$udo$cs$miningmart$m4$core$ForeignKey = Case.class$("edu.udo.cs.miningmart.m4.core.ForeignKey")) : class$edu$udo$cs$miningmart$m4$core$ForeignKey);
        Relation newRelation = (Relation)this.getM4Db().createNewInstance(class$edu$udo$cs$miningmart$m4$core$Relation == null ? (class$edu$udo$cs$miningmart$m4$core$Relation = Case.class$("edu.udo.cs.miningmart.m4.core.Relation")) : class$edu$udo$cs$miningmart$m4$core$Relation);
        edu.udo.cs.miningmart.m4.core.Columnset crossColumnset = (edu.udo.cs.miningmart.m4.core.Columnset)this.getM4Db().getColumnsetFromCase(crossTableName, this);
        if (crossColumnset == null) {
            crossColumnset = (edu.udo.cs.miningmart.m4.core.Columnset)newRelation.createCrossLinkColumnset(crossTableName, this.getM4Db().getBusinessSchemaName(), "T");
        }
        Iterator fromKeyIt = fromConceptKeyAttribs.iterator();
        Iterator crossKeyIt = crossLinkToFromConceptNames.iterator();
        Concept fromConcept = null;
        while (fromKeyIt.hasNext()) {
            Feature fromFeature = (Feature)fromKeyIt.next();
            String crossKeyName = (String)crossKeyIt.next();
            if (fromConcept == null) {
                fromConcept = (Concept)fromFeature.getConcept();
                linkCrossToFromConcept.setPrimaryKeyColumnset(fromConcept.getCurrentColumnSet());
                linkCrossToFromConcept.setForeignKeyColumnset(crossColumnset);
            } else if (!fromConcept.equals(fromFeature.getConcept())) {
                throw new M4Exception("Case.createManyToManyRelation: all 'from' key attributes must belong to the same Concept!");
            }
            if (fromFeature instanceof BaseAttribute) {
                Column fromCol = (Column)crossColumnset.getColumn(crossKeyName);
                Column toCol = (Column)((BaseAttribute)fromFeature).getCurrentColumn();
                linkCrossToFromConcept.addColumnLink(fromCol, toCol);
                continue;
            }
            throw new M4Exception("Case.createManyToManyRelation: MultiColumnFeatures are not allowed as Key attributes yet!");
        }
        Iterator toKeyIt = toConceptKeyAttribs.iterator();
        crossKeyIt = crossLinkToToConceptNames.iterator();
        Concept toConcept = null;
        while (toKeyIt.hasNext()) {
            Feature toFeature = (Feature)toKeyIt.next();
            String crossKeyName = (String)crossKeyIt.next();
            if (toConcept == null) {
                toConcept = (Concept)toFeature.getConcept();
                linkCrossToToConcept.setPrimaryKeyColumnset(toConcept.getCurrentColumnSet());
                linkCrossToToConcept.setForeignKeyColumnset(crossColumnset);
            } else if (!toConcept.equals(toFeature.getConcept())) {
                throw new M4Exception("Case.createManyToManyRelation: all 'to' key attributes must belong to the same Concept!");
            }
            if (toFeature instanceof BaseAttribute) {
                Column fromCol = (Column)crossColumnset.getColumn(crossKeyName);
                Column toCol = (Column)((BaseAttribute)toFeature).getCurrentColumn();
                linkCrossToToConcept.addColumnLink(fromCol, toCol);
                continue;
            }
            throw new M4Exception("Case.createManyToManyRelation: MultiColumnFeatures are not allowed as Key attributes yet!");
        }
        if (fromConcept == null || toConcept == null) {
            throw new M4Exception("Case.createOneToManyRelation: either FromConcept or ToConcept or both are NULL!");
        }
        linkCrossToFromConcept.setName(crossTableName + "_" + fromConcept.getName() + "_FK");
        linkCrossToToConcept.setName(crossTableName + "_" + toConcept.getName() + "_FK");
        newRelation.setFromKey(linkCrossToFromConcept);
        newRelation.setToKey(linkCrossToToConcept);
        newRelation.setTheFromConcept(fromConcept);
        newRelation.setTheToConcept(toConcept);
        newRelation.setName(relName);
        return newRelation;
    }

    /*
     * WARNING - void declaration
     */
    public edu.udo.cs.miningmart.m4.Concept getConcept(String conceptName) throws M4Exception {
        void var3_3;
        Iterator it;
        Collection c = this.getConcepts();
        if (conceptName == null || c == null || (it = c.iterator()) == null) {
            return null;
        }
        while (var3_3.hasNext()) {
            Concept concept = (Concept)var3_3.next();
            if (concept == null || !conceptName.equals(concept.getName())) continue;
            return concept;
        }
        return null;
    }

    public Collection getAllConceptNames() throws M4Exception {
        Iterator it;
        Collection c = this.getConcepts();
        if (c == null || (it = c.iterator()) == null) {
            return null;
        }
        Vector<String> names = new Vector<String>();
        while (it.hasNext()) {
            Concept concept = (Concept)it.next();
            if (concept == null) continue;
            names.add(concept.getName());
        }
        return names;
    }

    public int compareTo(Object o) {
        return super.compareTo(o);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

