/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.ParameterObject;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Condition;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.Operator;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.util.Collection;
import java.util.Iterator;

public class Assertion
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.Assertion {
    public static final String M4_TABLE_NAME = "op_assert_t";
    public static final String ATTRIB_ASSERT_ID = "assert_id";
    public static final String ATTRIB_OPERATOR_ID = "assert_opid";
    public static final String ATTRIB_ASSERT_TYPE = "assert_type";
    public static final String ATTRIB_ASSERT_OBJ1 = "assert_obj1";
    public static final String ATTRIB_ASSERT_OBJ2 = "assert_obj2";
    private static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private Operator myOperator;
    private String myType;
    private String myObj1;
    private String myObj2;
    private static final String ASSERTION_NOT_NULL = "NOT_NULL";
    private static final String ASSERTION_UNIQUE = "UNIQUE";
    static /* synthetic */ Class class$edu$udo$cs$miningmart$m4$Operator;
    static /* synthetic */ Class class$java$lang$String;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_ASSERT_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_ASSERT_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_OPERATOR_ID, "getTheOperator", "primitiveSetOperator", class$edu$udo$cs$miningmart$m4$Operator == null ? (class$edu$udo$cs$miningmart$m4$Operator = Assertion.class$("edu.udo.cs.miningmart.m4.Operator")) : class$edu$udo$cs$miningmart$m4$Operator, "NN"), new M4InfoEntry(ATTRIB_ASSERT_TYPE, "getAssertionType", "setAssertionType", class$java$lang$String == null ? (class$java$lang$String = Assertion.class$("java.lang.String")) : class$java$lang$String, "NN"), new M4InfoEntry(ATTRIB_ASSERT_OBJ1, "getObj1", "setObj1", class$java$lang$String == null ? (class$java$lang$String = Assertion.class$("java.lang.String")) : class$java$lang$String, "NN"), new M4InfoEntry(ATTRIB_ASSERT_OBJ2, "getObj2", "setObj2", class$java$lang$String == null ? (class$java$lang$String = Assertion.class$("java.lang.String")) : class$java$lang$String)};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Operator", "getTheOperator", "setTheOperator", class$edu$udo$cs$miningmart$m4$Operator == null ? (class$edu$udo$cs$miningmart$m4$Operator = Assertion.class$("edu.udo.cs.miningmart.m4.Operator")) : class$edu$udo$cs$miningmart$m4$Operator), new M4InfoEntry("Type", "getAssertionType", "setAssertionType", class$java$lang$String == null ? (class$java$lang$String = Assertion.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Obj1", "getObj1", "setObj1", class$java$lang$String == null ? (class$java$lang$String = Assertion.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Obj2", "getObj2", "setObj2", class$java$lang$String == null ? (class$java$lang$String = Assertion.class$("java.lang.String")) : class$java$lang$String), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", class$java$lang$String == null ? (class$java$lang$String = Assertion.class$("java.lang.String")) : class$java$lang$String)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Assertion(DB db) {
        super(db);
    }

    public void print() {
        edu.udo.cs.miningmart.m4.Operator op = this.getTheOperator();
        String opName = op == null ? null : op.getName();
        this.doPrint(Print.M4_OBJECT, "Assertion (Id = " + this.getId() + ";" + " Name = " + this.getName() + "; TYPE = " + this.getAssertionType() + " OBJ1 = " + this.getObj1() + "; OBJ2 = " + this.getObj2() + " Operator = " + opName + ")");
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        return null;
    }

    public String getObj1() {
        return this.myObj1;
    }

    public String getObj2() {
        return this.myObj2;
    }

    public edu.udo.cs.miningmart.m4.Operator getTheOperator() {
        return this.myOperator;
    }

    public String getAssertionType() {
        return this.myType;
    }

    public void setObj1(String myObj1) {
        this.setDirty();
        this.myObj1 = myObj1;
    }

    public void setObj2(String myObj2) {
        this.setDirty();
        this.myObj2 = myObj2;
    }

    public void setTheOperator(edu.udo.cs.miningmart.m4.Operator operator) throws M4Exception {
        Operator.op2assert.updateReferenceTo(this, operator);
    }

    public void primitiveSetOperator(edu.udo.cs.miningmart.m4.Operator operator) {
        this.setDirty();
        this.myOperator = (Operator)operator;
    }

    public void setAssertionType(String myType) {
        this.setDirty();
        this.myType = myType;
    }

    protected void removeAllM4References() throws M4Exception {
        this.setTheOperator(null);
        this.removeDocObject();
    }

    public void writeAssertion(ExecutableOperator op) throws M4CompilerError {
        String assertionType = this.getAssertionType();
        for (int loop = 0; loop < op.getNumberOfLoops(); ++loop) {
            if (assertionType.equals(ASSERTION_NOT_NULL)) {
                this.assertNotNull(op, loop);
                continue;
            }
            if (!assertionType.equals(ASSERTION_UNIQUE)) continue;
            this.assertUniqueness(op, loop);
        }
    }

    private void assertNotNull(ExecutableOperator exOp, int loop) throws M4CompilerError {
        try {
            String obj1 = this.getObj1();
            ParameterObject[] parArray = exOp.getParameter(obj1, loop);
            Collection columns = Condition.getColumnsForParameter(parArray);
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                column.setNumberOfMissingValues(0);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 exception caught when checking assertion '" + this.getAssertionType() + "': " + m4e.getMessage());
        }
    }

    private void assertUniqueness(ExecutableOperator exOp, int loop) throws M4CompilerError {
        try {
            String obj1 = this.getObj1();
            ParameterObject[] parArray = exOp.getParameter(obj1, loop);
            Collection columns = Condition.getColumnsForParameter(parArray);
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                String countS = column.getColumnset().readOrComputeCount();
                try {
                    int count = Integer.parseInt(countS);
                    column.setNumberOfUniqueValues(count);
                    column.setNumberOfMissingValues(0);
                }
                catch (NumberFormatException e) {
                    this.doPrint(Print.WARNING, "Could not compute count for Columnset with ID " + column.getColumnset().getId());
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 exception caught when checking assertion '" + this.getAssertionType() + "': " + m4e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

