/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.installer;

import edu.udo.cs.miningmart.db.ConfigReader;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.util.DbConfigEditorWindow;
import edu.udo.cs.miningmart.m4.M4Interface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;

public class MmInstallerTools {
    private DB db;
    boolean usingPostgres;
    boolean usingOracle;
    private static boolean mmHomeOk = false;
    private static boolean dbConfigOk = false;
    private static boolean m4SchemaOk = false;
    private static boolean aprioriOk = false;
    private static boolean svmOk = false;
    private static boolean c45Ok = false;
    private static boolean kmeansOk = false;
    private static boolean featSelectOk = false;
    private static boolean opsOk = false;
    String[] operatorTables = new String[]{"op_constr_t", "op_cond_t", "op_assert_t", "op_params_t", "op_group_t", "operator_t"};

    public MmInstallerTools(DB myM4Db) throws M4Exception {
        try {
            this.db = myM4Db;
            this.usingOracle = this.db.getM4Dbms() == 1;
            this.usingPostgres = this.db.getM4Dbms() == 2;
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
        }
    }

    public static boolean installationIsValid() {
        MmInstallerTools m4sc;
        String dbFileName;
        File f;
        String home = System.getProperty("MM_HOME");
        if (home != null) {
            f = new File(home);
            mmHomeOk = f.exists();
        }
        if (mmHomeOk) {
            home = home + File.separator + "config";
            f = new File(home);
            mmHomeOk = f.exists();
        }
        if ((dbFileName = System.getProperty("DB_CONFIG_PATH")) == null) {
            dbConfigOk = false;
        } else {
            File f2 = new File(dbFileName);
            if (!f2.exists()) {
                dbConfigOk = false;
            } else {
                try {
                    new ConfigReader(dbFileName);
                    M4Interface.getInstance();
                    dbConfigOk = true;
                }
                catch (M4Exception m) {
                    dbConfigOk = false;
                }
            }
        }
        if (!dbConfigOk) {
            m4SchemaOk = false;
        } else {
            try {
                m4sc = new MmInstallerTools(M4Interface.getInstance().getM4db());
                m4SchemaOk = m4sc.m4TablesExist();
            }
            catch (M4Exception m) {
                m4SchemaOk = false;
            }
        }
        if (!m4SchemaOk) {
            opsOk = false;
        } else {
            try {
                m4sc = new MmInstallerTools(M4Interface.getInstance().getM4db());
                opsOk = m4sc.staticOperatorEntriesExist();
            }
            catch (M4Exception m) {
                opsOk = false;
            }
        }
        if (mmHomeOk) {
            String osName = System.getProperty("os.name");
            String[] filesToCheck = new String[]{};
            home = System.getProperty("MM_HOME");
            if (!home.endsWith(File.separator)) {
                home = home + File.separator;
            }
            String path = null;
            if (!osName.substring(0, 3).equalsIgnoreCase("win")) {
                if (osName.equalsIgnoreCase("SunOS")) {
                    path = home + "ext/bin/SunOS/";
                } else if (osName.equalsIgnoreCase("Linux")) {
                    path = home + "ext/bin/Linux";
                }
                filesToCheck = new String[]{path + "apriori"};
                if (MmInstallerTools.allFilesExist(filesToCheck)) {
                    aprioriOk = true;
                }
                if (MmInstallerTools.allFilesExist(filesToCheck = new String[]{path + "mysvm", path + "predict"})) {
                    svmOk = true;
                }
                if (!osName.equalsIgnoreCase("Linux")) {
                    filesToCheck = new String[]{path + "C4.5_script", path + "c4.5", path + "c4.5rules", path + "rules2dlf", path + "tree2dlf"};
                    if (MmInstallerTools.allFilesExist(filesToCheck)) {
                        c45Ok = true;
                    }
                    if (MmInstallerTools.allFilesExist(filesToCheck = new String[]{path + "mms3"})) {
                        kmeansOk = true;
                    }
                    if (MmInstallerTools.allFilesExist(filesToCheck = new String[]{path + "fsgenetic", path + "c4.5_fselect", path + "fsstat"})) {
                        featSelectOk = true;
                    }
                }
            }
        }
        return mmHomeOk && dbConfigOk && m4SchemaOk && opsOk;
    }

    public static boolean doInstallation(String possibleHomeDirectory) {
        MmInstallerTools m4sc;
        block47: {
            m4sc = null;
            String home = System.getProperty("MM_HOME");
            File f = null;
            if (home != null) {
                f = new File(home);
                if (f.exists()) {
                    mmHomeOk = true;
                } else {
                    home = possibleHomeDirectory;
                    f = new File(home);
                    if (f.exists()) {
                        mmHomeOk = true;
                    }
                }
            }
            while (!mmHomeOk) {
                if ((home = JOptionPane.showInputDialog(null, "Please enter the Home directory for MiningMart,\nwhich is the complete path up to and including 'MiningMart-1.0'.", home)) != null) {
                    f = new File(home);
                    mmHomeOk = f.exists();
                    continue;
                }
                mmHomeOk = false;
                return false;
            }
            String propertiesFile = home + "config" + File.separator + "MiningMartHome.properties";
            f = new File(propertiesFile);
            if (!f.exists()) {
                JOptionPane.showConfirmDialog(null, "File '" + propertiesFile + "' should exist but doesn't!", "Error during installation", 2, 0);
                return false;
            }
            if (mmHomeOk) {
                if (!home.endsWith(File.separator)) {
                    home = home + File.separator;
                }
            } else {
                return false;
            }
            MmInstallerTools.setKeyValuePair(propertiesFile, "MM_HOME", home);
            System.setProperty("MM_HOME", home);
            MiningMartApplication.setDefaultProperties();
            if (!dbConfigOk) {
                String dbFileName = System.getProperty("DB_CONFIG_PATH");
                boolean dbConfFileOk = false;
                f = null;
                if (dbFileName != null) {
                    f = new File(dbFileName);
                }
                if (dbFileName == null || f != null && !f.exists()) {
                    boolean endsWithSlash = home.endsWith(File.separator);
                    String suggestion = home + (endsWithSlash ? "" : File.separator) + "config" + File.separator + "db.config.myname";
                    dbFileName = JOptionPane.showInputDialog(null, "Please enter the complete path and file name for a\nfile that contains the database connection information.", suggestion);
                    if (dbFileName == null) {
                        return false;
                    }
                    f = new File(dbFileName);
                    if (!f.exists()) {
                        boolean ready = MmInstallerTools.makeDbConfigFile(dbFileName, propertiesFile);
                        if (!ready) {
                            return false;
                        }
                    } else {
                        MmInstallerTools.setKeyValuePair(propertiesFile, "DB_CONFIG_PATH", dbFileName);
                    }
                    System.setProperty("DB_CONFIG_PATH", dbFileName);
                }
                try {
                    new ConfigReader(dbFileName);
                    dbConfFileOk = true;
                }
                catch (M4Exception m4e) {
                    dbConfFileOk = false;
                }
                if (!dbConfFileOk) {
                    boolean ready = MmInstallerTools.makeDbConfigFile(dbFileName, home);
                    if (!ready) {
                        return false;
                    }
                    MmInstallerTools.setKeyValuePair(propertiesFile, "DB_CONFIG_PATH", dbFileName);
                    System.setProperty("DB_CONFIG_PATH", dbFileName);
                }
            }
            try {
                m4sc = new MmInstallerTools(M4Interface.getInstance().getM4db());
                dbConfigOk = true;
            }
            catch (M4Exception m4e) {
                JOptionPane.showConfirmDialog(null, "Error trying to connect to database:\n" + m4e.getMessage(), "Error during installation", 2, 0);
                return false;
            }
            MmInstallerTools.installationIsValid();
            if (!m4SchemaOk) {
                try {
                    if (m4sc.m4TablesExist()) {
                        m4SchemaOk = true;
                        break block47;
                    }
                    int choice = JOptionPane.showConfirmDialog(null, "Warning: the system has not found all M4 tables. It will now create the M4 tables in the schema that was given\nas M4 schema in the database. If you have old M4 tables or tables with names identical\nto any M4 table, they will be deleted! Do you want to continue?", "Database warning", 2, 2);
                    if (choice == 2) {
                        return false;
                    }
                    boolean usingOracle = M4Interface.getInstance().getM4db().getM4Dbms() == 1;
                    boolean usingPostgres = M4Interface.getInstance().getM4db().getM4Dbms() == 2;
                    String s = File.separator;
                    String fileName = home + s + "m4install" + s;
                    if (usingOracle) {
                        fileName = fileName + "oracle";
                    }
                    if (usingPostgres) {
                        fileName = fileName + "postgres";
                    }
                    String createTablesFileName = fileName + s + "CreateM4Tables.sql";
                    m4sc.removeM4Tables();
                    m4sc.createM4Tables(createTablesFileName);
                    m4sc.installM4Sequence();
                    String insertOpsFileName = fileName + s + "Operators.sql";
                    m4sc.writeOperatorsIntoSchema(insertOpsFileName);
                    try {
                        m4sc.db.commitM4Transactions();
                    }
                    catch (SQLException sq) {
                        throw new M4Exception("No COMMIT was possible after M4 tables were created: " + sq.getMessage());
                    }
                }
                catch (M4Exception m4e) {
                    JOptionPane.showConfirmDialog(null, "Error trying to create M4 tables:\n" + m4e.getMessage(), "Error during installation", 2, 0);
                    return false;
                }
                catch (DbConnectionClosed d) {
                    JOptionPane.showConfirmDialog(null, "Error trying to create M4 tables: database connection closed!\n" + d.getMessage(), "Error during installation", 2, 0);
                    return false;
                }
            }
        }
        if (!opsOk) {
            try {
                opsOk = m4sc.staticOperatorEntriesExist();
                if (!opsOk) {
                    MmInstallerTools.ensureOperatorsAreInserted();
                }
            }
            catch (M4Exception m4e) {
                JOptionPane.showConfirmDialog(null, "An error occurred when checking for operator entries or\nwhen inserting operators into M4 tables. Error message:\n" + m4e.getMessage(), "Error during installation", 2, 0);
                return false;
            }
        }
        try {
            int i;
            if (!aprioriOk) {
                m4sc.removeOperatorFromM4("Apriori");
            }
            if (!c45Ok) {
                String[] opsToDelete = new String[]{"MissingValuesWithDecisionTree", "MissingValuesWithDecisionRules", "PredictionWithDecisionTree", "PredictionWithDecisionRules", "DecisionTreeForRegression", "AssignPredictedValueCategorial"};
                for (i = 0; i < opsToDelete.length; ++i) {
                    m4sc.removeOperatorFromM4(opsToDelete[i]);
                }
            }
            if (!svmOk) {
                String[] opsToDelete = new String[]{"SupportVectorMachineForClassification", "MissingValuesWithRegressionSVM", "FeatureSelectionWithSVM", "ComputeSVMError", "SupportVectorMachineForRegression"};
                for (i = 0; i < opsToDelete.length; ++i) {
                    m4sc.removeOperatorFromM4(opsToDelete[i]);
                }
            }
            if (!featSelectOk) {
                String[] opsToDelete = new String[]{"StatisticalFeatureSelection", "GeneticFeatureSelection", "SGFeatureSelection"};
                for (i = 0; i < opsToDelete.length; ++i) {
                    m4sc.removeOperatorFromM4(opsToDelete[i]);
                }
            }
            if (!kmeansOk) {
                m4sc.removeOperatorFromM4("SegmentationWithKMean");
            }
        }
        catch (M4Exception m4e) {
            JOptionPane.showConfirmDialog(null, "An error occurred when some operators that depend on external algorithms\nwere disabled. Depending on the type of error some of your machine learning\noperators may be defect. Error message:\n" + m4e.getMessage(), "Error during installation", 2, 2);
            return true;
        }
        return true;
    }

    public static String createHomePropertiesFile(String homeDirectory) {
        String configDirectory;
        File f = new File(homeDirectory);
        if (!f.exists()) {
            JOptionPane.showConfirmDialog(null, "You have entered the home directory\n" + homeDirectory + "\n but it does not exist!");
            return null;
        }
        if (!homeDirectory.endsWith(File.separator)) {
            homeDirectory = homeDirectory + File.separator;
        }
        if (!(f = new File(configDirectory = homeDirectory + "config" + File.separator)).exists()) {
            JOptionPane.showConfirmDialog(null, "You have entered the home directory\n" + homeDirectory + "\n but it does not have the required subdirectory 'config'!");
            return null;
        }
        String propFile = configDirectory + "MiningMartHome.properties";
        f = new File(propFile);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            PrintStream out = new PrintStream(new FileOutputStream(f));
            out.println("# Main configuration file for MiningMart.\n#\n#");
            out.println("# You should enter here the path to the MiningMart system directory.");
            out.println("# Example (Windows): MM_HOME=C:\\Programs\\MiningMart-1.0\\");
            out.println("# Example (Linux):   MM_HOME=/home/myname/analysis/MiningMart-1.0/");
            out.println("\nMM_HOME = " + homeDirectory + "\n");
            out.println("# You may enter here the complete path to the file db.config; this file");
            out.println("# is usually in MM_HOME/config/ and if this is the case, the system");
            out.println("# finds out for itself.");
            out.println("\nDB_CONFIG_PATH = ...");
            out.flush();
            out.close();
            return propFile;
        }
        catch (IOException ioe) {
            JOptionPane.showConfirmDialog(null, "Error trying to write properties to '" + propFile + ":\n" + ioe.getMessage(), "Error during installation", 2, 0);
            return null;
        }
    }

    public static void readSystemPropsFromHomeProperties(String propFilename) {
        File f = new File(propFilename);
        if (!f.exists()) {
            return;
        }
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(f));
            String line = lnr.readLine();
            while (line != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) {
                    line = lnr.readLine();
                    continue;
                }
                int indexOfEqualSign = line.indexOf("=");
                if (indexOfEqualSign == -1) {
                    throw new IOException("Found invalid key-value pair, line: " + line);
                }
                String readKey = line.substring(0, indexOfEqualSign).trim();
                if (readKey.equals("")) {
                    throw new IOException("Found invalid key-value pair, line: " + line);
                }
                String readValue = null;
                if (line.length() > indexOfEqualSign + 1) {
                    readValue = line.substring(indexOfEqualSign + 1).trim();
                }
                if (readKey.equalsIgnoreCase("DB_CONFIG_PATH") && readValue != null) {
                    System.setProperty("DB_CONFIG_PATH", readValue);
                }
                if (readKey.equalsIgnoreCase("MM_HOME") && readValue != null) {
                    System.setProperty("MM_HOME", readValue);
                }
                line = lnr.readLine();
            }
            lnr.close();
        }
        catch (IOException i) {
            JOptionPane.showConfirmDialog(null, "Error reading properties from '" + propFilename + ":\n" + i.getMessage(), "Error during startup", 2, 0);
            return;
        }
    }

    public static boolean makeDbConfigFile(String nameForDbConfigFile, String homePropertiesFileName) {
        final HashMap theValues = new HashMap();
        final String dbFileName = nameForDbConfigFile;
        ActionListener a = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MmInstallerTools.writeDbConfigValuesToFile(theValues, dbFileName);
            }
        };
        DbConfigEditorWindow w = new DbConfigEditorWindow(null, theValues, a);
        w.setRestartWarning(false);
        w.prepareWindow();
        w.show();
        if (w.isCanceled()) {
            return false;
        }
        MmInstallerTools.setKeyValuePair(homePropertiesFileName, "DB_CONFIG_PATH", nameForDbConfigFile);
        System.setProperty("DB_CONFIG_PATH", nameForDbConfigFile);
        return true;
    }

    private static boolean setKeyValuePair(String givenFile, String key, String value) {
        try {
            File f = new File(givenFile);
            if (!f.exists()) {
                f.createNewFile();
            }
            Vector<String> newLines = new Vector<String>();
            LineNumberReader lnr = new LineNumberReader(new FileReader(f));
            String line = lnr.readLine();
            while (line != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) {
                    newLines.add(line);
                    line = lnr.readLine();
                    continue;
                }
                int indexOfEqualSign = line.indexOf("=");
                if (indexOfEqualSign == -1) {
                    throw new IOException("Found invalid key-value pair, line: " + line);
                }
                String readKey = line.substring(0, indexOfEqualSign).trim();
                if (readKey.equals("")) {
                    throw new IOException("Found invalid key-value pair, line: " + line);
                }
                String readValue = null;
                if (line.length() > indexOfEqualSign + 1) {
                    readValue = line.substring(indexOfEqualSign + 1).trim();
                }
                if ((value == null || value.equals("")) && readValue != null) {
                    value = readValue;
                }
                if (readKey.equalsIgnoreCase(key)) {
                    line = key + " = " + value;
                }
                newLines.add(line);
                line = lnr.readLine();
            }
            PrintStream out = new PrintStream(new FileOutputStream(f));
            Iterator it = newLines.iterator();
            while (it.hasNext()) {
                String nextLine = (String)it.next();
                out.println(nextLine);
            }
            out.flush();
            out.close();
            return true;
        }
        catch (IOException ioe) {
            JOptionPane.showConfirmDialog(null, "Error trying to read or write properties from/to '" + givenFile + ":\n" + ioe.getMessage(), "Error during installation", 2, 0);
            return false;
        }
    }

    private static boolean writeDbConfigValuesToFile(HashMap theMap, String nameForFile) {
        try {
            File f = new File(nameForFile);
            if (!f.exists()) {
                f.createNewFile();
            }
            PrintStream out = new PrintStream(new FileOutputStream(f));
            MmInstallerTools.writeStartComment(out);
            String dbName = (String)theMap.get("dbName");
            out.println("# Name of database used for M4 tables:");
            out.println("M4_DBNAME = " + dbName + "\n");
            String driver = (String)theMap.get("jdbcDriver");
            out.println("# Path to JDBC driver used to access M4 tables.");
            out.println("# For Oracle this is probably 'jdbc:oracle:thin:'.");
            out.println("# For Postgres this is probably 'jdbc:postgresql:'.");
            out.println("M4_JDBC_DRIVER = " + driver + "\n");
            String host = (String)theMap.get("dbHost");
            String port = (String)theMap.get("dbPort");
            out.println("# Access to database server for M4 tables.");
            out.println("# Format for Oracle: @<host>:<port>:");
            out.println("# Format for Postgres: //<host>:<port>    (note: no final colon)");
            boolean oracle = driver.indexOf("oracle") > -1;
            boolean postgr = driver.indexOf("postgres") > -1;
            String location = null;
            if (oracle) {
                location = "@" + host + ":" + port + ":";
            }
            if (postgr) {
                location = "//" + host + ":" + port;
            }
            out.println("M4_HOST_PORT = " + location + "\n");
            String m4user = (String)theMap.get("m4User");
            out.println("# Name of DB user who owns M4 tables:");
            out.println("M4_USER = " + m4user + "\n");
            String m4pass = (String)theMap.get("m4Pass");
            out.println("# Password for DB user who owns M4 tables:");
            out.println("M4_PASSWORD = " + m4pass + "\n");
            out.println("# Name of database used for business tables:");
            out.println("BUS_DBNAME = " + dbName + "\n");
            out.println("# Path to JDBC driver used to access business tables.");
            out.println("# For Oracle this is probably 'jdbc:oracle:thin:'.");
            out.println("# For Postgres this is probably 'jdbc:postgresql:'.");
            out.println("BUS_JDBC_DRIVER = " + driver + "\n");
            out.println("# Access to database server for business tables.");
            out.println("# Format for Oracle: @<host>:<port>:");
            out.println("# Format for Postgres: //<host>:<port>    (note: no final colon)");
            out.println("BUS_HOST_PORT = " + location + "\n");
            String bususer = (String)theMap.get("busUser");
            out.println("# Name of DB user who owns business tables:");
            out.println("BUS_USER = " + bususer + "\n");
            String buspass = (String)theMap.get("busPass");
            out.println("# Password for DB user who owns business tables:");
            out.println("BUS_PASSWORD = " + buspass + "\n");
            out.flush();
            out.close();
            return true;
        }
        catch (IOException ioe) {
            JOptionPane.showConfirmDialog(null, "Error trying to read database connection info from user or writing it to a config file:\n" + ioe.getMessage(), "Error during installation", 2, 0);
            return false;
        }
    }

    private static void writeStartComment(PrintStream out) {
        out.println("# This file contains the information that tells\n# the MiningMart system how to connect to your database.\n#\n# There are two sets of values. The first set is for\n# the M4 database schema. This is the schema where you\n# installed the M4 tables when you followed the instructions\n# in the file MM_HOME/m4install/<DbmsName>/README.txt. \n# The second set of values is for the database schema that \n# holds the data which you want to prepare or analyse.\n# The values given in the two sets may be identical.\n#\n# You might want to entertain several copies of this file\n# with different database connection information. In order\n# to start MiningMart with the connection you choose, enter\n# the name and path of the correct version of this file as\n# the value of DB_CONFIG_PATH into the file\n# MM_HOME/config/MiningMartHome.properties.");
    }

    private static boolean allFilesExist(String[] fileNames) {
        for (int i = 0; i < fileNames.length; ++i) {
            File f = new File(fileNames[i]);
            if (f.exists()) continue;
            return false;
        }
        return true;
    }

    public void removeM4Tables() throws M4Exception {
        String[] tablenames = DB.ORDER_FOR_WRITING;
        try {
            for (int i = tablenames.length - 1; i >= 0; --i) {
                this.db.dropM4Table(tablenames[i]);
            }
            this.db.commitM4Transactions();
        }
        catch (SQLException s) {
            try {
                this.db.rollbackOnM4();
            }
            catch (DbConnectionClosed dbc) {
                throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
            }
            catch (SQLException sqle) {
                throw new M4Exception("MmInstallerTools: SQL error accessing DB: " + sqle.getMessage());
            }
            throw new M4Exception("MmInstallerTools: SQL error trying to drop an M4 table: " + s.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
        }
    }

    public void writeOperatorsIntoSchema(String fileAndPathWithOperatorInfo) throws M4Exception {
        if (!this.m4TablesExist()) {
            throw new M4Exception("MmInstallerTools: cannot update operators since the M4 tables do not seem to exist!");
        }
        File f = new File(fileAndPathWithOperatorInfo);
        if (!f.exists()) {
            throw new M4Exception("MmInstallerTools: cannot update operators since Operator information file could not be found!");
        }
        try {
            String query = "ALTER TABLE step_t DROP CONSTRAINT stopid_fk";
            try {
                this.db.executeM4SqlWrite(query);
                query = "ALTER TABLE parameter_t DROP CONSTRAINT paropid_fk";
                this.db.executeM4SqlWrite(query);
            }
            catch (SQLException s) {
                // empty catch block
            }
            query = "DELETE FROM docu_t WHERE doc_objtype = 'OPERATOR'";
            this.db.executeM4SqlWrite(query);
            for (int i = 0; i < this.operatorTables.length; ++i) {
                query = "DELETE FROM " + this.operatorTables[i];
                this.db.executeM4SqlWrite(query);
            }
            this.writeSqlCommandsFromFileIntoDb(f, true);
            query = "ALTER TABLE step_t ADD (CONSTRAINT stopid_fk FOREIGN KEY (st_opid) REFERENCES operator_t (op_id))";
            if (this.db.getM4Dbms() == 2) {
                query = "ALTER TABLE step_t ADD CONSTRAINT stopid_fk FOREIGN KEY (st_opid) REFERENCES operator_t (op_id)";
            }
            this.db.executeM4SqlWrite(query);
            query = "ALTER TABLE parameter_t ADD (CONSTRAINT paropid_fk FOREIGN KEY (par_opid) REFERENCES operator_t (op_id))";
            if (this.db.getM4Dbms() == 2) {
                query = "ALTER TABLE parameter_t ADD CONSTRAINT paropid_fk FOREIGN KEY (par_opid) REFERENCES operator_t (op_id)";
            }
            this.db.executeM4SqlWrite(query);
            this.db.commitM4Transactions();
        }
        catch (SQLException sql) {
            try {
                this.db.rollbackOnM4();
            }
            catch (DbConnectionClosed dbc) {
                throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
            }
            catch (SQLException sqle) {
                throw new M4Exception("MmInstallerTools: SQL error accessing DB: " + sqle.getMessage());
            }
            throw new M4Exception("MmInstallerTools: SQL error updating operator information: " + sql.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
        }
    }

    public static void ensureOperatorsAreInserted() {
        String homeDir = System.getProperty("MM_HOME");
        if (!homeDir.endsWith(File.separator)) {
            homeDir = homeDir + File.separator;
        }
        DB mdb = null;
        try {
            mdb = M4Interface.getInstance().getM4db();
            boolean usingOracle = mdb.getM4Dbms() == 1;
            boolean usingPostgres = mdb.getM4Dbms() == 2;
            String opsFile = homeDir + "m4install" + File.separator;
            if (usingOracle) {
                opsFile = opsFile + "oracle";
            }
            if (usingPostgres) {
                opsFile = opsFile + "postgres";
            }
            opsFile = opsFile + File.separator + "Operators.sql";
            MmInstallerTools m4sc = new MmInstallerTools(mdb);
            m4sc.writeOperatorsIntoSchema(opsFile);
        }
        catch (M4Exception m) {
            JOptionPane.showConfirmDialog(null, "Error trying to insert operators into M4 tables. System cannot start. Error message:\n" + m.getMessage());
            System.exit(-1);
        }
        catch (DbConnectionClosed dbc) {
            JOptionPane.showConfirmDialog(null, "Error trying to insert operators into M4 tables. System cannot start. Error message:\n" + dbc.getMessage());
            System.exit(-1);
        }
    }

    public void createM4Tables(String fileNameAndPath) throws M4Exception {
        if (this.m4TablesExist()) {
            throw new M4Exception("MmInstallerTools: cannot create M4 tables since they seem to exist already!");
        }
        File f = new File(fileNameAndPath);
        if (!f.exists()) {
            throw new M4Exception("MmInstallerTools: cannot create M4 tables since the file with their creation commands could not be found!");
        }
        this.writeSqlCommandsFromFileIntoDb(f, false);
    }

    public void removeM4Sequence() throws M4Exception {
        String seqname = "ALL_SQ";
        String query = "DROP SEQUENCE " + seqname;
        try {
            this.db.executeM4SqlWrite(query);
        }
        catch (SQLException s) {
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
        }
    }

    public void installM4Sequence() throws M4Exception {
        this.removeM4Sequence();
        String seqname = "ALL_SQ";
        try {
            String query = "CREATE SEQUENCE " + seqname + " INCREMENT ";
            if (this.usingOracle) {
                query = query + "BY ";
            }
            query = query + "1 START ";
            if (this.usingOracle) {
                query = query + "WITH ";
            }
            query = query + "100000000 MAXVALUE 199999999 MINVALUE 100000000 ";
            if (this.usingOracle) {
                query = query + "NOCYCLE ";
            }
            query = query + "CACHE 20";
            if (this.usingOracle) {
                query = query + " NOORDER";
            }
            this.db.executeM4SqlWrite(query);
        }
        catch (SQLException sql) {
            try {
                this.db.rollbackOnM4();
            }
            catch (DbConnectionClosed dbc) {
                throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
            }
            catch (SQLException sqle) {
                throw new M4Exception("MmInstallerTools: SQL error accessing DB: " + sqle.getMessage());
            }
            throw new M4Exception("MmInstallerTools: SQL error installing M4 sequence: " + sql.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
        }
    }

    private void writeSqlCommandsFromFileIntoDb(File commandFile, boolean useDrops) throws M4Exception {
        String line = null;
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(commandFile));
            line = lnr.readLine();
            int lineCount = 0;
            while (line != null) {
                if ((line = line.trim()).startsWith("--")) {
                    line = lnr.readLine();
                    continue;
                }
                if (line.equals("")) {
                    line = lnr.readLine();
                    continue;
                }
                while (!line.endsWith(";")) {
                    line = line + " " + lnr.readLine().trim();
                }
                line = line.substring(0, line.length() - 1);
                if (!useDrops && line.toUpperCase().startsWith("DROP ")) {
                    line = lnr.readLine();
                    continue;
                }
                this.db.executeM4SqlWrite(line);
                if (++lineCount % 500 == 0) {
                    this.db.commitM4Transactions();
                    this.db.getFreshM4Connection();
                }
                line = lnr.readLine();
            }
            this.db.commitM4Transactions();
            this.db.getFreshM4Connection();
        }
        catch (IOException ioe) {
            try {
                this.db.rollbackOnM4();
            }
            catch (DbConnectionClosed dbc) {
                throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
            }
            catch (SQLException sqle) {
                throw new M4Exception("MmInstallerTools: SQL error accessing DB: " + sqle.getMessage());
            }
            throw new M4Exception("MmInstallerTools: error accessing file: " + ioe.getMessage());
        }
        catch (SQLException sql) {
            try {
                this.db.rollbackOnM4();
            }
            catch (DbConnectionClosed dbc) {
                throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
            }
            catch (SQLException sqle) {
                throw new M4Exception("MmInstallerTools: SQL error accessing DB: " + sqle.getMessage());
            }
            throw new M4Exception("MmInstallerTools: SQL error executing command from file.\nLine: " + line + "\nMessage: " + sql.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: error accessing DB (connection closed): " + dbc.getMessage());
        }
    }

    private boolean m4TablesExist() throws M4Exception {
        String[] tablenames = DB.ORDER_FOR_WRITING;
        for (int i = tablenames.length - 1; i >= 0; --i) {
            if (this.db.tableExistsInM4(tablenames[i])) continue;
            return false;
        }
        return true;
    }

    private boolean staticOperatorEntriesExist() throws M4Exception {
        for (int i = 0; i < this.operatorTables.length; ++i) {
            if (!this.m4TableIsEmpty(this.operatorTables[i])) continue;
            return false;
        }
        return true;
    }

    private boolean m4TableIsEmpty(String tableName) throws M4Exception {
        String query = "SELECT COUNT(*) FROM " + tableName;
        try {
            Long l = this.db.executeM4SingleValueSqlReadL(query);
            return l == 0L;
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("MmInstallerTools: Db connection closed when checking if table '" + tableName + "' is empty: " + d.getMessage());
        }
        catch (SQLException s) {
            throw new M4Exception("MmInstallerTools: SQL error when checking if table '" + tableName + "' is empty: " + s.getMessage());
        }
    }

    private void removeOperatorFromM4(String operatorName) throws M4Exception {
        String query = "SELECT op_id FROM operator_t WHERE op_name = '" + operatorName + "'";
        Long l = null;
        try {
            l = this.db.executeM4SingleValueSqlReadL(query);
            String[] operatorTableIdFields = new String[]{"constr_opid", "cond_opid", "assert_opid", "op_id", "opg_opid", "op_id"};
            if (l != null) {
                query = "DELETE FROM docu_t WHERE doc_objid = " + l;
                this.db.executeM4SqlWrite(query);
                for (int i = 0; i < this.operatorTables.length; ++i) {
                    query = "DELETE FROM " + this.operatorTables[i] + " WHERE " + operatorTableIdFields[i] + " = " + l;
                    this.db.executeM4SqlWrite(query);
                }
            }
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error removing operator '" + operatorName + "': " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("MmInstallerTools: Connection to M4-DB was closed: " + dbc.getMessage());
        }
    }
}

