/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.util;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.DeleteCaseDialog;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import javax.swing.JOptionPane;
import org.musoft.limo.application.Resource;

public class CaseTrasher {
    private int retVal;
    private Case m4case = null;
    private boolean caseWasOpen;
    private MiningMartApplication application;

    public CaseTrasher(MiningMartApplication application) {
        this.application = application;
    }

    public void init() {
        this.retVal = 0;
        if (this.application.getModel() != null && M4Interface.getCurrentCase() != null) {
            this.m4case = M4Interface.getCurrentCase();
            this.caseWasOpen = true;
        } else {
            this.caseWasOpen = false;
            Object m4Cases = null;
            DeleteCaseDialog dialog = new DeleteCaseDialog(this.application);
            String casename = null;
            if (dialog.getExitAction() != 1) {
                this.retVal = 2;
                return;
            }
            this.retVal = 0;
            casename = dialog.getSelectedCase();
            try {
                this.m4case = MiningMartApplication.m4Interface.findCaseForUpdate(casename, true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.application, Resource.getString("ERROR_CANNOT_DELETE_CASE"), Resource.getString("DIALOG_ERROR_TITLE"), 0);
                this.retVal = 2;
            }
        }
    }

    public int deleteCase() {
        if (this.m4case == null || this.retVal != 0) {
            return -1;
        }
        Case caseToDelete = this.m4case;
        this.m4case = null;
        this.retVal = JOptionPane.showOptionDialog(this.application, Resource.getString("DELETE_CASE_MSG1") + "\n" + caseToDelete.getName() + "!\n" + Resource.getString("DELETE_CASE_MSG2"), Resource.getString("DELETE_CASE_TITLE"), 0, 3, null, null, null);
        if (this.retVal != 0) {
            if (!this.caseWasOpen) {
                MiningMartApplication.m4Interface.releaseCase(caseToDelete.getName());
            }
            return -1;
        }
        if (this.caseWasOpen) {
            this.application.promptClose();
        } else {
            MiningMartApplication.m4Interface.releaseCase(caseToDelete.getName());
        }
        try {
            caseToDelete.deleteSoon();
            caseToDelete.store();
        }
        catch (M4Exception e) {
            M4Interface.print.doPrint(Print.ERROR, Resource.getString("ERROR_CANNOT_DELETE_CASE"), e);
            JOptionPane.showMessageDialog(this.application, Resource.getString("ERROR_CANNOT_DELETE_CASE") + "\n" + caseToDelete.getName() + "\n" + e.getMessage(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return -1;
        }
        M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("CASE_DELETED"));
        if (M4Interface.getCurrentCase().equals(caseToDelete)) {
            M4Interface.removeCurrentCase();
        }
        return 0;
    }
}

