/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.util;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.MiningMartException;
import edu.udo.cs.miningmart.gui.application.CreateCaseDialog;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.XMLFileFilter;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.core.Case;
import edu.udo.cs.miningmart.m4.utils.M4Xml;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.musoft.limo.application.Resource;

public class CaseImporter {
    private MiningMartApplication app;
    private InputStream inputStream;
    private int retVal = 0;
    private boolean withColumns = false;
    private boolean noFile = false;

    public CaseImporter(MiningMartApplication parent) {
        this.app = parent;
        this.init();
    }

    public void init() {
        JFileChooser chooser = new JFileChooser(this.app.getWorkingDir());
        chooser.setFileFilter(new XMLFileFilter());
        this.retVal = chooser.showOpenDialog(this.app);
        File file = chooser.getSelectedFile();
        if (file == null) {
            this.noFile = true;
            return;
        }
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this.app, Resource.getString("ERROR_FILE_NOT_EXISTS") + "\n" + file.getName(), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            this.noFile = true;
            return;
        }
        this.noFile = false;
        String filename = file.getPath();
        try {
            this.inputStream = new BufferedInputStream(new FileInputStream(filename));
        }
        catch (FileNotFoundException fnfe) {
            M4Interface.print.doPrint(Print.ERROR, fnfe.getMessage(), fnfe);
            this.retVal = 2;
        }
        this.app.setWorkingDir(file.getParent());
    }

    public boolean importCase() throws IOException {
        if (this.noFile) {
            return false;
        }
        DB db = M4Interface.getInstance().getM4db();
        try {
            Case m4case = M4Xml.importCase(this.inputStream, db, "M4-XML V0.5");
            CreateCaseDialog ccd = new CreateCaseDialog(this.app, Resource.getString("SET_NAME_FOR_CASE"), true);
            ccd.showCreateDialog(m4case);
            M4Interface.setCurrentCase(m4case);
        }
        catch (MiningMartException e) {
            throw new IOException(e.getMessage());
        }
        return true;
    }
}

