/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.util;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.XMLFileFilter;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.core.Case;
import edu.udo.cs.miningmart.m4.utils.M4Xml;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.musoft.limo.application.Resource;

public class CaseExporter {
    private MiningMartApplication app;
    private String filename;
    private Writer exportWriter;
    private edu.udo.cs.miningmart.m4.Case casetoexport;
    private int returnVal = 0;
    private boolean withColumns = false;
    private boolean noFile = true;

    public CaseExporter(MiningMartApplication parent, edu.udo.cs.miningmart.m4.Case caseToExport) {
        this.app = parent;
        this.casetoexport = caseToExport;
        this.init();
    }

    public void init() {
        JFileChooser chooser = new JFileChooser(this.app.getWorkingDir());
        chooser.setFileFilter(new XMLFileFilter());
        this.returnVal = chooser.showSaveDialog(this.app);
        File file = chooser.getSelectedFile();
        if (file == null) {
            this.noFile = true;
            return;
        }
        this.noFile = false;
        this.filename = file.getPath();
        if (!this.filename.endsWith(".xml")) {
            if (this.filename.lastIndexOf(".") != -1) {
                this.filename = this.filename.substring(0, this.filename.lastIndexOf("."));
            }
            this.filename = this.filename + ".xml";
            file = new File(this.filename);
        }
        if (file.exists()) {
            int ret = JOptionPane.showConfirmDialog(this.app, Resource.getString("QUEST_OVERWRITE") + "\n" + file.getName(), Resource.getString("DIALOG_TITLE_FILE_EXISTS"), 0, 3);
            if (ret == 1) {
                this.noFile = true;
                return;
            }
            this.app.setWorkingDir(file.getParent());
        }
        try {
            FileWriter f = new FileWriter(this.filename);
            this.exportWriter = new BufferedWriter(f);
        }
        catch (FileNotFoundException fnfe) {
            M4Interface.print.doPrint(Print.ERROR, fnfe.getMessage(), fnfe);
            this.returnVal = 2;
        }
        catch (IOException ioe) {
            M4Interface.print.doPrint(Print.ERROR, ioe.getMessage(), ioe);
            this.returnVal = 2;
        }
    }

    public void exportCase() {
        if (this.noFile) {
            return;
        }
        try {
            M4Xml.exportCase((Case)this.casetoexport, this.exportWriter);
        }
        catch (IOException ioe) {
            M4Interface.print.doPrint(Print.ERROR, Resource.getString("ERROR_EXPORT_CASE1") + " " + Resource.getString("ERROR_EXPORT_CASE2") + " " + Resource.getString("ERROR_EXPORT_CASE3"), ioe);
            JOptionPane.showMessageDialog(this.app, Resource.getString("ERROR_EXPORT_CASE2") + " " + Resource.getString("ERROR_EXPORT_CASE3"), Resource.getString("ERROR_EXPORT_CASE1"), 0);
            ioe.printStackTrace();
            this.returnVal = 2;
            return;
        }
        if (this.returnVal != 2) {
            M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("CASE_EXPORTED1") + "\"" + this.casetoexport.getName() + "\"" + Resource.getString("CASE_EXPORTED2") + this.filename);
            JOptionPane.showMessageDialog(this.app, Resource.getString("CASE_EXPORTED1") + this.casetoexport.getName() + "!", Resource.getString("DIALOG_INFO_TITLE"), 1);
        }
    }
}

