/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.model.MiningMartStep;
import edu.udo.cs.miningmart.gui.model.StepTransition;
import edu.udo.cs.miningmart.gui.stepsettings.GroupsDialog;
import edu.udo.cs.miningmart.gui.stepsettings.LoopListener;
import edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor;
import edu.udo.cs.miningmart.gui.stepsettings.StepLoopPanel;
import edu.udo.cs.miningmart.gui.stepsettings.StepParameterModel;
import edu.udo.cs.miningmart.gui.stepsettings.StepParameterTable;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;

public class StepSettingsPanel
extends JPanel
implements ActionListener {
    public static final int NOT_TESTED = 0;
    public static final int VALID = 1;
    public static final int NOT_VALID = 2;
    private static final Color COLOR_NOT_TESTED = Resource.getColor("STEPSETTINGS_COLOR_NOT_TESTED");
    private static final Color COLOR_VALID = Resource.getColor("STEPSETTINGS_COLOR_VALID");
    private static final Color COLOR_NOT_VALID = Resource.getColor("STEPSETTINGS_COLOR_NOT_VALID");
    private MiningMartApplication app;
    private MiningMartStep mstep;
    private Step step;
    private Operator operator;
    private JLabel stepname;
    private JButton savebutton;
    private JButton closebutton;
    private JButton cancelbutton;
    private JButton validbutton;
    private JButton showgroupsbutton;
    private StepLoopPanel looppanel;
    private StepParameterTable paramtable;
    private LoopListener looplistener;
    private int validity;
    private boolean inputchanged;
    private boolean outputchanged;
    private boolean loopcountlower;
    private boolean loopcounthigher;
    private int minloopnr_changes_input;
    private int minloopnr_changes_output;

    public StepSettingsPanel(MiningMartApplication app, MiningMartStep step) {
        this.app = app;
        this.mstep = step;
        this.step = step.getStep();
        this.operator = this.step.getTheOperator();
        this.validity = 0;
        this.inputchanged = false;
        this.outputchanged = false;
        this.loopcountlower = false;
        this.loopcounthigher = false;
        this.minloopnr_changes_input = Integer.MAX_VALUE;
        this.minloopnr_changes_output = Integer.MAX_VALUE;
        this.initComponents();
    }

    private void initComponents() {
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout());
        JScrollPane scrollpanel = new JScrollPane(toppanel);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollpanel, "Center");
        JPanel northpanel = new JPanel();
        northpanel.setLayout(new BorderLayout());
        toppanel.add((Component)northpanel, "North");
        JPanel oppanel = new JPanel();
        oppanel.setLayout(new GridLayout(2, 1, 5, 5));
        oppanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        northpanel.add((Component)oppanel, "North");
        JLabel oplabel1 = new JLabel();
        oplabel1.setText(this.step.getTheOperator().getName());
        Font opfont = new Font("SansSerif", 0, 15);
        oplabel1.setFont(opfont);
        oplabel1.setHorizontalAlignment(0);
        oppanel.add(oplabel1);
        this.stepname = new JLabel();
        this.stepname.setText(this.step.getName());
        Font stepfont = new Font("SansSerif", 0, 13);
        this.stepname.setFont(stepfont);
        this.stepname.setHorizontalAlignment(0);
        this.stepname.setForeground(Color.BLUE);
        oppanel.add(this.stepname);
        try {
            if (this.operator.isLoopable() && !this.step.usesLoopsForCoordination()) {
                this.looppanel = new StepLoopPanel(this.app, this.step);
                northpanel.add((Component)this.looppanel, "Center");
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        JPanel southpanel = new JPanel();
        southpanel.setLayout(new BorderLayout());
        toppanel.add((Component)southpanel, "South");
        JPanel buttonpanel = new JPanel();
        buttonpanel.setLayout(new GridLayout(2, 1));
        buttonpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        southpanel.add((Component)buttonpanel, "East");
        JPanel buttonpanel1 = new JPanel();
        buttonpanel1.setLayout(new FlowLayout(2));
        buttonpanel.add(buttonpanel1);
        JPanel buttonpanel2 = new JPanel();
        buttonpanel2.setLayout(new FlowLayout(2));
        buttonpanel.add(buttonpanel2);
        this.savebutton = new JButton(Resource.getString("STEPSETTINGS_SAVE"));
        this.savebutton.setEnabled(false);
        buttonpanel2.add(this.savebutton);
        this.cancelbutton = new JButton(Resource.getString("STEPSETTINGS_CANCEL"));
        this.cancelbutton.setEnabled(false);
        buttonpanel2.add(this.cancelbutton);
        this.closebutton = new JButton(Resource.getString("STEPSETTINGS_CLOSE"));
        this.closebutton.addActionListener(this);
        buttonpanel2.add(this.closebutton);
        if (this.hasCoordinates()) {
            this.showgroupsbutton = new JButton(Resource.getString("STEPSETTINGS_SHOW_GROUPS"));
            this.showgroupsbutton.addActionListener(this);
            buttonpanel1.add(this.showgroupsbutton);
        }
        this.validbutton = new JButton(Resource.getString("STEPSETTINGS_VALID"));
        buttonpanel1.add(this.validbutton);
        this.setValidity(0);
        if (this.app.getViewMode() == 0) {
            this.savebutton.addActionListener(this);
            this.cancelbutton.addActionListener(this);
            this.validbutton.addActionListener(this);
        } else {
            this.savebutton.setEnabled(false);
            this.cancelbutton.setEnabled(false);
            this.validbutton.setEnabled(false);
        }
        this.paramtable = new StepParameterTable(this.app, this.step, this.app.getViewMode() == 0, new ParameterChangeListener());
        this.paramtable.createEditorAndRenderer();
        JScrollPane scrollpane = new JScrollPane(this.paramtable);
        toppanel.add((Component)scrollpane, "Center");
        try {
            if (this.operator.isLoopable() && !this.step.usesLoopsForCoordination()) {
                this.looplistener = new LoopListener(this, this.paramtable);
                this.looppanel.getIteratorList().addIteratorListener(this.looplistener);
                this.looppanel.addNrOfLoopsListener(this.looplistener);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void setStepName(String name) {
        this.stepname.setText(name);
    }

    public MiningMartStep getMiningMartStep() {
        return this.mstep;
    }

    private boolean hasCoordinates() {
        try {
            Iterator iter = this.step.getTheOperator().getOpParamsIterator();
            while (iter.hasNext()) {
                OpParam opParam = (OpParam)iter.next();
                if (!opParam.isCoordinated()) continue;
                return true;
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        return false;
    }

    public int getValidity() {
        return this.validity;
    }

    public void setValidity(int v) {
        this.validity = v;
        switch (this.validity) {
            case 0: {
                this.validbutton.setBackground(COLOR_NOT_TESTED);
                break;
            }
            case 1: {
                this.validbutton.setBackground(COLOR_VALID);
                break;
            }
            case 2: {
                this.validbutton.setBackground(COLOR_NOT_VALID);
                break;
            }
            default: {
                this.validbutton.setBackground(Color.WHITE);
            }
        }
    }

    public String toString() {
        return Resource.getString("STEPSETTINGS");
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(Resource.getString("STEPSETTINGS_SAVE"))) {
            this.saveParameter();
        } else if (command.equals(Resource.getString("STEPSETTINGS_CANCEL"))) {
            this.cancelEditing();
        } else if (command.equals(Resource.getString("STEPSETTINGS_CLOSE"))) {
            this.app.removeStepSettingsPanel();
        } else if (command.equals(Resource.getString("STEPSETTINGS_SHOW_GROUPS"))) {
            GroupsDialog groupsDialog = new GroupsDialog(this.app, this.step, this.paramtable.getEditor());
        } else if (command.equals(Resource.getString("STEPSETTINGS_VALID"))) {
            this.testValidity(false);
        }
    }

    public void enableCancelSave(boolean bool) {
        this.cancelbutton.setEnabled(bool);
        this.savebutton.setEnabled(bool);
    }

    public void cancelEditing() {
        if (this.looppanel != null) {
            this.looppanel.setNumberOfLoops(((StepParameterModel)this.paramtable.getModel()).getOldNrOfLoops());
        }
        try {
            this.paramtable.cancelEditing();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("STEPSETTINGS_SETTING_INPUT"), 0);
            return;
        }
        this.app.saveModel();
        this.inputchanged = false;
        this.outputchanged = false;
        this.loopcountlower = false;
        this.loopcounthigher = false;
        this.minloopnr_changes_input = Integer.MAX_VALUE;
        this.minloopnr_changes_output = Integer.MAX_VALUE;
        this.savebutton.setEnabled(false);
        this.cancelbutton.setEnabled(false);
    }

    public boolean testValidity(boolean save) {
        boolean isValid = false;
        try {
            this.paramtable.setParameterCollectionsInStep(save);
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("STEPSETTINGS_SETTING_INPUT"), 0);
            this.setValidity(2);
            return false;
        }
        int loop = this.step.getLoopCount();
        if (loop == 0) {
            loop = 1;
        }
        if (((StepParameterModel)this.paramtable.getModel()).getNrOfLoops() < loop) {
            this.loopcountlower = true;
        }
        if (((StepParameterModel)this.paramtable.getModel()).getNrOfLoops() > loop) {
            this.loopcounthigher = true;
        }
        try {
            isValid = this.step.checkInputParameterEntries();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("STEPSETTINGS_CHECK_INPUT"), 0);
            isValid = false;
        }
        if (isValid) {
            this.setValidity(1);
        } else {
            this.setValidity(2);
        }
        return isValid;
    }

    public void saveParameter() {
        if (this.testValidity(true)) {
            if (((StepParameterModel)this.paramtable.getModel()).getNrOfLoops() < this.minloopnr_changes_input) {
                this.inputchanged = false;
            }
            if (((StepParameterModel)this.paramtable.getModel()).getNrOfLoops() < this.minloopnr_changes_output) {
                this.outputchanged = false;
            }
            try {
                this.paramtable.makeOutput(this.inputchanged, this.outputchanged, this.loopcountlower, this.loopcounthigher);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                JOptionPane.showMessageDialog(this.app, error.getMessage(), Resource.getString("STEPSETTINGS_MAKE_OUTPUT"), 0);
            }
            Model model = (Model)this.mstep.getParent();
            for (int i = 0; i < model.getConnectionCount(); ++i) {
                ModelConnectionElement conn = model.getConnection(i);
                if (!conn.getStart().getName().equals(this.step.getName())) continue;
                ((StepTransition)conn).refreshName();
            }
            this.app.saveModel();
            this.inputchanged = false;
            this.outputchanged = false;
            this.loopcountlower = false;
            this.loopcounthigher = false;
            this.minloopnr_changes_input = Integer.MAX_VALUE;
            this.minloopnr_changes_output = Integer.MAX_VALUE;
            this.savebutton.setEnabled(false);
        } else {
            boolean save_input;
            boolean bl = save_input = JOptionPane.showConfirmDialog(this.app, Resource.getString("STEPSETTINGS_SAVE_MSG1") + "\n" + Resource.getString("STEPSETTINGS_SAVE_MSG2") + "\n" + Resource.getString("STEPSETTINGS_SAVE_MSG3"), Resource.getString("STEPSETTINGS_SAVE_TITLE"), 0, 2) == 0;
            if (save_input) {
                this.app.saveModel();
            }
        }
    }

    private class ParameterChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent event) {
            StepSettingsPanel.this.setValidity(0);
            StepSettingsPanel.this.savebutton.setEnabled(true);
            StepSettingsPanel.this.cancelbutton.setEnabled(true);
            ParameterEditor parameditor = (ParameterEditor)event.getSource();
            if (parameditor.getTheOpParam().isInput()) {
                try {
                    if (StepSettingsPanel.this.step.inputChangeCanAffectOutput(parameditor.getTheOpParam())) {
                        StepSettingsPanel.this.inputchanged = true;
                    }
                }
                catch (M4Exception error) {
                    M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    JOptionPane.showMessageDialog(StepSettingsPanel.this.app, error.getMessage(), Resource.getString("STEPSETTINGS"), 0);
                }
                StepSettingsPanel.this.minloopnr_changes_input = Math.min(StepSettingsPanel.this.minloopnr_changes_input, parameditor.getLoopNumber());
            } else {
                StepSettingsPanel.this.outputchanged = true;
                StepSettingsPanel.this.minloopnr_changes_output = Math.min(StepSettingsPanel.this.minloopnr_changes_output, parameditor.getLoopNumber());
            }
        }
    }
}

