/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.MiningMartException;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.util.Iterator;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.musoft.limo.application.Resource;

public class StepParameterModel
extends AbstractTableModel {
    private Step step;
    private Operator operator;
    private boolean editable;
    private String[] paramnames;
    private int loopnumber;
    private int nrOfLoops;
    private int oldNrOfLoops;

    public StepParameterModel(Step step, boolean editable) {
        this.step = step;
        this.operator = step.getTheOperator();
        this.editable = editable;
        this.loopnumber = 1;
        this.nrOfLoops = step.getLoopCount();
        if (this.nrOfLoops == 0) {
            this.nrOfLoops = 1;
        }
        this.oldNrOfLoops = this.nrOfLoops;
        this.initParameterNames();
    }

    private void initParameterNames() {
        this.paramnames = new String[this.getRowCount()];
        try {
            int p;
            Iterator iter = this.step.getTheOperator().getOpParamsIterator();
            for (p = 0; iter.hasNext() && p < this.paramnames.length; ++p) {
                OpParam opparam = (OpParam)iter.next();
                this.paramnames[p] = opparam.getName();
            }
            if (p != this.paramnames.length) {
                System.out.println("ParameterNames not all catched: " + p);
            }
        }
        catch (MiningMartException error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void setLoopNumber(int loopnumber) {
        this.loopnumber = loopnumber;
        this.fireTableDataChanged();
        this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount()));
    }

    public void setNrOfLoops(int nrOfLoops) {
        if (nrOfLoops == 0) {
            nrOfLoops = 1;
        }
        this.nrOfLoops = nrOfLoops;
    }

    public int getNrOfLoops() {
        return this.nrOfLoops;
    }

    public int getOldNrOfLoops() {
        return this.oldNrOfLoops;
    }

    public void setOldNrOfLoops(int oldNrOfLoops) {
        this.oldNrOfLoops = oldNrOfLoops;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        int rows = 0;
        try {
            rows = this.step != null && this.step.getTheOperator() != null ? this.step.getTheOperator().getOpParams().size() : 0;
        }
        catch (MiningMartException error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            rows = 0;
        }
        return rows;
    }

    public Object getValueAt(int rowIndex, int colIndex) {
        if (colIndex == 0) {
            return this.getParameterName(rowIndex);
        }
        return new String("");
    }

    public String getParameterName(int rowIndex) {
        if (this.paramnames[rowIndex] != null) {
            return this.paramnames[rowIndex];
        }
        return "";
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return Resource.getString("STEPSETTINGS_TABLE_PARAMETER");
        }
        if (columnIndex == 1) {
            return Resource.getString("STEPSETTINGS_TABLE_VALUE");
        }
        return "";
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    public short getType(int row) {
        try {
            OpParam opparam = (OpParam)this.step.getTheOperator().getOpParams().toArray()[row];
            return opparam.getType();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return -1;
        }
    }

    public boolean isInput(int row) {
        try {
            OpParam opparam = (OpParam)this.step.getTheOperator().getOpParams().toArray()[row];
            return opparam.isInput();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return false;
        }
    }

    public OpParam getOpParam(int row) {
        try {
            OpParam opparam = (OpParam)this.step.getTheOperator().getOpParams().toArray()[row];
            return opparam;
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            return null;
        }
    }

    public OpParam getOpParamByName(String opParamName) {
        for (int n = 0; n < this.paramnames.length; ++n) {
            if (!this.paramnames[n].equals(opParamName)) continue;
            return this.getOpParam(n);
        }
        return null;
    }

    public int getRowOfOpParamByName(String opParamName) {
        for (int n = 0; n < this.paramnames.length; ++n) {
            if (!this.paramnames[n].equals(opParamName)) continue;
            return n;
        }
        return -1;
    }
}

