/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.gui.application.IteratorList;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.NrOfLoopsListener;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.musoft.limo.application.Resource;

public class StepLoopPanel
extends JPanel
implements ActionListener {
    private MiningMartApplication app;
    private Step step;
    private int oldnumber = 0;
    private int number = 0;
    private JButton change;
    private JTextField loopsfield;
    private IteratorList iterlist;
    private Vector looplistener;

    public StepLoopPanel(MiningMartApplication app, Step step) {
        this.app = app;
        this.step = step;
        this.looplistener = new Vector();
        this.initComponents();
    }

    public void addNrOfLoopsListener(NrOfLoopsListener listener) {
        this.looplistener.add(listener);
    }

    public void removeNrOfLoopsListener(NrOfLoopsListener listener) {
        this.looplistener.remove(listener);
    }

    public void reamoveAllNrOfLoopsListener() {
        this.looplistener.removeAllElements();
    }

    public int getNrOfLoopsListenerCount() {
        return this.looplistener.size();
    }

    public NrOfLoopsListener getNrOfLoopsListener(int index) {
        return (NrOfLoopsListener)this.looplistener.get(index);
    }

    public void fireNrOfLoopsChanged() {
        for (int i = 0; i < this.looplistener.size(); ++i) {
            NrOfLoopsListener listener = this.getNrOfLoopsListener(i);
            listener.numberOfLoopsChanged(this.getNumberOfLoops(false));
        }
    }

    private void initComponents() {
        this.setLayout(new FlowLayout());
        JLabel label1 = new JLabel(Resource.getString("NUMBER_OF_LOOPS"));
        label1.setHorizontalAlignment(2);
        label1.setHorizontalTextPosition(2);
        this.add(label1);
        this.loopsfield = new JTextField("0", 2);
        this.loopsfield.setText(Integer.toString(this.step.getLoopCount()));
        this.loopsfield.setHorizontalAlignment(4);
        if (this.app.getViewMode() != 0) {
            this.loopsfield.setEnabled(false);
        }
        this.add(this.loopsfield);
        this.change = new JButton(Resource.getString("CHANGE_LOOP_NUMBER"));
        if (this.app.getViewMode() == 0) {
            this.change.addActionListener(this);
        } else {
            this.change.setEnabled(false);
        }
        this.add(this.change);
        JLabel label2 = new JLabel(Resource.getString("SHOW_LOOP_NUMBER"));
        this.add(label2);
        this.iterlist = new IteratorList();
        this.setData(this.step.getLoopCount());
        this.add(this.iterlist);
        if (this.app.isReadOnly()) {
            this.change.setEnabled(false);
            this.loopsfield.setEnabled(false);
        } else {
            this.change.setEnabled(true);
            this.loopsfield.setEnabled(true);
        }
    }

    public IteratorList getIteratorList() {
        return this.iterlist;
    }

    public void setNumberOfLoops(int nrOfLoops) {
        this.loopsfield.setText(nrOfLoops + "");
        this.setData(nrOfLoops);
        if (nrOfLoops >= 0) {
            this.fireNrOfLoopsChanged();
        }
    }

    public int getNumberOfLoops(boolean error) {
        int nr = 0;
        try {
            nr = Integer.parseInt(this.loopsfield.getText());
        }
        catch (NumberFormatException e) {
            if (error) {
                JOptionPane.showMessageDialog(this.app, Resource.getString("STEPSETTINGS_LOOPNUMBER_ERROR"), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            }
            M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
        }
        return nr;
    }

    public int getCurrentLoop() {
        int erg = 0;
        if (this.getNumberOfLoops(false) > 0) {
            String value = this.iterlist.getSelected();
            try {
                erg = Integer.parseInt(value);
            }
            catch (Exception e) {
                M4Interface.print.doPrint(Print.ERROR, e.getMessage(), e);
            }
        }
        return erg;
    }

    public void setData(int maxNr) {
        String[] data;
        if (maxNr == 0) {
            data = new String[]{""};
        } else {
            data = new String[maxNr];
            for (int i = 0; i < maxNr; ++i) {
                data[i] = "" + (i + 1);
            }
        }
        this.iterlist.setData(data);
        this.oldnumber = this.getNumberOfLoops(false);
    }

    public void actionPerformed(ActionEvent e) {
        int old = this.oldnumber;
        int newNumber = -1;
        if (this.testInput(this.loopsfield.getText()) && this.oldnumber != (newNumber = this.getNumberOfLoops(true))) {
            if (newNumber == 1) {
                newNumber = 0;
            }
            this.setNumberOfLoops(newNumber);
            this.firePropertyChange("loop_number", old, newNumber);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pCL) {
        super.addPropertyChangeListener(pCL);
        this.iterlist.addPropertyChangeListener(pCL);
    }

    private boolean testInput(String value) {
        try {
            int i = Integer.parseInt(value);
            if (i < 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            M4Interface.print.doPrint(Print.ERROR, Resource.getString("STEPSETTINGS_LOOPNUMBER_ERROR") + "\n" + e.getMessage(), e);
            JOptionPane.showMessageDialog(this.app, Resource.getString("STEPSETTINGS_LOOPNUMBER_ERROR"), Resource.getString("DIALOG_ERROR_TITLE"), 0);
            return false;
        }
        return true;
    }
}

