/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.SingleSelectDialog;
import edu.udo.cs.miningmart.gui.stepsettings.SingleSelectEditor;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.musoft.limo.application.Resource;

public class SingleRelationEditor
extends SingleSelectEditor {
    public SingleRelationEditor(MiningMartApplication app, Step step, OpParam opParam) {
        super(app, step, opParam);
    }

    public void init() {
        super.init();
        if (this.opParam.isInput()) {
            if (this.paramobject != null && this.paramobject instanceof Relation) {
                this.textfield.setText(((Relation)this.paramobject).getName());
            }
        } else {
            Collection coll = this.getParameterCollection();
            Iterator iter = coll.iterator();
            if (iter.hasNext()) {
                this.textfield.setText((String)iter.next());
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Collection relations = M4Interface.getCurrentCase().getAllRelations();
            String[] data = new String[relations.size()];
            int c = 0;
            Iterator iter = relations.iterator();
            while (iter.hasNext()) {
                data[c] = ((Relation)iter.next()).getName();
                ++c;
            }
            SingleSelectDialog dialog = new SingleSelectDialog(this.app, Resource.getString("STEPSETTINGS_TITLE_RELATION"), Resource.getString("STEPSETTINGS_TITLE_SELECT_RELATION"), data, true);
            if (dialog.getExitAction() == 1) {
                String selected = dialog.getSelectedDataItem();
                this.textfield.setText(selected);
                iter = relations.iterator();
                Relation selectedR = null;
                boolean found = false;
                while (iter.hasNext() && !found) {
                    selectedR = (Relation)iter.next();
                    if (!selectedR.getName().equals(selected)) continue;
                    found = true;
                }
                LinkedList<Relation> list = new LinkedList<Relation>();
                if (found) {
                    list.add(selectedR);
                    this.paramobject = selectedR;
                }
                this.setParameterCollection(list);
                this.fireStateChanged();
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public boolean existsOutput() {
        if (this.opParam.isInput()) {
            return false;
        }
        for (int loop = 1; loop <= this.numberofloops; ++loop) {
            Collection coll = (Collection)this.oldparamcollections.get(loop - 1);
            if (coll == null) {
                return false;
            }
            if (!coll.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

