/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.SingleSelectDialog;
import edu.udo.cs.miningmart.gui.stepsettings.SingleSelectEditor;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.musoft.limo.application.Resource;

public class SingleConceptEditor
extends SingleSelectEditor {
    public SingleConceptEditor(MiningMartApplication app, Step step, OpParam opParam) {
        super(app, step, opParam);
    }

    public void init() {
        super.init();
        if (this.opParam.isInput()) {
            if (this.paramobject != null && this.paramobject instanceof Concept) {
                this.textfield.setText(((Concept)this.paramobject).getName());
            }
        } else {
            Collection coll = this.getParameterCollection();
            Iterator iter = coll.iterator();
            if (iter.hasNext()) {
                this.textfield.setText((String)iter.next());
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Collection concepts = this.step.getPossibleInputConcepts();
            String[] data = new String[concepts.size() + 1];
            data[0] = Resource.getString("STEPSETTINGS_NONE_SELECTION");
            int c = 1;
            Iterator iter = concepts.iterator();
            while (iter.hasNext()) {
                data[c] = ((Concept)iter.next()).getName();
                ++c;
            }
            SingleSelectDialog dialog = new SingleSelectDialog(this.app, Resource.getString("STEPSETTINGS_TITLE_CONCEPT"), Resource.getString("STEPSETTINGS_TITLE_SELECT_CONCEPT"), data, true);
            if (dialog.getExitAction() == 1) {
                String selected = dialog.getSelectedDataItem();
                if (selected.equals(data[0])) {
                    selected = "";
                }
                this.textfield.setText(selected);
                iter = concepts.iterator();
                Concept selectedConcept = null;
                boolean found = false;
                while (iter.hasNext() && !found) {
                    selectedConcept = (Concept)iter.next();
                    if (!selectedConcept.getName().equals(selected)) continue;
                    found = true;
                }
                LinkedList<Concept> list = new LinkedList<Concept>();
                if (found) {
                    list.add(selectedConcept);
                    this.paramobject = selectedConcept;
                }
                this.setParameterCollection(list);
                this.fireStateChanged();
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public boolean existsOutput() {
        if (this.opParam.isInput()) {
            return false;
        }
        for (int loop = 1; loop <= this.numberofloops; ++loop) {
            Collection coll = (Collection)this.oldparamcollections.get(loop - 1);
            if (coll == null) {
                return false;
            }
            if (!coll.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

