/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.ParameterObject;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;

public class ParameterEditor
extends DefaultCellEditor
implements TableCellRenderer {
    protected MiningMartApplication app;
    protected Step step;
    protected OpParam opParam;
    protected int numberofloops;
    protected int loopnumber;
    protected Vector paramcollections;
    protected Vector oldparamcollections;
    private Vector changeslistener;
    protected boolean editable;

    public ParameterEditor() {
        super(new JTextField());
        this.changeslistener = new Vector();
        this.editable = false;
    }

    public ParameterEditor(MiningMartApplication app, Step step, OpParam opParam) {
        super(new JTextField());
        this.opParam = opParam;
        this.app = app;
        this.step = step;
        this.changeslistener = new Vector();
        this.numberofloops = step.getLoopCount();
        if (this.numberofloops == 0) {
            this.numberofloops = 1;
        }
        this.loopnumber = 1;
        this.editable = app.getViewMode() == 0;
        this.loadParamCollections();
    }

    private void addCollection(Collection coll) {
        if (coll == null) {
            coll = new LinkedList();
        }
        if (this.opParam.isInput()) {
            this.paramcollections.add(coll);
            this.oldparamcollections.add(coll);
        } else {
            LinkedList<String> list = new LinkedList<String>();
            if (coll != null && !coll.isEmpty()) {
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (obj instanceof Value) {
                        list.add(((Value)obj).getValue());
                        continue;
                    }
                    if (obj instanceof ParameterObject) {
                        list.add(((ParameterObject)obj).getName());
                        continue;
                    }
                    M4Interface.print.doPrint(Print.ERROR, "Unknown Object: " + obj.getClass().getName() + "\nCannot hold this object in the ParameterEditor!");
                }
            }
            this.paramcollections.add(list);
            this.oldparamcollections.add(list);
        }
    }

    private void loadParamCollections() {
        this.paramcollections = new Vector();
        this.oldparamcollections = new Vector();
        try {
            for (int i = 0; i < this.numberofloops; ++i) {
                Collection coll;
                if (this.opParam.isCoordinated()) {
                    coll = this.step.getParameter(this.opParam, 0);
                    this.addCollection(coll);
                    continue;
                }
                if (this.opParam.isLoopable() && this.numberofloops == 1) {
                    coll = this.step.getParameter(this.opParam, 0);
                    this.addCollection(coll);
                    continue;
                }
                if (this.opParam.isLoopable() && this.numberofloops > 1) {
                    coll = this.step.getParameter(this.opParam, i + 1);
                    this.addCollection(coll);
                    continue;
                }
                coll = this.step.getParameter(this.opParam, 0);
                this.addCollection(coll);
            }
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
    }

    public void init() {
    }

    public int getNumberOfLoops() {
        return this.numberofloops;
    }

    public int getLoopNumber() {
        return this.loopnumber;
    }

    public void setLoopNumber(int loopnumber) {
        this.loopnumber = loopnumber;
        this.init();
        this.setEditable();
    }

    public void setNumberOfLoops(int numberofloops) {
        block4: {
            block3: {
                if (numberofloops == 0) {
                    numberofloops = 1;
                }
                this.numberofloops = numberofloops;
                if (this.paramcollections.size() >= numberofloops) break block3;
                while (this.paramcollections.size() != numberofloops) {
                    this.paramcollections.add(new LinkedList());
                }
                break block4;
            }
            if (this.paramcollections.size() <= numberofloops) break block4;
            while (this.paramcollections.size() != numberofloops) {
                this.paramcollections.remove(this.paramcollections.size() - 1);
            }
        }
    }

    public Collection getParameterCollection(int loopnumber) {
        boolean loopable = true;
        try {
            loopable = this.opParam.isLoopable();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            loopable = true;
        }
        if (loopable) {
            return (Collection)this.paramcollections.get(loopnumber - 1);
        }
        return (Collection)this.paramcollections.get(0);
    }

    public Collection getParameterCollection() {
        return this.getParameterCollection(this.loopnumber);
    }

    public void setParameterCollection(Collection collection, int loopnumber) {
        boolean loopable = true;
        try {
            loopable = this.opParam.isLoopable();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            loopable = true;
        }
        if (!this.opParam.isInput()) {
            Iterator iter = collection.iterator();
            boolean onlystrings = true;
            while (iter.hasNext() && onlystrings) {
                if (iter.next() instanceof String) continue;
                onlystrings = false;
            }
            if (!onlystrings) {
                LinkedList list = new LinkedList();
                iter = collection.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (obj instanceof String) {
                        list.add(obj);
                        continue;
                    }
                    if (obj instanceof Value) {
                        list.add(((Value)obj).getValue());
                        continue;
                    }
                    if (obj instanceof ParameterObject) {
                        list.add(((ParameterObject)obj).getName());
                        continue;
                    }
                    M4Interface.print.doPrint(Print.ERROR, "Unknown Object: " + obj.getClass().getName() + "\nCannot hold this object in the ParameterEditor!");
                }
                collection = list;
            }
        }
        if (loopable) {
            this.paramcollections.set(loopnumber - 1, collection);
        } else {
            for (int i = 0; i < this.paramcollections.size(); ++i) {
                this.paramcollections.set(i, collection);
            }
        }
    }

    public void setParameterCollection(Collection collection) {
        this.setParameterCollection(collection, this.loopnumber);
    }

    public Collection getAllParameterCollections() {
        return this.paramcollections;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.editorComponent;
    }

    public void setCollectionsInStep() throws M4Exception {
        if (!this.opParam.isInput()) {
            return;
        }
        for (int loop = 1; loop <= this.numberofloops; ++loop) {
            LinkedList coll = this.getParameterCollection(loop);
            if (coll == null) {
                coll = new LinkedList();
            }
            if (this.opParam.isCoordinated()) {
                Collection coordcoll = this.step.getParameter(this.opParam, 0);
                int coordloops = coordcoll == null ? 0 : coordcoll.size();
                this.step.setParameter(this.opParam, new LinkedList(), 0);
                for (int i = coordloops; i >= 1; --i) {
                    this.step.setParameter(this.opParam, new LinkedList(), i);
                }
                Iterator iter = coll.iterator();
                int coord = 1;
                while (iter.hasNext()) {
                    LinkedList list = new LinkedList();
                    list.add(iter.next());
                    this.step.setParameter(this.opParam, list, coord);
                    ++coord;
                }
                continue;
            }
            if (!this.opParam.isLoopable() && loop == 1) {
                this.step.setParameter(this.opParam, coll, 0);
                continue;
            }
            if (!this.opParam.isLoopable() && loop > 1) continue;
            if (this.numberofloops > 1) {
                this.step.setParameter(this.opParam, new Vector(), 0);
                this.step.setParameter(this.opParam, coll, loop);
                continue;
            }
            this.step.setParameter(this.opParam, coll, 0);
        }
    }

    public boolean existsOutput() {
        return false;
    }

    public void makeOutput(boolean inputchanged, boolean outputchanged, boolean loopcountlower, boolean loopcounthigher) throws M4Exception {
        LinkedList emptyList;
        if (this.opParam.isInput()) {
            return;
        }
        if (loopcountlower && loopcounthigher) {
            throw new M4Exception("The loopcount could not be lower and higher!");
        }
        boolean outputexists = this.existsOutput();
        LinkedList<Object> outcoll = new LinkedList<Object>();
        if (this.opParam.isLoopable()) {
            outcoll.addAll(this.paramcollections);
        } else if (this.opParam.isCoordinated()) {
            Collection coll = (Collection)this.paramcollections.get(0);
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                LinkedList list = new LinkedList();
                list.add(iter.next());
                outcoll.add(list);
            }
        } else {
            Iterator iter = this.paramcollections.iterator();
            while (iter.hasNext()) {
                Collection inner = (Collection)iter.next();
                Iterator innerIt = inner.iterator();
                while (innerIt.hasNext()) {
                    Object o = innerIt.next();
                    if (outcoll.contains(o)) continue;
                    if (o instanceof String) {
                        outcoll.add(o);
                        continue;
                    }
                    outcoll.add(((ParameterObject)o).getName());
                }
            }
        }
        if (loopcountlower) {
            if (!outputexists) {
                this.step.createOutput(this.opParam, outcoll);
            } else {
                this.step.updateOutput(this.opParam);
                if (outputchanged) {
                    this.step.renameOutput(this.opParam, outcoll);
                }
            }
            outputchanged = false;
        } else if (loopcounthigher) {
            if (!outputexists) {
                this.step.createOutput(this.opParam, outcoll);
            } else {
                emptyList = new LinkedList();
                for (int loop = 1; loop <= this.numberofloops; ++loop) {
                    if (!this.opParam.isLoopable() && loop == 1) {
                        this.step.setParameter(this.opParam, emptyList, 0);
                        continue;
                    }
                    this.step.setParameter(this.opParam, emptyList, loop);
                }
                this.step.createOutput(this.opParam, outcoll);
            }
            outputchanged = false;
        } else {
            if (!outputexists) {
                if (outputchanged) {
                    emptyList = new LinkedList();
                    for (int loop = 1; loop <= this.numberofloops; ++loop) {
                        if (!this.opParam.isLoopable() && loop == 1) {
                            this.step.setParameter(this.opParam, emptyList, 0);
                            continue;
                        }
                        this.step.setParameter(this.opParam, emptyList, loop);
                    }
                    this.step.createOutput(this.opParam, outcoll);
                } else {
                    this.step.createOutput(this.opParam, outcoll);
                }
            } else {
                if (inputchanged) {
                    this.step.updateOutput(this.opParam);
                }
                if (outputchanged) {
                    this.step.renameOutput(this.opParam, outcoll);
                }
            }
            outputchanged = false;
        }
        this.loadParamCollections();
        this.init();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeslistener.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeslistener.remove(listener);
    }

    public void removeAllChangeListener() {
        this.changeslistener.removeAllElements();
    }

    public int getChangeListenerCount() {
        return this.changeslistener.size();
    }

    public ChangeListener getChangeListener(int index) {
        return (ChangeListener)this.changeslistener.get(index);
    }

    public void fireStateChanged() {
        for (int i = 0; i < this.changeslistener.size(); ++i) {
            this.getChangeListener(i).stateChanged(new ChangeEvent(this));
        }
    }

    public OpParam getTheOpParam() {
        return this.opParam;
    }

    public void cancelEditing() throws M4Exception {
        this.paramcollections = new Vector();
        for (int i = 0; i < this.oldparamcollections.size(); ++i) {
            this.paramcollections.add(this.oldparamcollections.get(i));
        }
        this.init();
        this.setCollectionsInStep();
    }

    public void setEditable() {
        block7: {
            if (this.app.getViewMode() == 0) {
                if (this.loopnumber > 1) {
                    try {
                        if (this.opParam.isLoopable()) {
                            this.editable = true;
                            break block7;
                        }
                        this.editable = false;
                    }
                    catch (M4Exception error) {
                        M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
                    }
                } else {
                    this.editable = true;
                }
            } else {
                this.editable = false;
            }
        }
    }
}

